# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['renku',
 'renku.command',
 'renku.command.checks',
 'renku.command.command_builder',
 'renku.command.format',
 'renku.command.schema',
 'renku.command.view_model',
 'renku.core',
 'renku.core.dataset',
 'renku.core.dataset.providers',
 'renku.core.incubation',
 'renku.core.interface',
 'renku.core.management',
 'renku.core.migration',
 'renku.core.migration.models',
 'renku.core.migration.utils',
 'renku.core.misc',
 'renku.core.plugin',
 'renku.core.plugin.implementations',
 'renku.core.session',
 'renku.core.template',
 'renku.core.util',
 'renku.core.workflow',
 'renku.core.workflow.converters',
 'renku.core.workflow.providers',
 'renku.data',
 'renku.domain_model',
 'renku.domain_model.provenance',
 'renku.domain_model.workflow',
 'renku.domain_model.workflow.converters',
 'renku.infrastructure',
 'renku.infrastructure.gateway',
 'renku.ui',
 'renku.ui.api',
 'renku.ui.api.graph',
 'renku.ui.api.models',
 'renku.ui.cli',
 'renku.ui.cli.utils',
 'renku.ui.service',
 'renku.ui.service.cache',
 'renku.ui.service.cache.models',
 'renku.ui.service.cache.serializers',
 'renku.ui.service.controllers',
 'renku.ui.service.controllers.api',
 'renku.ui.service.controllers.utils',
 'renku.ui.service.gateways',
 'renku.ui.service.interfaces',
 'renku.ui.service.jobs',
 'renku.ui.service.serializers',
 'renku.ui.service.serializers.v0_9',
 'renku.ui.service.serializers.v1_0',
 'renku.ui.service.utils',
 'renku.ui.service.views',
 'renku.ui.service.views.v0_9',
 'renku.ui.service.views.v1_0']

package_data = \
{'': ['*'],
 'renku': ['templates/*',
           'templates/R-minimal/*',
           'templates/R-minimal/.renku/*',
           'templates/R-minimal/data/*',
           'templates/R-minimal/notebooks/*',
           'templates/bioc-minimal/*',
           'templates/bioc-minimal/.renku/*',
           'templates/bioc-minimal/data/*',
           'templates/bioc-minimal/notebooks/*',
           'templates/julia-minimal/*',
           'templates/julia-minimal/.renku/*',
           'templates/julia-minimal/data/*',
           'templates/julia-minimal/notebooks/*',
           'templates/minimal/*',
           'templates/minimal/.renku/*',
           'templates/python-minimal/*',
           'templates/python-minimal/.renku/*',
           'templates/python-minimal/data/*',
           'templates/python-minimal/notebooks/*']}

install_requires = \
['appdirs>=1.4.3,<=1.4.4',
 'attrs>=21.1.0,<21.5.0',
 'calamus>=0.3.13,<0.4',
 'click-option-group>=0.5.2,<0.6.0',
 'click-plugins==1.1.1',
 'click>=8.0,<8.1.3',
 'cryptography>=3.4.1,<37.0.0',
 'cwl-utils>=0.12',
 'cwltool==3.1.20211107152837',
 'deepdiff>=5.8.0,<6.0.0',
 'deepmerge==1.0.1',
 'docker>=3.7.2,<6',
 'filelock>=3.3.0,<3.6.1',
 'gitpython==3.1.27',
 'grandalf==0.7',
 'humanize>=3.0.0,<4.1.0',
 'inject>=4.3.0,<4.4.0',
 'jinja2>=2.11.3,<3.1.3',
 'networkx>=2.6.0,<2.7',
 'numpy>=1.20.0,<1.22.0',
 'packaging>=21.3,<22.0',
 'pathspec>=0.8.0,<1.0.0',
 'patool==1.12',
 'pluggy==1.0.0',
 'portalocker>=2.2.1,<2.5',
 'psutil>=5.4.7,<5.9.1',
 'pyjwt>=2.1.0,<2.4.0',
 'pyld==2.0.3',
 'pyopenssl>=19.0.0,<22.1.0',
 'pyshacl>=0.17.2,<0.18.2',
 'python-dateutil>=2.6.1,<2.8.3',
 'python-editor==1.0.4',
 'python-gitlab>=2.10.1,<3.1.2',
 'pyyaml>=5.4,<6.1.0',
 'rdflib>=6.0.0,<7.0',
 'requests>=2.23.0,<2.27.2',
 'rich>=9.3.0,<12.3.0',
 'shellingham==1.4.0',
 'tabulate>=0.7.7,<0.8.10',
 'tqdm>=4.48.1,<4.62.4',
 'werkzeug>=1.0.0,<2.1.2',
 'yagup>=0.1.1',
 'yaspin==2.1.0',
 'zc.relation>=1.1,<1.2',
 'zodb==5.6.0',
 'zstandard>=0.16.0,<0.18.0']

extras_require = \
{':python_full_version < "3.8.0"': ['importlib-metadata>=4.8.1,<4.12.0'],
 ':python_full_version < "3.9.0"': ['importlib-resources>=5.4.0,<5.8.0'],
 'all': ['apispec>=4.0.0,<5.2.0',
         'apispec-webframeworks>=0.5.2,<0.6',
         'black==22.3.0',
         'circus==0.17.1',
         'coverage[toml]>=4.5.3,<6.4',
         'fakeredis[lua]>=1.4.1,<1.7.2',
         'flakehell>=0.9.0,<1.0',
         'flaky==3.7.0',
         'flask==2.1.1',
         'gunicorn',
         'isort>=5.3.2,<5.10.2',
         'marshmallow>=3.13.0,<3.16.0',
         'mypy>=0.942,<1.0',
         'pexpect>=4.8.0,<4.9.0',
         'pillow>=9.0.0,<9.2',
         'plantweb>=1.2.1,<1.3.0',
         'poetry-dynamic-versioning>=0.14.0,<0.15.0',
         'pydocstyle>=4.0.1,<6.1.2',
         'pyte>=0.8.0',
         'pytest>=4.0.0,<7.1.2',
         'pytest-black>=0.3.10,<0.3.13',
         'pytest-cache==1.0',
         'pytest-cov>=2.5.1,<3.1.0',
         'pytest-flake8>=1.0.6,<1.1.1',
         'pytest-mock>=3.2.0,<3.8.0',
         'pytest-pep8==1.0.6',
         'pytest-recording==0.12.0',
         'pytest-timeout==2.1.0',
         'pytest-xdist>=1.34.0,<2.6.0',
         'python-dotenv>=0.19.0,<0.21.0',
         'redis>=3.5.3,<4.2.0',
         'renku-sphinx-theme>=0.2.0',
         'responses>=0.7.0,<0.21.0',
         'rq==1.10.1',
         'rq-scheduler==0.11.0',
         'sentry-sdk[flask]>=1.5.11,<1.5.12',
         'sphinxcontrib-spelling>=7.0.0,<8.0.0',
         'sphinx-rtd-theme>=0.5.0,<1.1',
         'sphinx-tabs==3.2.0',
         'toil==5.6.0',
         'types-python-dateutil>=2.8.10,<3.0.0',
         'types-PyYAML>=5.4,<6.1.0',
         'types-redis>=3.5.3,<4.1.0',
         'types-requests>=2.23.0,<2.27.2',
         'types-tabulate>=0.7.7,<0.8.10',
         'walrus>=0.8.2,<0.10.0'],
 'docs': ['plantweb>=1.2.1,<1.3.0',
          'renku-sphinx-theme>=0.2.0',
          'sphinxcontrib-spelling>=7.0.0,<8.0.0',
          'sphinx-rtd-theme>=0.5.0,<1.1',
          'sphinx-tabs==3.2.0'],
 'service': ['apispec>=4.0.0,<5.2.0',
             'apispec-webframeworks>=0.5.2,<0.6',
             'circus==0.17.1',
             'flask==2.1.1',
             'gunicorn',
             'marshmallow>=3.13.0,<3.16.0',
             'pillow>=9.0.0,<9.2',
             'python-dotenv>=0.19.0,<0.21.0',
             'redis>=3.5.3,<4.2.0',
             'rq==1.10.1',
             'rq-scheduler==0.11.0',
             'sentry-sdk[flask]>=1.5.11,<1.5.12',
             'walrus>=0.8.2,<0.10.0'],
 'tests': ['black==22.3.0',
           'coverage[toml]>=4.5.3,<6.4',
           'fakeredis[lua]>=1.4.1,<1.7.2',
           'flakehell>=0.9.0,<1.0',
           'flaky==3.7.0',
           'isort>=5.3.2,<5.10.2',
           'mypy>=0.942,<1.0',
           'pexpect>=4.8.0,<4.9.0',
           'poetry-dynamic-versioning>=0.14.0,<0.15.0',
           'pydocstyle>=4.0.1,<6.1.2',
           'pyte>=0.8.0',
           'pytest>=4.0.0,<7.1.2',
           'pytest-black>=0.3.10,<0.3.13',
           'pytest-cache==1.0',
           'pytest-cov>=2.5.1,<3.1.0',
           'pytest-flake8>=1.0.6,<1.1.1',
           'pytest-mock>=3.2.0,<3.8.0',
           'pytest-pep8==1.0.6',
           'pytest-recording==0.12.0',
           'pytest-timeout==2.1.0',
           'pytest-xdist>=1.34.0,<2.6.0',
           'responses>=0.7.0,<0.21.0',
           'types-python-dateutil>=2.8.10,<3.0.0',
           'types-PyYAML>=5.4,<6.1.0',
           'types-redis>=3.5.3,<4.1.0',
           'types-requests>=2.23.0,<2.27.2',
           'types-tabulate>=0.7.7,<0.8.10'],
 'toil': ['toil==5.6.0']}

entry_points = \
{'console_scripts': ['renku = renku.ui.cli:cli']}

setup_kwargs = {
    'name': 'renku',
    'version': '1.6.0',
    'description': 'Python SDK and CLI for the Renku platform.',
    'long_description': '..\n    Copyright 2017-2022 - Swiss Data Science Center (SDSC)\n    A partnership between École Polytechnique Fédérale de Lausanne (EPFL) and\n    Eidgenössische Technische Hochschule Zürich (ETHZ).\n\n    Licensed under the Apache License, Version 2.0 (the "License");\n    you may not use this file except in compliance with the License.\n    You may obtain a copy of the License at\n\n        http://www.apache.org/licenses/LICENSE-2.0\n\n    Unless required by applicable law or agreed to in writing, software\n    distributed under the License is distributed on an "AS IS" BASIS,\n    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n    See the License for the specific language governing permissions and\n    limitations under the License.\n\n======================================\n Renku Python Library, CLI and Service\n======================================\n\n.. image:: https://github.com/SwissDataScienceCenter/renku-python/workflows/Test,%20Integration%20Tests%20and%20Deploy/badge.svg\n   :target: https://github.com/SwissDataScienceCenter/renku-python/actions?query=workflow%3A%22Test%2C+Integration+Tests+and+Deploy%22+branch%3Amaster\n\n.. image:: https://img.shields.io/coveralls/SwissDataScienceCenter/renku-python.svg\n   :target: https://coveralls.io/r/SwissDataScienceCenter/renku-python\n\n.. image:: https://img.shields.io/github/tag/SwissDataScienceCenter/renku-python.svg\n   :target: https://github.com/SwissDataScienceCenter/renku-python/releases\n\n.. image:: https://img.shields.io/pypi/dm/renku.svg\n   :target: https://pypi.python.org/pypi/renku\n\n.. image:: http://readthedocs.org/projects/renku-python/badge/?version=latest\n   :target: http://renku-python.readthedocs.io/en/latest/?badge=latest\n   :alt: Documentation Status\n\n.. image:: https://img.shields.io/github/license/SwissDataScienceCenter/renku-python.svg\n   :target: https://github.com/SwissDataScienceCenter/renku-python/blob/master/LICENSE\n\nA Python library for the `Renku collaborative data science platform\n<https://github.com/SwissDataScienceCenter/renku>`_. It includes a CLI and SDK\nfor end-users as well as a service backend. It provides functionality for the\ncreation and management of projects and datasets, and simple utilities to\ncapture data provenance while performing analysis tasks.\n\n**NOTE**:\n   ``renku-python`` is the python library and core service for Renku - it *does\n   not* start the Renku platform itself - for that, refer to the Renku docs on\n   `running the platform\n   <https://renku.readthedocs.io/en/latest/developer/setup.html>`_.\n\n\nRenku for Users\n===============\n\nInstallation\n------------\n\n.. _installation-reference:\n\nRenku releases and development versions are available from `PyPI\n<https://pypi.org/project/renku/>`_. You can install it using any tool that\nknows how to handle PyPI packages. Our recommendation is to use `:code:pipx\n<https://github.com/pipxproject/pipx>`_.\n\n.. note::\n\n   We do not officially support Windows at this moment. The way Windows\n   handles paths and symlinks interferes with some Renku functionality.\n   We recommend using the Windows Subsystem for Linux (WSL) to use Renku\n   on Windows.\n\nPrerequisites\n~~~~~~~~~~~~~\n\nRenku depends on Git under the hood, so make sure that you have Git\n`installed on your system <https://git-scm.com/downloads>`_.\n\nRenku also offers support to store large files in `Git LFS\n<https://git-lfs.github.com/>`_, which is used by default and should be\ninstalled on your system. If you do not wish to use Git LFS, you can run\nRenku commands with the `-S` flag, as in `renku -S <command>`.  More\ninformation on Git LFS usage in renku can be found in the `Data in Renku\n<https://renku.readthedocs.io/en/latest/user/data.html>`_ section of the docs.\n\nRenku uses CWL to execute recorded workflows when calling `renku update`\nor `renku rerun`. CWL depends on NodeJs to execute the workflows, so installing\n`NodeJs <https://nodejs.org/en/download/package-manager/>`_ is required if\nyou want to use those features.\n\nFor development of the service, `Docker <https://docker.com>`_ is recommended.\n\n\n.. _pipx-before-reference:\n\n``pipx``\n~~~~~~~~\n.. _pipx-after-reference:\n\nFirst, `install pipx <https://github.com/pipxproject/pipx#install-pipx>`_\nand make sure that the ``$PATH`` is correctly configured.\n\n::\n\n    $ python3 -m pip install --user pipx\n    $ python3 -m pipx ensurepath\n\nOnce ``pipx`` is installed use following command to install ``renku``.\n\n::\n\n    $ pipx install renku\n    $ which renku\n    ~/.local/bin/renku\n\n\n``pipx`` installs Renku into its own virtual environment, making sure that it\ndoes not pollute any other packages or versions that you may have already\ninstalled.\n\n.. note::\n\n    If you install Renku as a dependency in a virtual environment and the\n    environment is active, your shell will default to the version installed\n    in the virtual environment, *not* the version installed by ``pipx``.\n\n\nTo install a development release:\n\n::\n\n    $ pipx install --pip-args pre renku\n\n\n.. _pip-before-reference:\n\n``pip``\n~~~~~~~\n.. _pip-after-reference:\n\n::\n\n    $ pip install renku\n\nThe latest development versions are available on PyPI or from the Git\nrepository:\n\n::\n\n    $ pip install --pre renku\n    # - OR -\n    $ pip install -e git+https://github.com/SwissDataScienceCenter/renku-python.git#egg=renku\n\nUse following installation steps based on your operating system and preferences\nif you would like to work with the command line interface and you do not need\nthe Python library to be importable.\n\n.. _windows-before-reference:\n\nWindows\n~~~~~~~\n.. _windows-after-reference:\n\n.. note::\n\n    We don\'t officially support Windows yet, but Renku works well in the Windows Subsystem for Linux (WSL).\n    As such, the following can be regarded as a best effort description on how to get started with Renku on Windows.\n\nRenku can be run using the Windows Subsystem for Linux (WSL). To install the WSL, please follow the\n`official instructions <https://docs.microsoft.com/en-us/windows/wsl/install-win10#manual-installation-steps>`__.\n\nWe recommend you use the Ubuntu 20.04 image in the WSL when you get to that step of the installation.\n\nOnce WSL is installed, launch the WSL terminal and install the packages required by Renku with:\n\n::\n\n    $ sudo apt-get update && sudo apt-get install git python3 python3-pip python3-venv pipx\n\nSince Ubuntu has an older version of git LFS installed by default which is known to have some bugs when cloning\nrepositories, we recommend you manually install the newest version by following\n`these instructions <https://github.com/git-lfs/git-lfs/wiki/Installation#debian-and-ubuntu>`__.\n\nOnce all the requirements are installed, you can install Renku normally by running:\n\n::\n\n    $ pipx install renku\n    $ pipx ensurepath\n\nAfter this, Renku is ready to use. You can access your Windows in the various mount points in\n``/mnt/`` and you can execute Windows executables (e.g. ``\\*.exe``) as usual directly from the\nWSL (so ``renku run myexecutable.exe`` will work as expected).\n\n.. _docker-before-reference:\n\nDocker\n~~~~~~\n.. _docker-after-reference:\n\nThe containerized version of the CLI can be launched using Docker command.\n\n::\n\n    $ docker run -it -v "$PWD":"$PWD" -w="$PWD" renku/renku-python renku\n\nIt makes sure your current directory is mounted to the same place in the\ncontainer.\n\n\nCLI Example\n-----------\n\nInitialize a Renku project:\n\n::\n\n    $ mkdir -p ~/temp/my-renku-project\n    $ cd ~/temp/my-renku-project\n    $ renku init\n\nCreate a dataset and add data to it:\n\n::\n\n    $ renku dataset create my-dataset\n    $ renku dataset add my-dataset https://raw.githubusercontent.com/SwissDataScienceCenter/renku-python/master/README.rst\n\nRun an analysis:\n\n::\n\n    $ renku run --name my-workflow -- wc < data/my-dataset/README.rst > wc_readme\n\nTrace the data provenance:\n\n::\n\n    $ renku workflow visualize wc_readme\n\nThese are the basics, but there is much more that Renku allows you to do with\nyour data analysis workflows. The full documentation will soon be available\nat: https://renku-python.readthedocs.io/\n\n\nRenku as a Service\n==================\n\nThis repository includes a ``renku-core`` RPC service written as a `Flask\n<https://flask.palletsprojects.com>`_ application that provides (almost) all of\nthe functionality of the Renku CLI. This is used to provide one of the backends\nfor the `RenkuLab <https://renkulab.io>`_ web UI. The service can be deployed in\nproduction as a Helm chart (see `helm-chart <./helm-chart/README.rst>`_.\n\n\nDeploying locally\n-----------------\n\nTo test the service functionality you can deploy it quickly and easily using\n``docker-compose up`` [docker-compose](https://pypi.org/project/docker-compose/).\nMake sure to make a copy of the ``renku/service/.env-example`` file and configure it\nto your needs. The setup here is to expose the service behind a traefik reverse proxy\nto mimic an actual production deployment. You can access the proxied endpoints at\n``http://localhost/api``. The service itself is exposed on port 8080 so its endpoints\nare available directly under ``http://localhost:8080``.\n\n\nAPI Documentation\n-----------------\n\nThe renku core service implements the API documentation as an OpenAPI 3.0.x spec.\nYou can retrieve the yaml of the specification itself with\n\n```\n$ renku service apispec\n```\n\nIf deploying the service locally with ``docker-compose`` you can find the swagger-UI\nunder ``localhost/api/swagger``. To send the proper authorization headers to the\nservice endpoints, click the ``Authorize`` button and enter a valid JWT token and\na gitlab token with read/write repository scopes. The JWT token can be obtained by\nlogging in to a renku instance with ``renku login`` and retrieving it from your local\nrenku configuration.\n\nIn a live deployment, the swagger documentation is available under ``https://<renku-endpoint>/swagger``.\nYou can authorize the API by first logging into renku normally, then going to the\nswagger page, clicking ``Authorize`` and picking the ``oidc (OAuth2, authorization_code)``\noption. Leave the ``client_id`` as ``swagger`` and the ``client_secret`` empty, select\nall scopes and click ``Authorize``. You should now be logged in and you can send\nrequests using the ``Try it out`` buttons on individual requests.\n\n\nDeveloping Renku\n================\n\nFor testing the functionality from source it is convenient to install ``renku``\nin editable mode using ``pipx``. Clone the repository and then do:\n\n::\n\n    $ pipx install \\\n        --editable \\\n        <path-to-renku-python>[all] \\\n        renku\n\nThis will install all the extras for testing and debugging.\n\nIf you already use `pyenv <https://github.com/pyenv/pyenv>`__ to manage different python versions,\nyou may be interested in installing `pyenv-virtualenv <https://github.com/pyenv/pyenv-virtualenv>`__ to\ncreate an ad-hoc virtual environment for developing renku.\n\nOnce you have created and activated a virtual environment for renku-python, you can use the usual\n`pip` commands to install the required dependencies.\n\n::\n\n    $ pip install -e .[all]  # use `.[all]` for zsh\n\n\nService\n-------\n\nDeveloping the service and testing its APIs can be done with ``docker compose`` (see\n"Deploying Locally" above).\n\nIf you have a full RenkuLab deployment at your disposal, you can\nuse `telepresence <https://www.telepresence.io/>`__ v1 to develop and debug locally.\nJust run the `start-telepresence.sh` script and follow the instructions.\nMind that the script doesn\'t work with telepresence v2.\n\n\nRunning tests\n-------------\n\nWe use `pytest <https://docs.pytest.org>`__ for running tests.\nYou can use our `run-tests.sh` script for running specific set of tests.\n\n::\n\n    $ ./run-tests.sh -h\n\nWe lint the files using `black <https://github.com/psf/black>`__ and\n`isort <https://github.com/PyCQA/isort>`__.\n\n\nUsing External Debuggers\n------------------------\n\nLocal Machine\n~~~~~~~~~~~~~\n\nTo run ``renku`` via e.g. the `Visual Studio Code debugger\n<https://code.visualstudio.com/docs/python/debugging>`_ you need run it via\nthe python executable in whatever virtual environment was used to install ``renku``. If there is a package\nneeded for the debugger, you need to inject it into the virtual environment first, e.g.:\n\n::\n\n    $ pipx inject renku ptvsd\n\n\nFinally, run ``renku`` via the debugger:\n\n::\n\n    $ ~/.local/pipx/venvs/renku/bin/python -m ptvsd --host localhost --wait -m renku.ui.cli <command>\n\n\nIf using Visual Studio Code, you may also want to set the ``Remote Attach`` configuration\n``PathMappings`` so that it will find your source code, e.g.\n\n::\n\n    {\n        "name": "Python: Remote Attach",\n        "type": "python",\n        "request": "attach",\n        "port": 5678,\n        "host": "localhost",\n        "pathMappings": [\n            {\n                "localRoot": "<path-to-renku-python-source-code>",\n                "remoteRoot": "<path-to-renku-python-source-code>"\n            }\n        ]\n    }\n',
    'author': 'Swiss Data Science Center',
    'author_email': 'contact@datascience.ch',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/swissdatasciencecenter/renku-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<4.0.0',
}


setup(**setup_kwargs)
