# Project Maintainer Notes

## Code Testing

`tox` and `coverage` are used to execute the Font Bakery test suite and line coverage assessment, respectively.  

Use the following command to run all tests:

```
$ tox
```

The coverage report can be found at the end of the test results that are printed to the standard output/error stream.

Continuous integration testing is performed on Travis CI. Test jobs can be found at [https://travis-ci.org/googlefonts/fontbakery](https://travis-ci.org/googlefonts/fontbakery).

## Updating the distribution package

Releases to PyPI are performed by running the following commands (with the proper version number and date):

```sh
# cleanup
rm build/ -rf
rm dist/ -rf
rm venv/ -rf

# Update the cached list of vendor IDs:
wget https://docs.microsoft.com/en-us/typography/vendors/ --output-document=Lib/fontbakery/data/fontbakery-microsoft-vendorlist.cache
git add -p

# If something changed, commit it:
git commit -m "Updating cache of vendor IDs list from Microsoft's website"

# Check for updates on the Google Fonts Axis Registry textproto files at https://github.com/google/fonts/tree/main/axisregistry
# Newest files must be copied and committed at Lib/fontbakery/data/*.textproto

# update the docs so that https://font-bakery.readthedocs.io/
# displays the correct version number
vim docs/source/conf.py
git add -p
git commit -m "update version on docs/source/conf.py"

# create a fresh python virtual env
virtualenv venv -ppython3
. venv/bin/activate

# Install tox and run our code tests
pip install tox
tox

# Register a git tag for this release and publish it
git tag -a v0.6.11 -m "Font Bakery version 0.6.11 (2019-Feb-18)"
git push upstream --tags

# create the package
python setup.py bdist_wheel --universal

# and finally upload the new package to PyPI
pip install twine
twine upload dist/*
```

## Cached Vendor ID data

This project hosts a copy of the Microsoft's Vendor ID list at Lib/fontbakery/Lib/data/fontbakery-microsoft-vendorlist.cache

This is meant only as a caching mechanism. The latest data can always be fetched from Microsoft's website directly at: <https://www.microsoft.com/typography/links/vendorlist.aspx>
