'''
Created on Jun 15, 2017

@author: fan
'''
import logging

logger = logging.getLogger(__name__)

import numpy as np
# import Support.arraytools.scalararray as scalararray
import pyfan.amto.array.scalararray as scalararray


class BudgetConsumption():

    def __init__(self, param_inst):
        """Get Relevant Parameters         
        """
        # Depreication
        self.R_INFORM_SAVE = param_inst.esti_param['R_INFORM_SAVE']
        self.R_INFORM_BORR = param_inst.esti_param['R_INFORM_BORR']
        self.R_FORMAL_SAVE = param_inst.esti_param['R_FORMAL_SAVE']
        self.R_FORMAL_BORR = param_inst.esti_param['R_FORMAL_BORR']

        self.BNF_SAVE_P = param_inst.esti_param['BNF_SAVE_P']
        self.BNF_BORR_P = param_inst.esti_param['BNF_BORR_P']
        self.BNI_LEND_P = param_inst.esti_param['BNI_LEND_P']
        self.BNI_BORR_P = param_inst.esti_param['BNI_BORR_P']

        self.K_DEPRECIATION = param_inst.esti_param['K_DEPRECIATION']

        self.shape_choice = param_inst.grid_param['shape_choice']['shape']

    def budget_consumption(self,
                           y,
                           k_tt, k_tp,
                           b_tt,
                           b_tp_borr_for, b_tp_borr_inf,
                           b_tp_save_for, b_tp_lend_inf,
                           check_scalar=False):
        """
        """
        cash = self.cash(y, b_tt, k_tt)

        consumption, b_tp_principle = self.budget_consumption_cash(
            cash,
            k_tp,
            b_tp_borr_for, b_tp_borr_inf,
            b_tp_save_for, b_tp_lend_inf,
            check_scalar)

        return consumption, cash, b_tp_principle

    def budget_consumption_cash(self,
                                cash,
                                k_tp,
                                b_tp_borr_for, b_tp_borr_inf,
                                b_tp_save_for, b_tp_lend_inf,
                                check_scalar=False):
        """Consumption equation
        tt for today, include principle and interest 
        tp for t prime tomorrow
        
        Parameters
        ----------
        check_scalar: Boolean
            Generally do not check these, data generated by normal code
            in array already, but from _notes, somtimes a bunch of scalars, 
            but function requires indexing.   
        """

        #         if (check_scalar == True):
        #             b_tp_borr_for = scalararray.scalar_to_array(b_tp_borr_for)
        #             b_tp_save_for = scalararray.scalar_to_array(b_tp_save_for)
        #             b_tp_borr_inf = scalararray.scalar_to_array(b_tp_borr_inf)
        #             b_tp_lend_inf = scalararray.scalar_to_array(b_tp_lend_inf)
        #             logger.debug('b_tp_borr_for.shape:%s', b_tp_borr_for.shape)
        #             logger.debug('b_tp_save_for.shape:%s', b_tp_save_for.shape)
        #             logger.debug('b_tp_borr_inf.shape:%s', b_tp_borr_inf.shape)
        #             logger.debug('b_tp_lend_inf.shape:%s', b_tp_lend_inf.shape)

        b_tp_principle_fc = self.b_tp_principle_fc_array(b_tp_borr_for, b_tp_save_for, b_tp_borr_inf, b_tp_lend_inf)
        logger.debug('cash.shape:%s', cash.shape)
        logger.debug('k_tp.shape:%s', k_tp.shape)
        #         np.sum(b_tp_principle_fc >=0)/(b_tp_principle_fc).size
        consumption = cash - k_tp - b_tp_principle_fc

        return consumption, b_tp_principle_fc

    def b_tp_principle_fc_array_index(self, b_tp_borr_for, b_tp_save_for, b_tp_borr_inf, b_tp_lend_inf):
        """Aggregate Net Financial Asset for T+1

        The code below is suppose to save time, by calculating only 
        for subset of index that need calculation. Although this might take
        actually more time.                 
        
        Parameters
        ----------
        array_len: int
            length of the largest array
        b_tp_borr_for: array
            these four arrays, are principle + interest carried to future for each
            they can either be np.array([[0]]), or N by 1
            there is only one N, For example if borrowing formall and informally
            then both will by N by 1, but the other two vectors will by [[0]]
            some elements could be 0 for the N by 1 vectors
            
        Returns:
            present consumption cost of the four borrow and save choices with fc.
            if: b_tp_principle >= 0, saving (positive present consumption cost), will decrease consumption
            if: b_tp_principle <= 0, borrowing, will increase consumption            
           
            
        """

        '''
        A. Find non-zero index, to save time
        and also means if one of the arrays has just one 0, index will be empty
        and furthermore, no fixed cost will be added for this zero choice. 
        if we just directly add 0 if they are 0, will add on fixed costs. 
        '''
        b_tp_borr_for_nonzero_idx = np.nonzero(b_tp_borr_for)
        b_tp_save_for_nonzero_idx = np.nonzero(b_tp_save_for)
        b_tp_borr_inf_nonzero_idx = np.nonzero(b_tp_borr_inf)
        b_tp_lend_inf_nonzero_idx = np.nonzero(b_tp_lend_inf)

        logger.debug('borr_for_nonzero:%d', len(b_tp_borr_for_nonzero_idx[0]))
        logger.debug('save_for_nonzero:%d', len(b_tp_save_for_nonzero_idx[0]))
        logger.debug('borr_inf_nonzero:%d', len(b_tp_borr_inf_nonzero_idx[0]))
        logger.debug('lend_inf_nonzero:%d', len(b_tp_lend_inf_nonzero_idx[0]))

        '''
        B. get consumption value today of total net financial position tomorrow.
        if nonzero is empty, then the line below is still empty, zero time cost 
        '''
        # B1. Components: formal
        b_formal_prime_wthint_borr = \
            (1 / self.R_FORMAL_BORR) * b_tp_borr_for[b_tp_borr_for_nonzero_idx] + self.BNF_BORR_P
        b_formal_prime_wthint_save = \
            (1 / self.R_FORMAL_SAVE) * b_tp_save_for[b_tp_save_for_nonzero_idx] + self.BNF_SAVE_P

        # B2. Components: informal
        b_informal_prime_wthint_borr = \
            (1 / self.R_INFORM_BORR) * b_tp_borr_inf[b_tp_borr_inf_nonzero_idx] + self.BNI_BORR_P
        b_informal_prime_wthint_save = \
            (1 / self.R_INFORM_SAVE) * b_tp_lend_inf[b_tp_lend_inf_nonzero_idx] + self.BNI_LEND_P

        '''
        C. aggregate
        '''
        logger.info('self.shape_choice:%s', self.shape_choice)
        b_tp_principle = np.zeros(self.shape_choice)
        logger.debug('b_tp_principle:\n%s', b_tp_principle)
        logger.debug('b_tp_borr_for_nonzero_idx:\n%s', b_tp_borr_for_nonzero_idx)
        logger.debug('b_formal_prime_wthint_borr:\n%s', b_formal_prime_wthint_borr)
        b_tp_principle[b_tp_borr_for_nonzero_idx] = b_tp_principle[
                                                        b_tp_borr_for_nonzero_idx] + b_formal_prime_wthint_borr

        logger.debug('b_tp_principle:\n%s', b_tp_principle)
        logger.debug('b_tp_save_for_nonzero_idx:\n%s', b_tp_save_for_nonzero_idx)
        logger.debug('b_formal_prime_wthint_save:\n%s', b_formal_prime_wthint_save)
        b_tp_principle[b_tp_save_for_nonzero_idx] = b_tp_principle[
                                                        b_tp_save_for_nonzero_idx] + b_formal_prime_wthint_save

        logger.debug('b_tp_principle:\n%s', b_tp_principle)
        logger.debug('b_tp_borr_inf_nonzero_idx:\n%s', b_tp_borr_inf_nonzero_idx)
        logger.debug('b_informal_prime_wthint_borr:\n%s', b_informal_prime_wthint_borr)
        b_tp_principle[b_tp_borr_inf_nonzero_idx] = b_tp_principle[
                                                        b_tp_borr_inf_nonzero_idx] + b_informal_prime_wthint_borr

        b_tp_principle[b_tp_lend_inf_nonzero_idx] = b_tp_principle[
                                                        b_tp_lend_inf_nonzero_idx] + b_informal_prime_wthint_save

        return b_tp_principle

    def b_tp_principle_fc_array(self, b_tp_borr_for, b_tp_save_for, b_tp_borr_inf, b_tp_lend_inf):
        """Do not need to check zero
        - Checking zero seesm to be total waste of time
        - for joint formal informal, where formal has state dimension, informal has choice dimension
            can not broadcast
        """

        '''
        B. get consumption value today of total net financial position tomorrow.
        if nonzero is empty, then the line below is still empty, zero time cost 
        '''
        b_tp_principle = 0

        logger.debug('np.transpose(b_tp_borr_for):\n%s', np.transpose(b_tp_borr_for))
        # B1. b_formal_prime_wthint_borr
        if (b_tp_borr_for is not 0):
            b_tp_principle = b_tp_principle + (1 / self.R_FORMAL_BORR) * b_tp_borr_for + self.BNF_BORR_P
            logger.info('b_tp_borr_for,b_tp_principle.shape:%s', np.array(b_tp_principle).shape)

        # B2. b_formal_prime_wthint_save
        logger.debug('np.transpose(b_tp_save_for):\n%s', np.transpose(b_tp_save_for))
        if (b_tp_save_for is not 0):
            b_tp_principle = b_tp_principle + (1 / self.R_FORMAL_SAVE) * b_tp_save_for + self.BNF_SAVE_P
            logger.info('b_tp_save_for,b_tp_principle.shape:%s', np.array(b_tp_principle).shape)

        # B3. Components: informal, b_informal_prime_wthint_borr
        logger.debug('np.transpose(b_tp_borr_inf):\n%s', np.transpose(b_tp_borr_inf))
        if (b_tp_borr_inf is not 0):
            b_tp_principle = b_tp_principle + (1 / self.R_INFORM_BORR) * b_tp_borr_inf + self.BNI_BORR_P
            logger.info('b_tp_borr_inf,b_tp_principle.shape:%s', np.array(b_tp_principle).shape)

        # B4. Components: informal, b_informal_prime_wthint_save
        logger.debug('np.transpose(b_tp_lend_inf):\n%s', np.transpose(b_tp_lend_inf))
        if (b_tp_lend_inf is not 0):
            b_tp_principle = b_tp_principle + (1 / self.R_INFORM_SAVE) * b_tp_lend_inf + self.BNI_LEND_P
            logger.info('b_tp_lend_inf,b_tp_principle.shape:%s', np.array(b_tp_principle).shape)

        logger.debug('np.transpose(b_tp_principle):\n%s', np.transpose(b_tp_principle))
        return b_tp_principle

    def cash(self, Y, k_tt, b_tt):
        return Y + b_tt + self.k_depreciate(k_tt)

    def k_depreciate(self, k):
        return (1 - self.K_DEPRECIATION) * k
