# Generated by Django 3.2.2 on 2021-08-02 18:05

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("data", "0036_auto_20210802_1752"),
    ]

    operations = [
        migrations.CreateModel(
            name="RunPlan",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("success", models.BooleanField(default=True)),
                ("start_time", models.DateTimeField()),
                ("end_time", models.DateTimeField()),
                ("exception", models.TextField(blank=True, default="")),
                ("traceback", models.TextField(blank=True, default="")),
                (
                    "jurisdiction",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="runs",
                        to="data.jurisdiction",
                    ),
                ),
            ],
            options={
                "db_table": "pupa_runplan",
            },
        ),
        migrations.CreateModel(
            name="SessionDataQualityReport",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("bills_missing_actions", models.PositiveIntegerField()),
                ("bills_missing_sponsors", models.PositiveIntegerField()),
                ("bills_missing_versions", models.PositiveIntegerField()),
                ("votes_missing_voters", models.PositiveIntegerField()),
                ("votes_missing_bill", models.PositiveIntegerField()),
                ("votes_missing_yes_count", models.PositiveIntegerField()),
                ("votes_missing_no_count", models.PositiveIntegerField()),
                ("votes_with_bad_counts", models.PositiveIntegerField()),
                ("unmatched_sponsor_people", models.JSONField()),
                ("unmatched_sponsor_organizations", models.JSONField()),
                ("unmatched_voters", models.JSONField()),
                (
                    "legislative_session",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="data.legislativesession",
                    ),
                ),
            ],
            options={
                "db_table": "pupa_sessiondataqualityreport",
            },
        ),
        migrations.CreateModel(
            name="ScrapeReport",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("scraper", models.CharField(max_length=300)),
                ("args", models.CharField(max_length=300)),
                ("start_time", models.DateTimeField()),
                ("end_time", models.DateTimeField()),
                (
                    "plan",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="scrapers",
                        to="data.runplan",
                    ),
                ),
            ],
            options={
                "db_table": "pupa_scrapereport",
            },
        ),
        migrations.CreateModel(
            name="ScrapeObjects",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "object_type",
                    models.CharField(
                        choices=[
                            ("jurisdiction", "Jurisdiction"),
                            ("person", "Person"),
                            ("organization", "Organization"),
                            ("post", "Post"),
                            ("membership", "Membership"),
                            ("bill", "Bill"),
                            ("vote_event", "VoteEvent"),
                            ("event", "Event"),
                        ],
                        max_length=20,
                    ),
                ),
                ("count", models.PositiveIntegerField()),
                (
                    "report",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="scraped_objects",
                        to="data.scrapereport",
                    ),
                ),
            ],
            options={
                "db_table": "pupa_scrapeobjects",
            },
        ),
        migrations.CreateModel(
            name="ImportObjects",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "object_type",
                    models.CharField(
                        choices=[
                            ("jurisdiction", "Jurisdiction"),
                            ("person", "Person"),
                            ("organization", "Organization"),
                            ("post", "Post"),
                            ("membership", "Membership"),
                            ("bill", "Bill"),
                            ("vote_event", "VoteEvent"),
                            ("event", "Event"),
                        ],
                        max_length=20,
                    ),
                ),
                ("insert_count", models.PositiveIntegerField()),
                ("update_count", models.PositiveIntegerField()),
                ("noop_count", models.PositiveIntegerField()),
                ("start_time", models.DateTimeField()),
                ("end_time", models.DateTimeField()),
                (
                    "report",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="imported_objects",
                        to="data.runplan",
                    ),
                ),
            ],
            options={
                "db_table": "pupa_importobjects",
            },
        ),
    ]
