from ..models import State, Chamber, District, simple_numbered_districts

ID = State(
    name="Idaho",
    abbr="ID",
    capital="Boise",
    capital_tz="America/Denver",
    fips="16",
    unicameral=False,
    legislature_name="Idaho State Legislature",
    legislature_organization_id="ocd-organization/654d4d38-e413-4307-a420-6f1ee2594673",
    executive_name="Office of the Governor",
    executive_organization_id="ocd-organization/9bbaab73-ae4e-5d25-9f32-c3af64a77829",
    division_id="ocd-division/country:us/state:id",
    jurisdiction_id="ocd-jurisdiction/country:us/state:id/government",
    url="http://www.legislature.idaho.gov",
    lower=Chamber(
        chamber_type="lower",
        name="House",
        organization_id="ocd-organization/7a59916c-201a-49b2-9288-776ffea9f6cb",
        num_seats=70,
        title="Representative",
        districts=[
            District("1A", "lower", "ocd-division/country:us/state:id/sldl:1a", 1),
            District("1B", "lower", "ocd-division/country:us/state:id/sldl:1b", 1),
            District("2A", "lower", "ocd-division/country:us/state:id/sldl:2a", 1),
            District("2B", "lower", "ocd-division/country:us/state:id/sldl:2b", 1),
            District("3A", "lower", "ocd-division/country:us/state:id/sldl:3a", 1),
            District("3B", "lower", "ocd-division/country:us/state:id/sldl:3b", 1),
            District("4A", "lower", "ocd-division/country:us/state:id/sldl:4a", 1),
            District("4B", "lower", "ocd-division/country:us/state:id/sldl:4b", 1),
            District("5A", "lower", "ocd-division/country:us/state:id/sldl:5a", 1),
            District("5B", "lower", "ocd-division/country:us/state:id/sldl:5b", 1),
            District("6A", "lower", "ocd-division/country:us/state:id/sldl:6a", 1),
            District("6B", "lower", "ocd-division/country:us/state:id/sldl:6b", 1),
            District("7A", "lower", "ocd-division/country:us/state:id/sldl:7a", 1),
            District("7B", "lower", "ocd-division/country:us/state:id/sldl:7b", 1),
            District("8A", "lower", "ocd-division/country:us/state:id/sldl:8a", 1),
            District("8B", "lower", "ocd-division/country:us/state:id/sldl:8b", 1),
            District("9A", "lower", "ocd-division/country:us/state:id/sldl:9a", 1),
            District("9B", "lower", "ocd-division/country:us/state:id/sldl:9b", 1),
            District("10A", "lower", "ocd-division/country:us/state:id/sldl:10a", 1),
            District("10B", "lower", "ocd-division/country:us/state:id/sldl:10b", 1),
            District("11A", "lower", "ocd-division/country:us/state:id/sldl:11a", 1),
            District("11B", "lower", "ocd-division/country:us/state:id/sldl:11b", 1),
            District("12A", "lower", "ocd-division/country:us/state:id/sldl:12a", 1),
            District("12B", "lower", "ocd-division/country:us/state:id/sldl:12b", 1),
            District("13A", "lower", "ocd-division/country:us/state:id/sldl:13a", 1),
            District("13B", "lower", "ocd-division/country:us/state:id/sldl:13b", 1),
            District("14A", "lower", "ocd-division/country:us/state:id/sldl:14a", 1),
            District("14B", "lower", "ocd-division/country:us/state:id/sldl:14b", 1),
            District("15A", "lower", "ocd-division/country:us/state:id/sldl:15a", 1),
            District("15B", "lower", "ocd-division/country:us/state:id/sldl:15b", 1),
            District("16A", "lower", "ocd-division/country:us/state:id/sldl:16a", 1),
            District("16B", "lower", "ocd-division/country:us/state:id/sldl:16b", 1),
            District("17A", "lower", "ocd-division/country:us/state:id/sldl:17a", 1),
            District("17B", "lower", "ocd-division/country:us/state:id/sldl:17b", 1),
            District("18A", "lower", "ocd-division/country:us/state:id/sldl:18a", 1),
            District("18B", "lower", "ocd-division/country:us/state:id/sldl:18b", 1),
            District("19A", "lower", "ocd-division/country:us/state:id/sldl:19a", 1),
            District("19B", "lower", "ocd-division/country:us/state:id/sldl:19b", 1),
            District("20A", "lower", "ocd-division/country:us/state:id/sldl:20a", 1),
            District("20B", "lower", "ocd-division/country:us/state:id/sldl:20b", 1),
            District("21A", "lower", "ocd-division/country:us/state:id/sldl:21a", 1),
            District("21B", "lower", "ocd-division/country:us/state:id/sldl:21b", 1),
            District("22A", "lower", "ocd-division/country:us/state:id/sldl:22a", 1),
            District("22B", "lower", "ocd-division/country:us/state:id/sldl:22b", 1),
            District("23A", "lower", "ocd-division/country:us/state:id/sldl:23a", 1),
            District("23B", "lower", "ocd-division/country:us/state:id/sldl:23b", 1),
            District("24A", "lower", "ocd-division/country:us/state:id/sldl:24a", 1),
            District("24B", "lower", "ocd-division/country:us/state:id/sldl:24b", 1),
            District("25A", "lower", "ocd-division/country:us/state:id/sldl:25a", 1),
            District("25B", "lower", "ocd-division/country:us/state:id/sldl:25b", 1),
            District("26A", "lower", "ocd-division/country:us/state:id/sldl:26a", 1),
            District("26B", "lower", "ocd-division/country:us/state:id/sldl:26b", 1),
            District("27A", "lower", "ocd-division/country:us/state:id/sldl:27a", 1),
            District("27B", "lower", "ocd-division/country:us/state:id/sldl:27b", 1),
            District("28A", "lower", "ocd-division/country:us/state:id/sldl:28a", 1),
            District("28B", "lower", "ocd-division/country:us/state:id/sldl:28b", 1),
            District("29A", "lower", "ocd-division/country:us/state:id/sldl:29a", 1),
            District("29B", "lower", "ocd-division/country:us/state:id/sldl:29b", 1),
            District("30A", "lower", "ocd-division/country:us/state:id/sldl:30a", 1),
            District("30B", "lower", "ocd-division/country:us/state:id/sldl:30b", 1),
            District("31A", "lower", "ocd-division/country:us/state:id/sldl:31a", 1),
            District("31B", "lower", "ocd-division/country:us/state:id/sldl:31b", 1),
            District("32A", "lower", "ocd-division/country:us/state:id/sldl:32a", 1),
            District("32B", "lower", "ocd-division/country:us/state:id/sldl:32b", 1),
            District("33A", "lower", "ocd-division/country:us/state:id/sldl:33a", 1),
            District("33B", "lower", "ocd-division/country:us/state:id/sldl:33b", 1),
            District("34A", "lower", "ocd-division/country:us/state:id/sldl:34a", 1),
            District("34B", "lower", "ocd-division/country:us/state:id/sldl:34b", 1),
            District("35A", "lower", "ocd-division/country:us/state:id/sldl:35a", 1),
            District("35B", "lower", "ocd-division/country:us/state:id/sldl:35b", 1),
        ],
    ),
    upper=Chamber(
        chamber_type="upper",
        name="Senate",
        organization_id="ocd-organization/e8c4c8ae-7ba0-4116-9865-5d34fcc6e681",
        num_seats=35,
        title="Senator",
        districts=simple_numbered_districts(
            "ocd-division/country:us/state:id", "upper", 35
        ),
    ),
)
