from ..models import State, Chamber, District, simple_numbered_districts

MN = State(
    name="Minnesota",
    abbr="MN",
    capital="Saint Paul",
    capital_tz="America/Chicago",
    fips="27",
    unicameral=False,
    legislature_name="Minnesota State Legislature",
    legislature_organization_id="ocd-organization/c5dddecb-4365-441f-bb5b-251dc6828d14",
    executive_name="Office of the Governor",
    executive_organization_id="ocd-organization/339ea74e-8ea4-4ce3-902d-6fd7a5bc571b",
    division_id="ocd-division/country:us/state:mn",
    jurisdiction_id="ocd-jurisdiction/country:us/state:mn/government",
    url="http://state.mn.us/",
    lower=Chamber(
        chamber_type="lower",
        name="House",
        organization_id="ocd-organization/e91db6f8-2232-49cd-91af-fdb5adb4ac3b",
        num_seats=134,
        title="Representative",
        districts=[
            District("1A", "lower", "ocd-division/country:us/state:mn/sldl:1a", 1),
            District("1B", "lower", "ocd-division/country:us/state:mn/sldl:1b", 1),
            District("2A", "lower", "ocd-division/country:us/state:mn/sldl:2a", 1),
            District("2B", "lower", "ocd-division/country:us/state:mn/sldl:2b", 1),
            District("3A", "lower", "ocd-division/country:us/state:mn/sldl:3a", 1),
            District("3B", "lower", "ocd-division/country:us/state:mn/sldl:3b", 1),
            District("4A", "lower", "ocd-division/country:us/state:mn/sldl:4a", 1),
            District("4B", "lower", "ocd-division/country:us/state:mn/sldl:4b", 1),
            District("5A", "lower", "ocd-division/country:us/state:mn/sldl:5a", 1),
            District("5B", "lower", "ocd-division/country:us/state:mn/sldl:5b", 1),
            District("6A", "lower", "ocd-division/country:us/state:mn/sldl:6a", 1),
            District("6B", "lower", "ocd-division/country:us/state:mn/sldl:6b", 1),
            District("7A", "lower", "ocd-division/country:us/state:mn/sldl:7a", 1),
            District("7B", "lower", "ocd-division/country:us/state:mn/sldl:7b", 1),
            District("8A", "lower", "ocd-division/country:us/state:mn/sldl:8a", 1),
            District("8B", "lower", "ocd-division/country:us/state:mn/sldl:8b", 1),
            District("9A", "lower", "ocd-division/country:us/state:mn/sldl:9a", 1),
            District("9B", "lower", "ocd-division/country:us/state:mn/sldl:9b", 1),
            District("10A", "lower", "ocd-division/country:us/state:mn/sldl:10a", 1),
            District("10B", "lower", "ocd-division/country:us/state:mn/sldl:10b", 1),
            District("11A", "lower", "ocd-division/country:us/state:mn/sldl:11a", 1),
            District("11B", "lower", "ocd-division/country:us/state:mn/sldl:11b", 1),
            District("12A", "lower", "ocd-division/country:us/state:mn/sldl:12a", 1),
            District("12B", "lower", "ocd-division/country:us/state:mn/sldl:12b", 1),
            District("13A", "lower", "ocd-division/country:us/state:mn/sldl:13a", 1),
            District("13B", "lower", "ocd-division/country:us/state:mn/sldl:13b", 1),
            District("14A", "lower", "ocd-division/country:us/state:mn/sldl:14a", 1),
            District("14B", "lower", "ocd-division/country:us/state:mn/sldl:14b", 1),
            District("15A", "lower", "ocd-division/country:us/state:mn/sldl:15a", 1),
            District("15B", "lower", "ocd-division/country:us/state:mn/sldl:15b", 1),
            District("16A", "lower", "ocd-division/country:us/state:mn/sldl:16a", 1),
            District("16B", "lower", "ocd-division/country:us/state:mn/sldl:16b", 1),
            District("17A", "lower", "ocd-division/country:us/state:mn/sldl:17a", 1),
            District("17B", "lower", "ocd-division/country:us/state:mn/sldl:17b", 1),
            District("18A", "lower", "ocd-division/country:us/state:mn/sldl:18a", 1),
            District("18B", "lower", "ocd-division/country:us/state:mn/sldl:18b", 1),
            District("19A", "lower", "ocd-division/country:us/state:mn/sldl:19a", 1),
            District("19B", "lower", "ocd-division/country:us/state:mn/sldl:19b", 1),
            District("20A", "lower", "ocd-division/country:us/state:mn/sldl:20a", 1),
            District("20B", "lower", "ocd-division/country:us/state:mn/sldl:20b", 1),
            District("21A", "lower", "ocd-division/country:us/state:mn/sldl:21a", 1),
            District("21B", "lower", "ocd-division/country:us/state:mn/sldl:21b", 1),
            District("22A", "lower", "ocd-division/country:us/state:mn/sldl:22a", 1),
            District("22B", "lower", "ocd-division/country:us/state:mn/sldl:22b", 1),
            District("23A", "lower", "ocd-division/country:us/state:mn/sldl:23a", 1),
            District("23B", "lower", "ocd-division/country:us/state:mn/sldl:23b", 1),
            District("24A", "lower", "ocd-division/country:us/state:mn/sldl:24a", 1),
            District("24B", "lower", "ocd-division/country:us/state:mn/sldl:24b", 1),
            District("25A", "lower", "ocd-division/country:us/state:mn/sldl:25a", 1),
            District("25B", "lower", "ocd-division/country:us/state:mn/sldl:25b", 1),
            District("26A", "lower", "ocd-division/country:us/state:mn/sldl:26a", 1),
            District("26B", "lower", "ocd-division/country:us/state:mn/sldl:26b", 1),
            District("27A", "lower", "ocd-division/country:us/state:mn/sldl:27a", 1),
            District("27B", "lower", "ocd-division/country:us/state:mn/sldl:27b", 1),
            District("28A", "lower", "ocd-division/country:us/state:mn/sldl:28a", 1),
            District("28B", "lower", "ocd-division/country:us/state:mn/sldl:28b", 1),
            District("29A", "lower", "ocd-division/country:us/state:mn/sldl:29a", 1),
            District("29B", "lower", "ocd-division/country:us/state:mn/sldl:29b", 1),
            District("30A", "lower", "ocd-division/country:us/state:mn/sldl:30a", 1),
            District("30B", "lower", "ocd-division/country:us/state:mn/sldl:30b", 1),
            District("31A", "lower", "ocd-division/country:us/state:mn/sldl:31a", 1),
            District("31B", "lower", "ocd-division/country:us/state:mn/sldl:31b", 1),
            District("32A", "lower", "ocd-division/country:us/state:mn/sldl:32a", 1),
            District("32B", "lower", "ocd-division/country:us/state:mn/sldl:32b", 1),
            District("33A", "lower", "ocd-division/country:us/state:mn/sldl:33a", 1),
            District("33B", "lower", "ocd-division/country:us/state:mn/sldl:33b", 1),
            District("34A", "lower", "ocd-division/country:us/state:mn/sldl:34a", 1),
            District("34B", "lower", "ocd-division/country:us/state:mn/sldl:34b", 1),
            District("35A", "lower", "ocd-division/country:us/state:mn/sldl:35a", 1),
            District("35B", "lower", "ocd-division/country:us/state:mn/sldl:35b", 1),
            District("36A", "lower", "ocd-division/country:us/state:mn/sldl:36a", 1),
            District("36B", "lower", "ocd-division/country:us/state:mn/sldl:36b", 1),
            District("37A", "lower", "ocd-division/country:us/state:mn/sldl:37a", 1),
            District("37B", "lower", "ocd-division/country:us/state:mn/sldl:37b", 1),
            District("38A", "lower", "ocd-division/country:us/state:mn/sldl:38a", 1),
            District("38B", "lower", "ocd-division/country:us/state:mn/sldl:38b", 1),
            District("39A", "lower", "ocd-division/country:us/state:mn/sldl:39a", 1),
            District("39B", "lower", "ocd-division/country:us/state:mn/sldl:39b", 1),
            District("40A", "lower", "ocd-division/country:us/state:mn/sldl:40a", 1),
            District("40B", "lower", "ocd-division/country:us/state:mn/sldl:40b", 1),
            District("41A", "lower", "ocd-division/country:us/state:mn/sldl:41a", 1),
            District("41B", "lower", "ocd-division/country:us/state:mn/sldl:41b", 1),
            District("42A", "lower", "ocd-division/country:us/state:mn/sldl:42a", 1),
            District("42B", "lower", "ocd-division/country:us/state:mn/sldl:42b", 1),
            District("43A", "lower", "ocd-division/country:us/state:mn/sldl:43a", 1),
            District("43B", "lower", "ocd-division/country:us/state:mn/sldl:43b", 1),
            District("44A", "lower", "ocd-division/country:us/state:mn/sldl:44a", 1),
            District("44B", "lower", "ocd-division/country:us/state:mn/sldl:44b", 1),
            District("45A", "lower", "ocd-division/country:us/state:mn/sldl:45a", 1),
            District("45B", "lower", "ocd-division/country:us/state:mn/sldl:45b", 1),
            District("46A", "lower", "ocd-division/country:us/state:mn/sldl:46a", 1),
            District("46B", "lower", "ocd-division/country:us/state:mn/sldl:46b", 1),
            District("47A", "lower", "ocd-division/country:us/state:mn/sldl:47a", 1),
            District("47B", "lower", "ocd-division/country:us/state:mn/sldl:47b", 1),
            District("48A", "lower", "ocd-division/country:us/state:mn/sldl:48a", 1),
            District("48B", "lower", "ocd-division/country:us/state:mn/sldl:48b", 1),
            District("49A", "lower", "ocd-division/country:us/state:mn/sldl:49a", 1),
            District("49B", "lower", "ocd-division/country:us/state:mn/sldl:49b", 1),
            District("50A", "lower", "ocd-division/country:us/state:mn/sldl:50a", 1),
            District("50B", "lower", "ocd-division/country:us/state:mn/sldl:50b", 1),
            District("51A", "lower", "ocd-division/country:us/state:mn/sldl:51a", 1),
            District("51B", "lower", "ocd-division/country:us/state:mn/sldl:51b", 1),
            District("52A", "lower", "ocd-division/country:us/state:mn/sldl:52a", 1),
            District("52B", "lower", "ocd-division/country:us/state:mn/sldl:52b", 1),
            District("53A", "lower", "ocd-division/country:us/state:mn/sldl:53a", 1),
            District("53B", "lower", "ocd-division/country:us/state:mn/sldl:53b", 1),
            District("54A", "lower", "ocd-division/country:us/state:mn/sldl:54a", 1),
            District("54B", "lower", "ocd-division/country:us/state:mn/sldl:54b", 1),
            District("55A", "lower", "ocd-division/country:us/state:mn/sldl:55a", 1),
            District("55B", "lower", "ocd-division/country:us/state:mn/sldl:55b", 1),
            District("56A", "lower", "ocd-division/country:us/state:mn/sldl:56a", 1),
            District("56B", "lower", "ocd-division/country:us/state:mn/sldl:56b", 1),
            District("57A", "lower", "ocd-division/country:us/state:mn/sldl:57a", 1),
            District("57B", "lower", "ocd-division/country:us/state:mn/sldl:57b", 1),
            District("58A", "lower", "ocd-division/country:us/state:mn/sldl:58a", 1),
            District("58B", "lower", "ocd-division/country:us/state:mn/sldl:58b", 1),
            District("59A", "lower", "ocd-division/country:us/state:mn/sldl:59a", 1),
            District("59B", "lower", "ocd-division/country:us/state:mn/sldl:59b", 1),
            District("60A", "lower", "ocd-division/country:us/state:mn/sldl:60a", 1),
            District("60B", "lower", "ocd-division/country:us/state:mn/sldl:60b", 1),
            District("61A", "lower", "ocd-division/country:us/state:mn/sldl:61a", 1),
            District("61B", "lower", "ocd-division/country:us/state:mn/sldl:61b", 1),
            District("62A", "lower", "ocd-division/country:us/state:mn/sldl:62a", 1),
            District("62B", "lower", "ocd-division/country:us/state:mn/sldl:62b", 1),
            District("63A", "lower", "ocd-division/country:us/state:mn/sldl:63a", 1),
            District("63B", "lower", "ocd-division/country:us/state:mn/sldl:63b", 1),
            District("64A", "lower", "ocd-division/country:us/state:mn/sldl:64a", 1),
            District("64B", "lower", "ocd-division/country:us/state:mn/sldl:64b", 1),
            District("65A", "lower", "ocd-division/country:us/state:mn/sldl:65a", 1),
            District("65B", "lower", "ocd-division/country:us/state:mn/sldl:65b", 1),
            District("66A", "lower", "ocd-division/country:us/state:mn/sldl:66a", 1),
            District("66B", "lower", "ocd-division/country:us/state:mn/sldl:66b", 1),
            District("67A", "lower", "ocd-division/country:us/state:mn/sldl:67a", 1),
            District("67B", "lower", "ocd-division/country:us/state:mn/sldl:67b", 1),
        ],
    ),
    upper=Chamber(
        chamber_type="upper",
        name="Senate",
        organization_id="ocd-organization/6a026144-758d-4d57-b856-9c60dce3c4b5",
        num_seats=67,
        title="Senator",
        districts=simple_numbered_districts(
            "ocd-division/country:us/state:mn", "upper", 67
        ),
    ),
)
