from ..models import State, Chamber, District, simple_numbered_districts

ND = State(
    name="North Dakota",
    abbr="ND",
    capital="Bismarck",
    capital_tz="America/North_Dakota/Center",
    fips="38",
    unicameral=False,
    legislature_name="North Dakota Legislative Assembly",
    legislature_organization_id="ocd-organization/aa301a79-0ad8-4905-818c-0cd5f1ce5946",
    executive_name="Office of the Governor",
    executive_organization_id="ocd-organization/5ba1c008-42e8-55ad-864e-e95b318d7ce4",
    division_id="ocd-division/country:us/state:nd",
    jurisdiction_id="ocd-jurisdiction/country:us/state:nd/government",
    url="http://www.legis.nd.gov/",
    lower=Chamber(
        chamber_type="lower",
        name="House",
        organization_id="ocd-organization/b9f9b32c-a2cc-4cca-941f-862aecc30617",
        num_seats=94,
        title="Representative",
        districts=[
            District("1", "lower", "ocd-division/country:us/state:nd/sldl:1", 2),
            District("2", "lower", "ocd-division/country:us/state:nd/sldl:2", 2),
            District("3", "lower", "ocd-division/country:us/state:nd/sldl:3", 2),
            District("4A", "lower", "ocd-division/country:us/state:nd/sldl:4a", 1),
            District("4B", "lower", "ocd-division/country:us/state:nd/sldl:4b", 1),
            District("5", "lower", "ocd-division/country:us/state:nd/sldl:5", 2),
            District("6", "lower", "ocd-division/country:us/state:nd/sldl:6", 2),
            District("7", "lower", "ocd-division/country:us/state:nd/sldl:7", 2),
            District("8", "lower", "ocd-division/country:us/state:nd/sldl:8", 2),
            District("9A", "lower", "ocd-division/country:us/state:nd/sldl:9a", 1),
            District("9B", "lower", "ocd-division/country:us/state:nd/sldl:9b", 1),
            District("10", "lower", "ocd-division/country:us/state:nd/sldl:10", 2),
            District("11", "lower", "ocd-division/country:us/state:nd/sldl:11", 2),
            District("12", "lower", "ocd-division/country:us/state:nd/sldl:12", 2),
            District("13", "lower", "ocd-division/country:us/state:nd/sldl:13", 2),
            District("14", "lower", "ocd-division/country:us/state:nd/sldl:14", 2),
            District("15", "lower", "ocd-division/country:us/state:nd/sldl:15", 2),
            District("16", "lower", "ocd-division/country:us/state:nd/sldl:16", 2),
            District("17", "lower", "ocd-division/country:us/state:nd/sldl:17", 2),
            District("18", "lower", "ocd-division/country:us/state:nd/sldl:18", 2),
            District("19", "lower", "ocd-division/country:us/state:nd/sldl:19", 2),
            District("20", "lower", "ocd-division/country:us/state:nd/sldl:20", 2),
            District("21", "lower", "ocd-division/country:us/state:nd/sldl:21", 2),
            District("22", "lower", "ocd-division/country:us/state:nd/sldl:22", 2),
            District("23", "lower", "ocd-division/country:us/state:nd/sldl:23", 2),
            District("24", "lower", "ocd-division/country:us/state:nd/sldl:24", 2),
            District("25", "lower", "ocd-division/country:us/state:nd/sldl:25", 2),
            District("26", "lower", "ocd-division/country:us/state:nd/sldl:26", 2),
            District("27", "lower", "ocd-division/country:us/state:nd/sldl:27", 2),
            District("28", "lower", "ocd-division/country:us/state:nd/sldl:28", 2),
            District("29", "lower", "ocd-division/country:us/state:nd/sldl:29", 2),
            District("30", "lower", "ocd-division/country:us/state:nd/sldl:30", 2),
            District("31", "lower", "ocd-division/country:us/state:nd/sldl:31", 2),
            District("32", "lower", "ocd-division/country:us/state:nd/sldl:32", 2),
            District("33", "lower", "ocd-division/country:us/state:nd/sldl:33", 2),
            District("34", "lower", "ocd-division/country:us/state:nd/sldl:34", 2),
            District("35", "lower", "ocd-division/country:us/state:nd/sldl:35", 2),
            District("36", "lower", "ocd-division/country:us/state:nd/sldl:36", 2),
            District("37", "lower", "ocd-division/country:us/state:nd/sldl:37", 2),
            District("38", "lower", "ocd-division/country:us/state:nd/sldl:38", 2),
            District("39", "lower", "ocd-division/country:us/state:nd/sldl:39", 2),
            District("40", "lower", "ocd-division/country:us/state:nd/sldl:40", 2),
            District("41", "lower", "ocd-division/country:us/state:nd/sldl:41", 2),
            District("42", "lower", "ocd-division/country:us/state:nd/sldl:42", 2),
            District("43", "lower", "ocd-division/country:us/state:nd/sldl:43", 2),
            District("44", "lower", "ocd-division/country:us/state:nd/sldl:44", 2),
            District("45", "lower", "ocd-division/country:us/state:nd/sldl:45", 2),
            District("46", "lower", "ocd-division/country:us/state:nd/sldl:46", 2),
            District("47", "lower", "ocd-division/country:us/state:nd/sldl:47", 2),
        ],
    ),
    upper=Chamber(
        chamber_type="upper",
        name="Senate",
        organization_id="ocd-organization/79645ed7-6baa-4842-ac97-09b444c4020b",
        num_seats=47,
        title="Senator",
        districts=simple_numbered_districts(
            "ocd-division/country:us/state:nd", "upper", 47
        ),
    ),
)
