import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the ServicePerimeter and its use. Does not affect behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#description AccessContextManagerServicePerimeter#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Resource name for the ServicePerimeter. The short_name component must begin with a letter and only include alphanumeric and '_'. Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#name AccessContextManagerServicePerimeter#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The AccessPolicy this ServicePerimeter lives in. Format: accessPolicies/{policy_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#parent AccessContextManagerServicePerimeter#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * Specifies the type of the Perimeter.
     *
     * There are two types: regular and
     * bridge. Regular Service Perimeter contains resources, access levels,
     * and restricted services. Every resource can be in at most
     * ONE regular Service Perimeter.
     *
     * In addition to being in a regular service perimeter, a resource can also
     * be in zero or more perimeter bridges. A perimeter bridge only contains
     * resources. Cross project operations are permitted if all effected
     * resources share some perimeter (whether bridge or regular). Perimeter
     * Bridge does not contain access levels or services: those are governed
     * entirely by the regular perimeter that resource is in.
     *
     * Perimeter Bridges are typically useful when building more complex
     * topologies with many independent perimeters that need to share some data
     * with a common perimeter, but should not be able to share data among
     * themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#perimeter_type AccessContextManagerServicePerimeter#perimeter_type}
     *
     * @stability stable
     */
    readonly perimeterType?: string;
    /**
     * Human readable title. Must be unique within the Policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#title AccessContextManagerServicePerimeter#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * Use explicit dry run spec flag.
     *
     * Ordinarily, a dry-run spec implicitly exists
     * for all Service Perimeters, and that spec is identical to the status for those
     * Service Perimeters. When this flag is set, it inhibits the generation of the
     * implicit spec, thereby allowing the user to explicitly provide a
     * configuration ("spec") to use in a dry-run version of the Service Perimeter.
     * This allows the user to test changes to the enforced config ("status") without
     * actually enforcing them. This testing is done through analyzing the differences
     * between currently enforced and suggested restrictions. useExplicitDryRunSpec must
     * bet set to True if any of the fields in the spec are set to non-default values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#use_explicit_dry_run_spec AccessContextManagerServicePerimeter#use_explicit_dry_run_spec}
     *
     * @stability stable
     */
    readonly useExplicitDryRunSpec?: boolean | cdktf.IResolvable;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#spec AccessContextManagerServicePerimeter#spec}
     *
     * @stability stable
     */
    readonly spec?: AccessContextManagerServicePerimeterSpec;
    /**
     * status block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#status AccessContextManagerServicePerimeter#status}
     *
     * @stability stable
     */
    readonly status?: AccessContextManagerServicePerimeterStatus;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#timeouts AccessContextManagerServicePerimeter#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AccessContextManagerServicePerimeterTimeouts;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom {
    /**
     * A list of identities that are allowed access through this 'EgressPolicy'.
     *
     * Should be in the format of email address. The email address should
     * represent individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identities AccessContextManagerServicePerimeter#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access to outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will
     * be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identity_type AccessContextManagerServicePerimeter#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    /**
     * @stability stable
     */
    get identities(): string[] | undefined;
    /**
     * @stability stable
     */
    set identities(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIdentities(): void;
    /**
     * @stability stable
     */
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    /**
     * @stability stable
     */
    get identityType(): string | undefined;
    /**
     * @stability stable
     */
    set identityType(value: string | undefined);
    /**
     * @stability stable
     */
    resetIdentityType(): void;
    /**
     * @stability stable
     */
    get identityTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors {
    /**
     * Value for 'method' should be a valid method name for the corresponding  'serviceName' in 'ApiOperation'.
     *
     * If '*' used as value for method,
     * then ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method AccessContextManagerServicePerimeter#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#permission AccessContextManagerServicePerimeter#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with serviceName
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#service_name AccessContextManagerServicePerimeter#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method_selectors AccessContextManagerServicePerimeter#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', that match this to stanza.
     *
     * A request matches
     * if it contains a resource in this list. If * is specified for resources,
     * then this 'EgressTo' rule will authorize access to all resources outside
     * the perimeter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#operations AccessContextManagerServicePerimeter#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[];
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[] | undefined;
    /**
     * @stability stable
     */
    set resources(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _operations?;
    /**
     * @stability stable
     */
    get operations(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | undefined;
    /**
     * @stability stable
     */
    set operations(value: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | undefined);
    /**
     * @stability stable
     */
    resetOperations(): void;
    /**
     * @stability stable
     */
    get operationsInput(): AccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecEgressPolicies {
    /**
     * egress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_from AccessContextManagerServicePerimeter#egress_from}
     *
     * @stability stable
     */
    readonly egressFrom?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom;
    /**
     * egress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_to AccessContextManagerServicePerimeter#egress_to}
     *
     * @stability stable
     */
    readonly egressTo?: AccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources {
    /**
     * An 'AccessLevel' resource name that allow resources within the  'ServicePerimeters' to be accessed from the internet.
     *
     * 'AccessLevels' listed
     * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
     * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
     * resources within the perimeter can only be accessed via Google Cloud calls
     * with request origins within the perimeter.
     * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
     * If * is specified, then all IngressSources will be allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#access_level AccessContextManagerServicePerimeter#access_level}
     *
     * @stability stable
     */
    readonly accessLevel?: string;
    /**
     * A Google Cloud resource that is allowed to ingress the perimeter.
     *
     * Requests from these resources will be allowed to access perimeter data.
     * Currently only projects are allowed. Format 'projects/{project_number}'
     * The project may be in any Google Cloud organization, not just the
     * organization that the perimeter is defined in. '*' is not allowed, the case
     * of allowing all Google Cloud resources only is not supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resource AccessContextManagerServicePerimeter#resource}
     *
     * @stability stable
     */
    readonly resource?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom {
    /**
     * A list of identities that are allowed access through this ingress policy.
     *
     * Should be in the format of email address. The email address should represent
     * individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identities AccessContextManagerServicePerimeter#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access from outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will be
     * allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identity_type AccessContextManagerServicePerimeter#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
    /**
     * sources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#sources AccessContextManagerServicePerimeter#sources}
     *
     * @stability stable
     */
    readonly sources?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[];
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    /**
     * @stability stable
     */
    get identities(): string[] | undefined;
    /**
     * @stability stable
     */
    set identities(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIdentities(): void;
    /**
     * @stability stable
     */
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    /**
     * @stability stable
     */
    get identityType(): string | undefined;
    /**
     * @stability stable
     */
    set identityType(value: string | undefined);
    /**
     * @stability stable
     */
    resetIdentityType(): void;
    /**
     * @stability stable
     */
    get identityTypeInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | undefined;
    /**
     * @stability stable
     */
    set sources(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | undefined);
    /**
     * @stability stable
     */
    resetSources(): void;
    /**
     * @stability stable
     */
    get sourcesInput(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors {
    /**
     * Value for method should be a valid method name for the corresponding  serviceName in 'ApiOperation'.
     *
     * If '*' used as value for 'method', then
     * ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method AccessContextManagerServicePerimeter#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#permission AccessContextManagerServicePerimeter#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with 'serviceName'
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#service_name AccessContextManagerServicePerimeter#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method_selectors AccessContextManagerServicePerimeter#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', protected by this 'ServicePerimeter' that are allowed to be accessed by sources defined in the corresponding 'IngressFrom'.
     *
     * A request matches if it contains
     * a resource in this list. If '*' is specified for resources,
     * then this 'IngressTo' rule will authorize access to all
     * resources inside the perimeter, provided that the request
     * also matches the 'operations' field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#operations AccessContextManagerServicePerimeter#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[];
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[] | undefined;
    /**
     * @stability stable
     */
    set resources(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _operations?;
    /**
     * @stability stable
     */
    get operations(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | undefined;
    /**
     * @stability stable
     */
    set operations(value: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | undefined);
    /**
     * @stability stable
     */
    resetOperations(): void;
    /**
     * @stability stable
     */
    get operationsInput(): AccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecIngressPolicies {
    /**
     * ingress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_from AccessContextManagerServicePerimeter#ingress_from}
     *
     * @stability stable
     */
    readonly ingressFrom?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom;
    /**
     * ingress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_to AccessContextManagerServicePerimeter#ingress_to}
     *
     * @stability stable
     */
    readonly ingressTo?: AccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpecVpcAccessibleServices {
    /**
     * The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#allowed_services AccessContextManagerServicePerimeter#allowed_services}
     *
     * @stability stable
     */
    readonly allowedServices?: string[];
    /**
     * Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#enable_restriction AccessContextManagerServicePerimeter#enable_restriction}
     *
     * @stability stable
     */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedServices?;
    /**
     * @stability stable
     */
    get allowedServices(): string[] | undefined;
    /**
     * @stability stable
     */
    set allowedServices(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetAllowedServices(): void;
    /**
     * @stability stable
     */
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    /**
     * @stability stable
     */
    get enableRestriction(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableRestriction(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableRestriction(): void;
    /**
     * @stability stable
     */
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterSpec {
    /**
     * A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.
     *
     * AccessLevels listed must be in the same policy as this
     * ServicePerimeter. Referencing a nonexistent AccessLevel is a
     * syntax error. If no AccessLevel names are listed, resources within
     * the perimeter can only be accessed via GCP calls with request
     * origins within the perimeter. For Service Perimeter Bridge, must
     * be empty.
     *
     * Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#access_levels AccessContextManagerServicePerimeter#access_levels}
     *
     * @stability stable
     */
    readonly accessLevels?: string[];
    /**
     * A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * GCP services that are subject to the Service Perimeter restrictions.
     *
     * Must contain a list of services. For example, if
     * 'storage.googleapis.com' is specified, access to the storage
     * buckets inside the perimeter must meet the perimeter's access
     * restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#restricted_services AccessContextManagerServicePerimeter#restricted_services}
     *
     * @stability stable
     */
    readonly restrictedServices?: string[];
    /**
     * egress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_policies AccessContextManagerServicePerimeter#egress_policies}
     *
     * @stability stable
     */
    readonly egressPolicies?: AccessContextManagerServicePerimeterSpecEgressPolicies[];
    /**
     * ingress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_policies AccessContextManagerServicePerimeter#ingress_policies}
     *
     * @stability stable
     */
    readonly ingressPolicies?: AccessContextManagerServicePerimeterSpecIngressPolicies[];
    /**
     * vpc_accessible_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#vpc_accessible_services AccessContextManagerServicePerimeter#vpc_accessible_services}
     *
     * @stability stable
     */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimeterSpecVpcAccessibleServices;
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterSpecOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _accessLevels?;
    /**
     * @stability stable
     */
    get accessLevels(): string[] | undefined;
    /**
     * @stability stable
     */
    set accessLevels(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetAccessLevels(): void;
    /**
     * @stability stable
     */
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[] | undefined;
    /**
     * @stability stable
     */
    set resources(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    /**
     * @stability stable
     */
    get restrictedServices(): string[] | undefined;
    /**
     * @stability stable
     */
    set restrictedServices(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRestrictedServices(): void;
    /**
     * @stability stable
     */
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies?;
    /**
     * @stability stable
     */
    get egressPolicies(): AccessContextManagerServicePerimeterSpecEgressPolicies[] | undefined;
    /**
     * @stability stable
     */
    set egressPolicies(value: AccessContextManagerServicePerimeterSpecEgressPolicies[] | undefined);
    /**
     * @stability stable
     */
    resetEgressPolicies(): void;
    /**
     * @stability stable
     */
    get egressPoliciesInput(): AccessContextManagerServicePerimeterSpecEgressPolicies[] | undefined;
    private _ingressPolicies?;
    /**
     * @stability stable
     */
    get ingressPolicies(): AccessContextManagerServicePerimeterSpecIngressPolicies[] | undefined;
    /**
     * @stability stable
     */
    set ingressPolicies(value: AccessContextManagerServicePerimeterSpecIngressPolicies[] | undefined);
    /**
     * @stability stable
     */
    resetIngressPolicies(): void;
    /**
     * @stability stable
     */
    get ingressPoliciesInput(): AccessContextManagerServicePerimeterSpecIngressPolicies[] | undefined;
    private _vpcAccessibleServices?;
    private __vpcAccessibleServicesOutput;
    /**
     * @stability stable
     */
    get vpcAccessibleServices(): AccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference;
    /**
     * @stability stable
     */
    putVpcAccessibleServices(value: AccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined): void;
    /**
     * @stability stable
     */
    resetVpcAccessibleServices(): void;
    /**
     * @stability stable
     */
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom {
    /**
     * A list of identities that are allowed access through this 'EgressPolicy'.
     *
     * Should be in the format of email address. The email address should
     * represent individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identities AccessContextManagerServicePerimeter#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access to outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will
     * be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identity_type AccessContextManagerServicePerimeter#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    /**
     * @stability stable
     */
    get identities(): string[] | undefined;
    /**
     * @stability stable
     */
    set identities(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIdentities(): void;
    /**
     * @stability stable
     */
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    /**
     * @stability stable
     */
    get identityType(): string | undefined;
    /**
     * @stability stable
     */
    set identityType(value: string | undefined);
    /**
     * @stability stable
     */
    resetIdentityType(): void;
    /**
     * @stability stable
     */
    get identityTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors {
    /**
     * Value for 'method' should be a valid method name for the corresponding  'serviceName' in 'ApiOperation'.
     *
     * If '*' used as value for method,
     * then ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method AccessContextManagerServicePerimeter#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#permission AccessContextManagerServicePerimeter#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with serviceName
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#service_name AccessContextManagerServicePerimeter#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method_selectors AccessContextManagerServicePerimeter#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', that match this to stanza.
     *
     * A request matches
     * if it contains a resource in this list. If * is specified for resources,
     * then this 'EgressTo' rule will authorize access to all resources outside
     * the perimeter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#operations AccessContextManagerServicePerimeter#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[];
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[] | undefined;
    /**
     * @stability stable
     */
    set resources(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _operations?;
    /**
     * @stability stable
     */
    get operations(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | undefined;
    /**
     * @stability stable
     */
    set operations(value: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | undefined);
    /**
     * @stability stable
     */
    resetOperations(): void;
    /**
     * @stability stable
     */
    get operationsInput(): AccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusEgressPolicies {
    /**
     * egress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_from AccessContextManagerServicePerimeter#egress_from}
     *
     * @stability stable
     */
    readonly egressFrom?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom;
    /**
     * egress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_to AccessContextManagerServicePerimeter#egress_to}
     *
     * @stability stable
     */
    readonly egressTo?: AccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources {
    /**
     * An 'AccessLevel' resource name that allow resources within the  'ServicePerimeters' to be accessed from the internet.
     *
     * 'AccessLevels' listed
     * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
     * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
     * resources within the perimeter can only be accessed via Google Cloud calls
     * with request origins within the perimeter.
     * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
     * If * is specified, then all IngressSources will be allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#access_level AccessContextManagerServicePerimeter#access_level}
     *
     * @stability stable
     */
    readonly accessLevel?: string;
    /**
     * A Google Cloud resource that is allowed to ingress the perimeter.
     *
     * Requests from these resources will be allowed to access perimeter data.
     * Currently only projects are allowed. Format 'projects/{project_number}'
     * The project may be in any Google Cloud organization, not just the
     * organization that the perimeter is defined in. '*' is not allowed, the case
     * of allowing all Google Cloud resources only is not supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resource AccessContextManagerServicePerimeter#resource}
     *
     * @stability stable
     */
    readonly resource?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom {
    /**
     * A list of identities that are allowed access through this ingress policy.
     *
     * Should be in the format of email address. The email address should represent
     * individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identities AccessContextManagerServicePerimeter#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access from outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will be
     * allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#identity_type AccessContextManagerServicePerimeter#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
    /**
     * sources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#sources AccessContextManagerServicePerimeter#sources}
     *
     * @stability stable
     */
    readonly sources?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[];
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _identities?;
    /**
     * @stability stable
     */
    get identities(): string[] | undefined;
    /**
     * @stability stable
     */
    set identities(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIdentities(): void;
    /**
     * @stability stable
     */
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    /**
     * @stability stable
     */
    get identityType(): string | undefined;
    /**
     * @stability stable
     */
    set identityType(value: string | undefined);
    /**
     * @stability stable
     */
    resetIdentityType(): void;
    /**
     * @stability stable
     */
    get identityTypeInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | undefined;
    /**
     * @stability stable
     */
    set sources(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | undefined);
    /**
     * @stability stable
     */
    resetSources(): void;
    /**
     * @stability stable
     */
    get sourcesInput(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors {
    /**
     * Value for method should be a valid method name for the corresponding  serviceName in 'ApiOperation'.
     *
     * If '*' used as value for 'method', then
     * ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method AccessContextManagerServicePerimeter#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#permission AccessContextManagerServicePerimeter#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with 'serviceName'
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#service_name AccessContextManagerServicePerimeter#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#method_selectors AccessContextManagerServicePerimeter#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[];
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', protected by this 'ServicePerimeter' that are allowed to be accessed by sources defined in the corresponding 'IngressFrom'.
     *
     * A request matches if it contains
     * a resource in this list. If '*' is specified for resources,
     * then this 'IngressTo' rule will authorize access to all
     * resources inside the perimeter, provided that the request
     * also matches the 'operations' field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#operations AccessContextManagerServicePerimeter#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[];
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[] | undefined;
    /**
     * @stability stable
     */
    set resources(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _operations?;
    /**
     * @stability stable
     */
    get operations(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | undefined;
    /**
     * @stability stable
     */
    set operations(value: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | undefined);
    /**
     * @stability stable
     */
    resetOperations(): void;
    /**
     * @stability stable
     */
    get operationsInput(): AccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusIngressPolicies {
    /**
     * ingress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_from AccessContextManagerServicePerimeter#ingress_from}
     *
     * @stability stable
     */
    readonly ingressFrom?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom;
    /**
     * ingress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_to AccessContextManagerServicePerimeter#ingress_to}
     *
     * @stability stable
     */
    readonly ingressTo?: AccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatusVpcAccessibleServices {
    /**
     * The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#allowed_services AccessContextManagerServicePerimeter#allowed_services}
     *
     * @stability stable
     */
    readonly allowedServices?: string[];
    /**
     * Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#enable_restriction AccessContextManagerServicePerimeter#enable_restriction}
     *
     * @stability stable
     */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowedServices?;
    /**
     * @stability stable
     */
    get allowedServices(): string[] | undefined;
    /**
     * @stability stable
     */
    set allowedServices(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetAllowedServices(): void;
    /**
     * @stability stable
     */
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    /**
     * @stability stable
     */
    get enableRestriction(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enableRestriction(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnableRestriction(): void;
    /**
     * @stability stable
     */
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterStatus {
    /**
     * A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.
     *
     * AccessLevels listed must be in the same policy as this
     * ServicePerimeter. Referencing a nonexistent AccessLevel is a
     * syntax error. If no AccessLevel names are listed, resources within
     * the perimeter can only be accessed via GCP calls with request
     * origins within the perimeter. For Service Perimeter Bridge, must
     * be empty.
     *
     * Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#access_levels AccessContextManagerServicePerimeter#access_levels}
     *
     * @stability stable
     */
    readonly accessLevels?: string[];
    /**
     * A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#resources AccessContextManagerServicePerimeter#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * GCP services that are subject to the Service Perimeter restrictions.
     *
     * Must contain a list of services. For example, if
     * 'storage.googleapis.com' is specified, access to the storage
     * buckets inside the perimeter must meet the perimeter's access
     * restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#restricted_services AccessContextManagerServicePerimeter#restricted_services}
     *
     * @stability stable
     */
    readonly restrictedServices?: string[];
    /**
     * egress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#egress_policies AccessContextManagerServicePerimeter#egress_policies}
     *
     * @stability stable
     */
    readonly egressPolicies?: AccessContextManagerServicePerimeterStatusEgressPolicies[];
    /**
     * ingress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#ingress_policies AccessContextManagerServicePerimeter#ingress_policies}
     *
     * @stability stable
     */
    readonly ingressPolicies?: AccessContextManagerServicePerimeterStatusIngressPolicies[];
    /**
     * vpc_accessible_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#vpc_accessible_services AccessContextManagerServicePerimeter#vpc_accessible_services}
     *
     * @stability stable
     */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimeterStatusVpcAccessibleServices;
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterStatusOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _accessLevels?;
    /**
     * @stability stable
     */
    get accessLevels(): string[] | undefined;
    /**
     * @stability stable
     */
    set accessLevels(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetAccessLevels(): void;
    /**
     * @stability stable
     */
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[] | undefined;
    /**
     * @stability stable
     */
    set resources(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    /**
     * @stability stable
     */
    get restrictedServices(): string[] | undefined;
    /**
     * @stability stable
     */
    set restrictedServices(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetRestrictedServices(): void;
    /**
     * @stability stable
     */
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies?;
    /**
     * @stability stable
     */
    get egressPolicies(): AccessContextManagerServicePerimeterStatusEgressPolicies[] | undefined;
    /**
     * @stability stable
     */
    set egressPolicies(value: AccessContextManagerServicePerimeterStatusEgressPolicies[] | undefined);
    /**
     * @stability stable
     */
    resetEgressPolicies(): void;
    /**
     * @stability stable
     */
    get egressPoliciesInput(): AccessContextManagerServicePerimeterStatusEgressPolicies[] | undefined;
    private _ingressPolicies?;
    /**
     * @stability stable
     */
    get ingressPolicies(): AccessContextManagerServicePerimeterStatusIngressPolicies[] | undefined;
    /**
     * @stability stable
     */
    set ingressPolicies(value: AccessContextManagerServicePerimeterStatusIngressPolicies[] | undefined);
    /**
     * @stability stable
     */
    resetIngressPolicies(): void;
    /**
     * @stability stable
     */
    get ingressPoliciesInput(): AccessContextManagerServicePerimeterStatusIngressPolicies[] | undefined;
    private _vpcAccessibleServices?;
    private __vpcAccessibleServicesOutput;
    /**
     * @stability stable
     */
    get vpcAccessibleServices(): AccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference;
    /**
     * @stability stable
     */
    putVpcAccessibleServices(value: AccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined): void;
    /**
     * @stability stable
     */
    resetVpcAccessibleServices(): void;
    /**
     * @stability stable
     */
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimeterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#create AccessContextManagerServicePerimeter#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#delete AccessContextManagerServicePerimeter#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html#update AccessContextManagerServicePerimeter#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeterTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html google_access_context_manager_service_perimeter}.
 *
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeter extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeter.html google_access_context_manager_service_perimeter} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerServicePerimeterConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _perimeterType?;
    /**
     * @stability stable
     */
    get perimeterType(): string | undefined;
    /**
     * @stability stable
     */
    set perimeterType(value: string | undefined);
    /**
     * @stability stable
     */
    resetPerimeterType(): void;
    /**
     * @stability stable
     */
    get perimeterTypeInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _useExplicitDryRunSpec?;
    /**
     * @stability stable
     */
    get useExplicitDryRunSpec(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set useExplicitDryRunSpec(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetUseExplicitDryRunSpec(): void;
    /**
     * @stability stable
     */
    get useExplicitDryRunSpecInput(): boolean | cdktf.IResolvable | undefined;
    private _spec?;
    private __specOutput;
    /**
     * @stability stable
     */
    get spec(): AccessContextManagerServicePerimeterSpecOutputReference;
    /**
     * @stability stable
     */
    putSpec(value: AccessContextManagerServicePerimeterSpec | undefined): void;
    /**
     * @stability stable
     */
    resetSpec(): void;
    /**
     * @stability stable
     */
    get specInput(): AccessContextManagerServicePerimeterSpec | undefined;
    private _status?;
    private __statusOutput;
    /**
     * @stability stable
     */
    get status(): AccessContextManagerServicePerimeterStatusOutputReference;
    /**
     * @stability stable
     */
    putStatus(value: AccessContextManagerServicePerimeterStatus | undefined): void;
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): AccessContextManagerServicePerimeterStatus | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): AccessContextManagerServicePerimeterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AccessContextManagerServicePerimeterTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AccessContextManagerServicePerimeterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
