import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FolderAccessApprovalSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the folder of the access approval settings.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#folder_id FolderAccessApprovalSettings#folder_id}
     *
     * @stability stable
     */
    readonly folderId: string;
    /**
     * A list of email addresses to which notifications relating to approval requests should be sent.
     *
     * Notifications relating to a resource will be sent to all emails in the settings of ancestor
     * resources of that resource. A maximum of 50 email addresses are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#notification_emails FolderAccessApprovalSettings#notification_emails}
     *
     * @stability stable
     */
    readonly notificationEmails?: string[];
    /**
     * enrolled_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#enrolled_services FolderAccessApprovalSettings#enrolled_services}
     *
     * @stability stable
     */
    readonly enrolledServices: FolderAccessApprovalSettingsEnrolledServices[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#timeouts FolderAccessApprovalSettings#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FolderAccessApprovalSettingsTimeouts;
}
/**
 * @stability stable
 */
export interface FolderAccessApprovalSettingsEnrolledServices {
    /**
     * The product for which Access Approval will be enrolled.
     *
     * Allowed values are listed (case-sensitive):
     * all
     * App Engine
     * BigQuery
     * Cloud Bigtable
     * Cloud Key Management Service
     * Compute Engine
     * Cloud Dataflow
     * Cloud Identity and Access Management
     * Cloud Pub/Sub
     * Cloud Storage
     * Persistent Disk
     *
     * Note: These values are supported as input, but considered a legacy format:
     * all
     * appengine.googleapis.com
     * bigquery.googleapis.com
     * bigtable.googleapis.com
     * cloudkms.googleapis.com
     * compute.googleapis.com
     * dataflow.googleapis.com
     * iam.googleapis.com
     * pubsub.googleapis.com
     * storage.googleapis.com
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#cloud_product FolderAccessApprovalSettings#cloud_product}
     *
     * @stability stable
     */
    readonly cloudProduct: string;
    /**
     * The enrollment level of the service. Default value: "BLOCK_ALL" Possible values: ["BLOCK_ALL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#enrollment_level FolderAccessApprovalSettings#enrollment_level}
     *
     * @stability stable
     */
    readonly enrollmentLevel?: string;
}
/**
 * @stability stable
 */
export interface FolderAccessApprovalSettingsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#create FolderAccessApprovalSettings#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#delete FolderAccessApprovalSettings#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html#update FolderAccessApprovalSettings#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class FolderAccessApprovalSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html google_folder_access_approval_settings}.
 *
 * @stability stable
 */
export declare class FolderAccessApprovalSettings extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/folder_access_approval_settings.html google_folder_access_approval_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FolderAccessApprovalSettingsConfig);
    /**
     * @stability stable
     */
    get enrolledAncestor(): any;
    private _folderId?;
    /**
     * @stability stable
     */
    get folderId(): string;
    /**
     * @stability stable
     */
    set folderId(value: string);
    /**
     * @stability stable
     */
    get folderIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _notificationEmails?;
    /**
     * @stability stable
     */
    get notificationEmails(): string[] | undefined;
    /**
     * @stability stable
     */
    set notificationEmails(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetNotificationEmails(): void;
    /**
     * @stability stable
     */
    get notificationEmailsInput(): string[] | undefined;
    private _enrolledServices?;
    /**
     * @stability stable
     */
    get enrolledServices(): FolderAccessApprovalSettingsEnrolledServices[];
    /**
     * @stability stable
     */
    set enrolledServices(value: FolderAccessApprovalSettingsEnrolledServices[]);
    /**
     * @stability stable
     */
    get enrolledServicesInput(): FolderAccessApprovalSettingsEnrolledServices[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): FolderAccessApprovalSettingsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FolderAccessApprovalSettingsTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FolderAccessApprovalSettingsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
