# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI_Pred.ipynb (unless otherwise specified).

__all__ = ["logger"]

# Cell

from typing import *

# Internal Cell

import os
import typer
from typer import echo
from tabulate import tabulate

from . import helper
from ..logger import get_logger, set_level

# Internal Cell

app = typer.Typer()

# Cell

logger = get_logger(__name__)

# Internal Cell


@app.command()
@helper.requires_auth_token
def ls(
    offset: int = typer.Option(
        0,
        "--offset",
        "-o",
        help="The number of records to offset at the beginning of the predictions list. If None, then the default value 0 will be used.",
    ),
    limit: int = typer.Option(
        100,
        "--limit",
        "-l",
        help="The maximum number of records to return from the server. If None, then the default value 100 will be used.",
    ),
    disabled: bool = typer.Option(
        False,
        "--disabled",
        help="If set to True, then only the deleted predictions will be displayed. Else, the default value "
        "False will be used to display only the list of active predictions.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output only ids of prediction separated by space.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """List available predictions."""

    from ..client import Prediction

    df = Prediction.ls(offset=offset, limit=limit, disabled=disabled)

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        ids = df["id"].astype(str).to_list()
        typer.echo("\n".join(ids))
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def details(
    id: int = typer.Argument(
        ...,
        help="The prediction ID in the airt service.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Return metadata of the given prediction."""

    from ..client import Prediction

    df = Prediction.details(id=int(id))

    df["created"] = helper.humanize_date(df["created"])

    typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def rm(
    id: int = typer.Argument(
        ...,
        help="The prediction ID in the airt service.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output the deleted prediction id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Remove the prediction from airt service."""

    from ..client import Prediction

    df = Prediction.delete(id=int(id))

    df["created"] = helper.humanize_date(df["created"])

    if quiet:
        typer.echo(df.iloc[0]["id"])
    else:
        typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command("to-pandas")
@helper.requires_auth_token
def to_pandas(
    id: int = typer.Argument(
        ...,
        help="The prediction ID in the airt service.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Convert the predicted results into a Pandas DataFrame object."""

    from ..client import Prediction

    pred = Prediction(prediction_id=int(id))

    df = pred.to_pandas()

    typer.echo(tabulate(df, headers="keys", tablefmt="plain", showindex=False))


# Internal Cell


@app.command()
@helper.requires_auth_token
def push(
    data_id: int = typer.Option(
        ...,
        "--data",
        help="The data ID in the airt service.",
    ),
    pred_id: int = typer.Option(
        ...,
        "--pred",
        help="The prediction ID in the airt service.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output the pushed prediction id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Push the prediction results into the target data source."""

    from ..client import DataSource, Prediction

    datasource = DataSource(int(data_id))
    prediction = Prediction(prediction_id=int(pred_id), datasource_id=int(data_id))

    progress = prediction.push(datasource)

    if quiet:
        progress.wait()

        typer.echo(prediction.prediction_id)
    else:
        typer.echo(
            f"Pushing the results of prediction id: {prediction.prediction_id} into the datasource id: {prediction.datasource_id}"
        )

        progress.progress_bar()
