# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI_Token.ipynb (unless otherwise specified).

__all__ = ["logger"]

# Cell

from typing import *

# Internal Cell

import os
import typer
import logging

from ..client import Client
from ..logger import get_logger, set_level

# Internal Cell

app = typer.Typer()

# Cell

logger = get_logger(__name__)

# Internal Cell


def token(
    username: Optional[str] = typer.Option(
        None,
        "--username",
        "-u",
        help="Username for your developer account. If not set (default value None), "
        "it will try to use the value from environment variable AIRT_SERVICE_USERNAME.",
    ),
    password: Optional[str] = typer.Option(
        None,
        "--password",
        "-p",
        help="Password for your developer account. If not set (default value None), "
        "it will try to use the value from environment variable AIRT_SERVICE_PASSWORD.",
    ),
    server: Optional[str] = typer.Option(
        None,
        "--server",
        "-s",
        help="Server address used to connect to. If not set (default value None), it will "
        "try to use the value from environment variable AIRT_SERVER_URL. If the variable is not "
        "set as well, then the default public server will be used. You should leave this to default "
        "value unless you are running your own server (please contact us for that possibility by email info@airt.ai).",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output authentication token only.",
    ),
    debug: bool = typer.Option(
        False, "--debug", "-d", help="Set logger level to DEBUG and output everything."
    ),
) -> None:
    """Get application token for airt service from a username/password pair.

    Before you can use the service, you must acquire a username and password for your developer account.
    Please contact us by email info@airt.ai to get one.

    The username, password, and server address can either be passed explicitly while calling this command
    or can be stored in environment variables AIRT_SERVICE_USERNAME, AIRT_SERVICE_PASSWORD,
    and AIRT_SERVER_URL.

    Upon successful authentication, the airt services will be available to access.
    """
    try:
        if debug:
            set_level(logging.DEBUG)
        else:
            set_level(logging.WARNING)

        Client.get_token(username=username, password=password, server=server)

        if quiet:
            typer.echo(Client.auth_token)
        else:
            typer.echo(f"token: {Client.auth_token}")

    except KeyError as e:
        typer.echo(message=f"Error: {e}", err=True)
        typer.echo(f"\nTry 'airt token --help' for help.")
        raise typer.Exit(code=1)

    except Exception as e:
        typer.echo(message=f"Error: {e}", err=True)
        raise typer.Exit(code=1)


# Internal Cell


app.command()(token)
