import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeViewsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database from which to return the schemas from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/views#database DataSnowflakeViews#database}
    */
    readonly database: string;
    /**
    * The schema from which to return the views from.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/d/views#schema DataSnowflakeViews#schema}
    */
    readonly schema: string;
}
export interface DataSnowflakeViewsViews {
}
export declare function dataSnowflakeViewsViewsToTerraform(struct?: DataSnowflakeViewsViews): any;
export declare class DataSnowflakeViewsViewsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeViewsViews | undefined;
    set internalValue(value: DataSnowflakeViewsViews | undefined);
    get comment(): string;
    get database(): string;
    get name(): string;
    get schema(): string;
}
export declare class DataSnowflakeViewsViewsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeViewsViewsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/d/views snowflake_views}
*/
export declare class DataSnowflakeViews extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_views";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/d/views snowflake_views} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeViewsConfig
    */
    constructor(scope: Construct, id: string, config: DataSnowflakeViewsConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get id(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _views;
    get views(): DataSnowflakeViewsViewsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
