"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stringifyObjects = exports.getHash = void 0;
const crypto = require("crypto");
function getHash(stringToHash) {
    const hash = crypto.createHash('sha256').update(stringToHash).digest('hex');
    const truncatedHash = hash.substring(0, 5).toUpperCase();
    return truncatedHash;
}
exports.getHash = getHash;
function stringifyObjects(...objects) {
    const combinedObject = Object.assign({}, ...objects);
    return JSON.stringify(combinedObject);
}
exports.stringifyObjects = stringifyObjects;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGFzaC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImhhc2gudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsaUNBQWlDO0FBRWpDLFNBQWdCLE9BQU8sQ0FBQyxZQUFvQjtJQUMxQyxNQUFNLElBQUksR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDNUUsTUFBTSxhQUFhLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsV0FBVyxFQUFFLENBQUM7SUFDekQsT0FBTyxhQUFhLENBQUM7QUFDdkIsQ0FBQztBQUpELDBCQUlDO0FBRUQsU0FBZ0IsZ0JBQWdCLENBQUMsR0FBRyxPQUFjO0lBQ2hELE1BQU0sY0FBYyxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUMsRUFBRSxFQUFFLEdBQUcsT0FBTyxDQUFDLENBQUM7SUFDckQsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQyxDQUFDO0FBQ3hDLENBQUM7QUFIRCw0Q0FHQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNyeXB0byBmcm9tICdjcnlwdG8nO1xuXG5leHBvcnQgZnVuY3Rpb24gZ2V0SGFzaChzdHJpbmdUb0hhc2g6IHN0cmluZyk6IHN0cmluZyB7XG4gIGNvbnN0IGhhc2ggPSBjcnlwdG8uY3JlYXRlSGFzaCgnc2hhMjU2JykudXBkYXRlKHN0cmluZ1RvSGFzaCkuZGlnZXN0KCdoZXgnKTtcbiAgY29uc3QgdHJ1bmNhdGVkSGFzaCA9IGhhc2guc3Vic3RyaW5nKDAsIDUpLnRvVXBwZXJDYXNlKCk7XG4gIHJldHVybiB0cnVuY2F0ZWRIYXNoO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc3RyaW5naWZ5T2JqZWN0cyguLi5vYmplY3RzOiBhbnlbXSk6IHN0cmluZyB7XG4gIGNvbnN0IGNvbWJpbmVkT2JqZWN0ID0gT2JqZWN0LmFzc2lnbih7fSwgLi4ub2JqZWN0cyk7XG4gIHJldHVybiBKU09OLnN0cmluZ2lmeShjb21iaW5lZE9iamVjdCk7XG59Il19