"""Add Role, Permission, UserRole and UserPermission models

Revision ID: 7f4cbde3bcb7
Revises: ac76d4c912eb
Create Date: 2022-05-31 13:21:15.383928

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "7f4cbde3bcb7"
down_revision = "ac76d4c912eb"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "fief_permissions",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("codename", sa.String(length=255), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("codename"),
    )
    op.create_index(
        op.f("ix_fief_permissions_created_at"),
        "fief_permissions",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_fief_permissions_updated_at"),
        "fief_permissions",
        ["updated_at"],
        unique=False,
    )
    op.create_table(
        "fief_roles",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column("granted_by_default", sa.Boolean(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_fief_roles_created_at"), "fief_roles", ["created_at"], unique=False
    )
    op.create_index(
        op.f("ix_fief_roles_updated_at"), "fief_roles", ["updated_at"], unique=False
    )
    op.create_table(
        "roles_permissions",
        sa.Column("role_id", fief.models.generics.GUID(), nullable=False),
        sa.Column("permission_id", fief.models.generics.GUID(), nullable=False),
        sa.ForeignKeyConstraint(
            ["permission_id"], ["fief_permissions.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(["role_id"], ["fief_roles.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("role_id", "permission_id"),
    )
    op.create_table(
        "fief_user_permissions",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("user_id", fief.models.generics.GUID(), nullable=False),
        sa.Column("permission_id", fief.models.generics.GUID(), nullable=False),
        sa.Column("from_role_id", fief.models.generics.GUID(), nullable=True),
        sa.ForeignKeyConstraint(
            ["from_role_id"], ["fief_roles.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(
            ["permission_id"], ["fief_permissions.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(["user_id"], ["fief_users.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("user_id", "permission_id", "from_role_id"),
    )
    op.create_index(
        op.f("ix_fief_user_permissions_created_at"),
        "fief_user_permissions",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_fief_user_permissions_updated_at"),
        "fief_user_permissions",
        ["updated_at"],
        unique=False,
    )
    op.create_table(
        "fief_user_roles",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column("user_id", fief.models.generics.GUID(), nullable=False),
        sa.Column("role_id", fief.models.generics.GUID(), nullable=False),
        sa.ForeignKeyConstraint(["role_id"], ["fief_roles.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["user_id"], ["fief_users.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("user_id", "role_id"),
    )
    op.create_index(
        op.f("ix_fief_user_roles_created_at"),
        "fief_user_roles",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_fief_user_roles_updated_at"),
        "fief_user_roles",
        ["updated_at"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_fief_user_roles_updated_at"), table_name="fief_user_roles")
    op.drop_index(op.f("ix_fief_user_roles_created_at"), table_name="fief_user_roles")
    op.drop_table("fief_user_roles")
    op.drop_index(
        op.f("ix_fief_user_permissions_updated_at"), table_name="fief_user_permissions"
    )
    op.drop_index(
        op.f("ix_fief_user_permissions_created_at"), table_name="fief_user_permissions"
    )
    op.drop_table("fief_user_permissions")
    op.drop_table("roles_permissions")
    op.drop_index(op.f("ix_fief_roles_updated_at"), table_name="fief_roles")
    op.drop_index(op.f("ix_fief_roles_created_at"), table_name="fief_roles")
    op.drop_table("fief_roles")
    op.drop_index(op.f("ix_fief_permissions_updated_at"), table_name="fief_permissions")
    op.drop_index(op.f("ix_fief_permissions_created_at"), table_name="fief_permissions")
    op.drop_table("fief_permissions")
    # ### end Alembic commands ###
