import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OsLoginSshPublicKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * An expiration time in microseconds since epoch.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#expiration_time_usec OsLoginSshPublicKey#expiration_time_usec}
     *
     * @stability stable
     */
    readonly expirationTimeUsec?: string;
    /**
     * Public key text in SSH format, defined by RFC4253 section 6.6.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#key OsLoginSshPublicKey#key}
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * The project ID of the Google Cloud Platform project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#project OsLoginSshPublicKey#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The user email.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#user OsLoginSshPublicKey#user}
     *
     * @stability stable
     */
    readonly user: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#timeouts OsLoginSshPublicKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: OsLoginSshPublicKeyTimeouts;
}
/**
 * @stability stable
 */
export interface OsLoginSshPublicKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#create OsLoginSshPublicKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#delete OsLoginSshPublicKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html#update OsLoginSshPublicKey#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class OsLoginSshPublicKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html google_os_login_ssh_public_key}.
 *
 * @stability stable
 */
export declare class OsLoginSshPublicKey extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key.html google_os_login_ssh_public_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OsLoginSshPublicKeyConfig);
    private _expirationTimeUsec?;
    /**
     * @stability stable
     */
    get expirationTimeUsec(): string | undefined;
    /**
     * @stability stable
     */
    set expirationTimeUsec(value: string | undefined);
    /**
     * @stability stable
     */
    resetExpirationTimeUsec(): void;
    /**
     * @stability stable
     */
    get expirationTimeUsecInput(): string | undefined;
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _user?;
    /**
     * @stability stable
     */
    get user(): string;
    /**
     * @stability stable
     */
    set user(value: string);
    /**
     * @stability stable
     */
    get userInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): OsLoginSshPublicKeyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: OsLoginSshPublicKeyTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): OsLoginSshPublicKeyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
