import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PrivatecaCaPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Labels with user-defined metadata.
     *
     * An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
     * "1.3kg", "count": "3" }.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#labels PrivatecaCaPool#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Location of the CaPool. A full list of valid locations can be found by running 'gcloud privateca locations list'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#location PrivatecaCaPool#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The name for this CaPool.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#name PrivatecaCaPool#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#project PrivatecaCaPool#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Tier of this CaPool. Possible values: ["ENTERPRISE", "DEVOPS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#tier PrivatecaCaPool#tier}
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * issuance_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#issuance_policy PrivatecaCaPool#issuance_policy}
     *
     * @stability stable
     */
    readonly issuancePolicy?: PrivatecaCaPoolIssuancePolicy;
    /**
     * publishing_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#publishing_options PrivatecaCaPool#publishing_options}
     *
     * @stability stable
     */
    readonly publishingOptions?: PrivatecaCaPoolPublishingOptions;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#timeouts PrivatecaCaPool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PrivatecaCaPoolTimeouts;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes {
    /**
     * When true, allows callers to create Certificates by specifying a CertificateConfig.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allow_config_based_issuance PrivatecaCaPool#allow_config_based_issuance}
     *
     * @stability stable
     */
    readonly allowConfigBasedIssuance: boolean | cdktf.IResolvable;
    /**
     * When true, allows callers to create Certificates by specifying a CSR.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allow_csr_based_issuance PrivatecaCaPool#allow_csr_based_issuance}
     *
     * @stability stable
     */
    readonly allowCsrBasedIssuance: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowConfigBasedIssuance?;
    /**
     * @stability stable
     */
    get allowConfigBasedIssuance(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowConfigBasedIssuance(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get allowConfigBasedIssuanceInput(): boolean | cdktf.IResolvable | undefined;
    private _allowCsrBasedIssuance?;
    /**
     * @stability stable
     */
    get allowCsrBasedIssuance(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowCsrBasedIssuance(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get allowCsrBasedIssuanceInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve {
    /**
     * The algorithm used. Possible values: ["ECDSA_P256", "ECDSA_P384", "EDDSA_25519"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#signature_algorithm PrivatecaCaPool#signature_algorithm}
     *
     * @stability stable
     */
    readonly signatureAlgorithm: string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _signatureAlgorithm?;
    /**
     * @stability stable
     */
    get signatureAlgorithm(): string;
    /**
     * @stability stable
     */
    set signatureAlgorithm(value: string);
    /**
     * @stability stable
     */
    get signatureAlgorithmInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa {
    /**
     * The maximum allowed RSA modulus size, in bits.
     *
     * If this is not set, or if set to zero, the
     * service will not enforce an explicit upper bound on RSA modulus sizes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#max_modulus_size PrivatecaCaPool#max_modulus_size}
     *
     * @stability stable
     */
    readonly maxModulusSize?: string;
    /**
     * The minimum allowed RSA modulus size, in bits.
     *
     * If this is not set, or if set to zero, the
     * service-level min RSA modulus size will continue to apply.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#min_modulus_size PrivatecaCaPool#min_modulus_size}
     *
     * @stability stable
     */
    readonly minModulusSize?: string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maxModulusSize?;
    /**
     * @stability stable
     */
    get maxModulusSize(): string | undefined;
    /**
     * @stability stable
     */
    set maxModulusSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetMaxModulusSize(): void;
    /**
     * @stability stable
     */
    get maxModulusSizeInput(): string | undefined;
    private _minModulusSize?;
    /**
     * @stability stable
     */
    get minModulusSize(): string | undefined;
    /**
     * @stability stable
     */
    set minModulusSize(value: string | undefined);
    /**
     * @stability stable
     */
    resetMinModulusSize(): void;
    /**
     * @stability stable
     */
    get minModulusSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyAllowedKeyTypes {
    /**
     * elliptic_curve block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#elliptic_curve PrivatecaCaPool#elliptic_curve}
     *
     * @stability stable
     */
    readonly ellipticCurve?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve;
    /**
     * rsa block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#rsa PrivatecaCaPool#rsa}
     *
     * @stability stable
     */
    readonly rsa?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#object_id_path PrivatecaCaPool#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _objectIdPath?;
    /**
     * @stability stable
     */
    get objectIdPath(): number[];
    /**
     * @stability stable
     */
    set objectIdPath(value: number[]);
    /**
     * @stability stable
     */
    get objectIdPathInput(): number[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions {
    /**
     * Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#critical PrivatecaCaPool#critical}
     *
     * @stability stable
     */
    readonly critical: boolean | cdktf.IResolvable;
    /**
     * The value of this X.509 extension. A base64-encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#value PrivatecaCaPool#value}
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * object_id block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#object_id PrivatecaCaPool#object_id}
     *
     * @stability stable
     */
    readonly objectId: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions {
    /**
     * Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#is_ca PrivatecaCaPool#is_ca}
     *
     * @stability stable
     */
    readonly isCa?: boolean | cdktf.IResolvable;
    /**
     * Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#max_issuer_path_length PrivatecaCaPool#max_issuer_path_length}
     *
     * @stability stable
     */
    readonly maxIssuerPathLength?: number;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isCa?;
    /**
     * @stability stable
     */
    get isCa(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isCa(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsCa(): void;
    /**
     * @stability stable
     */
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    /**
     * @stability stable
     */
    get maxIssuerPathLength(): number | undefined;
    /**
     * @stability stable
     */
    set maxIssuerPathLength(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxIssuerPathLength(): void;
    /**
     * @stability stable
     */
    get maxIssuerPathLengthInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage {
    /**
     * The key may be used to sign certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#cert_sign PrivatecaCaPool#cert_sign}
     *
     * @stability stable
     */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#content_commitment PrivatecaCaPool#content_commitment}
     *
     * @stability stable
     */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used sign certificate revocation lists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#crl_sign PrivatecaCaPool#crl_sign}
     *
     * @stability stable
     */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#data_encipherment PrivatecaCaPool#data_encipherment}
     *
     * @stability stable
     */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to decipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#decipher_only PrivatecaCaPool#decipher_only}
     *
     * @stability stable
     */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used for digital signatures.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#digital_signature PrivatecaCaPool#digital_signature}
     *
     * @stability stable
     */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#encipher_only PrivatecaCaPool#encipher_only}
     *
     * @stability stable
     */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
     * The key may be used in a key agreement protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#key_agreement PrivatecaCaPool#key_agreement}
     *
     * @stability stable
     */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
     * The key may be used to encipher other keys.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#key_encipherment PrivatecaCaPool#key_encipherment}
     *
     * @stability stable
     */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _certSign?;
    /**
     * @stability stable
     */
    get certSign(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set certSign(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCertSign(): void;
    /**
     * @stability stable
     */
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    /**
     * @stability stable
     */
    get contentCommitment(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set contentCommitment(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetContentCommitment(): void;
    /**
     * @stability stable
     */
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    /**
     * @stability stable
     */
    get crlSign(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set crlSign(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCrlSign(): void;
    /**
     * @stability stable
     */
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    /**
     * @stability stable
     */
    get dataEncipherment(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set dataEncipherment(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDataEncipherment(): void;
    /**
     * @stability stable
     */
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    /**
     * @stability stable
     */
    get decipherOnly(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set decipherOnly(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDecipherOnly(): void;
    /**
     * @stability stable
     */
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    /**
     * @stability stable
     */
    get digitalSignature(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set digitalSignature(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDigitalSignature(): void;
    /**
     * @stability stable
     */
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    /**
     * @stability stable
     */
    get encipherOnly(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set encipherOnly(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEncipherOnly(): void;
    /**
     * @stability stable
     */
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    /**
     * @stability stable
     */
    get keyAgreement(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set keyAgreement(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetKeyAgreement(): void;
    /**
     * @stability stable
     */
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    /**
     * @stability stable
     */
    get keyEncipherment(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set keyEncipherment(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetKeyEncipherment(): void;
    /**
     * @stability stable
     */
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage {
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#client_auth PrivatecaCaPool#client_auth}
     *
     * @stability stable
     */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#code_signing PrivatecaCaPool#code_signing}
     *
     * @stability stable
     */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#email_protection PrivatecaCaPool#email_protection}
     *
     * @stability stable
     */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#ocsp_signing PrivatecaCaPool#ocsp_signing}
     *
     * @stability stable
     */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#server_auth PrivatecaCaPool#server_auth}
     *
     * @stability stable
     */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
     * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#time_stamping PrivatecaCaPool#time_stamping}
     *
     * @stability stable
     */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _clientAuth?;
    /**
     * @stability stable
     */
    get clientAuth(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set clientAuth(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetClientAuth(): void;
    /**
     * @stability stable
     */
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    /**
     * @stability stable
     */
    get codeSigning(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set codeSigning(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCodeSigning(): void;
    /**
     * @stability stable
     */
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    /**
     * @stability stable
     */
    get emailProtection(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set emailProtection(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEmailProtection(): void;
    /**
     * @stability stable
     */
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    /**
     * @stability stable
     */
    get ocspSigning(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set ocspSigning(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetOcspSigning(): void;
    /**
     * @stability stable
     */
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    /**
     * @stability stable
     */
    get serverAuth(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set serverAuth(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetServerAuth(): void;
    /**
     * @stability stable
     */
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    /**
     * @stability stable
     */
    get timeStamping(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set timeStamping(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTimeStamping(): void;
    /**
     * @stability stable
     */
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#object_id_path PrivatecaCaPool#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage {
    /**
     * base_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#base_key_usage PrivatecaCaPool#base_key_usage}
     *
     * @stability stable
     */
    readonly baseKeyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage;
    /**
     * extended_key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#extended_key_usage PrivatecaCaPool#extended_key_usage}
     *
     * @stability stable
     */
    readonly extendedKeyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage;
    /**
     * unknown_extended_key_usages block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#unknown_extended_key_usages PrivatecaCaPool#unknown_extended_key_usages}
     *
     * @stability stable
     */
    readonly unknownExtendedKeyUsages?: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[];
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _baseKeyUsage?;
    private __baseKeyUsageOutput;
    /**
     * @stability stable
     */
    get baseKeyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putBaseKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage): void;
    /**
     * @stability stable
     */
    get baseKeyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage?;
    private __extendedKeyUsageOutput;
    /**
     * @stability stable
     */
    get extendedKeyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putExtendedKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage): void;
    /**
     * @stability stable
     */
    get extendedKeyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages?;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsages(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | undefined;
    /**
     * @stability stable
     */
    set unknownExtendedKeyUsages(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | undefined);
    /**
     * @stability stable
     */
    resetUnknownExtendedKeyUsages(): void;
    /**
     * @stability stable
     */
    get unknownExtendedKeyUsagesInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds {
    /**
     * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#object_id_path PrivatecaCaPool#object_id_path}
     *
     * @stability stable
     */
    readonly objectIdPath: number[];
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyBaselineValues {
    /**
     * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#aia_ocsp_servers PrivatecaCaPool#aia_ocsp_servers}
     *
     * @stability stable
     */
    readonly aiaOcspServers?: string[];
    /**
     * additional_extensions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#additional_extensions PrivatecaCaPool#additional_extensions}
     *
     * @stability stable
     */
    readonly additionalExtensions?: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[];
    /**
     * ca_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#ca_options PrivatecaCaPool#ca_options}
     *
     * @stability stable
     */
    readonly caOptions: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions;
    /**
     * key_usage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#key_usage PrivatecaCaPool#key_usage}
     *
     * @stability stable
     */
    readonly keyUsage: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage;
    /**
     * policy_ids block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#policy_ids PrivatecaCaPool#policy_ids}
     *
     * @stability stable
     */
    readonly policyIds?: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[];
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _aiaOcspServers?;
    /**
     * @stability stable
     */
    get aiaOcspServers(): string[] | undefined;
    /**
     * @stability stable
     */
    set aiaOcspServers(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetAiaOcspServers(): void;
    /**
     * @stability stable
     */
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions?;
    /**
     * @stability stable
     */
    get additionalExtensions(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | undefined;
    /**
     * @stability stable
     */
    set additionalExtensions(value: PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | undefined);
    /**
     * @stability stable
     */
    resetAdditionalExtensions(): void;
    /**
     * @stability stable
     */
    get additionalExtensionsInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | undefined;
    private _caOptions?;
    private __caOptionsOutput;
    /**
     * @stability stable
     */
    get caOptions(): PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference;
    /**
     * @stability stable
     */
    putCaOptions(value: PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions): void;
    /**
     * @stability stable
     */
    get caOptionsInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined;
    private _keyUsage?;
    private __keyUsageOutput;
    /**
     * @stability stable
     */
    get keyUsage(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference;
    /**
     * @stability stable
     */
    putKeyUsage(value: PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage): void;
    /**
     * @stability stable
     */
    get keyUsageInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined;
    private _policyIds?;
    /**
     * @stability stable
     */
    get policyIds(): PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | undefined;
    /**
     * @stability stable
     */
    set policyIds(value: PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | undefined);
    /**
     * @stability stable
     */
    resetPolicyIds(): void;
    /**
     * @stability stable
     */
    get policyIdsInput(): PrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression {
    /**
     * Description of the expression.
     *
     * This is a longer text which describes the expression, e.g. when hovered over it in a UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#description PrivatecaCaPool#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#expression PrivatecaCaPool#expression}
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#location PrivatecaCaPool#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#title PrivatecaCaPool#title}
     *
     * @stability stable
     */
    readonly title?: string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string | undefined;
    /**
     * @stability stable
     */
    set location(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string | undefined;
    /**
     * @stability stable
     */
    set title(value: string | undefined);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicyIdentityConstraints {
    /**
     * If this is set, the SubjectAltNames extension may be copied from a certificate request into the signed certificate.
     *
     * Otherwise, the requested SubjectAltNames will be discarded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allow_subject_alt_names_passthrough PrivatecaCaPool#allow_subject_alt_names_passthrough}
     *
     * @stability stable
     */
    readonly allowSubjectAltNamesPassthrough: boolean | cdktf.IResolvable;
    /**
     * If this is set, the Subject field may be copied from a certificate request into the signed certificate.
     *
     * Otherwise, the requested Subject will be discarded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allow_subject_passthrough PrivatecaCaPool#allow_subject_passthrough}
     *
     * @stability stable
     */
    readonly allowSubjectPassthrough: boolean | cdktf.IResolvable;
    /**
     * cel_expression block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#cel_expression PrivatecaCaPool#cel_expression}
     *
     * @stability stable
     */
    readonly celExpression?: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowSubjectAltNamesPassthrough?;
    /**
     * @stability stable
     */
    get allowSubjectAltNamesPassthrough(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowSubjectAltNamesPassthrough(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get allowSubjectAltNamesPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _allowSubjectPassthrough?;
    /**
     * @stability stable
     */
    get allowSubjectPassthrough(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set allowSubjectPassthrough(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get allowSubjectPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _celExpression?;
    private __celExpressionOutput;
    /**
     * @stability stable
     */
    get celExpression(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference;
    /**
     * @stability stable
     */
    putCelExpression(value: PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined): void;
    /**
     * @stability stable
     */
    resetCelExpression(): void;
    /**
     * @stability stable
     */
    get celExpressionInput(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolIssuancePolicy {
    /**
     * The maximum lifetime allowed for issued Certificates.
     *
     * Note that if the issuing CertificateAuthority
     * expires before a Certificate's requested maximumLifetime, the effective lifetime will be explicitly truncated to match it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#maximum_lifetime PrivatecaCaPool#maximum_lifetime}
     *
     * @stability stable
     */
    readonly maximumLifetime?: string;
    /**
     * allowed_issuance_modes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allowed_issuance_modes PrivatecaCaPool#allowed_issuance_modes}
     *
     * @stability stable
     */
    readonly allowedIssuanceModes?: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes;
    /**
     * allowed_key_types block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#allowed_key_types PrivatecaCaPool#allowed_key_types}
     *
     * @stability stable
     */
    readonly allowedKeyTypes?: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[];
    /**
     * baseline_values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#baseline_values PrivatecaCaPool#baseline_values}
     *
     * @stability stable
     */
    readonly baselineValues?: PrivatecaCaPoolIssuancePolicyBaselineValues;
    /**
     * identity_constraints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#identity_constraints PrivatecaCaPool#identity_constraints}
     *
     * @stability stable
     */
    readonly identityConstraints?: PrivatecaCaPoolIssuancePolicyIdentityConstraints;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolIssuancePolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _maximumLifetime?;
    /**
     * @stability stable
     */
    get maximumLifetime(): string | undefined;
    /**
     * @stability stable
     */
    set maximumLifetime(value: string | undefined);
    /**
     * @stability stable
     */
    resetMaximumLifetime(): void;
    /**
     * @stability stable
     */
    get maximumLifetimeInput(): string | undefined;
    private _allowedIssuanceModes?;
    private __allowedIssuanceModesOutput;
    /**
     * @stability stable
     */
    get allowedIssuanceModes(): PrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference;
    /**
     * @stability stable
     */
    putAllowedIssuanceModes(value: PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined): void;
    /**
     * @stability stable
     */
    resetAllowedIssuanceModes(): void;
    /**
     * @stability stable
     */
    get allowedIssuanceModesInput(): PrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined;
    private _allowedKeyTypes?;
    /**
     * @stability stable
     */
    get allowedKeyTypes(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | undefined;
    /**
     * @stability stable
     */
    set allowedKeyTypes(value: PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | undefined);
    /**
     * @stability stable
     */
    resetAllowedKeyTypes(): void;
    /**
     * @stability stable
     */
    get allowedKeyTypesInput(): PrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | undefined;
    private _baselineValues?;
    private __baselineValuesOutput;
    /**
     * @stability stable
     */
    get baselineValues(): PrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference;
    /**
     * @stability stable
     */
    putBaselineValues(value: PrivatecaCaPoolIssuancePolicyBaselineValues | undefined): void;
    /**
     * @stability stable
     */
    resetBaselineValues(): void;
    /**
     * @stability stable
     */
    get baselineValuesInput(): PrivatecaCaPoolIssuancePolicyBaselineValues | undefined;
    private _identityConstraints?;
    private __identityConstraintsOutput;
    /**
     * @stability stable
     */
    get identityConstraints(): PrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference;
    /**
     * @stability stable
     */
    putIdentityConstraints(value: PrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined): void;
    /**
     * @stability stable
     */
    resetIdentityConstraints(): void;
    /**
     * @stability stable
     */
    get identityConstraintsInput(): PrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolPublishingOptions {
    /**
     * When true, publishes each CertificateAuthority's CA certificate and includes its URL in the "Authority Information Access" X.509 extension in all issued Certificates. If this is false, the CA certificate will not be published and the corresponding X.509 extension will not be written in issued certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#publish_ca_cert PrivatecaCaPool#publish_ca_cert}
     *
     * @stability stable
     */
    readonly publishCaCert: boolean | cdktf.IResolvable;
    /**
     * When true, publishes each CertificateAuthority's CRL and includes its URL in the "CRL Distribution Points" X.509 extension in all issued Certificates. If this is false, CRLs will not be published and the corresponding X.509 extension will not be written in issued certificates. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#publish_crl PrivatecaCaPool#publish_crl}
     *
     * @stability stable
     */
    readonly publishCrl: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolPublishingOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _publishCaCert?;
    /**
     * @stability stable
     */
    get publishCaCert(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publishCaCert(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get publishCaCertInput(): boolean | cdktf.IResolvable | undefined;
    private _publishCrl?;
    /**
     * @stability stable
     */
    get publishCrl(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publishCrl(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get publishCrlInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface PrivatecaCaPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#create PrivatecaCaPool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#delete PrivatecaCaPool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html#update PrivatecaCaPool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class PrivatecaCaPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html google_privateca_ca_pool}.
 *
 * @stability stable
 */
export declare class PrivatecaCaPool extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool.html google_privateca_ca_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PrivatecaCaPoolConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _issuancePolicy?;
    private __issuancePolicyOutput;
    /**
     * @stability stable
     */
    get issuancePolicy(): PrivatecaCaPoolIssuancePolicyOutputReference;
    /**
     * @stability stable
     */
    putIssuancePolicy(value: PrivatecaCaPoolIssuancePolicy | undefined): void;
    /**
     * @stability stable
     */
    resetIssuancePolicy(): void;
    /**
     * @stability stable
     */
    get issuancePolicyInput(): PrivatecaCaPoolIssuancePolicy | undefined;
    private _publishingOptions?;
    private __publishingOptionsOutput;
    /**
     * @stability stable
     */
    get publishingOptions(): PrivatecaCaPoolPublishingOptionsOutputReference;
    /**
     * @stability stable
     */
    putPublishingOptions(value: PrivatecaCaPoolPublishingOptions | undefined): void;
    /**
     * @stability stable
     */
    resetPublishingOptions(): void;
    /**
     * @stability stable
     */
    get publishingOptionsInput(): PrivatecaCaPoolPublishingOptions | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): PrivatecaCaPoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PrivatecaCaPoolTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PrivatecaCaPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
