import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The MySQL, PostgreSQL or SQL Server (beta) version to use.
     *
     * Supported values include MYSQL_5_6, MYSQL_5_7, MYSQL_8_0, POSTGRES_9_6, POSTGRES_10, POSTGRES_11, POSTGRES_12, POSTGRES_13, SQLSERVER_2017_STANDARD, SQLSERVER_2017_ENTERPRISE, SQLSERVER_2017_EXPRESS, SQLSERVER_2017_WEB. Database Version Policies includes an up-to-date reference of supported versions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#database_version SqlDatabaseInstance#database_version}
     *
     * @stability stable
     */
    readonly databaseVersion?: string;
    /**
     * Used to block Terraform from deleting a SQL Instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#deletion_protection SqlDatabaseInstance#deletion_protection}
     *
     * @stability stable
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * The name of the instance that will act as the master in the replication setup.
     *
     * Note, this requires the master to have binary_log_enabled set, as well as existing backups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#master_instance_name SqlDatabaseInstance#master_instance_name}
     *
     * @stability stable
     */
    readonly masterInstanceName?: string;
    /**
     * The name of the instance.
     *
     * If the name is left blank, Terraform will randomly generate one when the instance is first created. This is done because after a name is used, it cannot be reused for up to one week.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#name SqlDatabaseInstance#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#project SqlDatabaseInstance#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region the instance will sit in.
     *
     * Note, Cloud SQL is not available in all regions. A valid region must be provided to use this resource. If a region is not provided in the resource definition, the provider region will be used instead, but this will be an apply-time error for instances if the provider region is not supported with Cloud SQL. If you choose not to provide the region argument for this resource, make sure you understand this.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#region SqlDatabaseInstance#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Initial root password. Required for MS SQL Server, ignored by MySQL and PostgreSQL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#root_password SqlDatabaseInstance#root_password}
     *
     * @stability stable
     */
    readonly rootPassword?: string;
    /**
     * clone block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#clone SqlDatabaseInstance#clone}
     *
     * @stability stable
     */
    readonly clone?: SqlDatabaseInstanceClone;
    /**
     * replica_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#replica_configuration SqlDatabaseInstance#replica_configuration}
     *
     * @stability stable
     */
    readonly replicaConfiguration?: SqlDatabaseInstanceReplicaConfiguration;
    /**
     * restore_backup_context block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#restore_backup_context SqlDatabaseInstance#restore_backup_context}
     *
     * @stability stable
     */
    readonly restoreBackupContext?: SqlDatabaseInstanceRestoreBackupContext;
    /**
     * settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#settings SqlDatabaseInstance#settings}
     *
     * @stability stable
     */
    readonly settings?: SqlDatabaseInstanceSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#timeouts SqlDatabaseInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlDatabaseInstanceTimeouts;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceIpAddress extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get timeToRetire(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceServerCaCert extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cert(): string;
    /**
     * @stability stable
     */
    get commonName(): string;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get sha1Fingerprint(): string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceClone {
    /**
     * The timestamp of the point in time that should be restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#point_in_time SqlDatabaseInstance#point_in_time}
     *
     * @stability stable
     */
    readonly pointInTime?: string;
    /**
     * The name of the instance from which the point in time should be restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#source_instance_name SqlDatabaseInstance#source_instance_name}
     *
     * @stability stable
     */
    readonly sourceInstanceName: string;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceCloneOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _pointInTime?;
    /**
     * @stability stable
     */
    get pointInTime(): string | undefined;
    /**
     * @stability stable
     */
    set pointInTime(value: string | undefined);
    /**
     * @stability stable
     */
    resetPointInTime(): void;
    /**
     * @stability stable
     */
    get pointInTimeInput(): string | undefined;
    private _sourceInstanceName?;
    /**
     * @stability stable
     */
    get sourceInstanceName(): string;
    /**
     * @stability stable
     */
    set sourceInstanceName(value: string);
    /**
     * @stability stable
     */
    get sourceInstanceNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceReplicaConfiguration {
    /**
     * PEM representation of the trusted CA's x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ca_certificate SqlDatabaseInstance#ca_certificate}
     *
     * @stability stable
     */
    readonly caCertificate?: string;
    /**
     * PEM representation of the replica's x509 certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#client_certificate SqlDatabaseInstance#client_certificate}
     *
     * @stability stable
     */
    readonly clientCertificate?: string;
    /**
     * PEM representation of the replica's private key. The corresponding public key in encoded in the client_certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#client_key SqlDatabaseInstance#client_key}
     *
     * @stability stable
     */
    readonly clientKey?: string;
    /**
     * The number of seconds between connect retries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#connect_retry_interval SqlDatabaseInstance#connect_retry_interval}
     *
     * @stability stable
     */
    readonly connectRetryInterval?: number;
    /**
     * Path to a SQL file in Google Cloud Storage from which replica instances are created. Format is gs://bucket/filename.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#dump_file_path SqlDatabaseInstance#dump_file_path}
     *
     * @stability stable
     */
    readonly dumpFilePath?: string;
    /**
     * Specifies if the replica is the failover target.
     *
     * If the field is set to true the replica will be designated as a failover replica. If the master instance fails, the replica instance will be promoted as the new master instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#failover_target SqlDatabaseInstance#failover_target}
     *
     * @stability stable
     */
    readonly failoverTarget?: boolean | cdktf.IResolvable;
    /**
     * Time in ms between replication heartbeats.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#master_heartbeat_period SqlDatabaseInstance#master_heartbeat_period}
     *
     * @stability stable
     */
    readonly masterHeartbeatPeriod?: number;
    /**
     * Password for the replication connection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#password SqlDatabaseInstance#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Permissible ciphers for use in SSL encryption.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ssl_cipher SqlDatabaseInstance#ssl_cipher}
     *
     * @stability stable
     */
    readonly sslCipher?: string;
    /**
     * Username for replication connection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#username SqlDatabaseInstance#username}
     *
     * @stability stable
     */
    readonly username?: string;
    /**
     * True if the master's common name value is checked during the SSL handshake.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#verify_server_certificate SqlDatabaseInstance#verify_server_certificate}
     *
     * @stability stable
     */
    readonly verifyServerCertificate?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceReplicaConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _caCertificate?;
    /**
     * @stability stable
     */
    get caCertificate(): string | undefined;
    /**
     * @stability stable
     */
    set caCertificate(value: string | undefined);
    /**
     * @stability stable
     */
    resetCaCertificate(): void;
    /**
     * @stability stable
     */
    get caCertificateInput(): string | undefined;
    private _clientCertificate?;
    /**
     * @stability stable
     */
    get clientCertificate(): string | undefined;
    /**
     * @stability stable
     */
    set clientCertificate(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientCertificate(): void;
    /**
     * @stability stable
     */
    get clientCertificateInput(): string | undefined;
    private _clientKey?;
    /**
     * @stability stable
     */
    get clientKey(): string | undefined;
    /**
     * @stability stable
     */
    set clientKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientKey(): void;
    /**
     * @stability stable
     */
    get clientKeyInput(): string | undefined;
    private _connectRetryInterval?;
    /**
     * @stability stable
     */
    get connectRetryInterval(): number | undefined;
    /**
     * @stability stable
     */
    set connectRetryInterval(value: number | undefined);
    /**
     * @stability stable
     */
    resetConnectRetryInterval(): void;
    /**
     * @stability stable
     */
    get connectRetryIntervalInput(): number | undefined;
    private _dumpFilePath?;
    /**
     * @stability stable
     */
    get dumpFilePath(): string | undefined;
    /**
     * @stability stable
     */
    set dumpFilePath(value: string | undefined);
    /**
     * @stability stable
     */
    resetDumpFilePath(): void;
    /**
     * @stability stable
     */
    get dumpFilePathInput(): string | undefined;
    private _failoverTarget?;
    /**
     * @stability stable
     */
    get failoverTarget(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set failoverTarget(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetFailoverTarget(): void;
    /**
     * @stability stable
     */
    get failoverTargetInput(): boolean | cdktf.IResolvable | undefined;
    private _masterHeartbeatPeriod?;
    /**
     * @stability stable
     */
    get masterHeartbeatPeriod(): number | undefined;
    /**
     * @stability stable
     */
    set masterHeartbeatPeriod(value: number | undefined);
    /**
     * @stability stable
     */
    resetMasterHeartbeatPeriod(): void;
    /**
     * @stability stable
     */
    get masterHeartbeatPeriodInput(): number | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string | undefined;
    /**
     * @stability stable
     */
    set password(value: string | undefined);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sslCipher?;
    /**
     * @stability stable
     */
    get sslCipher(): string | undefined;
    /**
     * @stability stable
     */
    set sslCipher(value: string | undefined);
    /**
     * @stability stable
     */
    resetSslCipher(): void;
    /**
     * @stability stable
     */
    get sslCipherInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string | undefined;
    /**
     * @stability stable
     */
    set username(value: string | undefined);
    /**
     * @stability stable
     */
    resetUsername(): void;
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _verifyServerCertificate?;
    /**
     * @stability stable
     */
    get verifyServerCertificate(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set verifyServerCertificate(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetVerifyServerCertificate(): void;
    /**
     * @stability stable
     */
    get verifyServerCertificateInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceRestoreBackupContext {
    /**
     * The ID of the backup run to restore from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#backup_run_id SqlDatabaseInstance#backup_run_id}
     *
     * @stability stable
     */
    readonly backupRunId: number;
    /**
     * The ID of the instance that the backup was taken from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#instance_id SqlDatabaseInstance#instance_id}
     *
     * @stability stable
     */
    readonly instanceId?: string;
    /**
     * The full project ID of the source instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#project SqlDatabaseInstance#project}
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceRestoreBackupContextOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _backupRunId?;
    /**
     * @stability stable
     */
    get backupRunId(): number;
    /**
     * @stability stable
     */
    set backupRunId(value: number);
    /**
     * @stability stable
     */
    get backupRunIdInput(): number | undefined;
    private _instanceId?;
    /**
     * @stability stable
     */
    get instanceId(): string | undefined;
    /**
     * @stability stable
     */
    set instanceId(value: string | undefined);
    /**
     * @stability stable
     */
    resetInstanceId(): void;
    /**
     * @stability stable
     */
    get instanceIdInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings {
    /**
     * Number of backups to retain.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#retained_backups SqlDatabaseInstance#retained_backups}
     *
     * @stability stable
     */
    readonly retainedBackups: number;
    /**
     * The unit that 'retainedBackups' represents. Defaults to COUNT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#retention_unit SqlDatabaseInstance#retention_unit}
     *
     * @stability stable
     */
    readonly retentionUnit?: string;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _retainedBackups?;
    /**
     * @stability stable
     */
    get retainedBackups(): number;
    /**
     * @stability stable
     */
    set retainedBackups(value: number);
    /**
     * @stability stable
     */
    get retainedBackupsInput(): number | undefined;
    private _retentionUnit?;
    /**
     * @stability stable
     */
    get retentionUnit(): string | undefined;
    /**
     * @stability stable
     */
    set retentionUnit(value: string | undefined);
    /**
     * @stability stable
     */
    resetRetentionUnit(): void;
    /**
     * @stability stable
     */
    get retentionUnitInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsBackupConfiguration {
    /**
     * True if binary logging is enabled.
     *
     * If settings.backup_configuration.enabled is false, this must be as well. Cannot be used with Postgres.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#binary_log_enabled SqlDatabaseInstance#binary_log_enabled}
     *
     * @stability stable
     */
    readonly binaryLogEnabled?: boolean | cdktf.IResolvable;
    /**
     * True if backup configuration is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#enabled SqlDatabaseInstance#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Location of the backup configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#location SqlDatabaseInstance#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * True if Point-in-time recovery is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#point_in_time_recovery_enabled SqlDatabaseInstance#point_in_time_recovery_enabled}
     *
     * @stability stable
     */
    readonly pointInTimeRecoveryEnabled?: boolean | cdktf.IResolvable;
    /**
     * HH:MM format time indicating when backup configuration starts.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#start_time SqlDatabaseInstance#start_time}
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * The number of days of transaction logs we retain for point in time restore, from 1-7.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#transaction_log_retention_days SqlDatabaseInstance#transaction_log_retention_days}
     *
     * @stability stable
     */
    readonly transactionLogRetentionDays?: number;
    /**
     * backup_retention_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#backup_retention_settings SqlDatabaseInstance#backup_retention_settings}
     *
     * @stability stable
     */
    readonly backupRetentionSettings?: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsBackupConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _binaryLogEnabled?;
    /**
     * @stability stable
     */
    get binaryLogEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set binaryLogEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetBinaryLogEnabled(): void;
    /**
     * @stability stable
     */
    get binaryLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string | undefined;
    /**
     * @stability stable
     */
    set location(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _pointInTimeRecoveryEnabled?;
    /**
     * @stability stable
     */
    get pointInTimeRecoveryEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set pointInTimeRecoveryEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetPointInTimeRecoveryEnabled(): void;
    /**
     * @stability stable
     */
    get pointInTimeRecoveryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string | undefined;
    /**
     * @stability stable
     */
    set startTime(value: string | undefined);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _transactionLogRetentionDays?;
    /**
     * @stability stable
     */
    get transactionLogRetentionDays(): number | undefined;
    /**
     * @stability stable
     */
    set transactionLogRetentionDays(value: number | undefined);
    /**
     * @stability stable
     */
    resetTransactionLogRetentionDays(): void;
    /**
     * @stability stable
     */
    get transactionLogRetentionDaysInput(): number | undefined;
    private _backupRetentionSettings?;
    private __backupRetentionSettingsOutput;
    /**
     * @stability stable
     */
    get backupRetentionSettings(): SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsOutputReference;
    /**
     * @stability stable
     */
    putBackupRetentionSettings(value: SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined): void;
    /**
     * @stability stable
     */
    resetBackupRetentionSettings(): void;
    /**
     * @stability stable
     */
    get backupRetentionSettingsInput(): SqlDatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsDatabaseFlags {
    /**
     * Name of the flag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#name SqlDatabaseInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Value of the flag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#value SqlDatabaseInstance#value}
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsInsightsConfig {
    /**
     * True if Query Insights feature is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#query_insights_enabled SqlDatabaseInstance#query_insights_enabled}
     *
     * @stability stable
     */
    readonly queryInsightsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#query_string_length SqlDatabaseInstance#query_string_length}
     *
     * @stability stable
     */
    readonly queryStringLength?: number;
    /**
     * True if Query Insights will record application tags from query when enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#record_application_tags SqlDatabaseInstance#record_application_tags}
     *
     * @stability stable
     */
    readonly recordApplicationTags?: boolean | cdktf.IResolvable;
    /**
     * True if Query Insights will record client address when enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#record_client_address SqlDatabaseInstance#record_client_address}
     *
     * @stability stable
     */
    readonly recordClientAddress?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsInsightsConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _queryInsightsEnabled?;
    /**
     * @stability stable
     */
    get queryInsightsEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set queryInsightsEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetQueryInsightsEnabled(): void;
    /**
     * @stability stable
     */
    get queryInsightsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _queryStringLength?;
    /**
     * @stability stable
     */
    get queryStringLength(): number | undefined;
    /**
     * @stability stable
     */
    set queryStringLength(value: number | undefined);
    /**
     * @stability stable
     */
    resetQueryStringLength(): void;
    /**
     * @stability stable
     */
    get queryStringLengthInput(): number | undefined;
    private _recordApplicationTags?;
    /**
     * @stability stable
     */
    get recordApplicationTags(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set recordApplicationTags(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetRecordApplicationTags(): void;
    /**
     * @stability stable
     */
    get recordApplicationTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _recordClientAddress?;
    /**
     * @stability stable
     */
    get recordClientAddress(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set recordClientAddress(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetRecordClientAddress(): void;
    /**
     * @stability stable
     */
    get recordClientAddressInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#expiration_time SqlDatabaseInstance#expiration_time}.
     *
     * @stability stable
     */
    readonly expirationTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#name SqlDatabaseInstance#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#value SqlDatabaseInstance#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsIpConfiguration {
    /**
     * Whether this Cloud SQL instance should be assigned a public IPV4 address.
     *
     * At least ipv4_enabled must be enabled or a private_network must be configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ipv4_enabled SqlDatabaseInstance#ipv4_enabled}
     *
     * @stability stable
     */
    readonly ipv4Enabled?: boolean | cdktf.IResolvable;
    /**
     * The VPC network from which the Cloud SQL instance is accessible for private IP.
     *
     * For example, projects/myProject/global/networks/default. Specifying a network enables private IP. At least ipv4_enabled must be enabled or a private_network must be configured. This setting can be updated, but it cannot be removed after it is set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#private_network SqlDatabaseInstance#private_network}
     *
     * @stability stable
     */
    readonly privateNetwork?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#require_ssl SqlDatabaseInstance#require_ssl}.
     *
     * @stability stable
     */
    readonly requireSsl?: boolean | cdktf.IResolvable;
    /**
     * authorized_networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#authorized_networks SqlDatabaseInstance#authorized_networks}
     *
     * @stability stable
     */
    readonly authorizedNetworks?: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[];
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsIpConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _ipv4Enabled?;
    /**
     * @stability stable
     */
    get ipv4Enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set ipv4Enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIpv4Enabled(): void;
    /**
     * @stability stable
     */
    get ipv4EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _privateNetwork?;
    /**
     * @stability stable
     */
    get privateNetwork(): string | undefined;
    /**
     * @stability stable
     */
    set privateNetwork(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrivateNetwork(): void;
    /**
     * @stability stable
     */
    get privateNetworkInput(): string | undefined;
    private _requireSsl?;
    /**
     * @stability stable
     */
    get requireSsl(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set requireSsl(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetRequireSsl(): void;
    /**
     * @stability stable
     */
    get requireSslInput(): boolean | cdktf.IResolvable | undefined;
    private _authorizedNetworks?;
    /**
     * @stability stable
     */
    get authorizedNetworks(): SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | undefined;
    /**
     * @stability stable
     */
    set authorizedNetworks(value: SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | undefined);
    /**
     * @stability stable
     */
    resetAuthorizedNetworks(): void;
    /**
     * @stability stable
     */
    get authorizedNetworksInput(): SqlDatabaseInstanceSettingsIpConfigurationAuthorizedNetworks[] | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsLocationPreference {
    /**
     * A Google App Engine application whose zone to remain in. Must be in the same region as this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#follow_gae_application SqlDatabaseInstance#follow_gae_application}
     *
     * @stability stable
     */
    readonly followGaeApplication?: string;
    /**
     * The preferred compute engine zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#zone SqlDatabaseInstance#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsLocationPreferenceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _followGaeApplication?;
    /**
     * @stability stable
     */
    get followGaeApplication(): string | undefined;
    /**
     * @stability stable
     */
    set followGaeApplication(value: string | undefined);
    /**
     * @stability stable
     */
    resetFollowGaeApplication(): void;
    /**
     * @stability stable
     */
    get followGaeApplicationInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string | undefined;
    /**
     * @stability stable
     */
    set zone(value: string | undefined);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettingsMaintenanceWindow {
    /**
     * Day of week (1-7), starting on Monday.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#day SqlDatabaseInstance#day}
     *
     * @stability stable
     */
    readonly day?: number;
    /**
     * Hour of day (0-23), ignored if day not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#hour SqlDatabaseInstance#hour}
     *
     * @stability stable
     */
    readonly hour?: number;
    /**
     * Receive updates earlier (canary) or later (stable).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#update_track SqlDatabaseInstance#update_track}
     *
     * @stability stable
     */
    readonly updateTrack?: string;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _day?;
    /**
     * @stability stable
     */
    get day(): number | undefined;
    /**
     * @stability stable
     */
    set day(value: number | undefined);
    /**
     * @stability stable
     */
    resetDay(): void;
    /**
     * @stability stable
     */
    get dayInput(): number | undefined;
    private _hour?;
    /**
     * @stability stable
     */
    get hour(): number | undefined;
    /**
     * @stability stable
     */
    set hour(value: number | undefined);
    /**
     * @stability stable
     */
    resetHour(): void;
    /**
     * @stability stable
     */
    get hourInput(): number | undefined;
    private _updateTrack?;
    /**
     * @stability stable
     */
    get updateTrack(): string | undefined;
    /**
     * @stability stable
     */
    set updateTrack(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdateTrack(): void;
    /**
     * @stability stable
     */
    get updateTrackInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceSettings {
    /**
     * This specifies when the instance should be active. Can be either ALWAYS, NEVER or ON_DEMAND.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#activation_policy SqlDatabaseInstance#activation_policy}
     *
     * @stability stable
     */
    readonly activationPolicy?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see https://cloud.google.com/sql/docs/mysql/deprecation-notice for information on how to upgrade to Second Generation instances. A list of Google App Engine project names that are allowed to access this instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#authorized_gae_applications SqlDatabaseInstance#authorized_gae_applications}
     *
     * @stability stable
     */
    readonly authorizedGaeApplications?: string[];
    /**
     * The availability type of the Cloud SQL instance, high availability (REGIONAL) or single zone (ZONAL).
     *
     * For MySQL instances, ensure that
     * settings.backup_configuration.enabled and
     * settings.backup_configuration.binary_log_enabled are both set to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#availability_type SqlDatabaseInstance#availability_type}
     *
     * @stability stable
     */
    readonly availabilityType?: string;
    /**
     * The name of server instance collation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#collation SqlDatabaseInstance#collation}
     *
     * @stability stable
     */
    readonly collation?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see here for information on how to upgrade to Second Generation instances. Specific to read instances, indicates when crash-safe replication flags are enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#crash_safe_replication SqlDatabaseInstance#crash_safe_replication}
     *
     * @stability stable
     */
    readonly crashSafeReplication?: boolean | cdktf.IResolvable;
    /**
     * Configuration to increase storage size automatically.
     *
     * Note that future terraform apply calls will attempt to resize the disk to the value specified in disk_size - if this is set, do not set disk_size.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_autoresize SqlDatabaseInstance#disk_autoresize}
     *
     * @stability stable
     */
    readonly diskAutoresize?: boolean | cdktf.IResolvable;
    /**
     * The maximum size, in GB, to which storage capacity can be automatically increased.
     *
     * The default value is 0, which specifies that there is no limit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_autoresize_limit SqlDatabaseInstance#disk_autoresize_limit}
     *
     * @stability stable
     */
    readonly diskAutoresizeLimit?: number;
    /**
     * The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_size SqlDatabaseInstance#disk_size}
     *
     * @stability stable
     */
    readonly diskSize?: number;
    /**
     * The type of data disk: PD_SSD or PD_HDD.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#disk_type SqlDatabaseInstance#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * Pricing plan for this instance, can only be PER_USE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#pricing_plan SqlDatabaseInstance#pricing_plan}
     *
     * @stability stable
     */
    readonly pricingPlan?: string;
    /**
     * This property is only applicable to First Generation instances.
     *
     * First Generation instances are now deprecated, see here for information on how to upgrade to Second Generation instances. Replication type for this instance, can be one of ASYNCHRONOUS or SYNCHRONOUS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#replication_type SqlDatabaseInstance#replication_type}
     *
     * @stability stable
     */
    readonly replicationType?: string;
    /**
     * The machine type to use.
     *
     * See tiers for more details and supported versions. Postgres supports only shared-core machine types, and custom machine types such as db-custom-2-13312. See the Custom Machine Type Documentation to learn about specifying custom machine types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#tier SqlDatabaseInstance#tier}
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * A set of key/value user label pairs to assign to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#user_labels SqlDatabaseInstance#user_labels}
     *
     * @stability stable
     */
    readonly userLabels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * backup_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#backup_configuration SqlDatabaseInstance#backup_configuration}
     *
     * @stability stable
     */
    readonly backupConfiguration?: SqlDatabaseInstanceSettingsBackupConfiguration;
    /**
     * database_flags block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#database_flags SqlDatabaseInstance#database_flags}
     *
     * @stability stable
     */
    readonly databaseFlags?: SqlDatabaseInstanceSettingsDatabaseFlags[];
    /**
     * insights_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#insights_config SqlDatabaseInstance#insights_config}
     *
     * @stability stable
     */
    readonly insightsConfig?: SqlDatabaseInstanceSettingsInsightsConfig;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#ip_configuration SqlDatabaseInstance#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration?: SqlDatabaseInstanceSettingsIpConfiguration;
    /**
     * location_preference block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#location_preference SqlDatabaseInstance#location_preference}
     *
     * @stability stable
     */
    readonly locationPreference?: SqlDatabaseInstanceSettingsLocationPreference;
    /**
     * maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#maintenance_window SqlDatabaseInstance#maintenance_window}
     *
     * @stability stable
     */
    readonly maintenanceWindow?: SqlDatabaseInstanceSettingsMaintenanceWindow;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _activationPolicy?;
    /**
     * @stability stable
     */
    get activationPolicy(): string | undefined;
    /**
     * @stability stable
     */
    set activationPolicy(value: string | undefined);
    /**
     * @stability stable
     */
    resetActivationPolicy(): void;
    /**
     * @stability stable
     */
    get activationPolicyInput(): string | undefined;
    private _authorizedGaeApplications?;
    /**
     * @stability stable
     */
    get authorizedGaeApplications(): string[] | undefined;
    /**
     * @stability stable
     */
    set authorizedGaeApplications(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetAuthorizedGaeApplications(): void;
    /**
     * @stability stable
     */
    get authorizedGaeApplicationsInput(): string[] | undefined;
    private _availabilityType?;
    /**
     * @stability stable
     */
    get availabilityType(): string | undefined;
    /**
     * @stability stable
     */
    set availabilityType(value: string | undefined);
    /**
     * @stability stable
     */
    resetAvailabilityType(): void;
    /**
     * @stability stable
     */
    get availabilityTypeInput(): string | undefined;
    private _collation?;
    /**
     * @stability stable
     */
    get collation(): string | undefined;
    /**
     * @stability stable
     */
    set collation(value: string | undefined);
    /**
     * @stability stable
     */
    resetCollation(): void;
    /**
     * @stability stable
     */
    get collationInput(): string | undefined;
    private _crashSafeReplication?;
    /**
     * @stability stable
     */
    get crashSafeReplication(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set crashSafeReplication(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCrashSafeReplication(): void;
    /**
     * @stability stable
     */
    get crashSafeReplicationInput(): boolean | cdktf.IResolvable | undefined;
    private _diskAutoresize?;
    /**
     * @stability stable
     */
    get diskAutoresize(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set diskAutoresize(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDiskAutoresize(): void;
    /**
     * @stability stable
     */
    get diskAutoresizeInput(): boolean | cdktf.IResolvable | undefined;
    private _diskAutoresizeLimit?;
    /**
     * @stability stable
     */
    get diskAutoresizeLimit(): number | undefined;
    /**
     * @stability stable
     */
    set diskAutoresizeLimit(value: number | undefined);
    /**
     * @stability stable
     */
    resetDiskAutoresizeLimit(): void;
    /**
     * @stability stable
     */
    get diskAutoresizeLimitInput(): number | undefined;
    private _diskSize?;
    /**
     * @stability stable
     */
    get diskSize(): number | undefined;
    /**
     * @stability stable
     */
    set diskSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetDiskSize(): void;
    /**
     * @stability stable
     */
    get diskSizeInput(): number | undefined;
    private _diskType?;
    /**
     * @stability stable
     */
    get diskType(): string | undefined;
    /**
     * @stability stable
     */
    set diskType(value: string | undefined);
    /**
     * @stability stable
     */
    resetDiskType(): void;
    /**
     * @stability stable
     */
    get diskTypeInput(): string | undefined;
    private _pricingPlan?;
    /**
     * @stability stable
     */
    get pricingPlan(): string | undefined;
    /**
     * @stability stable
     */
    set pricingPlan(value: string | undefined);
    /**
     * @stability stable
     */
    resetPricingPlan(): void;
    /**
     * @stability stable
     */
    get pricingPlanInput(): string | undefined;
    private _replicationType?;
    /**
     * @stability stable
     */
    get replicationType(): string | undefined;
    /**
     * @stability stable
     */
    set replicationType(value: string | undefined);
    /**
     * @stability stable
     */
    resetReplicationType(): void;
    /**
     * @stability stable
     */
    get replicationTypeInput(): string | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _userLabels?;
    /**
     * @stability stable
     */
    get userLabels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set userLabels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetUserLabels(): void;
    /**
     * @stability stable
     */
    get userLabelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _backupConfiguration?;
    private __backupConfigurationOutput;
    /**
     * @stability stable
     */
    get backupConfiguration(): SqlDatabaseInstanceSettingsBackupConfigurationOutputReference;
    /**
     * @stability stable
     */
    putBackupConfiguration(value: SqlDatabaseInstanceSettingsBackupConfiguration | undefined): void;
    /**
     * @stability stable
     */
    resetBackupConfiguration(): void;
    /**
     * @stability stable
     */
    get backupConfigurationInput(): SqlDatabaseInstanceSettingsBackupConfiguration | undefined;
    private _databaseFlags?;
    /**
     * @stability stable
     */
    get databaseFlags(): SqlDatabaseInstanceSettingsDatabaseFlags[] | undefined;
    /**
     * @stability stable
     */
    set databaseFlags(value: SqlDatabaseInstanceSettingsDatabaseFlags[] | undefined);
    /**
     * @stability stable
     */
    resetDatabaseFlags(): void;
    /**
     * @stability stable
     */
    get databaseFlagsInput(): SqlDatabaseInstanceSettingsDatabaseFlags[] | undefined;
    private _insightsConfig?;
    private __insightsConfigOutput;
    /**
     * @stability stable
     */
    get insightsConfig(): SqlDatabaseInstanceSettingsInsightsConfigOutputReference;
    /**
     * @stability stable
     */
    putInsightsConfig(value: SqlDatabaseInstanceSettingsInsightsConfig | undefined): void;
    /**
     * @stability stable
     */
    resetInsightsConfig(): void;
    /**
     * @stability stable
     */
    get insightsConfigInput(): SqlDatabaseInstanceSettingsInsightsConfig | undefined;
    private _ipConfiguration?;
    private __ipConfigurationOutput;
    /**
     * @stability stable
     */
    get ipConfiguration(): SqlDatabaseInstanceSettingsIpConfigurationOutputReference;
    /**
     * @stability stable
     */
    putIpConfiguration(value: SqlDatabaseInstanceSettingsIpConfiguration | undefined): void;
    /**
     * @stability stable
     */
    resetIpConfiguration(): void;
    /**
     * @stability stable
     */
    get ipConfigurationInput(): SqlDatabaseInstanceSettingsIpConfiguration | undefined;
    private _locationPreference?;
    private __locationPreferenceOutput;
    /**
     * @stability stable
     */
    get locationPreference(): SqlDatabaseInstanceSettingsLocationPreferenceOutputReference;
    /**
     * @stability stable
     */
    putLocationPreference(value: SqlDatabaseInstanceSettingsLocationPreference | undefined): void;
    /**
     * @stability stable
     */
    resetLocationPreference(): void;
    /**
     * @stability stable
     */
    get locationPreferenceInput(): SqlDatabaseInstanceSettingsLocationPreference | undefined;
    private _maintenanceWindow?;
    private __maintenanceWindowOutput;
    /**
     * @stability stable
     */
    get maintenanceWindow(): SqlDatabaseInstanceSettingsMaintenanceWindowOutputReference;
    /**
     * @stability stable
     */
    putMaintenanceWindow(value: SqlDatabaseInstanceSettingsMaintenanceWindow | undefined): void;
    /**
     * @stability stable
     */
    resetMaintenanceWindow(): void;
    /**
     * @stability stable
     */
    get maintenanceWindowInput(): SqlDatabaseInstanceSettingsMaintenanceWindow | undefined;
}
/**
 * @stability stable
 */
export interface SqlDatabaseInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#create SqlDatabaseInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#delete SqlDatabaseInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html#update SqlDatabaseInstance#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class SqlDatabaseInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html google_sql_database_instance}.
 *
 * @stability stable
 */
export declare class SqlDatabaseInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_database_instance.html google_sql_database_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: SqlDatabaseInstanceConfig);
    /**
     * @stability stable
     */
    get connectionName(): string;
    private _databaseVersion?;
    /**
     * @stability stable
     */
    get databaseVersion(): string | undefined;
    /**
     * @stability stable
     */
    set databaseVersion(value: string | undefined);
    /**
     * @stability stable
     */
    resetDatabaseVersion(): void;
    /**
     * @stability stable
     */
    get databaseVersionInput(): string | undefined;
    private _deletionProtection?;
    /**
     * @stability stable
     */
    get deletionProtection(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set deletionProtection(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDeletionProtection(): void;
    /**
     * @stability stable
     */
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get firstIpAddress(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    ipAddress(index: string): SqlDatabaseInstanceIpAddress;
    private _masterInstanceName?;
    /**
     * @stability stable
     */
    get masterInstanceName(): string | undefined;
    /**
     * @stability stable
     */
    set masterInstanceName(value: string | undefined);
    /**
     * @stability stable
     */
    resetMasterInstanceName(): void;
    /**
     * @stability stable
     */
    get masterInstanceNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicIpAddress(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _rootPassword?;
    /**
     * @stability stable
     */
    get rootPassword(): string | undefined;
    /**
     * @stability stable
     */
    set rootPassword(value: string | undefined);
    /**
     * @stability stable
     */
    resetRootPassword(): void;
    /**
     * @stability stable
     */
    get rootPasswordInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    serverCaCert(index: string): SqlDatabaseInstanceServerCaCert;
    /**
     * @stability stable
     */
    get serviceAccountEmailAddress(): string;
    private _clone?;
    private __cloneOutput;
    /**
     * @stability stable
     */
    get clone(): SqlDatabaseInstanceCloneOutputReference;
    /**
     * @stability stable
     */
    putClone(value: SqlDatabaseInstanceClone | undefined): void;
    /**
     * @stability stable
     */
    resetClone(): void;
    /**
     * @stability stable
     */
    get cloneInput(): SqlDatabaseInstanceClone | undefined;
    private _replicaConfiguration?;
    private __replicaConfigurationOutput;
    /**
     * @stability stable
     */
    get replicaConfiguration(): SqlDatabaseInstanceReplicaConfigurationOutputReference;
    /**
     * @stability stable
     */
    putReplicaConfiguration(value: SqlDatabaseInstanceReplicaConfiguration | undefined): void;
    /**
     * @stability stable
     */
    resetReplicaConfiguration(): void;
    /**
     * @stability stable
     */
    get replicaConfigurationInput(): SqlDatabaseInstanceReplicaConfiguration | undefined;
    private _restoreBackupContext?;
    private __restoreBackupContextOutput;
    /**
     * @stability stable
     */
    get restoreBackupContext(): SqlDatabaseInstanceRestoreBackupContextOutputReference;
    /**
     * @stability stable
     */
    putRestoreBackupContext(value: SqlDatabaseInstanceRestoreBackupContext | undefined): void;
    /**
     * @stability stable
     */
    resetRestoreBackupContext(): void;
    /**
     * @stability stable
     */
    get restoreBackupContextInput(): SqlDatabaseInstanceRestoreBackupContext | undefined;
    private _settings?;
    private __settingsOutput;
    /**
     * @stability stable
     */
    get settings(): SqlDatabaseInstanceSettingsOutputReference;
    /**
     * @stability stable
     */
    putSettings(value: SqlDatabaseInstanceSettings | undefined): void;
    /**
     * @stability stable
     */
    resetSettings(): void;
    /**
     * @stability stable
     */
    get settingsInput(): SqlDatabaseInstanceSettings | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): SqlDatabaseInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SqlDatabaseInstanceTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlDatabaseInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
