[![Actions Status](https://github.com/pulumi/pulumi-gcp/workflows/master/badge.svg)](https://github.com/pulumi/pulumi-gcp/actions)
[![Slack](http://www.pulumi.com/images/docs/badges/slack.svg)](https://slack.pulumi.com)
[![NPM version](https://badge.fury.io/js/%40pulumi%2Fgcp.svg)](https://npmjs.com/package/@pulumi/gcp)
[![NuGet version](https://badge.fury.io/nu/pulumi.gcp.svg)](https://badge.fury.io/nu/pulumi.gcp)
[![Python version](https://badge.fury.io/py/pulumi-gcp.svg)](https://pypi.org/project/pulumi-gcp)
[![PkgGoDev](https://pkg.go.dev/badge/github.com/pulumi/pulumi-gcp/sdk/v3/go)](https://pkg.go.dev/github.com/pulumi/pulumi-gcp/sdk/v3/go)
[![License](https://img.shields.io/npm/l/%40pulumi%2Fpulumi.svg)](https://github.com/pulumi/pulumi-gcp/blob/master/LICENSE)

# Google Cloud Platform Resource Provider

The Google Cloud Platform (GCP) resource provider for Pulumi lets you use GCP resources in your cloud programs.  To use
this package, please [install the Pulumi CLI first](https://pulumi.io/). For a streamlined Pulumi walkthrough, including language runtime installation and GCP configuration, click "Get Started" below.

<div>
    <a href="https://www.pulumi.com/docs/get-started/gcp" title="Get Started">
       <img src="https://www.pulumi.com/images/get-started.svg" width="120">
    </a>
</div>

## Installing

This package is available in many languages in the standard packaging formats.

### Node.js (JavaScript/TypeScript)

To use from JavaScript or TypeScript in Node.js, install using either `npm`:

    $ npm install @pulumi/gcp

or `yarn`:

    $ yarn add @pulumi/gcp

### Python

To use from Python, install using `pip`:

    $ pip install pulumi_gcp

### Go

To use from Go, use `go get` to grab the latest version of the library

    $ go get github.com/pulumi/pulumi-gcp/sdk/v3

### .NET 

To use from .NET, install using `dotnet add package`:

   $ dotnet add package Pulumi.Gcp

## Reference

For further information, please visit [the GCP provider docs](https://www.pulumi.com/docs/intro/cloud-providers/gcp) or for detailed reference documentation, please visit [the API docs](https://www.pulumi.com/docs/reference/pkg/gcp).
