# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['PreventionJobTrigger']


class PreventionJobTrigger(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 inspect_job: Optional[pulumi.Input[pulumi.InputType['PreventionJobTriggerInspectJobArgs']]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PreventionJobTriggerTriggerArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        A job trigger configuration.

        To get more information about JobTrigger, see:

        * [API documentation](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.jobTriggers)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dlp/docs/creating-job-triggers)

        ## Example Usage
        ### Dlp Job Trigger Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionJobTrigger("basic",
            description="Description",
            display_name="Displayname",
            inspect_job=gcp.dataloss.PreventionJobTriggerInspectJobArgs(
                actions=[gcp.dataloss.PreventionJobTriggerInspectJobActionArgs(
                    save_findings=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsArgs(
                        output_config=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigArgs(
                            table=gcp.dataloss.PreventionJobTriggerInspectJobActionSaveFindingsOutputConfigTableArgs(
                                dataset_id="asdf",
                                project_id="asdf",
                            ),
                        ),
                    ),
                )],
                inspect_template_name="fake",
                storage_config=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigArgs(
                    cloud_storage_options=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsArgs(
                        file_set=gcp.dataloss.PreventionJobTriggerInspectJobStorageConfigCloudStorageOptionsFileSetArgs(
                            url="gs://mybucket/directory/",
                        ),
                    ),
                ),
            ),
            parent="projects/my-project-name",
            triggers=[gcp.dataloss.PreventionJobTriggerTriggerArgs(
                schedule=gcp.dataloss.PreventionJobTriggerTriggerScheduleArgs(
                    recurrence_period_duration="86400s",
                ),
            )])
        ```

        ## Import

        JobTrigger can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:dataloss/preventionJobTrigger:PreventionJobTrigger default {{parent}}/jobTriggers/{{name}}
        ```

        ```sh
         $ pulumi import gcp:dataloss/preventionJobTrigger:PreventionJobTrigger default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the job trigger.
        :param pulumi.Input[str] display_name: User set display name of the job trigger.
        :param pulumi.Input[pulumi.InputType['PreventionJobTriggerInspectJobArgs']] inspect_job: Controls what and how to inspect for findings.
               Structure is documented below.
        :param pulumi.Input[str] parent: The parent of the trigger, either in the format `projects/{{project}}`
               or `projects/{{project}}/locations/{{location}}`
        :param pulumi.Input[str] status: Whether the trigger is currently active.
               Default value is `HEALTHY`.
               Possible values are `PAUSED`, `HEALTHY`, and `CANCELLED`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PreventionJobTriggerTriggerArgs']]]] triggers: What event needs to occur for a new job to be started.
               Structure is documented below.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['display_name'] = display_name
            __props__['inspect_job'] = inspect_job
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__['parent'] = parent
            __props__['status'] = status
            if triggers is None and not opts.urn:
                raise TypeError("Missing required property 'triggers'")
            __props__['triggers'] = triggers
            __props__['last_run_time'] = None
            __props__['name'] = None
        super(PreventionJobTrigger, __self__).__init__(
            'gcp:dataloss/preventionJobTrigger:PreventionJobTrigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            inspect_job: Optional[pulumi.Input[pulumi.InputType['PreventionJobTriggerInspectJobArgs']]] = None,
            last_run_time: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            triggers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PreventionJobTriggerTriggerArgs']]]]] = None) -> 'PreventionJobTrigger':
        """
        Get an existing PreventionJobTrigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description of the job trigger.
        :param pulumi.Input[str] display_name: User set display name of the job trigger.
        :param pulumi.Input[pulumi.InputType['PreventionJobTriggerInspectJobArgs']] inspect_job: Controls what and how to inspect for findings.
               Structure is documented below.
        :param pulumi.Input[str] last_run_time: The timestamp of the last time this trigger executed.
        :param pulumi.Input[str] name: The name of the Datastore kind.
        :param pulumi.Input[str] parent: The parent of the trigger, either in the format `projects/{{project}}`
               or `projects/{{project}}/locations/{{location}}`
        :param pulumi.Input[str] status: Whether the trigger is currently active.
               Default value is `HEALTHY`.
               Possible values are `PAUSED`, `HEALTHY`, and `CANCELLED`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PreventionJobTriggerTriggerArgs']]]] triggers: What event needs to occur for a new job to be started.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["display_name"] = display_name
        __props__["inspect_job"] = inspect_job
        __props__["last_run_time"] = last_run_time
        __props__["name"] = name
        __props__["parent"] = parent
        __props__["status"] = status
        __props__["triggers"] = triggers
        return PreventionJobTrigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the job trigger.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        User set display name of the job trigger.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inspectJob")
    def inspect_job(self) -> pulumi.Output[Optional['outputs.PreventionJobTriggerInspectJob']]:
        """
        Controls what and how to inspect for findings.
        Structure is documented below.
        """
        return pulumi.get(self, "inspect_job")

    @property
    @pulumi.getter(name="lastRunTime")
    def last_run_time(self) -> pulumi.Output[str]:
        """
        The timestamp of the last time this trigger executed.
        """
        return pulumi.get(self, "last_run_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Datastore kind.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[str]:
        """
        The parent of the trigger, either in the format `projects/{{project}}`
        or `projects/{{project}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        Whether the trigger is currently active.
        Default value is `HEALTHY`.
        Possible values are `PAUSED`, `HEALTHY`, and `CANCELLED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def triggers(self) -> pulumi.Output[Sequence['outputs.PreventionJobTriggerTrigger']]:
        """
        What event needs to occur for a new job to be started.
        Structure is documented below.
        """
        return pulumi.get(self, "triggers")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

