# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['LiteTopic']


class LiteTopic(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partition_config: Optional[pulumi.Input[pulumi.InputType['LiteTopicPartitionConfigArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 retention_config: Optional[pulumi.Input[pulumi.InputType['LiteTopicRetentionConfigArgs']]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        A named resource to which messages are sent by publishers.

        To get more information about Topic, see:

        * [API documentation](https://cloud.google.com/pubsub/docs/reference/rest/v1/projects.topics)
        * How-to Guides
            * [Managing Topics](https://cloud.google.com/pubsub/docs/admin#managing_topics)

        ## Example Usage
        ### Pubsub Lite Topic Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example = gcp.pubsub.LiteTopic("example",
            project=project.number,
            partition_config=gcp.pubsub.LiteTopicPartitionConfigArgs(
                count=1,
                capacity=gcp.pubsub.LiteTopicPartitionConfigCapacityArgs(
                    publish_mib_per_sec=4,
                    subscribe_mib_per_sec=8,
                ),
            ),
            retention_config=gcp.pubsub.LiteTopicRetentionConfigArgs(
                per_partition_bytes="32212254720",
            ))
        ```

        ## Import

        Topic can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:pubsub/liteTopic:LiteTopic default projects/{{project}}/locations/{{zone}}/topics/{{name}}
        ```

        ```sh
         $ pulumi import gcp:pubsub/liteTopic:LiteTopic default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:pubsub/liteTopic:LiteTopic default {{zone}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:pubsub/liteTopic:LiteTopic default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name of the topic.
        :param pulumi.Input[pulumi.InputType['LiteTopicPartitionConfigArgs']] partition_config: The settings for this topic's partitions.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region of the pubsub lite topic.
        :param pulumi.Input[pulumi.InputType['LiteTopicRetentionConfigArgs']] retention_config: The settings for a topic's message retention.
               Structure is documented below.
        :param pulumi.Input[str] zone: The zone of the pubsub lite topic.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['name'] = name
            __props__['partition_config'] = partition_config
            __props__['project'] = project
            __props__['region'] = region
            __props__['retention_config'] = retention_config
            __props__['zone'] = zone
        super(LiteTopic, __self__).__init__(
            'gcp:pubsub/liteTopic:LiteTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            partition_config: Optional[pulumi.Input[pulumi.InputType['LiteTopicPartitionConfigArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            retention_config: Optional[pulumi.Input[pulumi.InputType['LiteTopicRetentionConfigArgs']]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'LiteTopic':
        """
        Get an existing LiteTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name of the topic.
        :param pulumi.Input[pulumi.InputType['LiteTopicPartitionConfigArgs']] partition_config: The settings for this topic's partitions.
               Structure is documented below.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: The region of the pubsub lite topic.
        :param pulumi.Input[pulumi.InputType['LiteTopicRetentionConfigArgs']] retention_config: The settings for a topic's message retention.
               Structure is documented below.
        :param pulumi.Input[str] zone: The zone of the pubsub lite topic.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["name"] = name
        __props__["partition_config"] = partition_config
        __props__["project"] = project
        __props__["region"] = region
        __props__["retention_config"] = retention_config
        __props__["zone"] = zone
        return LiteTopic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the topic.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="partitionConfig")
    def partition_config(self) -> pulumi.Output[Optional['outputs.LiteTopicPartitionConfig']]:
        """
        The settings for this topic's partitions.
        Structure is documented below.
        """
        return pulumi.get(self, "partition_config")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        The region of the pubsub lite topic.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="retentionConfig")
    def retention_config(self) -> pulumi.Output[Optional['outputs.LiteTopicRetentionConfig']]:
        """
        The settings for a topic's message retention.
        Structure is documented below.
        """
        return pulumi.get(self, "retention_config")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[str]]:
        """
        The zone of the pubsub lite topic.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

