"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasResource = exports.findResources = void 0;
const match_1 = require("../match");
const matcher_1 = require("../matcher");
function findResources(inspector, type, props = {}) {
    const matcher = matcher_1.Matcher.isMatcher(props) ? props : match_1.Match.objectLike(props);
    let results = [];
    eachResourceWithType(inspector, type, (resource) => {
        const result = matcher.test(resource);
        if (!result.hasFailed()) {
            results.push(resource);
        }
    });
    return results;
}
exports.findResources = findResources;
function hasResource(inspector, type, props) {
    const matcher = matcher_1.Matcher.isMatcher(props) ? props : match_1.Match.objectLike(props);
    let closestResult = undefined;
    let closestResource = undefined;
    let count = 0;
    let match = false;
    eachResourceWithType(inspector, type, (resource) => {
        if (match) {
            return;
        }
        count++;
        const result = matcher.test(resource);
        if (!result.hasFailed()) {
            match = true;
        }
        if (closestResult === undefined || closestResult.failCount > result.failCount) {
            closestResult = result;
            closestResource = resource;
        }
    });
    if (match) {
        return;
    }
    if (closestResult === undefined) {
        return `No resource with type ${type} found`;
    }
    if (!closestResource) {
        throw new Error('unexpected: closestResult is null');
    }
    return [
        `${count} resources with type ${type} found, but none match as expected.`,
        formatMessage(closestResult, closestResource),
    ].join('\n');
}
exports.hasResource = hasResource;
function eachResourceWithType(inspector, type, cb) {
    var _a;
    for (const logicalId of Object.keys((_a = inspector.value.Resources) !== null && _a !== void 0 ? _a : {})) {
        const resource = inspector.value.Resources[logicalId];
        if (resource.Type === type) {
            cb(resource);
        }
    }
}
function formatMessage(closestResult, closestResource) {
    return [
        'The closest result is:',
        reindent(JSON.stringify(closestResource, undefined, 2)),
        'with the following mismatches:',
        ...closestResult.toHumanStrings().map(s => `\t${s}`),
    ].join('\n');
}
function reindent(x, indent = 2) {
    const pad = ' '.repeat(indent);
    return pad + x.split('\n').join(`\n${pad}`);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzb3VyY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyZXNvdXJjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxvQ0FBaUM7QUFDakMsd0NBQWtEO0FBR2xELFNBQWdCLGFBQWEsQ0FBQyxTQUF5QixFQUFFLElBQVksRUFBRSxRQUFhLEVBQUU7SUFDcEYsTUFBTSxPQUFPLEdBQUcsaUJBQU8sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsYUFBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMzRSxJQUFJLE9BQU8sR0FBNkIsRUFBRSxDQUFDO0lBRTNDLG9CQUFvQixDQUFDLFNBQVMsRUFBRSxJQUFJLEVBQUUsQ0FBQyxRQUFRLEVBQUUsRUFBRTtRQUNqRCxNQUFNLE1BQU0sR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3RDLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxFQUFFLEVBQUU7WUFDdkIsT0FBTyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUN4QjtJQUNILENBQUMsQ0FBQyxDQUFDO0lBRUgsT0FBTyxPQUFPLENBQUM7QUFDakIsQ0FBQztBQVpELHNDQVlDO0FBRUQsU0FBZ0IsV0FBVyxDQUFDLFNBQXlCLEVBQUUsSUFBWSxFQUFFLEtBQVU7SUFDN0UsTUFBTSxPQUFPLEdBQUcsaUJBQU8sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsYUFBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUMzRSxJQUFJLGFBQWEsR0FBNEIsU0FBUyxDQUFDO0lBQ3ZELElBQUksZUFBZSxHQUF1QyxTQUFTLENBQUM7SUFDcEUsSUFBSSxLQUFLLEdBQVcsQ0FBQyxDQUFDO0lBRXRCLElBQUksS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNsQixvQkFBb0IsQ0FBQyxTQUFTLEVBQUUsSUFBSSxFQUFFLENBQUMsUUFBUSxFQUFFLEVBQUU7UUFDakQsSUFBSSxLQUFLLEVBQUU7WUFBRSxPQUFPO1NBQUU7UUFDdEIsS0FBSyxFQUFFLENBQUM7UUFDUixNQUFNLE1BQU0sR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3RDLElBQUksQ0FBQyxNQUFNLENBQUMsU0FBUyxFQUFFLEVBQUU7WUFDdkIsS0FBSyxHQUFHLElBQUksQ0FBQztTQUNkO1FBQ0QsSUFBSSxhQUFhLEtBQUssU0FBUyxJQUFJLGFBQWEsQ0FBQyxTQUFTLEdBQUcsTUFBTSxDQUFDLFNBQVMsRUFBRTtZQUM3RSxhQUFhLEdBQUcsTUFBTSxDQUFDO1lBQ3ZCLGVBQWUsR0FBRyxRQUFRLENBQUM7U0FDNUI7SUFDSCxDQUFDLENBQUMsQ0FBQztJQUVILElBQUksS0FBSyxFQUFFO1FBQ1QsT0FBTztLQUNSO0lBRUQsSUFBSSxhQUFhLEtBQUssU0FBUyxFQUFFO1FBQy9CLE9BQU8seUJBQXlCLElBQUksUUFBUSxDQUFDO0tBQzlDO0lBRUQsSUFBSSxDQUFDLGVBQWUsRUFBRTtRQUNwQixNQUFNLElBQUksS0FBSyxDQUFDLG1DQUFtQyxDQUFDLENBQUM7S0FDdEQ7SUFFRCxPQUFPO1FBQ0wsR0FBRyxLQUFLLHdCQUF3QixJQUFJLHFDQUFxQztRQUN6RSxhQUFhLENBQUMsYUFBYSxFQUFFLGVBQWUsQ0FBQztLQUM5QyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUNmLENBQUM7QUFwQ0Qsa0NBb0NDO0FBRUQsU0FBUyxvQkFBb0IsQ0FDM0IsU0FBeUIsRUFDekIsSUFBWSxFQUNaLEVBQTRDOztJQUU1QyxLQUFLLE1BQU0sU0FBUyxJQUFJLE1BQU0sQ0FBQyxJQUFJLE9BQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxTQUFTLG1DQUFJLEVBQUUsQ0FBQyxFQUFFO1FBQ3BFLE1BQU0sUUFBUSxHQUEyQixTQUFTLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUM5RSxJQUFJLFFBQVEsQ0FBQyxJQUFJLEtBQUssSUFBSSxFQUFFO1lBQzFCLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUNkO0tBQ0Y7QUFDSCxDQUFDO0FBRUQsU0FBUyxhQUFhLENBQUMsYUFBMEIsRUFBRSxlQUFtQjtJQUNwRSxPQUFPO1FBQ0wsd0JBQXdCO1FBQ3hCLFFBQVEsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLGVBQWUsRUFBRSxTQUFTLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDdkQsZ0NBQWdDO1FBQ2hDLEdBQUcsYUFBYSxDQUFDLGNBQWMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7S0FDckQsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDZixDQUFDO0FBRUQsU0FBUyxRQUFRLENBQUMsQ0FBUyxFQUFFLFNBQWlCLENBQUM7SUFDN0MsTUFBTSxHQUFHLEdBQUcsR0FBRyxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUMvQixPQUFPLEdBQUcsR0FBRyxDQUFDLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLEdBQUcsRUFBRSxDQUFDLENBQUM7QUFDOUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IE1hdGNoIH0gZnJvbSAnLi4vbWF0Y2gnO1xuaW1wb3J0IHsgTWF0Y2hlciwgTWF0Y2hSZXN1bHQgfSBmcm9tICcuLi9tYXRjaGVyJztcbmltcG9ydCB7IFN0YWNrSW5zcGVjdG9yIH0gZnJvbSAnLi4vdmVuZG9yZWQvYXNzZXJ0JztcblxuZXhwb3J0IGZ1bmN0aW9uIGZpbmRSZXNvdXJjZXMoaW5zcGVjdG9yOiBTdGFja0luc3BlY3RvciwgdHlwZTogc3RyaW5nLCBwcm9wczogYW55ID0ge30pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9W10ge1xuICBjb25zdCBtYXRjaGVyID0gTWF0Y2hlci5pc01hdGNoZXIocHJvcHMpID8gcHJvcHMgOiBNYXRjaC5vYmplY3RMaWtlKHByb3BzKTtcbiAgbGV0IHJlc3VsdHM6IHsgW2tleTogc3RyaW5nXTogYW55IH1bXSA9IFtdO1xuXG4gIGVhY2hSZXNvdXJjZVdpdGhUeXBlKGluc3BlY3RvciwgdHlwZSwgKHJlc291cmNlKSA9PiB7XG4gICAgY29uc3QgcmVzdWx0ID0gbWF0Y2hlci50ZXN0KHJlc291cmNlKTtcbiAgICBpZiAoIXJlc3VsdC5oYXNGYWlsZWQoKSkge1xuICAgICAgcmVzdWx0cy5wdXNoKHJlc291cmNlKTtcbiAgICB9XG4gIH0pO1xuXG4gIHJldHVybiByZXN1bHRzO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaGFzUmVzb3VyY2UoaW5zcGVjdG9yOiBTdGFja0luc3BlY3RvciwgdHlwZTogc3RyaW5nLCBwcm9wczogYW55KTogc3RyaW5nIHwgdm9pZCB7XG4gIGNvbnN0IG1hdGNoZXIgPSBNYXRjaGVyLmlzTWF0Y2hlcihwcm9wcykgPyBwcm9wcyA6IE1hdGNoLm9iamVjdExpa2UocHJvcHMpO1xuICBsZXQgY2xvc2VzdFJlc3VsdDogTWF0Y2hSZXN1bHQgfCB1bmRlZmluZWQgPSB1bmRlZmluZWQ7XG4gIGxldCBjbG9zZXN0UmVzb3VyY2U6IHsgW2tleTogc3RyaW5nXTogYW55IH0gfCB1bmRlZmluZWQgPSB1bmRlZmluZWQ7XG4gIGxldCBjb3VudDogbnVtYmVyID0gMDtcblxuICBsZXQgbWF0Y2ggPSBmYWxzZTtcbiAgZWFjaFJlc291cmNlV2l0aFR5cGUoaW5zcGVjdG9yLCB0eXBlLCAocmVzb3VyY2UpID0+IHtcbiAgICBpZiAobWF0Y2gpIHsgcmV0dXJuOyB9XG4gICAgY291bnQrKztcbiAgICBjb25zdCByZXN1bHQgPSBtYXRjaGVyLnRlc3QocmVzb3VyY2UpO1xuICAgIGlmICghcmVzdWx0Lmhhc0ZhaWxlZCgpKSB7XG4gICAgICBtYXRjaCA9IHRydWU7XG4gICAgfVxuICAgIGlmIChjbG9zZXN0UmVzdWx0ID09PSB1bmRlZmluZWQgfHwgY2xvc2VzdFJlc3VsdC5mYWlsQ291bnQgPiByZXN1bHQuZmFpbENvdW50KSB7XG4gICAgICBjbG9zZXN0UmVzdWx0ID0gcmVzdWx0O1xuICAgICAgY2xvc2VzdFJlc291cmNlID0gcmVzb3VyY2U7XG4gICAgfVxuICB9KTtcblxuICBpZiAobWF0Y2gpIHtcbiAgICByZXR1cm47XG4gIH1cblxuICBpZiAoY2xvc2VzdFJlc3VsdCA9PT0gdW5kZWZpbmVkKSB7XG4gICAgcmV0dXJuIGBObyByZXNvdXJjZSB3aXRoIHR5cGUgJHt0eXBlfSBmb3VuZGA7XG4gIH1cblxuICBpZiAoIWNsb3Nlc3RSZXNvdXJjZSkge1xuICAgIHRocm93IG5ldyBFcnJvcigndW5leHBlY3RlZDogY2xvc2VzdFJlc3VsdCBpcyBudWxsJyk7XG4gIH1cblxuICByZXR1cm4gW1xuICAgIGAke2NvdW50fSByZXNvdXJjZXMgd2l0aCB0eXBlICR7dHlwZX0gZm91bmQsIGJ1dCBub25lIG1hdGNoIGFzIGV4cGVjdGVkLmAsXG4gICAgZm9ybWF0TWVzc2FnZShjbG9zZXN0UmVzdWx0LCBjbG9zZXN0UmVzb3VyY2UpLFxuICBdLmpvaW4oJ1xcbicpO1xufVxuXG5mdW5jdGlvbiBlYWNoUmVzb3VyY2VXaXRoVHlwZShcbiAgaW5zcGVjdG9yOiBTdGFja0luc3BlY3RvcixcbiAgdHlwZTogc3RyaW5nLFxuICBjYjogKHJlc291cmNlOiB7W2tleTogc3RyaW5nXTogYW55fSkgPT4gdm9pZCk6IHZvaWQge1xuXG4gIGZvciAoY29uc3QgbG9naWNhbElkIG9mIE9iamVjdC5rZXlzKGluc3BlY3Rvci52YWx1ZS5SZXNvdXJjZXMgPz8ge30pKSB7XG4gICAgY29uc3QgcmVzb3VyY2U6IHsgW2tleTogc3RyaW5nXTogYW55IH0gPSBpbnNwZWN0b3IudmFsdWUuUmVzb3VyY2VzW2xvZ2ljYWxJZF07XG4gICAgaWYgKHJlc291cmNlLlR5cGUgPT09IHR5cGUpIHtcbiAgICAgIGNiKHJlc291cmNlKTtcbiAgICB9XG4gIH1cbn1cblxuZnVuY3Rpb24gZm9ybWF0TWVzc2FnZShjbG9zZXN0UmVzdWx0OiBNYXRjaFJlc3VsdCwgY2xvc2VzdFJlc291cmNlOiB7fSk6IHN0cmluZyB7XG4gIHJldHVybiBbXG4gICAgJ1RoZSBjbG9zZXN0IHJlc3VsdCBpczonLFxuICAgIHJlaW5kZW50KEpTT04uc3RyaW5naWZ5KGNsb3Nlc3RSZXNvdXJjZSwgdW5kZWZpbmVkLCAyKSksXG4gICAgJ3dpdGggdGhlIGZvbGxvd2luZyBtaXNtYXRjaGVzOicsXG4gICAgLi4uY2xvc2VzdFJlc3VsdC50b0h1bWFuU3RyaW5ncygpLm1hcChzID0+IGBcXHQke3N9YCksXG4gIF0uam9pbignXFxuJyk7XG59XG5cbmZ1bmN0aW9uIHJlaW5kZW50KHg6IHN0cmluZywgaW5kZW50OiBudW1iZXIgPSAyKTogc3RyaW5nIHtcbiAgY29uc3QgcGFkID0gJyAnLnJlcGVhdChpbmRlbnQpO1xuICByZXR1cm4gcGFkICsgeC5zcGxpdCgnXFxuJykuam9pbihgXFxuJHtwYWR9YCk7XG59Il19