# -*- coding: utf-8 -*-
# Generated by Django 1.11.27 on 2020-02-26 20:45
from __future__ import unicode_literals

from itertools import chain
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import leprikon.models.fields
from leprikon.utils import get_birth_date


def set_birth_dates(apps, schema_editor):
    Participant = apps.get_model('leprikon', 'Participant')
    SubjectRegistrationParticipant = apps.get_model('leprikon', 'SubjectRegistrationParticipant')
    for participant in chain(Participant.objects.iterator(), SubjectRegistrationParticipant.objects.iterator()) :
        participant.birth_date = get_birth_date(participant.birth_num)
        participant.save()


class Migration(migrations.Migration):

    dependencies = [
        ('leprikon', '0047_pr_print_setup'),
    ]

    operations = [
        migrations.AddField(
            model_name='citizenship',
            name='require_birth_num',
            field=models.BooleanField(default=True, verbose_name='require birth number'),
        ),
        migrations.AddField(
            model_name='participant',
            name='birth_date',
            field=models.DateField(default=django.utils.timezone.now, verbose_name='birth date'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='subjectregistrationparticipant',
            name='birth_date',
            field=models.DateField(default=django.utils.timezone.now, verbose_name='birth date'),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='participant',
            name='birth_num',
            field=leprikon.models.fields.BirthNumberField(blank=True, null=True, verbose_name='birth number'),
        ),
        migrations.AlterField(
            model_name='participant',
            name='gender',
            field=models.CharField(choices=[('m', 'male / boy'), ('f', 'female / girl')], max_length=1, verbose_name='gender'),
        ),
        migrations.AlterField(
            model_name='subjectregistrationparticipant',
            name='birth_num',
            field=leprikon.models.fields.BirthNumberField(blank=True, null=True, verbose_name='birth number'),
        ),
        migrations.AlterField(
            model_name='subjectregistrationparticipant',
            name='gender',
            field=models.CharField(choices=[('m', 'male / boy'), ('f', 'female / girl')], max_length=1, verbose_name='gender'),
        ),
        migrations.AlterUniqueTogether(
            name='participant',
            unique_together=set([]),
        ),
        migrations.RunPython(set_birth_dates),
    ]
