"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const sqs_generated_1 = require("./sqs.generated");
/**
 * Applies a policy to SQS queues.
 */
class QueuePolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * The IAM policy document for this policy.
         */
        this.document = new aws_iam_1.PolicyDocument();
        new sqs_generated_1.CfnQueuePolicy(this, 'Resource', {
            policyDocument: this.document,
            queues: props.queues.map(q => q.queueUrl)
        });
    }
}
exports.QueuePolicy = QueuePolicy;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicG9saWN5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsicG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQWtEO0FBQ2xELHdDQUFvRDtBQUVwRCxtREFBaUQ7QUFTakQ7O0dBRUc7QUFDSCxNQUFhLFdBQVksU0FBUSxlQUFRO0lBTXZDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBdUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQU5uQjs7V0FFRztRQUNhLGFBQVEsR0FBRyxJQUFJLHdCQUFjLEVBQUUsQ0FBQztRQUs5QyxJQUFJLDhCQUFjLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNuQyxjQUFjLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDN0IsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQztTQUMxQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFkRCxrQ0FjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFBvbGljeURvY3VtZW50IH0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QsIFJlc291cmNlIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBJUXVldWUgfSBmcm9tICcuL3F1ZXVlLWJhc2UnO1xuaW1wb3J0IHsgQ2ZuUXVldWVQb2xpY3kgfSBmcm9tICcuL3Nxcy5nZW5lcmF0ZWQnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFF1ZXVlUG9saWN5UHJvcHMge1xuICAvKipcbiAgICogVGhlIHNldCBvZiBxdWV1ZXMgdGhpcyBwb2xpY3kgYXBwbGllcyB0by5cbiAgICovXG4gIHJlYWRvbmx5IHF1ZXVlczogSVF1ZXVlW107XG59XG5cbi8qKlxuICogQXBwbGllcyBhIHBvbGljeSB0byBTUVMgcXVldWVzLlxuICovXG5leHBvcnQgY2xhc3MgUXVldWVQb2xpY3kgZXh0ZW5kcyBSZXNvdXJjZSB7XG4gIC8qKlxuICAgKiBUaGUgSUFNIHBvbGljeSBkb2N1bWVudCBmb3IgdGhpcyBwb2xpY3kuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgZG9jdW1lbnQgPSBuZXcgUG9saWN5RG9jdW1lbnQoKTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUXVldWVQb2xpY3lQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBuZXcgQ2ZuUXVldWVQb2xpY3kodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgcG9saWN5RG9jdW1lbnQ6IHRoaXMuZG9jdW1lbnQsXG4gICAgICBxdWV1ZXM6IHByb3BzLnF1ZXVlcy5tYXAocSA9PiBxLnF1ZXVlVXJsKVxuICAgIH0pO1xuICB9XG59XG4iXX0=