import { Widget } from '@lumino/widgets';
import { IStatusBar } from '@jupyterlab/statusbar';
import { requestAPI } from './server-api';
/**
 * Initialization data for the environment-life extension.
 */
const extension = {
    id: '@nbgallery/environment-life:environment-life',
    autoStart: true,
    requires: [IStatusBar],
    activate: async (app, statusBar) => {
        let termination_time = "";
        try {
            const data = await requestAPI('expiration');
            termination_time = data['NBGALLERY_TERMINATION_TIME'];
            displayExpiration();
        }
        catch (reason) {
            console.error(`ERROR on get /jupyter_nbgallery/environment.\n ${reason}`);
        }
        function displayExpiration() {
            console.log(`termination Time: ${termination_time}`);
            if (termination_time && termination_time.length > 0) {
                let expires = new Date(termination_time + " UTC");
                const widget = new expirationWidget();
                widget.node.textContent = "Expires: " + expires.toLocaleString();
                statusBar.registerStatusItem('bench-expiration', { align: "right", item: widget });
            }
        }
    }
};
export default extension;
class expirationWidget extends Widget {
    constructor() {
        super();
        this.addClass('jp-expiration-widget');
        this.id = 'environment_expires';
        this.title.label = 'Jupyter Environment Expires';
    }
}
