import { IDisposable } from '@lumino/disposable';
import { JupyterFrontEndPlugin } from '@jupyterlab/application';
import { ToolbarButton } from '@jupyterlab/apputils';
import { DocumentRegistry } from '@jupyterlab/docregistry';
import { NotebookPanel, INotebookModel, INotebookTracker } from '@jupyterlab/notebook';
import 'fa-icons';
/**
* Creating the Plugin that will add the buttons
*/
declare const plugin: JupyterFrontEndPlugin<void>;
declare class stagingJson {
    link: string;
    commit: string;
    staging_id: string;
    filename: string;
    clone: string;
}
export declare class ButtonExtension implements DocumentRegistry.IWidgetExtension<NotebookPanel, INotebookModel> {
    nbgallery_url: string;
    gallery_metadata: any;
    notebook_url: string;
    loaded: boolean;
    nbgallery_link: ToolbarButton;
    upload: ToolbarButton;
    download: ToolbarButton;
    fork: ToolbarButton;
    link: ToolbarButton;
    save: ToolbarButton;
    changereq: ToolbarButton;
    unlink: ToolbarButton;
    notebook: INotebookModel;
    panel: NotebookPanel;
    context: DocumentRegistry.IContext<INotebookModel>;
    notebooks: INotebookTracker;
    dialogPromiseCache: Map<string, Promise<void>>;
    createNew(panel: NotebookPanel, context: DocumentRegistry.IContext<INotebookModel>): IDisposable;
    setTracker(notebooks: INotebookTracker): void;
    panelChanged(): void;
    updateMetadata(response: stagingJson, notebook_base: string): void;
    finishUpload(response: stagingJson, notebook_base: string, change_request: boolean): void;
    buildButtons(context: DocumentRegistry.IContext<INotebookModel>): void;
    load(): void;
    toggleButtons(): void;
    link_notebook_if_exists(nb_url: string): void;
    stageNotebook(gallery_url: URL, id: string, notebook_content: string): Promise<any>;
    checkForUpdates(url: string): Promise<boolean>;
    triggerSave(): void;
    strip_output(notebook: INotebookModel): any;
    downloadReplace(): Promise<void>;
    changedDialog(showDiff: boolean): Promise<void>;
}
export default plugin;
