"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from freeclimb.api_client import ApiClient, Endpoint as _Endpoint
from freeclimb.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from freeclimb.model.account_request import AccountRequest
from freeclimb.model.account_result import AccountResult
from freeclimb.model.application_list import ApplicationList
from freeclimb.model.application_request import ApplicationRequest
from freeclimb.model.application_result import ApplicationResult
from freeclimb.model.available_number_list import AvailableNumberList
from freeclimb.model.buy_incoming_number_request import BuyIncomingNumberRequest
from freeclimb.model.call_list import CallList
from freeclimb.model.call_result import CallResult
from freeclimb.model.call_status import CallStatus
from freeclimb.model.conference_list import ConferenceList
from freeclimb.model.conference_participant_list import ConferenceParticipantList
from freeclimb.model.conference_participant_result import ConferenceParticipantResult
from freeclimb.model.conference_result import ConferenceResult
from freeclimb.model.create_conference_request import CreateConferenceRequest
from freeclimb.model.filter_logs_request import FilterLogsRequest
from freeclimb.model.incoming_number_list import IncomingNumberList
from freeclimb.model.incoming_number_request import IncomingNumberRequest
from freeclimb.model.incoming_number_result import IncomingNumberResult
from freeclimb.model.log_list import LogList
from freeclimb.model.make_call_request import MakeCallRequest
from freeclimb.model.message_direction import MessageDirection
from freeclimb.model.message_request import MessageRequest
from freeclimb.model.message_result import MessageResult
from freeclimb.model.messages_list import MessagesList
from freeclimb.model.queue_list import QueueList
from freeclimb.model.queue_member import QueueMember
from freeclimb.model.queue_member_list import QueueMemberList
from freeclimb.model.queue_request import QueueRequest
from freeclimb.model.queue_result import QueueResult
from freeclimb.model.recording_list import RecordingList
from freeclimb.model.recording_result import RecordingResult
from freeclimb.model.update_call_request import UpdateCallRequest
from freeclimb.model.update_conference_participant_request import UpdateConferenceParticipantRequest
from freeclimb.model.update_conference_request import UpdateConferenceRequest


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None, account_id=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        if account_id is None:
            account_id = self.api_client.configuration.username
        self.account_id = account_id
        self.buy_a_phone_number_endpoint = _Endpoint(
            settings={
                'response_type': (IncomingNumberResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/IncomingPhoneNumbers',
                'operation_id': 'buy_a_phone_number',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'buy_incoming_number_request',
                ],
                'required': [
                    'account_id',
                    'buy_incoming_number_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'buy_incoming_number_request':
                        (BuyIncomingNumberRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'buy_incoming_number_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_a_conference_endpoint = _Endpoint(
            settings={
                'response_type': (ConferenceResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Conferences',
                'operation_id': 'create_a_conference',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'create_conference_request',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'create_conference_request':
                        (CreateConferenceRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'create_conference_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_a_queue_endpoint = _Endpoint(
            settings={
                'response_type': (QueueResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Queues',
                'operation_id': 'create_a_queue',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'queue_request',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'queue_request':
                        (QueueRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'queue_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_an_application_endpoint = _Endpoint(
            settings={
                'response_type': (ApplicationResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Applications',
                'operation_id': 'create_an_application',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'application_request',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'application_request':
                        (ApplicationRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'application_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_a_recording_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Recordings/{recordingId}',
                'operation_id': 'delete_a_recording',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'recording_id',
                ],
                'required': [
                    'account_id',
                    'recording_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'recording_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'recording_id': 'recordingId',
                },
                'location_map': {
                    'account_id': 'path',
                    'recording_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_an_application_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Applications/{applicationId}',
                'operation_id': 'delete_an_application',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'application_id',
                ],
                'required': [
                    'account_id',
                    'application_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'application_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'application_id': 'applicationId',
                },
                'location_map': {
                    'account_id': 'path',
                    'application_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_an_incoming_number_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/IncomingPhoneNumbers/{phoneNumberId}',
                'operation_id': 'delete_an_incoming_number',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'phone_number_id',
                ],
                'required': [
                    'account_id',
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'phone_number_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'phone_number_id': 'phoneNumberId',
                },
                'location_map': {
                    'account_id': 'path',
                    'phone_number_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.dequeue_a_member_endpoint = _Endpoint(
            settings={
                'response_type': (QueueMember,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Queues/{queueId}/Members/{callId}',
                'operation_id': 'dequeue_a_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'queue_id',
                    'call_id',
                ],
                'required': [
                    'account_id',
                    'queue_id',
                    'call_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'queue_id':
                        (str,),
                    'call_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'queue_id': 'queueId',
                    'call_id': 'callId',
                },
                'location_map': {
                    'account_id': 'path',
                    'queue_id': 'path',
                    'call_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.dequeue_head_member_endpoint = _Endpoint(
            settings={
                'response_type': (QueueMember,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Queues/{queueId}/Members/Front',
                'operation_id': 'dequeue_head_member',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'queue_id',
                ],
                'required': [
                    'account_id',
                    'queue_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'queue_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'queue_id': 'queueId',
                },
                'location_map': {
                    'account_id': 'path',
                    'queue_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.download_a_recording_file_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Recordings/{recordingId}/Download',
                'operation_id': 'download_a_recording_file',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'recording_id',
                ],
                'required': [
                    'account_id',
                    'recording_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'recording_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'recording_id': 'recordingId',
                },
                'location_map': {
                    'account_id': 'path',
                    'recording_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'audio/x-wav'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.filter_logs_endpoint = _Endpoint(
            settings={
                'response_type': (LogList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Logs',
                'operation_id': 'filter_logs',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'filter_logs_request',
                ],
                'required': [
                    'account_id',
                    'filter_logs_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'filter_logs_request':
                        (FilterLogsRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'filter_logs_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_a_call_endpoint = _Endpoint(
            settings={
                'response_type': (CallResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Calls/{callId}',
                'operation_id': 'get_a_call',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'call_id',
                ],
                'required': [
                    'account_id',
                    'call_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'call_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'call_id': 'callId',
                },
                'location_map': {
                    'account_id': 'path',
                    'call_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_a_conference_endpoint = _Endpoint(
            settings={
                'response_type': (ConferenceResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Conferences/{conferenceId}',
                'operation_id': 'get_a_conference',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'conference_id',
                ],
                'required': [
                    'account_id',
                    'conference_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'conference_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'conference_id': 'conferenceId',
                },
                'location_map': {
                    'account_id': 'path',
                    'conference_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_a_member_endpoint = _Endpoint(
            settings={
                'response_type': (QueueMember,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Queues/{queueId}/Members/{callId}',
                'operation_id': 'get_a_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'queue_id',
                    'call_id',
                ],
                'required': [
                    'account_id',
                    'queue_id',
                    'call_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'queue_id':
                        (str,),
                    'call_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'queue_id': 'queueId',
                    'call_id': 'callId',
                },
                'location_map': {
                    'account_id': 'path',
                    'queue_id': 'path',
                    'call_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_a_participant_endpoint = _Endpoint(
            settings={
                'response_type': (ConferenceParticipantResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Conferences/{conferenceId}/Participants/{callId}',
                'operation_id': 'get_a_participant',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'conference_id',
                    'call_id',
                ],
                'required': [
                    'account_id',
                    'conference_id',
                    'call_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'conference_id':
                        (str,),
                    'call_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'conference_id': 'conferenceId',
                    'call_id': 'callId',
                },
                'location_map': {
                    'account_id': 'path',
                    'conference_id': 'path',
                    'call_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_a_queue_endpoint = _Endpoint(
            settings={
                'response_type': (QueueResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Queues/{queueId}',
                'operation_id': 'get_a_queue',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'queue_id',
                ],
                'required': [
                    'account_id',
                    'queue_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'queue_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'queue_id': 'queueId',
                },
                'location_map': {
                    'account_id': 'path',
                    'queue_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_a_recording_endpoint = _Endpoint(
            settings={
                'response_type': (RecordingResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Recordings/{recordingId}',
                'operation_id': 'get_a_recording',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'recording_id',
                ],
                'required': [
                    'account_id',
                    'recording_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'recording_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'recording_id': 'recordingId',
                },
                'location_map': {
                    'account_id': 'path',
                    'recording_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_an_account_endpoint = _Endpoint(
            settings={
                'response_type': (AccountResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}',
                'operation_id': 'get_an_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_an_application_endpoint = _Endpoint(
            settings={
                'response_type': (ApplicationResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Applications/{applicationId}',
                'operation_id': 'get_an_application',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'application_id',
                ],
                'required': [
                    'account_id',
                    'application_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'application_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'application_id': 'applicationId',
                },
                'location_map': {
                    'account_id': 'path',
                    'application_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_an_incoming_number_endpoint = _Endpoint(
            settings={
                'response_type': (IncomingNumberResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/IncomingPhoneNumbers/{phoneNumberId}',
                'operation_id': 'get_an_incoming_number',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'phone_number_id',
                ],
                'required': [
                    'account_id',
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'phone_number_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'phone_number_id': 'phoneNumberId',
                },
                'location_map': {
                    'account_id': 'path',
                    'phone_number_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_an_sms_message_endpoint = _Endpoint(
            settings={
                'response_type': (MessageResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Messages/{messageId}',
                'operation_id': 'get_an_sms_message',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'message_id',
                ],
                'required': [
                    'account_id',
                    'message_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'message_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'message_id': 'messageId',
                },
                'location_map': {
                    'account_id': 'path',
                    'message_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_head_member_endpoint = _Endpoint(
            settings={
                'response_type': (QueueMember,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Queues/{queueId}/Members/Front',
                'operation_id': 'get_head_member',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'queue_id',
                ],
                'required': [
                    'account_id',
                    'queue_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'queue_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'queue_id': 'queueId',
                },
                'location_map': {
                    'account_id': 'path',
                    'queue_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_active_queues_endpoint = _Endpoint(
            settings={
                'response_type': (QueueList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Queues',
                'operation_id': 'list_active_queues',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'alias',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'alias':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'alias': 'alias',
                },
                'location_map': {
                    'account_id': 'path',
                    'alias': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_all_account_logs_endpoint = _Endpoint(
            settings={
                'response_type': (LogList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Logs',
                'operation_id': 'list_all_account_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_applications_endpoint = _Endpoint(
            settings={
                'response_type': (ApplicationList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Applications',
                'operation_id': 'list_applications',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'alias',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'alias':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'alias': 'alias',
                },
                'location_map': {
                    'account_id': 'path',
                    'alias': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_available_numbers_endpoint = _Endpoint(
            settings={
                'response_type': (AvailableNumberList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/AvailablePhoneNumbers',
                'operation_id': 'list_available_numbers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'phone_number',
                    'region',
                    'country',
                    'voice_enabled',
                    'sms_enabled',
                    'capabilities_voice',
                    'capabilities_sms',
                    'capabilities_toll_free',
                    'capabilities_ten_dlc',
                    'capabilities_short_code',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'phone_number':
                        (str,),
                    'region':
                        (str,),
                    'country':
                        (str,),
                    'voice_enabled':
                        (bool,),
                    'sms_enabled':
                        (bool,),
                    'capabilities_voice':
                        (bool,),
                    'capabilities_sms':
                        (bool,),
                    'capabilities_toll_free':
                        (bool,),
                    'capabilities_ten_dlc':
                        (bool,),
                    'capabilities_short_code':
                        (bool,),
                },
                'attribute_map': {
                    'phone_number': 'phoneNumber',
                    'region': 'region',
                    'country': 'country',
                    'voice_enabled': 'voiceEnabled',
                    'sms_enabled': 'smsEnabled',
                    'capabilities_voice': 'capabilities.voice',
                    'capabilities_sms': 'capabilities.sms',
                    'capabilities_toll_free': 'capabilities.tollFree',
                    'capabilities_ten_dlc': 'capabilities.tenDLC',
                    'capabilities_short_code': 'capabilities.shortCode',
                },
                'location_map': {
                    'phone_number': 'query',
                    'region': 'query',
                    'country': 'query',
                    'voice_enabled': 'query',
                    'sms_enabled': 'query',
                    'capabilities_voice': 'query',
                    'capabilities_sms': 'query',
                    'capabilities_toll_free': 'query',
                    'capabilities_ten_dlc': 'query',
                    'capabilities_short_code': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_call_logs_endpoint = _Endpoint(
            settings={
                'response_type': (LogList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Calls/{callId}/Logs',
                'operation_id': 'list_call_logs',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'call_id',
                ],
                'required': [
                    'account_id',
                    'call_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'call_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'call_id': 'callId',
                },
                'location_map': {
                    'account_id': 'path',
                    'call_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_call_recordings_endpoint = _Endpoint(
            settings={
                'response_type': (RecordingList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Calls/{callId}/Recordings',
                'operation_id': 'list_call_recordings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'call_id',
                    'date_created',
                ],
                'required': [
                    'account_id',
                    'call_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'call_id':
                        (str,),
                    'date_created':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'call_id': 'callId',
                    'date_created': 'dateCreated',
                },
                'location_map': {
                    'account_id': 'path',
                    'call_id': 'path',
                    'date_created': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_calls_endpoint = _Endpoint(
            settings={
                'response_type': (CallList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Calls',
                'operation_id': 'list_calls',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'active',
                    'to',
                    '_from',
                    'status',
                    'start_time',
                    'end_time',
                    'parent_call_id',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'active':
                        (bool,),
                    'to':
                        (str,),
                    '_from':
                        (str,),
                    'status':
                        (CallStatus,),
                    'start_time':
                        (str,),
                    'end_time':
                        (str,),
                    'parent_call_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'active': 'active',
                    'to': 'to',
                    '_from': 'from',
                    'status': 'status',
                    'start_time': 'startTime',
                    'end_time': 'endTime',
                    'parent_call_id': 'parentCallId',
                },
                'location_map': {
                    'account_id': 'path',
                    'active': 'query',
                    'to': 'query',
                    '_from': 'query',
                    'status': 'query',
                    'start_time': 'query',
                    'end_time': 'query',
                    'parent_call_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_conferences_endpoint = _Endpoint(
            settings={
                'response_type': (ConferenceList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Conferences',
                'operation_id': 'list_conferences',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'status',
                    'alias',
                    'date_created',
                    'date_updated',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'status':
                        (str,),
                    'alias':
                        (str,),
                    'date_created':
                        (str,),
                    'date_updated':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'status': 'status',
                    'alias': 'alias',
                    'date_created': 'dateCreated',
                    'date_updated': 'dateUpdated',
                },
                'location_map': {
                    'account_id': 'path',
                    'status': 'query',
                    'alias': 'query',
                    'date_created': 'query',
                    'date_updated': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_incoming_numbers_endpoint = _Endpoint(
            settings={
                'response_type': (IncomingNumberList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/IncomingPhoneNumbers',
                'operation_id': 'list_incoming_numbers',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'phone_number',
                    'alias',
                    'region',
                    'country',
                    'application_id',
                    'has_application',
                    'voice_enabled',
                    'sms_enabled',
                    'capabilities_voice',
                    'capabilities_sms',
                    'capabilities_toll_free',
                    'capabilities_ten_dlc',
                    'capabilities_short_code',
                    'offnet',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                    'offnet',
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'phone_number':
                        (str,),
                    'alias':
                        (str,),
                    'region':
                        (str,),
                    'country':
                        (str,),
                    'application_id':
                        (str,),
                    'has_application':
                        (bool,),
                    'voice_enabled':
                        (bool,),
                    'sms_enabled':
                        (bool,),
                    'capabilities_voice':
                        (bool,),
                    'capabilities_sms':
                        (bool,),
                    'capabilities_toll_free':
                        (bool,),
                    'capabilities_ten_dlc':
                        (bool,),
                    'capabilities_short_code':
                        (bool,),
                    'offnet':
                        (bool, none_type,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'phone_number': 'phoneNumber',
                    'alias': 'alias',
                    'region': 'region',
                    'country': 'country',
                    'application_id': 'applicationId',
                    'has_application': 'hasApplication',
                    'voice_enabled': 'voiceEnabled',
                    'sms_enabled': 'smsEnabled',
                    'capabilities_voice': 'capabilities.voice',
                    'capabilities_sms': 'capabilities.sms',
                    'capabilities_toll_free': 'capabilities.tollFree',
                    'capabilities_ten_dlc': 'capabilities.tenDLC',
                    'capabilities_short_code': 'capabilities.shortCode',
                    'offnet': 'offnet',
                },
                'location_map': {
                    'account_id': 'path',
                    'phone_number': 'query',
                    'alias': 'query',
                    'region': 'query',
                    'country': 'query',
                    'application_id': 'query',
                    'has_application': 'query',
                    'voice_enabled': 'query',
                    'sms_enabled': 'query',
                    'capabilities_voice': 'query',
                    'capabilities_sms': 'query',
                    'capabilities_toll_free': 'query',
                    'capabilities_ten_dlc': 'query',
                    'capabilities_short_code': 'query',
                    'offnet': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_members_endpoint = _Endpoint(
            settings={
                'response_type': (QueueMemberList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Queues/{queueId}/Members',
                'operation_id': 'list_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'queue_id',
                ],
                'required': [
                    'account_id',
                    'queue_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'queue_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'queue_id': 'queueId',
                },
                'location_map': {
                    'account_id': 'path',
                    'queue_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_participants_endpoint = _Endpoint(
            settings={
                'response_type': (ConferenceParticipantList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Conferences/{conferenceId}/Participants',
                'operation_id': 'list_participants',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'conference_id',
                    'talk',
                    'listen',
                ],
                'required': [
                    'account_id',
                    'conference_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'conference_id':
                        (str,),
                    'talk':
                        (bool,),
                    'listen':
                        (bool,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'conference_id': 'conferenceId',
                    'talk': 'talk',
                    'listen': 'listen',
                },
                'location_map': {
                    'account_id': 'path',
                    'conference_id': 'path',
                    'talk': 'query',
                    'listen': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_recordings_endpoint = _Endpoint(
            settings={
                'response_type': (RecordingList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Recordings',
                'operation_id': 'list_recordings',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'call_id',
                    'conference_id',
                    'date_created',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'call_id':
                        (str,),
                    'conference_id':
                        (str,),
                    'date_created':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'call_id': 'callId',
                    'conference_id': 'conferenceId',
                    'date_created': 'dateCreated',
                },
                'location_map': {
                    'account_id': 'path',
                    'call_id': 'query',
                    'conference_id': 'query',
                    'date_created': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_sms_messages_endpoint = _Endpoint(
            settings={
                'response_type': (MessagesList,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Messages',
                'operation_id': 'list_sms_messages',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'to',
                    '_from',
                    'begin_time',
                    'end_time',
                    'direction',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'to':
                        (str,),
                    '_from':
                        (str,),
                    'begin_time':
                        (str,),
                    'end_time':
                        (str,),
                    'direction':
                        (MessageDirection,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'to': 'to',
                    '_from': 'from',
                    'begin_time': 'beginTime',
                    'end_time': 'endTime',
                    'direction': 'direction',
                },
                'location_map': {
                    'account_id': 'path',
                    'to': 'query',
                    '_from': 'query',
                    'begin_time': 'query',
                    'end_time': 'query',
                    'direction': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.make_a_call_endpoint = _Endpoint(
            settings={
                'response_type': (CallResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Calls',
                'operation_id': 'make_a_call',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'make_call_request',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'make_call_request':
                        (MakeCallRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'make_call_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.remove_a_participant_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Conferences/{conferenceId}/Participants/{callId}',
                'operation_id': 'remove_a_participant',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'conference_id',
                    'call_id',
                ],
                'required': [
                    'account_id',
                    'conference_id',
                    'call_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'conference_id':
                        (str,),
                    'call_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'conference_id': 'conferenceId',
                    'call_id': 'callId',
                },
                'location_map': {
                    'account_id': 'path',
                    'conference_id': 'path',
                    'call_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.send_an_sms_message_endpoint = _Endpoint(
            settings={
                'response_type': (MessageResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Messages',
                'operation_id': 'send_an_sms_message',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'message_request',
                ],
                'required': [
                    'account_id',
                    'message_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'message_request':
                        (MessageRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'message_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.stream_a_recording_file_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Recordings/{recordingId}/Stream',
                'operation_id': 'stream_a_recording_file',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'recording_id',
                ],
                'required': [
                    'account_id',
                    'recording_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'recording_id':
                        (str,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'recording_id': 'recordingId',
                },
                'location_map': {
                    'account_id': 'path',
                    'recording_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'audio/x-wav'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_a_conference_endpoint = _Endpoint(
            settings={
                'response_type': (ConferenceResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Conferences/{conferenceId}',
                'operation_id': 'update_a_conference',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'conference_id',
                    'update_conference_request',
                ],
                'required': [
                    'account_id',
                    'conference_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'conference_id':
                        (str,),
                    'update_conference_request':
                        (UpdateConferenceRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'conference_id': 'conferenceId',
                },
                'location_map': {
                    'account_id': 'path',
                    'conference_id': 'path',
                    'update_conference_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_a_live_call_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Calls/{callId}',
                'operation_id': 'update_a_live_call',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'call_id',
                    'update_call_request',
                ],
                'required': [
                    'account_id',
                    'call_id',
                    'update_call_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'call_id':
                        (str,),
                    'update_call_request':
                        (UpdateCallRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'call_id': 'callId',
                },
                'location_map': {
                    'account_id': 'path',
                    'call_id': 'path',
                    'update_call_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_a_participant_endpoint = _Endpoint(
            settings={
                'response_type': (ConferenceParticipantResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Conferences/{conferenceId}/Participants/{callId}',
                'operation_id': 'update_a_participant',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'conference_id',
                    'call_id',
                    'update_conference_participant_request',
                ],
                'required': [
                    'account_id',
                    'conference_id',
                    'call_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'conference_id':
                        (str,),
                    'call_id':
                        (str,),
                    'update_conference_participant_request':
                        (UpdateConferenceParticipantRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'conference_id': 'conferenceId',
                    'call_id': 'callId',
                },
                'location_map': {
                    'account_id': 'path',
                    'conference_id': 'path',
                    'call_id': 'path',
                    'update_conference_participant_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_a_queue_endpoint = _Endpoint(
            settings={
                'response_type': (QueueResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Queues/{queueId}',
                'operation_id': 'update_a_queue',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'queue_id',
                    'queue_request',
                ],
                'required': [
                    'account_id',
                    'queue_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'queue_id':
                        (str,),
                    'queue_request':
                        (QueueRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'queue_id': 'queueId',
                },
                'location_map': {
                    'account_id': 'path',
                    'queue_id': 'path',
                    'queue_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_an_account_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}',
                'operation_id': 'update_an_account',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'account_request',
                ],
                'required': [
                    'account_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'account_request':
                        (AccountRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                },
                'location_map': {
                    'account_id': 'path',
                    'account_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_an_application_endpoint = _Endpoint(
            settings={
                'response_type': (ApplicationResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/Applications/{applicationId}',
                'operation_id': 'update_an_application',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'application_id',
                    'application_request',
                ],
                'required': [
                    'account_id',
                    'application_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'application_id':
                        (str,),
                    'application_request':
                        (ApplicationRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'application_id': 'applicationId',
                },
                'location_map': {
                    'account_id': 'path',
                    'application_id': 'path',
                    'application_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_an_incoming_number_endpoint = _Endpoint(
            settings={
                'response_type': (IncomingNumberResult,),
                'auth': [
                    'fc'
                ],
                'endpoint_path': '/Accounts/{accountId}/IncomingPhoneNumbers/{phoneNumberId}',
                'operation_id': 'update_an_incoming_number',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'phone_number_id',
                    'incoming_number_request',
                ],
                'required': [
                    'account_id',
                    'phone_number_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'phone_number_id':
                        (str,),
                    'incoming_number_request':
                        (IncomingNumberRequest,),
                },
                'attribute_map': {
                    'account_id': 'accountId',
                    'phone_number_id': 'phoneNumberId',
                },
                'location_map': {
                    'account_id': 'path',
                    'phone_number_id': 'path',
                    'incoming_number_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def buy_a_phone_number(
        self,
        buy_incoming_number_request, 
        **kwargs
        ):
        """Buy a Phone Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.buy_a_phone_number(buy_incoming_number_request, async_req=True)
        >>> result = thread.get()


        Args:


            buy_incoming_number_request (BuyIncomingNumberRequest): Incoming Number transaction details




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IncomingNumberResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['buy_incoming_number_request'] = \
            buy_incoming_number_request

        return self.buy_a_phone_number_endpoint.call_with_http_info(**kwargs)

    def create_a_conference(
        self,
         
        **kwargs
        ):
        """Create a Conference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_a_conference(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            create_conference_request (CreateConferenceRequest): Conference to create. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ConferenceResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.create_a_conference_endpoint.call_with_http_info(**kwargs)

    def create_a_queue(
        self,
         
        **kwargs
        ):
        """Create a Queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_a_queue(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            queue_request (QueueRequest): Queue details used to create a queue. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueueResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.create_a_queue_endpoint.call_with_http_info(**kwargs)

    def create_an_application(
        self,
         
        **kwargs
        ):
        """Create an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_an_application(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            application_request (ApplicationRequest): Application Details. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.create_an_application_endpoint.call_with_http_info(**kwargs)

    def delete_a_recording(
        self,
        recording_id, 
        **kwargs
        ):
        """Delete a Recording  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_a_recording(recording_id, async_req=True)
        >>> result = thread.get()


        Args:


            recording_id (str): String that uniquely identifies this recording resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['recording_id'] = \
            recording_id

        return self.delete_a_recording_endpoint.call_with_http_info(**kwargs)

    def delete_an_application(
        self,
        application_id, 
        **kwargs
        ):
        """Delete an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_an_application(application_id, async_req=True)
        >>> result = thread.get()


        Args:


            application_id (str): String that uniquely identifies this application resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['application_id'] = \
            application_id

        return self.delete_an_application_endpoint.call_with_http_info(**kwargs)

    def delete_an_incoming_number(
        self,
        phone_number_id, 
        **kwargs
        ):
        """Delete an Incoming Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_an_incoming_number(phone_number_id, async_req=True)
        >>> result = thread.get()


        Args:


            phone_number_id (str): String that uniquely identifies this phone number resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['phone_number_id'] = \
            phone_number_id

        return self.delete_an_incoming_number_endpoint.call_with_http_info(**kwargs)

    def dequeue_a_member(
        self,
        queue_id,call_id, 
        **kwargs
        ):
        """Dequeue a Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.dequeue_a_member(queue_id, call_id, async_req=True)
        >>> result = thread.get()



        Args:


            queue_id (str): String that uniquely identifies the Queue that the Member belongs to.

            call_id (str): ID if the Call that the Member belongs to





        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueueMember
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['queue_id'] = \
            queue_id

        kwargs['call_id'] = \
            call_id

        return self.dequeue_a_member_endpoint.call_with_http_info(**kwargs)

    def dequeue_head_member(
        self,
        queue_id, 
        **kwargs
        ):
        """Dequeue Head Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.dequeue_head_member(queue_id, async_req=True)
        >>> result = thread.get()


        Args:


            queue_id (str): String that uniquely identifies this queue resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueueMember
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['queue_id'] = \
            queue_id

        return self.dequeue_head_member_endpoint.call_with_http_info(**kwargs)

    def download_a_recording_file(
        self,
        recording_id, 
        **kwargs
        ):
        """Download a Recording File  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.download_a_recording_file(recording_id, async_req=True)
        >>> result = thread.get()


        Args:


            recording_id (str): String that uniquely identifies this recording resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['recording_id'] = \
            recording_id

        return self.download_a_recording_file_endpoint.call_with_http_info(**kwargs)

    def filter_logs(
        self,
        filter_logs_request, 
        **kwargs
        ):
        """Filter Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.filter_logs(filter_logs_request, async_req=True)
        >>> result = thread.get()


        Args:


            filter_logs_request (FilterLogsRequest): Filter logs request paramters




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['filter_logs_request'] = \
            filter_logs_request

        return self.filter_logs_endpoint.call_with_http_info(**kwargs)

    def get_a_call(
        self,
        call_id, 
        **kwargs
        ):
        """Get a Call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_a_call(call_id, async_req=True)
        >>> result = thread.get()


        Args:


            call_id (str): String that uniquely identifies this call resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CallResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['call_id'] = \
            call_id

        return self.get_a_call_endpoint.call_with_http_info(**kwargs)

    def get_a_conference(
        self,
        conference_id, 
        **kwargs
        ):
        """Get a Conference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_a_conference(conference_id, async_req=True)
        >>> result = thread.get()


        Args:


            conference_id (str): A string that uniquely identifies this conference resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ConferenceResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['conference_id'] = \
            conference_id

        return self.get_a_conference_endpoint.call_with_http_info(**kwargs)

    def get_a_member(
        self,
        queue_id,call_id, 
        **kwargs
        ):
        """Get a Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_a_member(queue_id, call_id, async_req=True)
        >>> result = thread.get()



        Args:


            queue_id (str): String that uniquely identifies the Queue that the Member belongs to.

            call_id (str): ID of the Call that the Member belongs to





        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueueMember
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['queue_id'] = \
            queue_id

        kwargs['call_id'] = \
            call_id

        return self.get_a_member_endpoint.call_with_http_info(**kwargs)

    def get_a_participant(
        self,
        conference_id,call_id, 
        **kwargs
        ):
        """Get a Participant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_a_participant(conference_id, call_id, async_req=True)
        >>> result = thread.get()



        Args:


            conference_id (str): ID of the conference this participant is in.

            call_id (str): ID of the Call associated with this participant.





        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ConferenceParticipantResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['conference_id'] = \
            conference_id

        kwargs['call_id'] = \
            call_id

        return self.get_a_participant_endpoint.call_with_http_info(**kwargs)

    def get_a_queue(
        self,
        queue_id, 
        **kwargs
        ):
        """Get a Queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_a_queue(queue_id, async_req=True)
        >>> result = thread.get()


        Args:


            queue_id (str): A string that uniquely identifies this queue resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueueResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['queue_id'] = \
            queue_id

        return self.get_a_queue_endpoint.call_with_http_info(**kwargs)

    def get_a_recording(
        self,
        recording_id, 
        **kwargs
        ):
        """Get a Recording  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_a_recording(recording_id, async_req=True)
        >>> result = thread.get()


        Args:


            recording_id (str): String that uniquely identifies this recording resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            RecordingResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['recording_id'] = \
            recording_id

        return self.get_a_recording_endpoint.call_with_http_info(**kwargs)

    def get_an_account(
        self,
         
        **kwargs
        ):
        """Get an Account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_an_account(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AccountResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.get_an_account_endpoint.call_with_http_info(**kwargs)

    def get_an_application(
        self,
        application_id, 
        **kwargs
        ):
        """Get an Application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_an_application(application_id, async_req=True)
        >>> result = thread.get()


        Args:


            application_id (str): A string that uniquely identifies this application resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['application_id'] = \
            application_id

        return self.get_an_application_endpoint.call_with_http_info(**kwargs)

    def get_an_incoming_number(
        self,
        phone_number_id, 
        **kwargs
        ):
        """Get an Incoming Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_an_incoming_number(phone_number_id, async_req=True)
        >>> result = thread.get()


        Args:


            phone_number_id (str): String that uniquely identifies this phone number resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IncomingNumberResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['phone_number_id'] = \
            phone_number_id

        return self.get_an_incoming_number_endpoint.call_with_http_info(**kwargs)

    def get_an_sms_message(
        self,
        message_id, 
        **kwargs
        ):
        """Get an SMS Message  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_an_sms_message(message_id, async_req=True)
        >>> result = thread.get()


        Args:


            message_id (str): String that uniquely identifies this Message resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MessageResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['message_id'] = \
            message_id

        return self.get_an_sms_message_endpoint.call_with_http_info(**kwargs)

    def get_head_member(
        self,
        queue_id, 
        **kwargs
        ):
        """Get Head Member  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_head_member(queue_id, async_req=True)
        >>> result = thread.get()


        Args:


            queue_id (str): String that uniquely identifies the Queue that the Member belongs to.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueueMember
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['queue_id'] = \
            queue_id

        return self.get_head_member_endpoint.call_with_http_info(**kwargs)

    def list_active_queues(
        self,
         
        **kwargs
        ):
        """List Active Queues  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_active_queues(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            alias (str): Return only the Queue resources with aliases that exactly match this name.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueueList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.list_active_queues_endpoint.call_with_http_info(**kwargs)

    def list_all_account_logs(
        self,
         
        **kwargs
        ):
        """List All Account Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_all_account_logs(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.list_all_account_logs_endpoint.call_with_http_info(**kwargs)

    def list_applications(
        self,
         
        **kwargs
        ):
        """List applications  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_applications(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            alias (str): Return only applications with aliases that exactly match this value.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.list_applications_endpoint.call_with_http_info(**kwargs)

    def list_available_numbers(
        self,
         
        **kwargs
        ):
        """List available numbers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_available_numbers(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            phone_number (str): PCRE-compatible regular expression to filter against `phoneNumber` field, which is in E.164 format.. [optional]
            region (str): State or province of this phone number.. [optional]
            country (str): Country of this phone number.. [optional]
            voice_enabled (bool): Indicates whether the phone number can handle Calls. Typically set to true for all numbers.. [optional] if omitted the server will use the default value of True
            sms_enabled (bool): Indication of whether the phone number can handle sending and receiving SMS messages. Typically set to true for all numbers.. [optional] if omitted the server will use the default value of True
            capabilities_voice (bool): [optional]
            capabilities_sms (bool): [optional]
            capabilities_toll_free (bool): [optional]
            capabilities_ten_dlc (bool): [optional]
            capabilities_short_code (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AvailableNumberList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')

        return self.list_available_numbers_endpoint.call_with_http_info(**kwargs)

    def list_call_logs(
        self,
        call_id, 
        **kwargs
        ):
        """List Call Logs  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_call_logs(call_id, async_req=True)
        >>> result = thread.get()


        Args:


            call_id (str): String that uniquely identifies this call resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            LogList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['call_id'] = \
            call_id

        return self.list_call_logs_endpoint.call_with_http_info(**kwargs)

    def list_call_recordings(
        self,
        call_id, 
        **kwargs
        ):
        """List Call Recordings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_call_recordings(call_id, async_req=True)
        >>> result = thread.get()


        Args:


            call_id (str): String that uniquely identifies this call resource.




        Keyword Args:
            date_created (str): Only show recordings created on the specified date, in the form *YYYY-MM-DD*.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            RecordingList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['call_id'] = \
            call_id

        return self.list_call_recordings_endpoint.call_with_http_info(**kwargs)

    def list_calls(
        self,
         
        **kwargs
        ):
        """List Calls  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_calls(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            active (bool): If active is set to true then all calls of the nature queued, ringing, inProgress are returned in the query.. [optional] if omitted the server will use the default value of False
            to (str): Only show Calls to this phone number.. [optional]
            _from (str): Only show Calls from this phone number.. [optional]
            status (CallStatus): Only show Calls currently in this status. May be `queued`, `ringing`, `inProgress`, `canceled`, `completed`, `failed`, `busy`, or `noAnswer`.. [optional]
            start_time (str): Only show Calls that started at or after this time, given as YYYY-MM-DD hh:mm:ss.. [optional]
            end_time (str): Only show Calls that ended at or before this time, given as YYYY-MM- DD hh:mm:ss.. [optional]
            parent_call_id (str): Only show Calls spawned by the call with this ID.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CallList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.list_calls_endpoint.call_with_http_info(**kwargs)

    def list_conferences(
        self,
         
        **kwargs
        ):
        """List Conferences  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_conferences(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            status (str): Only show conferences that currently have the specified status. Valid values: `empty`, `populated`, `inProgress`, or `terminated`.. [optional]
            alias (str): List Conferences whose alias exactly matches this string.. [optional]
            date_created (str): Only show Conferences that were created on the specified date, in the form *YYYY-MM-DD*.. [optional]
            date_updated (str): Only show Conferences that were last updated on the specified date, in the form *YYYY-MM-DD*.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ConferenceList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.list_conferences_endpoint.call_with_http_info(**kwargs)

    def list_incoming_numbers(
        self,
         
        **kwargs
        ):
        """List Incoming Numbers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_incoming_numbers(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            phone_number (str): Only show incoming phone number resources that match this PCRE-compatible regular expression.. [optional]
            alias (str): Only show incoming phone numbers with aliases that exactly match this value.. [optional]
            region (str): State or province of this phone number.. [optional]
            country (str): Country of this phone number.. [optional]
            application_id (str): ID of the Application that FreeClimb should contact if a Call or SMS arrives for this phone number or a Call from this number is placed. An incoming phone number is not useful until associated with an applicationId.. [optional]
            has_application (bool): Indication of whether the phone number has an application linked to it.. [optional] if omitted the server will use the default value of False
            voice_enabled (bool): Indicates whether the phone number can handle Calls. Typically set to true for all numbers.. [optional] if omitted the server will use the default value of True
            sms_enabled (bool): Indication of whether the phone number can handle sending and receiving SMS messages. Typically set to true for all numbers.. [optional] if omitted the server will use the default value of True
            capabilities_voice (bool): [optional]
            capabilities_sms (bool): [optional]
            capabilities_toll_free (bool): [optional]
            capabilities_ten_dlc (bool): [optional]
            capabilities_short_code (bool): [optional]
            offnet (bool, none_type): Indication of whether the phone number was registered as an offnet number. This field will be rendered only for requests to the IncomingPhone number resource.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IncomingNumberList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.list_incoming_numbers_endpoint.call_with_http_info(**kwargs)

    def list_members(
        self,
        queue_id, 
        **kwargs
        ):
        """List Members  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_members(queue_id, async_req=True)
        >>> result = thread.get()


        Args:


            queue_id (str): String that uniquely identifies the Queue that the Member belongs to.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueueMemberList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['queue_id'] = \
            queue_id

        return self.list_members_endpoint.call_with_http_info(**kwargs)

    def list_participants(
        self,
        conference_id, 
        **kwargs
        ):
        """List Participants  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_participants(conference_id, async_req=True)
        >>> result = thread.get()


        Args:


            conference_id (str): ID of the conference this participant is in.




        Keyword Args:
            talk (bool): Only show Participants with the talk privilege.. [optional]
            listen (bool): Only show Participants with the listen privilege.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ConferenceParticipantList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['conference_id'] = \
            conference_id

        return self.list_participants_endpoint.call_with_http_info(**kwargs)

    def list_recordings(
        self,
         
        **kwargs
        ):
        """List Recordings  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_recordings(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            call_id (str): Show only Recordings made during the Call with this ID.. [optional]
            conference_id (str): Show only Recordings made during the conference with this ID.. [optional]
            date_created (str): Only show Recordings created on this date, formatted as *YYYY-MM-DD*.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            RecordingList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.list_recordings_endpoint.call_with_http_info(**kwargs)

    def list_sms_messages(
        self,
         
        **kwargs
        ):
        """List SMS Messages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_sms_messages(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            to (str): Only show Messages to this phone number.. [optional]
            _from (str): Only show Messages from this phone number.. [optional]
            begin_time (str): Only show Messages sent at or after this time (GMT), given as *YYYY-MM-DD hh:mm:ss*.. [optional]
            end_time (str): Only show messages sent at or before this time (GMT), given as *YYYY-MM-DD hh:mm*... [optional]
            direction (MessageDirection): Either `inbound` or `outbound`. Only show Messages that were either *sent from* or *received by* FreeClimb.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MessagesList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.list_sms_messages_endpoint.call_with_http_info(**kwargs)

    def make_a_call(
        self,
         
        **kwargs
        ):
        """Make a Call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.make_a_call(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            make_call_request (MakeCallRequest): Call details for making a call. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CallResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.make_a_call_endpoint.call_with_http_info(**kwargs)

    def remove_a_participant(
        self,
        conference_id,call_id, 
        **kwargs
        ):
        """Remove a Participant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_a_participant(conference_id, call_id, async_req=True)
        >>> result = thread.get()



        Args:


            conference_id (str): ID of the conference this participant is in.

            call_id (str): ID of the Call associated with this participant.





        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['conference_id'] = \
            conference_id

        kwargs['call_id'] = \
            call_id

        return self.remove_a_participant_endpoint.call_with_http_info(**kwargs)

    def send_an_sms_message(
        self,
        message_request, 
        **kwargs
        ):
        """Send an SMS Message  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.send_an_sms_message(message_request, async_req=True)
        >>> result = thread.get()


        Args:


            message_request (MessageRequest): Details to create a message




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            MessageResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['message_request'] = \
            message_request

        return self.send_an_sms_message_endpoint.call_with_http_info(**kwargs)

    def stream_a_recording_file(
        self,
        recording_id, 
        **kwargs
        ):
        """Stream a Recording File  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.stream_a_recording_file(recording_id, async_req=True)
        >>> result = thread.get()


        Args:


            recording_id (str): String that uniquely identifies this recording resource.




        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['recording_id'] = \
            recording_id

        return self.stream_a_recording_file_endpoint.call_with_http_info(**kwargs)

    def update_a_conference(
        self,
        conference_id, 
        **kwargs
        ):
        """Update a Conference  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_a_conference(conference_id, async_req=True)
        >>> result = thread.get()


        Args:


            conference_id (str): String that uniquely identifies this conference resource.




        Keyword Args:
            update_conference_request (UpdateConferenceRequest): Conference Details to update. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ConferenceResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['conference_id'] = \
            conference_id

        return self.update_a_conference_endpoint.call_with_http_info(**kwargs)

    def update_a_live_call(
        self,
        call_id,update_call_request, 
        **kwargs
        ):
        """Update a Live Call  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_a_live_call(call_id, update_call_request, async_req=True)
        >>> result = thread.get()



        Args:


            call_id (str): String that uniquely identifies this call resource.

            update_call_request (UpdateCallRequest): Call details to update





        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['call_id'] = \
            call_id

        kwargs['update_call_request'] = \
            update_call_request

        return self.update_a_live_call_endpoint.call_with_http_info(**kwargs)

    def update_a_participant(
        self,
        conference_id,call_id, 
        **kwargs
        ):
        """Update a Participant  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_a_participant(conference_id, call_id, async_req=True)
        >>> result = thread.get()



        Args:


            conference_id (str): ID of the conference this participant is in.

            call_id (str): ID of the Call associated with this participant.





        Keyword Args:
            update_conference_participant_request (UpdateConferenceParticipantRequest): Conference participant details to update. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ConferenceParticipantResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['conference_id'] = \
            conference_id

        kwargs['call_id'] = \
            call_id

        return self.update_a_participant_endpoint.call_with_http_info(**kwargs)

    def update_a_queue(
        self,
        queue_id, 
        **kwargs
        ):
        """Update a Queue  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_a_queue(queue_id, async_req=True)
        >>> result = thread.get()


        Args:


            queue_id (str): A string that uniquely identifies this Queue resource.




        Keyword Args:
            queue_request (QueueRequest): Queue Details to update. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            QueueResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['queue_id'] = \
            queue_id

        return self.update_a_queue_endpoint.call_with_http_info(**kwargs)

    def update_an_account(
        self,
         
        **kwargs
        ):
        """Manage an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_an_account(async_req=True)
        >>> result = thread.get()





        Keyword Args:
            account_request (AccountRequest): Account details to update. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        return self.update_an_account_endpoint.call_with_http_info(**kwargs)

    def update_an_application(
        self,
        application_id, 
        **kwargs
        ):
        """Update an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_an_application(application_id, async_req=True)
        >>> result = thread.get()


        Args:


            application_id (str): A string that uniquely identifies this application resource.




        Keyword Args:
            application_request (ApplicationRequest): Application details to update.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ApplicationResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['application_id'] = \
            application_id

        return self.update_an_application_endpoint.call_with_http_info(**kwargs)

    def update_an_incoming_number(
        self,
        phone_number_id, 
        **kwargs
        ):
        """Update an Incoming Number  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_an_incoming_number(phone_number_id, async_req=True)
        >>> result = thread.get()


        Args:


            phone_number_id (str): String that uniquely identifies this phone number resource.




        Keyword Args:
            incoming_number_request (IncomingNumberRequest): Incoming Number details to update. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            IncomingNumberResult
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['account_id'] = \
            self.account_id

        kwargs['phone_number_id'] = \
            phone_number_id

        return self.update_an_incoming_number_endpoint.call_with_http_info(**kwargs)

