# vrt_lss_fieldservice
Veeroute.LSS Field Service Engineers API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.8.168672
- Package version: 3.8.168672
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import vrt_lss_fieldservice
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import vrt_lss_fieldservice
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import vrt_lss_fieldservice
from pprint import pprint
from vrt_lss_fieldservice.api import analytics_api
from vrt_lss_fieldservice.model.analytics_task import AnalyticsTask
from vrt_lss_fieldservice.model.inline_response400 import InlineResponse400
from vrt_lss_fieldservice.model.inline_response401 import InlineResponse401
from vrt_lss_fieldservice.model.inline_response406 import InlineResponse406
from vrt_lss_fieldservice.model.inline_response415 import InlineResponse415
from vrt_lss_fieldservice.model.inline_response429 import InlineResponse429
from vrt_lss_fieldservice.model.inline_response500 import InlineResponse500
from vrt_lss_fieldservice.model.inline_response501 import InlineResponse501
from vrt_lss_fieldservice.model.inline_response502 import InlineResponse502
from vrt_lss_fieldservice.model.inline_response503 import InlineResponse503
from vrt_lss_fieldservice.model.inline_response504 import InlineResponse504
from vrt_lss_fieldservice.model.inline_response_default import InlineResponseDefault
# Defining the host is optional and defaults to https://api.veeroute.tech/v3
# See configuration.py for a list of all supported configuration parameters.
configuration = vrt_lss_fieldservice.Configuration(
    host = "https://api.veeroute.tech/v3"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): ApiKeyAuth
configuration = vrt_lss_fieldservice.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with vrt_lss_fieldservice.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = analytics_api.AnalyticsApi(api_client)
    analytics_task = AnalyticsTask(
        plan_task=PlanTask(
            orders=[
                Order(
                    key="order0001",
                    location=Location(
                        latitude=55.692789,
                        longitude=37.554554,
                        arrival_duration=15,
                        departure_duration=5,
                    ),
                    time_windows=[
                        TimeWindow(
                            _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                            to=dateutil_parser('2021-02-21T19:45:00Z'),
                        ),
                    ],
                    duration=30,
                    cost=OrderCost(
                        reward=CostReward(199.1),
                        penalty=CostPenalty(
                            start_time=dateutil_parser('2021-05-21T17:00:00Z'),
                            period=60,
                            value=1000,
                            max_value=10000,
                        ),
                    ),
                    restrictions=PerformerRestrictions(["Special"]),
                    blacklist=PerformerBlacklist(["A0"]),
                ),
            ],
            performers=[
                Performer(
                    key="performer0001",
                    start_location=Location(
                        latitude=55.692789,
                        longitude=37.554554,
                        arrival_duration=15,
                        departure_duration=5,
                    ),
                    finish_location=Location(
                        latitude=55.692789,
                        longitude=37.554554,
                        arrival_duration=15,
                        departure_duration=5,
                    ),
                    features=PerformerFeatures(["B1","Special"]),
                    transport_type=TransportType("CAR"),
                    shifts=[
                        Shift(
                            availability_time=TimeWindow(
                                _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                to=dateutil_parser('2021-02-21T19:45:00Z'),
                            ),
                            working_time=TimeWindow(
                                _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                to=dateutil_parser('2021-02-21T19:45:00Z'),
                            ),
                        ),
                    ],
                    tariff=Tariff(
                        basic=TariffPrimary(
                            cost_per_shift=1000,
                            cost_per_meter=0.1,
                            max_length=200000,
                            cost_per_minute=0.2,
                            max_time=480,
                        ),
                        extra=[
                            TariffPrimary(
                                cost_per_shift=1000,
                                cost_per_meter=0.1,
                                max_length=200000,
                                cost_per_minute=0.2,
                                max_time=480,
                            ),
                        ],
                    ),
                ),
            ],
            trips=[
                Trip(
                    key="TRIP0001",
                    trip_time=TimeWindow(
                        _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                        to=dateutil_parser('2021-02-21T19:45:00Z'),
                    ),
                    performer_key="performer01",
                    actions=[
                        TripAction(
                            order_key="order01",
                            order_time=TimeWindow(
                                _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                to=dateutil_parser('2021-02-21T19:45:00Z'),
                            ),
                            location_time=TimeWindow(
                                _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                to=dateutil_parser('2021-02-21T19:45:00Z'),
                            ),
                        ),
                    ],
                    waitlist=["order02"],
                ),
            ],
            settings=PlanSettings(
                configuration="optimize_distance",
                planning_time=30,
                result_ttl=10,
                result_timezone=3,
                predict_slots=2,
                transport_factor=[
                    TransportFactor(
                        transport_type=TransportType("CAR"),
                        speed=2.5,
                    ),
                ],
                capacity_factor=[
                    CapacityFactor(
                        transport_type=TransportType("CAR"),
                        capacity=Capacity(
                            mass=10,
                            volume=2,
                            capacity_x=1,
                            capacity_y=2,
                            capacity_z=3,
                        ),
                    ),
                ],
                routing=[
                    Routing(
                        transport_type=TransportType("CAR"),
                        matrix=RoutingMatrix(
                            waypoints=[
                                Waypoint(
                                    name="central",
                                    latitude=55.692789,
                                    longitude=37.554554,
                                    duration=15,
                                ),
                            ],
                            distances=[
                                MatrixLine([
                                    -1,
                                ]),
                            ],
                            durations=[
                                MatrixLine(MatrixLine),
                            ],
                        ),
                        traffic_jams=[
                            TrafficFactor(
                                time_window=TimeWindow(
                                    _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                    to=dateutil_parser('2021-02-21T19:45:00Z'),
                                ),
                                length_multiplier=2,
                                length_additive=20,
                                time_multiplier=2,
                                time_additive=30,
                            ),
                        ],
                    ),
                ],
                assumptions=PlanAssumptions(
                    traffic_jams=False,
                    toll_roads=False,
                    ferry_crossing=False,
                    flight_distance=True,
                    disable_compatibility=True,
                    disable_capacity=True,
                    same_order_time_window=True,
                    expand_shift_time_window=True,
                ),
                precision=3,
            ),
        ),
        plan_result=PlanResult(
            tracedata=TraceData(
                code="client_server_service_time_uuid",
                client="client_name",
                server="server_name",
                service="LASTMILE",
                method="PLAN",
                time=dateutil_parser('2021-02-21T09:30:00+03:00'),
            ),
            trips=[
                Trip(
                    key="TRIP0001",
                    trip_time=TimeWindow(
                        _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                        to=dateutil_parser('2021-02-21T19:45:00Z'),
                    ),
                    performer_key="performer01",
                    actions=[],
                    waitlist=["order02"],
                ),
            ],
            statistics=PlanStatistics(
                total_statistics=Statistics(
                    cost=1231.1,
                    reward=2343.3,
                    measurements=Measurements(
                        driving_time=15,
                        waiting_time=5,
                        working_time=50,
                        arriving_time=30,
                        departure_time=20,
                        total_time=120,
                        distance=5200,
                        time_window=TimeWindow(
                            _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                            to=dateutil_parser('2021-02-21T19:45:00Z'),
                        ),
                    ),
                    orders_count=1700,
                    plan_orders_count=1000,
                    waitlist_orders_count=700,
                    performers_count=257,
                    capacity_utilization=Capacity(
                        mass=10,
                        volume=2,
                        capacity_x=1,
                        capacity_y=2,
                        capacity_z=3,
                    ),
                    capacity_max=Capacity(
                        mass=10,
                        volume=2,
                        capacity_x=1,
                        capacity_y=2,
                        capacity_z=3,
                    ),
                    quality=QualityStatistics(
                        soft_time_window_violations=TimeWindowViolation(
                            before=ObjectsMetrics(
                                keys=["obj1"],
                                count=1700,
                            ),
                            after=ObjectsMetrics(
                                keys=["obj1"],
                                count=1700,
                            ),
                        ),
                        hard_time_window_violations=TimeWindowViolation(
                            before=ObjectsMetrics(
                                keys=["obj1"],
                                count=1700,
                            ),
                            after=ObjectsMetrics(
                                keys=["obj1"],
                                count=1700,
                            ),
                        ),
                    ),
                ),
                trips_statistics=[
                    TripStatistics(
                        trip_key="trip01",
                        statistics=Statistics(
                            cost=1231.1,
                            reward=2343.3,
                            measurements=Measurements(
                                driving_time=15,
                                waiting_time=5,
                                working_time=50,
                                arriving_time=30,
                                departure_time=20,
                                total_time=120,
                                distance=5200,
                                time_window=TimeWindow(
                                    _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                    to=dateutil_parser('2021-02-21T19:45:00Z'),
                                ),
                            ),
                            orders_count=1700,
                            plan_orders_count=1000,
                            waitlist_orders_count=700,
                            performers_count=257,
                            capacity_utilization=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                            capacity_max=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                            quality=QualityStatistics(
                                soft_time_window_violations=TimeWindowViolation(
                                    before=ObjectsMetrics(
                                        keys=["obj1"],
                                        count=1700,
                                    ),
                                    after=ObjectsMetrics(
                                        keys=["obj1"],
                                        count=1700,
                                    ),
                                ),
                                hard_time_window_violations=TimeWindowViolation(
                                    before=ObjectsMetrics(
                                        keys=["obj1"],
                                        count=1700,
                                    ),
                                    after=ObjectsMetrics(
                                        keys=["obj1"],
                                        count=1700,
                                    ),
                                ),
                            ),
                        ),
                        stop_statistics=[
                            StopStatistics(
                                location=Location(
                                    latitude=55.692789,
                                    longitude=37.554554,
                                    arrival_duration=15,
                                    departure_duration=5,
                                ),
                                location_key="location01",
                                demand_ids=[
                                    "demand01",
                                ],
                                measurements=Measurements(
                                    driving_time=15,
                                    waiting_time=5,
                                    working_time=50,
                                    arriving_time=30,
                                    departure_time=20,
                                    total_time=120,
                                    distance=5200,
                                    time_window=TimeWindow(
                                        _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                        to=dateutil_parser('2021-02-21T19:45:00Z'),
                                    ),
                                ),
                                upload=TransportLoad(
                                    count=460,
                                    capacity=Capacity(
                                        mass=10,
                                        volume=2,
                                        capacity_x=1,
                                        capacity_y=2,
                                        capacity_z=3,
                                    ),
                                ),
                                download=TransportLoad(
                                    count=460,
                                    capacity=Capacity(
                                        mass=10,
                                        volume=2,
                                        capacity_x=1,
                                        capacity_y=2,
                                        capacity_z=3,
                                    ),
                                ),
                                current_load=TransportLoad(
                                    count=460,
                                    capacity=Capacity(
                                        mass=10,
                                        volume=2,
                                        capacity_x=1,
                                        capacity_y=2,
                                        capacity_z=3,
                                    ),
                                ),
                            ),
                        ],
                        total_load=TransportLoad(
                            count=460,
                            capacity=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                        ),
                        max_load=TransportLoad(
                            count=460,
                            capacity=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                        ),
                    ),
                ],
            ),
            validations=[
                Validation(
                    type="info",
                    entity_key="ord0001",
                    entity_type="order",
                    info="bad time windows",
                ),
            ],
            unplanned_orders=[
                UnplannedOrder(
                    order=Order(
                        key="order0001",
                        location=Location(
                            latitude=55.692789,
                            longitude=37.554554,
                            arrival_duration=15,
                            departure_duration=5,
                        ),
                        time_windows=[],
                        duration=30,
                        cost=OrderCost(
                            reward=CostReward(199.1),
                            penalty=CostPenalty(
                                start_time=dateutil_parser('2021-05-21T17:00:00Z'),
                                period=60,
                                value=1000,
                                max_value=10000,
                            ),
                        ),
                        restrictions=PerformerRestrictions(["Special"]),
                        blacklist=PerformerBlacklist(["A0"]),
                    ),
                    reason="undefined",
                ),
            ],
            progress=50,
            info=PlanInfo(
                status=PlanStatus("FINISHED_IN_TIME"),
                result_version=13,
                planning_time=10,
                waiting_time=5,
            ),
        ),
    ) # AnalyticsTask | Request for analytics.

    try:
        # Planning result analytics.
        api_response = api_instance.analytics(analytics_task)
        pprint(api_response)
    except vrt_lss_fieldservice.ApiException as e:
        print("Exception when calling AnalyticsApi->analytics: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.veeroute.tech/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnalyticsApi* | [**analytics**](docs/AnalyticsApi.md#analytics) | **POST** /fieldservice/analytics/xlsx | Planning result analytics.
*ConvertApi* | [**convert_to_json**](docs/ConvertApi.md#convert_to_json) | **POST** /fieldservice/convert/json | Conversion of planning task and result.
*ConvertApi* | [**convert_to_xlsx**](docs/ConvertApi.md#convert_to_xlsx) | **POST** /fieldservice/convert/xlsx | Conversion of planning task and result.
*PlanApi* | [**delete_result**](docs/PlanApi.md#delete_result) | **DELETE** /fieldservice/result/{id} | Planning result removal.
*PlanApi* | [**get_result**](docs/PlanApi.md#get_result) | **GET** /fieldservice/result/{id} | Getting the planning result.
*PlanApi* | [**plan**](docs/PlanApi.md#plan) | **POST** /fieldservice/plan | Planning, synchronous call.
*PlanApi* | [**run_plan**](docs/PlanApi.md#run_plan) | **POST** /fieldservice/run_plan | Launching the planning process.
*PredictApi* | [**predict**](docs/PredictApi.md#predict) | **POST** /fieldservice/predict | Time window prediction.
*SystemApi* | [**check**](docs/SystemApi.md#check) | **GET** /fieldservice/check | Checking the service availability.
*SystemApi* | [**version**](docs/SystemApi.md#version) | **GET** /fieldservice/version | Getting the service version.
*ValidateApi* | [**validate**](docs/ValidateApi.md#validate) | **POST** /fieldservice/validate | Data validation for planning.


## Documentation For Models

 - [AnalyticsTask](docs/AnalyticsTask.md)
 - [CalculationDetail](docs/CalculationDetail.md)
 - [Capacity](docs/Capacity.md)
 - [CapacityFactor](docs/CapacityFactor.md)
 - [CheckResult](docs/CheckResult.md)
 - [ConvertSettings](docs/ConvertSettings.md)
 - [ConvertTask](docs/ConvertTask.md)
 - [CostPenalty](docs/CostPenalty.md)
 - [CostReward](docs/CostReward.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse401](docs/InlineResponse401.md)
 - [InlineResponse404](docs/InlineResponse404.md)
 - [InlineResponse406](docs/InlineResponse406.md)
 - [InlineResponse415](docs/InlineResponse415.md)
 - [InlineResponse429](docs/InlineResponse429.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [InlineResponse501](docs/InlineResponse501.md)
 - [InlineResponse502](docs/InlineResponse502.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InlineResponse504](docs/InlineResponse504.md)
 - [InlineResponseDefault](docs/InlineResponseDefault.md)
 - [Location](docs/Location.md)
 - [MatrixLine](docs/MatrixLine.md)
 - [Measurements](docs/Measurements.md)
 - [ObjectsMetrics](docs/ObjectsMetrics.md)
 - [Order](docs/Order.md)
 - [OrderCost](docs/OrderCost.md)
 - [Performer](docs/Performer.md)
 - [PerformerBlacklist](docs/PerformerBlacklist.md)
 - [PerformerFeatures](docs/PerformerFeatures.md)
 - [PerformerRestrictions](docs/PerformerRestrictions.md)
 - [PlanAssumptions](docs/PlanAssumptions.md)
 - [PlanId](docs/PlanId.md)
 - [PlanInfo](docs/PlanInfo.md)
 - [PlanResult](docs/PlanResult.md)
 - [PlanSettings](docs/PlanSettings.md)
 - [PlanStatistics](docs/PlanStatistics.md)
 - [PlanStatus](docs/PlanStatus.md)
 - [PlanTask](docs/PlanTask.md)
 - [PredictResult](docs/PredictResult.md)
 - [PredictResultWindow](docs/PredictResultWindow.md)
 - [PredictTask](docs/PredictTask.md)
 - [QualityStatistics](docs/QualityStatistics.md)
 - [Routing](docs/Routing.md)
 - [RoutingMatrix](docs/RoutingMatrix.md)
 - [Shift](docs/Shift.md)
 - [Statistics](docs/Statistics.md)
 - [StopStatistics](docs/StopStatistics.md)
 - [Tariff](docs/Tariff.md)
 - [TariffPrimary](docs/TariffPrimary.md)
 - [TimeWindow](docs/TimeWindow.md)
 - [TimeWindowViolation](docs/TimeWindowViolation.md)
 - [TraceData](docs/TraceData.md)
 - [TrafficFactor](docs/TrafficFactor.md)
 - [TransportFactor](docs/TransportFactor.md)
 - [TransportLoad](docs/TransportLoad.md)
 - [TransportType](docs/TransportType.md)
 - [Trip](docs/Trip.md)
 - [TripAction](docs/TripAction.md)
 - [TripStatistics](docs/TripStatistics.md)
 - [UnplannedOrder](docs/UnplannedOrder.md)
 - [ValidateResult](docs/ValidateResult.md)
 - [Validation](docs/Validation.md)
 - [VersionResult](docs/VersionResult.md)
 - [Waypoint](docs/Waypoint.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: Bearer authentication (JWT)


## Author

support@veeroute.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in vrt_lss_fieldservice.apis and vrt_lss_fieldservice.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from vrt_lss_fieldservice.api.default_api import DefaultApi`
- `from vrt_lss_fieldservice.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import vrt_lss_fieldservice
from vrt_lss_fieldservice.apis import *
from vrt_lss_fieldservice.models import *
```

