"""
    Veeroute.LSS Field Service Engineers

    Veeroute.LSS Field Service Engineers API  # noqa: E501

    The version of the OpenAPI document: 3.8.168672
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_fieldservice.api_client import ApiClient, Endpoint as _Endpoint
from vrt_lss_fieldservice.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from vrt_lss_fieldservice.model.calculation_detail import CalculationDetail
from vrt_lss_fieldservice.model.inline_response400 import InlineResponse400
from vrt_lss_fieldservice.model.inline_response401 import InlineResponse401
from vrt_lss_fieldservice.model.inline_response404 import InlineResponse404
from vrt_lss_fieldservice.model.inline_response415 import InlineResponse415
from vrt_lss_fieldservice.model.inline_response429 import InlineResponse429
from vrt_lss_fieldservice.model.inline_response500 import InlineResponse500
from vrt_lss_fieldservice.model.inline_response501 import InlineResponse501
from vrt_lss_fieldservice.model.inline_response502 import InlineResponse502
from vrt_lss_fieldservice.model.inline_response503 import InlineResponse503
from vrt_lss_fieldservice.model.inline_response504 import InlineResponse504
from vrt_lss_fieldservice.model.inline_response_default import InlineResponseDefault
from vrt_lss_fieldservice.model.plan_id import PlanId
from vrt_lss_fieldservice.model.plan_result import PlanResult
from vrt_lss_fieldservice.model.plan_task import PlanTask


class PlanApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __delete_result(
            self,
            id,
            **kwargs
        ):
            """Planning result removal.  # noqa: E501

            Planning result removal by the calculation ID.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_result(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Calculation ID.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.delete_result = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/fieldservice/result/{id}',
                'operation_id': 'delete_result',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_result
        )

        def __get_result(
            self,
            id,
            **kwargs
        ):
            """Getting the planning result.  # noqa: E501

            Getting the planning result based on the calculation ID.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_result(id, async_req=True)
            >>> result = thread.get()

            Args:
                id (str): Calculation ID.

            Keyword Args:
                detail (CalculationDetail): Response details level.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PlanResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['id'] = \
                id
            return self.call_with_http_info(**kwargs)

        self.get_result = _Endpoint(
            settings={
                'response_type': (PlanResult,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/fieldservice/result/{id}',
                'operation_id': 'get_result',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'detail',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'detail':
                        (CalculationDetail,),
                },
                'attribute_map': {
                    'id': 'id',
                    'detail': 'detail',
                },
                'location_map': {
                    'id': 'path',
                    'detail': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_result
        )

        def __plan(
            self,
            plan_task,
            **kwargs
        ):
            """Planning, synchronous call.  # noqa: E501

            Planning trips for field engineers.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.plan(plan_task, async_req=True)
            >>> result = thread.get()

            Args:
                plan_task (PlanTask): New planning request.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PlanResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['plan_task'] = \
                plan_task
            return self.call_with_http_info(**kwargs)

        self.plan = _Endpoint(
            settings={
                'response_type': (PlanResult,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/fieldservice/plan',
                'operation_id': 'plan',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'plan_task',
                ],
                'required': [
                    'plan_task',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'plan_task':
                        (PlanTask,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'plan_task': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__plan
        )

        def __run_plan(
            self,
            plan_task,
            **kwargs
        ):
            """Launching the planning process.  # noqa: E501

            Planning trips for field engineers.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.run_plan(plan_task, async_req=True)
            >>> result = thread.get()

            Args:
                plan_task (PlanTask): Launching the asynchronous planning.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PlanId
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['plan_task'] = \
                plan_task
            return self.call_with_http_info(**kwargs)

        self.run_plan = _Endpoint(
            settings={
                'response_type': (PlanId,),
                'auth': [
                    'ApiKeyAuth'
                ],
                'endpoint_path': '/fieldservice/run_plan',
                'operation_id': 'run_plan',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'plan_task',
                ],
                'required': [
                    'plan_task',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'plan_task':
                        (PlanTask,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'plan_task': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__run_plan
        )
