"""
    Veeroute.LSS Field Service Engineers

    Veeroute.LSS Field Service Engineers API  # noqa: E501

    The version of the OpenAPI document: 3.8.168672
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_fieldservice.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from vrt_lss_fieldservice.model.capacity_factor import CapacityFactor
    from vrt_lss_fieldservice.model.plan_assumptions import PlanAssumptions
    from vrt_lss_fieldservice.model.routing import Routing
    from vrt_lss_fieldservice.model.transport_factor import TransportFactor
    globals()['CapacityFactor'] = CapacityFactor
    globals()['PlanAssumptions'] = PlanAssumptions
    globals()['Routing'] = Routing
    globals()['TransportFactor'] = TransportFactor


class PlanSettings(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('configuration',): {
            'max_length': 1000,
            'min_length': 1,
        },
        ('planning_time',): {
            'inclusive_maximum': 2880,
            'inclusive_minimum': 1,
        },
        ('result_ttl',): {
            'inclusive_maximum': 14400,
            'inclusive_minimum': 1,
        },
        ('result_timezone',): {
            'inclusive_maximum': 12,
            'inclusive_minimum': -12,
        },
        ('predict_slots',): {
            'inclusive_maximum': 8,
            'inclusive_minimum': 0,
        },
        ('transport_factor',): {
            'max_items': 7,
            'min_items': 0,
        },
        ('capacity_factor',): {
            'max_items': 7,
            'min_items': 0,
        },
        ('routing',): {
            'max_items': 7,
            'min_items': 0,
        },
        ('precision',): {
            'inclusive_maximum': 6,
            'inclusive_minimum': 0,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'configuration': (str,),  # noqa: E501
            'planning_time': (int,),  # noqa: E501
            'result_ttl': (int,),  # noqa: E501
            'result_timezone': (int,),  # noqa: E501
            'predict_slots': (int,),  # noqa: E501
            'transport_factor': ([TransportFactor],),  # noqa: E501
            'capacity_factor': ([CapacityFactor],),  # noqa: E501
            'routing': ([Routing],),  # noqa: E501
            'assumptions': (PlanAssumptions,),  # noqa: E501
            'precision': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'configuration': 'configuration',  # noqa: E501
        'planning_time': 'planning_time',  # noqa: E501
        'result_ttl': 'result_ttl',  # noqa: E501
        'result_timezone': 'result_timezone',  # noqa: E501
        'predict_slots': 'predict_slots',  # noqa: E501
        'transport_factor': 'transport_factor',  # noqa: E501
        'capacity_factor': 'capacity_factor',  # noqa: E501
        'routing': 'routing',  # noqa: E501
        'assumptions': 'assumptions',  # noqa: E501
        'precision': 'precision',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """PlanSettings - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            configuration (str): Name of the planning configuration. The configuration determines the result goal and quality. [List of available](https://docs.veeroute.com/#/lss/scenarios?id=planning-configuration) planning configurations. . [optional] if omitted the server will use the default value of "default"  # noqa: E501
            planning_time (int): Planning time in minutes. The countdown starts from the time when data is uploaded to the server and planning starts. . [optional] if omitted the server will use the default value of 20  # noqa: E501
            result_ttl (int): Planning result lifetime, in minutes. The countdown starts from the time when the planning is completed. . [optional] if omitted the server will use the default value of 20  # noqa: E501
            result_timezone (int): The time zone where the planning result is returned. . [optional] if omitted the server will use the default value of 0  # noqa: E501
            predict_slots (int): The number of slots for data preparation to predict time windows. If the value equals zero, the data to predict time windows is not prepared. Learn more about the [time window tip script](https://docs.veeroute.com/#/lss/scenarios?id=predict-time-windows). . [optional] if omitted the server will use the default value of 0  # noqa: E501
            transport_factor ([TransportFactor]): Vehicle speed change coefficients.. [optional] if omitted the server will use the default value of []  # noqa: E501
            capacity_factor ([CapacityFactor]): Vehicle capacity change coefficients.. [optional] if omitted the server will use the default value of []  # noqa: E501
            routing ([Routing]): Time and distance matrices list for each vehicle type. By specifying an external routing matrix, parameters `flight_distance`, `traffic_jams`, `transport_factor` are not taken into account. . [optional] if omitted the server will use the default value of []  # noqa: E501
            assumptions (PlanAssumptions): [optional]  # noqa: E501
            precision (int): Specifies the calculation accuracy in the decimal point sequence number. It equals 2 by default, so the accuracy is 0.01. . [optional] if omitted the server will use the default value of 2  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
