/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.calc.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cmayes.hartree.calc.Calculation;
import org.cmayes.hartree.model.BaseResult;
import org.cmayes.hartree.model.def.DefaultThermalResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThermalCalculation
implements Calculation {
    private static final double SCALE_RATIO = 1.0;
    private static final double SCALED_GAS_KCAL = 0.0019872156;
    private static final List<Double> TEMPS = Arrays.asList(298.15, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0, 1100.0, 1200.0, 1300.0, 1400.0, 1500.0, 6000.0, 773.15);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private double zpe = 0.9657;
    private double ssf = 0.945;
    private double hsf = 0.944;

    @Override
    public Object calculate(Object calcResult) {
        ArrayList<DefaultThermalResult> results = new ArrayList<DefaultThermalResult>();
        SymAdj symAdj = this.evalSym((BaseResult)calcResult);
        for (Double curTemp : TEMPS) {
            double entropyTemp = this.scaleEntropyTemp((BaseResult)calcResult, symAdj, curTemp);
            double heatCap = this.scaleHeatCap(symAdj);
            double enthalpy = this.scaleEnthalpyTemp(symAdj, curTemp);
            double zpeVal = 0.0;
            for (double curFreq : ((BaseResult)calcResult).getFrequencyValues()) {
                if (curFreq < 0.0) {
                    this.logger.debug("Skipping negative frequency " + curFreq);
                    continue;
                }
                entropyTemp += 0.0019872156 * (6.626068E-34 * curFreq * this.ssf * 2.99792458E10 / 1.3806503E-23 / curTemp / (Math.exp(6.626068E-34) - 1.0) - Math.log(1.0 - Math.exp(-(6.626068E-34 * curFreq * this.ssf * 2.99792458E10 / 1.3806503E-23) / curTemp)));
                heatCap += 0.0019872156 * Math.pow(Math.exp(-(6.626068E-34 * curFreq * this.ssf * 2.99792458E10 / 1.3806503E-23) / curTemp) - 1.0, 2.0);
                enthalpy += 0.0019872156 * (6.626068E-34 * curFreq * this.hsf * 2.99792458E10 / 1.3806503E-23) * (0.0 + 1.0 / (Math.exp(6.626068E-34 * curFreq * this.hsf * 2.99792458E10 / 1.3806503E-23 / curTemp) - 1.0));
                zpeVal += 3.313034E-34 * curFreq * 2.99792458E10 * 6.0221415E23 / 4.184 / 1000.0 / 627.509469 * this.zpe;
            }
            DefaultThermalResult curResult = new DefaultThermalResult(curTemp);
            curResult.setEnthalpy(zpeVal + ((BaseResult)calcResult).getElecEn() + (0.0019872156 * curTemp + enthalpy));
            curResult.setEntropy(entropyTemp * 1000.0);
            curResult.setHeatCapacity((0.0019872156 + heatCap) * 1000.0);
            results.add(curResult);
        }
        return null;
    }

    private Double scaleEnthalpyTemp(SymAdj symAdj, Double curTemp) {
        double scaledVal = 0.0019872156 * curTemp;
        return scaledVal += 0.0019872156 * curTemp + symAdj.getSceAdj() * curTemp;
    }

    private Double scaleHeatCap(SymAdj symAdj) {
        return 0.0039744312 + symAdj.getSceAdj();
    }

    private double scaleTransPart(double transPart, double tempK) {
        return transPart * Math.pow(tempK / 298.15, 2.0);
    }

    private double scaleRotPart(BaseResult result, SymAdj symAdj, double tempK) {
        return result.getRotPart() * Math.pow(tempK / 298.15, symAdj.getFlagAdj());
    }

    private double scaleEntropyTemp(BaseResult result, SymAdj symAdj, double tempK) {
        double scaledVal = 0.0019872156 * (Math.log(this.scaleTransPart(result.getTransPart(), tempK)) + 1.0 + 1.0);
        scaledVal += 0.0019872156 * Math.log(result.getMult().intValue());
        return scaledVal += 0.0019872156 * (Math.log(this.scaleRotPart(result, symAdj, tempK)) + 1.0) + symAdj.getSceAdj();
    }

    private SymAdj evalSym(BaseResult result) {
        if (result.isSymmetricTop() && Integer.valueOf(2).equals(result.getAtomCount())) {
            return new SymAdj(1.0, -9.936078E-4);
        }
        return new SymAdj(1.5, 0.0);
    }

    private static class SymAdj {
        private final double flagAdj;
        private final double sceAdj;

        public SymAdj(double flag, double sce) {
            this.flagAdj = flag;
            this.sceAdj = sce;
        }

        public double getFlagAdj() {
            return this.flagAdj;
        }

        public double getSceAdj() {
            return this.sceAdj;
        }
    }
}

