/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.disp.csv;

import au.com.bytecode.opencsv.CSVWriter;
import com.cmayes.common.MediaType;
import com.cmayes.common.exception.EnvironmentException;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cmayes.hartree.disp.Display;
import org.cmayes.hartree.model.BaseResult;
import org.cmayes.hartree.model.def.CremerPopleCoordinates;
import org.cmayes.hartree.model.def.CremerPopleResult;

public class SnapshotCsvDisplay
implements Display<BaseResult> {
    private static final String MISSING = "N/A";
    private String[] headerRow;
    private final String[] defaultHeaderRow = new String[]{"File Name", "Solvent type", "Stoichiometry", "Charge", "Mult", "Functional", "Basis Set", "Energy (A.U.)", "dipole", "ZPE (Hartrees)", "H298 (Hartrees)", "G298 (Hartrees)", "Freq 1", "Freq 2", "BSSE (Hartrees)"};
    private final String[] cpHeaderRow = new String[]{"File Name", "Solvent type", "Stoichiometry", "Charge", "Mult", "Functional", "Basis Set", "Energy (A.U.)", "dipole", "ZPE (Hartrees)", "H298 (Hartrees)", "G298 (Hartrees)", "BSSE (Hartrees)", "Freq 1", "Freq 2", "phi", "theta", "Q", "Pucker", "HM1 (deg)", "HM2 (deg)", "AC1 (deg)", "AC2 (deg)", "Ano1 (deg)", "Ano2 (deg)", "R1 (A)", "R2 (A)", "R3 (A)", "R4 (A)", "R5 (A)", "R6 (A)", "O1 (A)", "O2 (A)", "O3 (A)", "O4 (A)", "O6 (A)", "Ion1 (A)", "Ion2 (A)", "Ion3 (A)", "Ion4 (A)", "Ion5 (A)", "Ion6 (A)"};
    private boolean first = true;
    private volatile boolean writeMulti = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer writer, BaseResult valToDisp) {
        CSVWriter csvWriter = new CSVWriter(writer);
        try {
            if (this.first) {
                csvWriter.writeNext(this.getHeaderRow(valToDisp));
                this.first = false;
            }
            String charge = this.valOrMissing(valToDisp.getCharge());
            String mult = this.valOrMissing(valToDisp.getMult());
            String energy = this.valOrMissing(valToDisp.getElecEn());
            List<Double> freq = valToDisp.getFrequencyValues();
            String firstFreq = freq == null || freq.isEmpty() ? MISSING : this.valOrMissing(freq.get(0));
            String secFreq = freq == null || freq.size() < 2 ? MISSING : this.valOrMissing(freq.get(1));
            String solv = this.valOrMissing(valToDisp.getSolvent());
            String zpe = this.valOrMissing(valToDisp.getZpeCorrection());
            String stoi = this.valOrMissing(valToDisp.getStoichiometry());
            String dip = this.valOrMissing(valToDisp.getDipoleMomentTotal());
            String fname = this.valOrMissing(valToDisp.getSourceName());
            String func = this.valOrMissing(valToDisp.getFunctional());
            String basisSet = this.valOrMissing(valToDisp.getBasisSet());
            String h298 = this.valOrMissing(valToDisp.getEnthalpy298());
            String g298 = this.valOrMissing(valToDisp.getGibbs298());
            String bsse = this.valOrMissing(valToDisp.getBsse());
            if (valToDisp instanceof CremerPopleResult) {
                CremerPopleResult cpResult = (CremerPopleResult)((Object)valToDisp);
                CremerPopleCoordinates cpCoords = cpResult.getCpCoords();
                if (cpCoords == null) {
                    csvWriter.writeNext(new String[]{fname, solv, stoi, charge, mult, func, basisSet, energy, dip, zpe, h298, g298, bsse, firstFreq, secFreq, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING, MISSING});
                } else {
                    String phi = this.valOrMissing(cpCoords.getPhi());
                    String theta = this.valOrMissing(cpCoords.getTheta());
                    String q = this.valOrMissing(cpCoords.getQ());
                    String pucker = this.valOrMissing(cpCoords.getPucker());
                    String hm1 = this.valOrMissing(cpResult.getHmArmAngle1());
                    String hm2 = this.valOrMissing(cpResult.getHmArmAngle2());
                    String ac1 = this.valOrMissing(cpResult.getAcArmAngle1());
                    String ac2 = this.valOrMissing(cpResult.getAcArmAngle2());
                    String third1 = this.valOrMissing(cpResult.getAnoAngle1());
                    String third2 = this.valOrMissing(cpResult.getAnoAngle2());
                    String[] baseLine = new String[]{fname, solv, stoi, charge, mult, func, basisSet, energy, dip, zpe, h298, g298, bsse, firstFreq, secFreq, phi, theta, q, pucker, hm1, hm2, ac1, ac2, third1, third2};
                    String[] withCarbs = ObjectArrays.concat(baseLine, this.valListOrMissing(cpResult.getCarbonDistances(), 6), String.class);
                    String[] withOxys = ObjectArrays.concat(withCarbs, this.valListOrMissing(cpResult.getOxygenDistances(), 5), String.class);
                    String[] withIons = ObjectArrays.concat(withOxys, this.valListOrMissing(cpResult.getIonDistances(), 6), String.class);
                    csvWriter.writeNext(withIons);
                }
            } else {
                csvWriter.writeNext(new String[]{fname, solv, stoi, charge, mult, func, basisSet, energy, dip, zpe, h298, g298, firstFreq, secFreq, bsse});
            }
        }
        finally {
            try {
                csvWriter.flush();
            }
            catch (IOException e) {
                throw new EnvironmentException("Problems writing CSV to writer", (Throwable)e, new Object[0]);
            }
        }
    }

    private String[] valListOrMissing(Collection<?> valCol, int expectedSize) {
        Object[] arrayList = new String[expectedSize];
        Arrays.fill(arrayList, MISSING);
        if (valCol == null) {
            return arrayList;
        }
        int i = 0;
        for (Object val : Iterables.limit(valCol, expectedSize)) {
            arrayList[i] = this.valOrMissing(val);
            ++i;
        }
        return arrayList;
    }

    private String valOrMissing(Object val) {
        if (val == null || val.toString().isEmpty()) {
            return MISSING;
        }
        return val.toString();
    }

    @Override
    public MediaType getMediaType() {
        return MediaType.CSV;
    }

    public String[] getHeaderRow() {
        return this.headerRow;
    }

    public String[] getHeaderRow(BaseResult res) {
        if (this.headerRow != null) {
            return this.headerRow;
        }
        if (res instanceof CremerPopleResult) {
            return this.cpHeaderRow;
        }
        return this.defaultHeaderRow;
    }

    public void setHeaderRow(String[] row) {
        this.headerRow = row;
    }

    boolean isFirst() {
        return this.first;
    }

    @Override
    public void finish(Writer writer) {
        this.first = true;
    }

    @Override
    public boolean isWriteMulti() {
        return this.writeMulti;
    }

    @Override
    public void setWriteMulti(boolean wMulti) {
        this.writeMulti = wMulti;
    }
}

