/*
 * Decompiled with CFR 0.152.
 */
package org.cmayes.hartree.loader.gaussian;

import com.cmayes.common.exception.EnvironmentException;
import com.cmayes.common.model.impl.DefaultAtom;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.cmayes.hartree.loader.Loader;
import org.cmayes.hartree.loader.ParseException;
import org.cmayes.hartree.loader.gaussian.BaseGaussianLoader;
import org.cmayes.hartree.model.BaseResult;
import org.cmayes.hartree.model.def.DefaultBaseResult;
import org.cmayes.hartree.parser.gaussian.antlr.CalcResultParser;
import org.cmayes.hartree.parser.gaussian.antlr.GaussianLexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalcResultLoader
extends BaseGaussianLoader
implements Loader<BaseResult> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public BaseResult load(String srcName, Reader reader) {
        return this.extractCalcThermData(srcName, this.extractAst(srcName, reader));
    }

    private BaseResult extractCalcThermData(String srcName, CommonTree ast) {
        DefaultBaseResult result = new DefaultBaseResult(srcName);
        int atomColCount = 0;
        DefaultAtom curAtom = new DefaultAtom();
        List<? extends Object> eventList = ast.getChildren();
        if (eventList == null) {
            this.logger.error("Parse failed: no AST children found for source " + srcName);
            return result;
        }
        block13: for (CommonTree commonTree : eventList) {
            switch (commonTree.getType()) {
                case -1: {
                    continue block13;
                }
                case 13: {
                    result.getCpuTimes().add(this.processCpuTime(commonTree));
                    continue block13;
                }
                case 37: {
                    result.getTerminationDates().add(this.processTermDate(commonTree));
                    continue block13;
                }
                case 42: {
                    result.setTransPart(this.toDouble(commonTree.getText()));
                    continue block13;
                }
                case 34: {
                    result.setRotPart(this.toDouble(commonTree.getText()));
                    continue block13;
                }
                case 21: {
                    result.setMult(this.toInt(commonTree.getText()));
                    continue block13;
                }
                case 24: {
                    result.setAtomCount(this.toInt(commonTree.getText()));
                    continue block13;
                }
                case 18: {
                    Double freqVal = this.toDouble(commonTree.getText());
                    if (freqVal == null) continue block13;
                    result.getFrequencyValues().add(freqVal);
                    continue block13;
                }
                case 15: {
                    result.setElecEn(this.toDouble(commonTree.getText()));
                    continue block13;
                }
                case 5: {
                    result.setSymmetricTop(false);
                    continue block13;
                }
                case 48: 
                case 49: {
                    this.handleAtom(commonTree.getText(), curAtom, atomColCount);
                    if (++atomColCount % 6 != 0) continue block13;
                    result.addAtom(curAtom);
                    curAtom = new DefaultAtom();
                    continue block13;
                }
            }
            this.logger.warn(String.format("Unhandled data %s %s", commonTree.getType(), commonTree.getText()));
        }
        return result;
    }

    protected CommonTree extractAst(String srcName, Reader reader) {
        try {
            GaussianLexer lexer = new GaussianLexer(new ANTLRReaderStream(reader));
            CalcResultParser parser = new CalcResultParser(new CommonTokenStream(lexer));
            return (CommonTree)parser.script().getTree();
        }
        catch (IOException e) {
            throw new EnvironmentException("Problems reading from " + srcName, (Throwable)e, new Object[0]);
        }
        catch (RecognitionException e) {
            throw new ParseException("Problems parsing data from " + srcName, e);
        }
    }
}

