# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.3, generator: @autorest/python@5.16.0)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._affinda_api_operations import (
    build_create_index_document_request,
    build_create_index_request,
    build_create_invoice_request,
    build_create_job_description_request,
    build_create_job_description_search_embed_url_request,
    build_create_job_description_search_request,
    build_create_redacted_resume_request,
    build_create_resume_request,
    build_create_resume_search_embed_url_request,
    build_create_resume_search_request,
    build_create_user_request,
    build_delete_index_document_request,
    build_delete_index_request,
    build_delete_invoice_request,
    build_delete_job_description_request,
    build_delete_redacted_resume_request,
    build_delete_resume_request,
    build_get_all_index_documents_request,
    build_get_all_indexes_request,
    build_get_all_invoices_request,
    build_get_all_job_descriptions_request,
    build_get_all_redacted_resumes_request,
    build_get_all_resumes_request,
    build_get_all_users_request,
    build_get_invoice_request,
    build_get_job_description_request,
    build_get_job_description_search_config_request,
    build_get_job_description_search_detail_request,
    build_get_redacted_resume_request,
    build_get_resume_request,
    build_get_resume_search_config_request,
    build_get_resume_search_detail_request,
    build_get_resume_search_match_request,
    build_get_resume_search_suggestion_job_title_request,
    build_get_resume_search_suggestion_skill_request,
    build_list_occupation_groups_request,
    build_update_job_description_search_config_request,
    build_update_resume_data_request,
    build_update_resume_search_config_request,
)

T = TypeVar("T")
ClsType = Optional[
    Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]
]


class AffindaAPIOperationsMixin:  # pylint: disable=too-many-public-methods
    async def get_all_resumes(
        self, offset: Optional[int] = None, limit: Optional[int] = 300, **kwargs: Any
    ) -> Union[_models.GetAllDocumentsResults, _models.RequestError]:
        """Get list of all resumes.

        Returns all the resume summaries for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.GetAllDocumentsResults, _models.RequestError]]

        request = build_get_all_resumes_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_resumes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllDocumentsResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_resumes.metadata = {"url": "/resumes"}  # type: ignore

    async def create_resume(
        self,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        data: Optional[_models.ResumeData] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = False,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> Union[_models.Resume, _models.RequestError]:
        """Upload a resume for parsing.

        Uploads a resume for parsing. When successful, returns an ``identifier`` in the response for
        subsequent use with the `/resumes/{identifier} <#get-/resumes/-identifier->`_ endpoint to check
        processing status and retrieve results.:code:`<br/>`
        Resumes can be uploaded as a file or a URL. In addition, data can be added directly if users
        want to upload directly without parsing any resume file. For uploading resume data, the
        ``data`` argument provided must be a JSON-encoded string. Data uploads will not impact upon
        parsing credits.

        :param file:  Default value is None.
        :type file: IO
        :param url:  Default value is None.
        :type url: str
        :param data:  Default value is None.
        :type data: ~affinda.models.ResumeData
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param reject_duplicates:  Default value is False.
        :type reject_duplicates: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Resume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[Union[_models.Resume, _models.RequestError]]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "data": data,
            "identifier": identifier,
            "fileName": file_name,
            "wait": wait,
            "rejectDuplicates": reject_duplicates,
            "language": language,
            "expiryTime": expiry_time,
        }

        request = build_create_resume_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume.metadata = {"url": "/resumes"}  # type: ignore

    async def get_resume(
        self, identifier: str, format: Optional[str] = None, **kwargs: Any
    ) -> Union[_models.Resume, _models.RequestError]:
        """Get parse results for a specific resume.

        Returns all the parse results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the `/resumes
        <#post-/resumes>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :param format: Set this to "hr-xml" to get the response in HR-XML format. Currently the only
         supported value for this parameter is "hr-xml". Default value is None.
        :type format: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Resume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Resume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Union[_models.Resume, _models.RequestError]]

        request = build_get_resume_request(
            identifier=identifier,
            format=format,
            template_url=self.get_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 200, 400, 400, 401, 401, 404, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 200:
            deserialized = self._deserialize("Resume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    async def update_resume_data(
        self, identifier: str, body: _models.ResumeData, **kwargs: Any
    ) -> Union[Optional[_models.ResumeData], _models.RequestError]:
        """Update a resume's data.

        Update data of a parsed resume.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the `/resumes
        <#post-/resumes>`_ endpoint.

        :param identifier: Resume identifier.
        :type identifier: str
        :param body: Resume data to update.
        :type body: ~affinda.models.ResumeData
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeData or None or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeData or None or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[Optional[_models.ResumeData], _models.RequestError]]

        _json = self._serialize.body(body, "ResumeData")

        request = build_update_resume_data_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.update_resume_data.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeData", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resume_data.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    async def delete_resume(
        self, identifier: str, **kwargs: Any
    ) -> Optional[_models.RequestError]:
        """Delete a resume.

        Deletes the specified resume from the database.

        :param identifier: Resume identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_resume_request(
            identifier=identifier,
            template_url=self.delete_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_resume.metadata = {"url": "/resumes/{identifier}"}  # type: ignore

    async def get_all_redacted_resumes(
        self, offset: Optional[int] = None, limit: Optional[int] = 300, **kwargs: Any
    ) -> Union[_models.GetAllDocumentsResults, _models.RequestError]:
        """Get list of all redacted resumes.

        Returns all the redacted resume information for that resume.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllDocumentsResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllDocumentsResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.GetAllDocumentsResults, _models.RequestError]]

        request = build_get_all_redacted_resumes_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_redacted_resumes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllDocumentsResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_redacted_resumes.metadata = {"url": "/redacted_resumes"}  # type: ignore

    async def create_redacted_resume(
        self,
        file: Optional[IO] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        url: Optional[str] = None,
        language: Optional[str] = None,
        wait: Optional[bool] = True,
        redact_headshot: Optional[bool] = True,
        redact_personal_details: Optional[bool] = True,
        redact_work_details: Optional[bool] = True,
        redact_education_details: Optional[bool] = True,
        redact_referees: Optional[bool] = True,
        redact_locations: Optional[bool] = True,
        redact_dates: Optional[bool] = True,
        redact_gender: Optional[str] = "true",
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> Union[_models.RedactedResume, _models.RequestError]:
        """Upload a resume for redacting.

        Uploads a resume for redacting.

        :param file:  Default value is None.
        :type file: IO
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param url:  Default value is None.
        :type url: str
        :param language:  Default value is None.
        :type language: str
        :param wait:  Default value is True.
        :type wait: bool
        :param redact_headshot: Whether to redact headshot. Default value is True.
        :type redact_headshot: bool
        :param redact_personal_details: Whether to redact personal details (e.g. name, address).
         Default value is True.
        :type redact_personal_details: bool
        :param redact_work_details: Whether to redact work details (e.g. company names). Default value
         is True.
        :type redact_work_details: bool
        :param redact_education_details: Whether to redact education details (e.g. university names).
         Default value is True.
        :type redact_education_details: bool
        :param redact_referees: Whether to redact referee details. Default value is True.
        :type redact_referees: bool
        :param redact_locations: Whether to redact location names. Default value is True.
        :type redact_locations: bool
        :param redact_dates: Whether to redact dates. Default value is True.
        :type redact_dates: bool
        :param redact_gender: Whether to redact gender. Default value is "true".
        :type redact_gender: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RedactedResume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.RedactedResume, _models.RequestError]]

        # Construct form data
        _files = {
            "file": file,
            "identifier": identifier,
            "fileName": file_name,
            "url": url,
            "language": language,
            "wait": wait,
            "redactHeadshot": redact_headshot,
            "redactPersonalDetails": redact_personal_details,
            "redactWorkDetails": redact_work_details,
            "redactEducationDetails": redact_education_details,
            "redactReferees": redact_referees,
            "redactLocations": redact_locations,
            "redactDates": redact_dates,
            "redactGender": redact_gender,
            "expiryTime": expiry_time,
        }

        request = build_create_redacted_resume_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_redacted_resume.metadata = {"url": "/redacted_resumes"}  # type: ignore

    async def get_redacted_resume(
        self, identifier: str, **kwargs: Any
    ) -> Union[_models.RedactedResume, _models.RequestError]:
        """Get redaction results for a specific resume.

        Returns all the redaction results for that resume if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/redacted_resumes <#post-/redacted_resumes>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RedactedResume or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RedactedResume or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.RedactedResume, _models.RequestError]]

        request = build_get_redacted_resume_request(
            identifier=identifier,
            template_url=self.get_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RedactedResume", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_redacted_resume.metadata = {"url": "/redacted_resumes/{identifier}"}  # type: ignore

    async def delete_redacted_resume(
        self, identifier: str, **kwargs: Any
    ) -> Optional[_models.RequestError]:
        """Delete a redacted resume.

        Deletes the specified resume from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_redacted_resume_request(
            identifier=identifier,
            template_url=self.delete_redacted_resume.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_redacted_resume.metadata = {"url": "/redacted_resumes/{identifier}"}  # type: ignore

    async def create_resume_search(
        self,
        body: _models.ResumeSearchParameters,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        **kwargs: Any,
    ) -> Union[_models.ResumeSearch, _models.RequestError]:
        """Search through parsed resumes.

        Searches through parsed resumes. Users have 3 options to create a search::code:`<br
        />`:code:`<br />` 1.    Match to a job description - a parsed job description is used to find
        candidates that suit it:code:`<br />` 2.  Match to a resume - a parsed resume is used to find
        other candidates that have similar attributes:code:`<br />` 3.  Search using custom
        criteria:code:`<br />`:code:`<br />` Users should only populate 1 of jobDescription, resume or
        the custom criteria.

        :param body: Search parameters.
        :type body: ~affinda.models.ResumeSearchParameters
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearch or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearch or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearch, _models.RequestError]]

        _json = self._serialize.body(body, "ResumeSearchParameters")

        request = build_create_resume_search_request(
            content_type=content_type,
            json=_json,
            offset=offset,
            limit=limit,
            template_url=self.create_resume_search.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 201:
            deserialized = self._deserialize("ResumeSearch", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume_search.metadata = {"url": "/resume_search"}  # type: ignore

    async def get_resume_search_detail(
        self, identifier: str, body: _models.ResumeSearchParameters, **kwargs: Any
    ) -> Union[_models.ResumeSearchDetail, _models.RequestError]:
        """Get search result of specific resume.

        This contains more detailed information about the matching score of the search criteria, or
        which search criteria is missing in this resume.
        The ``identifier`` is the unique ID returned via the `/resume_search <#post-/resume_search>`_
        endpoint.

        :param identifier: Resume identifier.
        :type identifier: str
        :param body: Search parameters.
        :type body: ~affinda.models.ResumeSearchParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchDetail or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchDetail or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearchDetail, _models.RequestError]]

        _json = self._serialize.body(body, "ResumeSearchParameters")

        request = build_get_resume_search_detail_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.get_resume_search_detail.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeSearchDetail", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_detail.metadata = {"url": "/resume_search/details/{identifier}"}  # type: ignore

    async def get_resume_search_match(
        self,
        resume: str,
        job_description: str,
        index: Optional[str] = None,
        search_expression: Optional[str] = None,
        job_titles_weight: Optional[float] = None,
        years_experience_weight: Optional[float] = None,
        locations_weight: Optional[float] = None,
        languages_weight: Optional[float] = None,
        skills_weight: Optional[float] = None,
        education_weight: Optional[float] = None,
        search_expression_weight: Optional[float] = None,
        soc_codes_weight: Optional[float] = None,
        management_level_weight: Optional[float] = None,
        **kwargs: Any,
    ) -> Union[_models.ResumeSearchMatch, _models.RequestError]:
        """Match a single resume and job description.

        Get the matching score between a resume and a job description. The score ranges between 0 and
        1, with 0 being not a match at all, and 1 being perfect match.:code:`<br/>` Note, this score
        will not directly match the score returned from POST `/resume_search/details/{identifier}
        <#post-/resume_search/details/-identifier->`_.

        :param resume: Identify the resume to match.
        :type resume: str
        :param job_description: Identify the job description to match.
        :type job_description: str
        :param index: Optionally, specify an index to search in. If not specified, will search in all
         indexes. Default value is None.
        :type index: str
        :param search_expression: Add keywords to the search criteria. Default value is None.
        :type search_expression: str
        :param job_titles_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type job_titles_weight: float
        :param years_experience_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type years_experience_weight: float
        :param locations_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type locations_weight: float
        :param languages_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type languages_weight: float
        :param skills_weight: How important is this criteria to the matching score, range from 0 to 1.
         Default value is None.
        :type skills_weight: float
        :param education_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type education_weight: float
        :param search_expression_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type search_expression_weight: float
        :param soc_codes_weight: How important is this criteria to the matching score, range from 0 to
         1. Default value is None.
        :type soc_codes_weight: float
        :param management_level_weight: How important is this criteria to the matching score, range
         from 0 to 1. Default value is None.
        :type management_level_weight: float
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchMatch or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchMatch or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearchMatch, _models.RequestError]]

        request = build_get_resume_search_match_request(
            resume=resume,
            job_description=job_description,
            index=index,
            search_expression=search_expression,
            job_titles_weight=job_titles_weight,
            years_experience_weight=years_experience_weight,
            locations_weight=locations_weight,
            languages_weight=languages_weight,
            skills_weight=skills_weight,
            education_weight=education_weight,
            search_expression_weight=search_expression_weight,
            soc_codes_weight=soc_codes_weight,
            management_level_weight=management_level_weight,
            template_url=self.get_resume_search_match.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeSearchMatch", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_match.metadata = {"url": "/resume_search/match"}  # type: ignore

    async def get_resume_search_config(
        self, **kwargs: Any
    ) -> Union[_models.ResumeSearchConfig, _models.RequestError]:
        """Get the config for the logged in user's embeddable resume search tool.

        Return configurations such as which fields can be displayed in the logged in user's embeddable
        resume search tool, what are their weights, what is the maximum number of results that can be
        returned, etc.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchConfig or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchConfig or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearchConfig, _models.RequestError]]

        request = build_get_resume_search_config_request(
            template_url=self.get_resume_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeSearchConfig", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_config.metadata = {"url": "/resume_search/config"}  # type: ignore

    async def update_resume_search_config(
        self, body: _models.ResumeSearchConfig, **kwargs: Any
    ) -> Union[_models.ResumeSearchConfig, _models.RequestError]:
        """Update the config for the logged in user's embeddable resume search tool.

        Update configurations such as which fields can be displayed in the logged in user's embeddable
        resume search tool, what are their weights, what is the maximum number of results that can be
        returned, etc.

        :param body:
        :type body: ~affinda.models.ResumeSearchConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchConfig or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchConfig or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearchConfig, _models.RequestError]]

        _json = self._serialize.body(body, "ResumeSearchConfig")

        request = build_update_resume_search_config_request(
            content_type=content_type,
            json=_json,
            template_url=self.update_resume_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeSearchConfig", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_resume_search_config.metadata = {"url": "/resume_search/config"}  # type: ignore

    async def create_resume_search_embed_url(
        self,
        body: Optional[
            _models.Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema
        ] = None,
        **kwargs: Any,
    ) -> Union[_models.ResumeSearchEmbed, _models.RequestError]:
        """Create a signed URL for the embeddable resume search tool.

        Create and return a signed URL of the resume search tool which then can be embedded on a web
        page. An optional parameter ``config_override`` can be passed to override the user-level
        configurations of the embeddable resume search tool.

        :param body:  Default value is None.
        :type body:
         ~affinda.models.Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: ResumeSearchEmbed or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.ResumeSearchEmbed or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.ResumeSearchEmbed, _models.RequestError]]

        if body is not None:
            _json = self._serialize.body(
                body, "Paths2T1Oc0ResumeSearchEmbedPostRequestbodyContentApplicationJsonSchema"
            )
        else:
            _json = None

        request = build_create_resume_search_embed_url_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_resume_search_embed_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ResumeSearchEmbed", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_resume_search_embed_url.metadata = {"url": "/resume_search/embed"}  # type: ignore

    async def get_resume_search_suggestion_job_title(
        self, job_titles: List[str], **kwargs: Any
    ) -> Union[List[str], _models.RequestError]:
        """Get job title suggestions based on provided job title(s).

        Provided one or more job titles, get related suggestions for your search.

        :param job_titles: Job title to query suggestions for.
        :type job_titles: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of str or RequestError, or the result of cls(response)
        :rtype: list[str] or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Union[List[str], _models.RequestError]]

        request = build_get_resume_search_suggestion_job_title_request(
            job_titles=job_titles,
            template_url=self.get_resume_search_suggestion_job_title.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("[str]", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_suggestion_job_title.metadata = {"url": "/resume_search/suggestion_job_title"}  # type: ignore

    async def get_resume_search_suggestion_skill(
        self, skills: List[str], **kwargs: Any
    ) -> Union[List[str], _models.RequestError]:
        """Get skill suggestions based on provided skill(s).

        Provided one or more skills, get related suggestions for your search.

        :param skills: Skill to query suggestions for.
        :type skills: list[str]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of str or RequestError, or the result of cls(response)
        :rtype: list[str] or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Union[List[str], _models.RequestError]]

        request = build_get_resume_search_suggestion_skill_request(
            skills=skills,
            template_url=self.get_resume_search_suggestion_skill.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("[str]", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resume_search_suggestion_skill.metadata = {"url": "/resume_search/suggestion_skill"}  # type: ignore

    async def get_all_job_descriptions(
        self, offset: Optional[int] = None, limit: Optional[int] = 300, **kwargs: Any
    ) -> Union[_models.GetAllJobDescriptionsResults, _models.RequestError]:
        """Get list of all job descriptions.

        Returns all the job descriptions for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllJobDescriptionsResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllJobDescriptionsResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.GetAllJobDescriptionsResults, _models.RequestError]]

        request = build_get_all_job_descriptions_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_job_descriptions.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllJobDescriptionsResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_job_descriptions.metadata = {"url": "/job_descriptions"}  # type: ignore

    async def create_job_description(
        self,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = False,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> Union[_models.JobDescription, _models.RequestError]:
        """Upload a job description for parsing.

        Uploads a job description for parsing.
        When successful, returns an ``identifier`` in the response for subsequent use with the
        `/job_descriptions/{identifier} <#get-/job_descriptions/-identifier->`_ endpoint to check
        processing status and retrieve results.
        Job Descriptions can be uploaded as a file or a URL.

        :param file:  Default value is None.
        :type file: IO
        :param url:  Default value is None.
        :type url: str
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param reject_duplicates:  Default value is False.
        :type reject_duplicates: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescription or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescription or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescription, _models.RequestError]]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "identifier": identifier,
            "fileName": file_name,
            "wait": wait,
            "rejectDuplicates": reject_duplicates,
            "language": language,
            "expiryTime": expiry_time,
        }

        request = build_create_job_description_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescription", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("JobDescription", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description.metadata = {"url": "/job_descriptions"}  # type: ignore

    async def get_job_description(
        self, identifier: str, **kwargs: Any
    ) -> Union[_models.JobDescription, _models.RequestError]:
        """Get job description results for a specific job description file.

        Returns all the results for that job description if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the resume via the
        `/job_descriptions <#post-/job_descriptions>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescription or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescription or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescription, _models.RequestError]]

        request = build_get_job_description_request(
            identifier=identifier,
            template_url=self.get_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescription", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description.metadata = {"url": "/job_descriptions/{identifier}"}  # type: ignore

    async def delete_job_description(
        self, identifier: str, **kwargs: Any
    ) -> Optional[_models.RequestError]:
        """Delete a job description.

        Deletes the specified job description from the database.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_job_description_request(
            identifier=identifier,
            template_url=self.delete_job_description.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_job_description.metadata = {"url": "/job_descriptions/{identifier}"}  # type: ignore

    async def create_job_description_search(
        self,
        body: _models.JobDescriptionSearchParameters,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        **kwargs: Any,
    ) -> Union[_models.JobDescriptionSearch, _models.RequestError]:
        """Search through parsed job descriptions.

        Searches through parsed job descriptions. You can search with custom criterias or a resume.

        :param body: Search parameters.
        :type body: ~affinda.models.JobDescriptionSearchParameters
        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearch or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearch or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescriptionSearch, _models.RequestError]]

        _json = self._serialize.body(body, "JobDescriptionSearchParameters")

        request = build_create_job_description_search_request(
            content_type=content_type,
            json=_json,
            offset=offset,
            limit=limit,
            template_url=self.create_job_description_search.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 201:
            deserialized = self._deserialize("JobDescriptionSearch", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description_search.metadata = {"url": "/job_description_search"}  # type: ignore

    async def get_job_description_search_detail(
        self, identifier: str, body: _models.JobDescriptionSearchParameters, **kwargs: Any
    ) -> Union[_models.JobDescriptionSearchDetail, _models.RequestError]:
        """Get search result of specific job description.

        This contains more detailed information about the matching score of the search criteria, or
        which search criteria is missing in this job description.
        The ``identifier`` is the unique ID returned via the `/job_description_search
        <#post-/job_description_search>`_ endpoint.

        :param identifier: Job Description identifier.
        :type identifier: str
        :param body: Search parameters.
        :type body: ~affinda.models.JobDescriptionSearchParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchDetail or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchDetail or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescriptionSearchDetail, _models.RequestError]]

        _json = self._serialize.body(body, "JobDescriptionSearchParameters")

        request = build_get_job_description_search_detail_request(
            identifier=identifier,
            content_type=content_type,
            json=_json,
            template_url=self.get_job_description_search_detail.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescriptionSearchDetail", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description_search_detail.metadata = {"url": "/job_description_search/details/{identifier}"}  # type: ignore

    async def get_job_description_search_config(
        self, **kwargs: Any
    ) -> Union[_models.JobDescriptionSearchConfig, _models.RequestError]:
        """Get the config for the logged in user's embeddable job description search tool.

        Return configurations such as which fields can be displayed in the logged in user's embeddable
        job description search tool, what are their weights, what is the maximum number of results that
        can be returned, etc.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchConfig or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchConfig or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescriptionSearchConfig, _models.RequestError]]

        request = build_get_job_description_search_config_request(
            template_url=self.get_job_description_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescriptionSearchConfig", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_job_description_search_config.metadata = {"url": "/job_description_search/config"}  # type: ignore

    async def update_job_description_search_config(
        self, body: _models.JobDescriptionSearchConfig, **kwargs: Any
    ) -> Union[_models.JobDescriptionSearchConfig, _models.RequestError]:
        """Update the config for the logged in user's embeddable job description search tool.

        Update configurations such as which fields can be displayed in the logged in user's embeddable
        job description search tool, what are their weights, what is the maximum number of results that
        can be returned, etc.

        :param body:
        :type body: ~affinda.models.JobDescriptionSearchConfig
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchConfig or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchConfig or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescriptionSearchConfig, _models.RequestError]]

        _json = self._serialize.body(body, "JobDescriptionSearchConfig")

        request = build_update_job_description_search_config_request(
            content_type=content_type,
            json=_json,
            template_url=self.update_job_description_search_config.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescriptionSearchConfig", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update_job_description_search_config.metadata = {"url": "/job_description_search/config"}  # type: ignore

    async def create_job_description_search_embed_url(
        self,
        body: Optional[
            _models.PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema
        ] = None,
        **kwargs: Any,
    ) -> Union[_models.JobDescriptionSearchEmbed, _models.RequestError]:
        """Create a signed URL for the embeddable job description search tool.

        Create and return a signed URL of the job description search tool which then can be embedded on
        a web page. An optional parameter ``config_override`` can be passed to override the user-level
        configurations of the embeddable search tool.

        :param body:  Default value is None.
        :type body:
         ~affinda.models.PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: JobDescriptionSearchEmbed or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.JobDescriptionSearchEmbed or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.JobDescriptionSearchEmbed, _models.RequestError]]

        if body is not None:
            _json = self._serialize.body(
                body,
                "PathsFqn8P8JobDescriptionSearchEmbedPostRequestbodyContentApplicationJsonSchema",
            )
        else:
            _json = None

        request = build_create_job_description_search_embed_url_request(
            content_type=content_type,
            json=_json,
            template_url=self.create_job_description_search_embed_url.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("JobDescriptionSearchEmbed", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_job_description_search_embed_url.metadata = {"url": "/job_description_search/embed"}  # type: ignore

    async def get_all_indexes(
        self,
        offset: Optional[int] = None,
        limit: Optional[int] = 300,
        document_type: Optional[Union[str, "_models.Enum2"]] = None,
        **kwargs: Any,
    ) -> Union[
        _models.Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema, _models.RequestError
    ]:
        """Get list of all indexes.

        Returns all the indexes.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :param document_type: Filter indices by a document type. Default value is None.
        :type document_type: str or ~affinda.models.Enum2
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema or RequestError, or the
         result of cls(response)
        :rtype: ~affinda.models.Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema, _models.RequestError]]

        request = build_get_all_indexes_request(
            offset=offset,
            limit=limit,
            document_type=document_type,
            template_url=self.get_all_indexes.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize(
                "Paths6Pypg5IndexGetResponses200ContentApplicationJsonSchema", pipeline_response
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_indexes.metadata = {"url": "/index"}  # type: ignore

    async def create_index(
        self,
        name: Optional[str] = None,
        document_type: Optional[Union[str, "_models.PostContentSchemaDocumentType"]] = None,
        **kwargs: Any,
    ) -> Union[
        _models.Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema, _models.RequestError
    ]:
        """Create a new index.

        Create an index for the search tool.

        :param name:  Default value is None.
        :type name: str
        :param document_type:  Default value is None.
        :type document_type: str or ~affinda.models.PostContentSchemaDocumentType
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema or RequestError, or the
         result of cls(response)
        :rtype: ~affinda.models.Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema, _models.RequestError]]

        # Construct form data
        _files = {
            "name": name,
            "documentType": document_type,
        }

        request = build_create_index_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 201:
            deserialized = self._deserialize(
                "Paths1Mc0Je6IndexPostResponses201ContentApplicationJsonSchema", pipeline_response
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_index.metadata = {"url": "/index"}  # type: ignore

    async def delete_index(self, name: str, **kwargs: Any) -> Optional[_models.RequestError]:
        """Delete an index.

        Deletes the specified index from the database.

        :param name: Index name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_index_request(
            name=name,
            template_url=self.delete_index.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_index.metadata = {"url": "/index/{name}"}  # type: ignore

    async def get_all_index_documents(
        self, name: str, **kwargs: Any
    ) -> Union[
        _models.PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema,
        _models.RequestError,
    ]:
        """Get indexed documents for a specific index.

        Returns all the indexed documents for that index.

        :param name: Index name.
        :type name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema or
         RequestError, or the result of cls(response)
        :rtype:
         ~affinda.models.PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema, _models.RequestError]]

        request = build_get_all_index_documents_request(
            name=name,
            template_url=self.get_all_index_documents.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize(
                "PathsRvverlIndexNameDocumentsGetResponses200ContentApplicationJsonSchema",
                pipeline_response,
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_index_documents.metadata = {"url": "/index/{name}/documents"}  # type: ignore

    async def create_index_document(
        self,
        name: str,
        body: _models.PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema,
        **kwargs: Any,
    ) -> Union[
        _models.PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema,
        _models.RequestError,
    ]:
        """Index a new document.

        Create an indexed document for the search tool.

        :param name: Index name.
        :type name: str
        :param body: Document to index.
        :type body:
         ~affinda.models.PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema or
         RequestError, or the result of cls(response)
        :rtype:
         ~affinda.models.PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", "application/json")
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema, _models.RequestError]]

        _json = self._serialize.body(
            body, "PathsGpptmIndexNameDocumentsPostRequestbodyContentApplicationJsonSchema"
        )

        request = build_create_index_document_request(
            name=name,
            content_type=content_type,
            json=_json,
            template_url=self.create_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 201:
            deserialized = self._deserialize(
                "PathsCoo0XpIndexNameDocumentsPostResponses201ContentApplicationJsonSchema",
                pipeline_response,
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_index_document.metadata = {"url": "/index/{name}/documents"}  # type: ignore

    async def delete_index_document(
        self, name: str, identifier: str, **kwargs: Any
    ) -> Optional[_models.RequestError]:
        """Delete an indexed document.

        Delete the specified indexed document from the database.

        :param name: Index name.
        :type name: str
        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_index_document_request(
            name=name,
            identifier=identifier,
            template_url=self.delete_index_document.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_index_document.metadata = {"url": "/index/{name}/documents/{identifier}"}  # type: ignore

    async def get_all_invoices(
        self, offset: Optional[int] = None, limit: Optional[int] = 300, **kwargs: Any
    ) -> Union[_models.GetAllInvoicesResults, _models.RequestError]:
        """Get list of all invoices.

        Returns all the invoice summaries for that user, limited to 300 per page.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: GetAllInvoicesResults or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.GetAllInvoicesResults or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.GetAllInvoicesResults, _models.RequestError]]

        request = build_get_all_invoices_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_invoices.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("GetAllInvoicesResults", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_invoices.metadata = {"url": "/invoices"}  # type: ignore

    async def create_invoice(
        self,
        file: Optional[IO] = None,
        url: Optional[str] = None,
        identifier: Optional[str] = None,
        file_name: Optional[str] = None,
        wait: Optional[bool] = True,
        reject_duplicates: Optional[bool] = False,
        language: Optional[str] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs: Any,
    ) -> Union[_models.Invoice, _models.RequestError]:
        """Upload an invoice for parsing.

        Uploads an invoice for parsing.
        When successful, returns an ``identifier`` in the response for subsequent use with the
        `/invoices/{identifier} <#get-/invoices/-identifier->`_ endpoint to check processing status and
        retrieve results.

        :param file:  Default value is None.
        :type file: IO
        :param url:  Default value is None.
        :type url: str
        :param identifier:  Default value is None.
        :type identifier: str
        :param file_name:  Default value is None.
        :type file_name: str
        :param wait:  Default value is True.
        :type wait: bool
        :param reject_duplicates:  Default value is False.
        :type reject_duplicates: bool
        :param language:  Default value is None.
        :type language: str
        :param expiry_time:  Default value is None.
        :type expiry_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invoice or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Invoice or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.Invoice, _models.RequestError]]

        # Construct form data
        _files = {
            "file": file,
            "url": url,
            "identifier": identifier,
            "fileName": file_name,
            "wait": wait,
            "rejectDuplicates": reject_duplicates,
            "language": language,
            "expiryTime": expiry_time,
        }

        request = build_create_invoice_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Invoice", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Invoice", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_invoice.metadata = {"url": "/invoices"}  # type: ignore

    async def get_invoice(
        self, identifier: str, **kwargs: Any
    ) -> Union[_models.Invoice, _models.RequestError]:
        """Get parse results for a specific invoice.

        Returns all the parse results for that invoice if processing is completed.
        The ``identifier`` is the unique ID returned after POST-ing the invoice via the `/invoices
        <#post-/invoices>`_ endpoint.

        :param identifier: Document identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: Invoice or RequestError, or the result of cls(response)
        :rtype: ~affinda.models.Invoice or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.Invoice, _models.RequestError]]

        request = build_get_invoice_request(
            identifier=identifier,
            template_url=self.get_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("Invoice", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_invoice.metadata = {"url": "/invoices/{identifier}"}  # type: ignore

    async def delete_invoice(
        self, identifier: str, **kwargs: Any
    ) -> Optional[_models.RequestError]:
        """Delete an invoice.

        Delete the specified invoice from the database. Note, any invoices deleted from the database
        will no longer be used in any tailored customer models.

        :param identifier: Invoice identifier.
        :type identifier: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequestError, or the result of cls(response)
        :rtype: ~affinda.models.RequestError or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[_models.RequestError]]

        request = build_delete_invoice_request(
            identifier=identifier,
            template_url=self.delete_invoice.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    delete_invoice.metadata = {"url": "/invoices/{identifier}"}  # type: ignore

    async def list_occupation_groups(
        self, **kwargs: Any
    ) -> Union[List[_models.OccupationGroup], _models.RequestError]:
        """List occupation groups.

        Returns the list of searchable occupation groups.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: list of OccupationGroup or RequestError, or the result of cls(response)
        :rtype: list[~affinda.models.OccupationGroup] or ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[List[_models.OccupationGroup], _models.RequestError]]

        request = build_list_occupation_groups_request(
            template_url=self.list_occupation_groups.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("[OccupationGroup]", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_occupation_groups.metadata = {"url": "/occupation_groups"}  # type: ignore

    async def get_all_users(
        self, offset: Optional[int] = None, limit: Optional[int] = 300, **kwargs: Any
    ) -> Union[
        _models.PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema, _models.RequestError
    ]:
        """Get list of all users.

        Returns all the users.

        :param offset: The number of documents to skip before starting to collect the result set.
         Default value is None.
        :type offset: int
        :param limit: The numbers of results to return. Default value is 300.
        :type limit: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema or RequestError, or the
         result of cls(response)
        :rtype: ~affinda.models.PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema, _models.RequestError]]

        request = build_get_all_users_request(
            offset=offset,
            limit=limit,
            template_url=self.get_all_users.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize(
                "PathsWjaaeuUsersGetResponses200ContentApplicationJsonSchema", pipeline_response
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_all_users.metadata = {"url": "/users"}  # type: ignore

    async def create_user(
        self,
        username: str,
        id: Optional[int] = None,
        name: Optional[str] = None,
        email: Optional[str] = None,
        api_key: Optional[str] = None,
        **kwargs: Any,
    ) -> Union[
        _models.PathsTop5ZkUsersPostResponses201ContentApplicationJsonSchema, _models.RequestError
    ]:
        """Create a new user.

        Create an user as part of your account.

        :param username:
        :type username: str
        :param id:  Default value is None.
        :type id: int
        :param name:  Default value is None.
        :type name: str
        :param email:  Default value is None.
        :type email: str
        :param api_key:  Default value is None.
        :type api_key: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PathsTop5ZkUsersPostResponses201ContentApplicationJsonSchema or RequestError, or the
         result of cls(response)
        :rtype: ~affinda.models.PathsTop5ZkUsersPostResponses201ContentApplicationJsonSchema or
         ~affinda.models.RequestError
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop(
            "cls", None
        )  # type: ClsType[Union[_models.PathsTop5ZkUsersPostResponses201ContentApplicationJsonSchema, _models.RequestError]]

        # Construct form data
        _files = {
            "id": id,
            "name": name,
            "username": username,
            "email": email,
            "apiKey": api_key,
        }

        request = build_create_user_request(
            content_type=content_type,
            files=_files,
            template_url=self.create_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request, _files)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [201, 400, 401]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.RequestError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 201:
            deserialized = self._deserialize(
                "PathsTop5ZkUsersPostResponses201ContentApplicationJsonSchema", pipeline_response
            )

        if response.status_code == 400:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("RequestError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_user.metadata = {"url": "/users"}  # type: ignore
