"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedInstanceRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class ManagedInstanceRole extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        var managedPolicies = props.managedPolicies === undefined ? [] : props.managedPolicies;
        let domainJoinEnabled = props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true;
        let ssmManagementEnabled = props.ssmManagementEnabled === undefined ||
            props.domainJoinEnabled === undefined ||
            props.domainJoinEnabled === true ||
            props.ssmManagementEnabled === true;
        if (ssmManagementEnabled) {
            managedPolicies.push(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        }
        ;
        if (domainJoinEnabled) {
            managedPolicies.push(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMDirectoryServiceAccess'));
        }
        ;
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('ec2.amazonaws.com'),
            managedPolicies,
        });
        this.instanceProfile = new aws_cdk_lib_1.aws_iam.CfnInstanceProfile(this, 'instanceProfile', {
            roles: [role.roleName],
        });
    }
}
exports.ManagedInstanceRole = ManagedInstanceRole;
_a = JSII_RTTI_SYMBOL_1;
ManagedInstanceRole[_a] = { fqn: "@renovosolutions/cdk-library-managed-instance-role.ManagedInstanceRole", version: "2.1.59" };
//# sourceMappingURL=data:application/json;base64,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