import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppEngineFlexibleAppVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Metadata settings that are supplied to this version to enable beta runtime features.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#beta_settings AppEngineFlexibleAppVersion#beta_settings}
    */
    readonly betaSettings?: {
        [key: string]: string;
    };
    /**
    * Duration that static files should be cached by web proxies and browsers.
  Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#default_expiration AppEngineFlexibleAppVersion#default_expiration}
    */
    readonly defaultExpiration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#delete_service_on_destroy AppEngineFlexibleAppVersion#delete_service_on_destroy}
    */
    readonly deleteServiceOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Environment variables available to the application.  As these are not returned in the API request, Terraform will not detect any changes made outside of the Terraform config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#env_variables AppEngineFlexibleAppVersion#env_variables}
    */
    readonly envVariables?: {
        [key: string]: string;
    };
    /**
    * A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#inbound_services AppEngineFlexibleAppVersion#inbound_services}
    */
    readonly inboundServices?: string[];
    /**
    * Instance class that is used to run this version. Valid values are
  AutomaticScaling: F1, F2, F4, F4_1G
  ManualScaling: B1, B2, B4, B8, B4_1G
  Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#instance_class AppEngineFlexibleAppVersion#instance_class}
    */
    readonly instanceClass?: string;
    /**
    * Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#nobuild_files_regex AppEngineFlexibleAppVersion#nobuild_files_regex}
    */
    readonly nobuildFilesRegex?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#noop_on_destroy AppEngineFlexibleAppVersion#noop_on_destroy}
    */
    readonly noopOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#project AppEngineFlexibleAppVersion#project}
    */
    readonly project?: string;
    /**
    * Desired runtime. Example python27.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#runtime AppEngineFlexibleAppVersion#runtime}
    */
    readonly runtime: string;
    /**
    * The version of the API in the given runtime environment.
  Please see the app.yaml reference for valid values at https://cloud.google.com/appengine/docs/standard//config/appref
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#runtime_api_version AppEngineFlexibleAppVersion#runtime_api_version}
    */
    readonly runtimeApiVersion?: string;
    /**
    * The channel of the runtime to use. Only available for some runtimes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#runtime_channel AppEngineFlexibleAppVersion#runtime_channel}
    */
    readonly runtimeChannel?: string;
    /**
    * The path or name of the app's main executable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#runtime_main_executable_path AppEngineFlexibleAppVersion#runtime_main_executable_path}
    */
    readonly runtimeMainExecutablePath?: string;
    /**
    * AppEngine service resource. Can contain numbers, letters, and hyphens.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#service AppEngineFlexibleAppVersion#service}
    */
    readonly service: string;
    /**
    * Current serving status of this version. Only the versions with a SERVING status create instances and can be billed. Default value: "SERVING" Possible values: ["SERVING", "STOPPED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#serving_status AppEngineFlexibleAppVersion#serving_status}
    */
    readonly servingStatus?: string;
    /**
    * Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens.
  Reserved names,"default", "latest", and any name with the prefix "ah-".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#version_id AppEngineFlexibleAppVersion#version_id}
    */
    readonly versionId?: string;
    /**
    * api_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#api_config AppEngineFlexibleAppVersion#api_config}
    */
    readonly apiConfig?: AppEngineFlexibleAppVersionApiConfig;
    /**
    * automatic_scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#automatic_scaling AppEngineFlexibleAppVersion#automatic_scaling}
    */
    readonly automaticScaling?: AppEngineFlexibleAppVersionAutomaticScaling;
    /**
    * deployment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#deployment AppEngineFlexibleAppVersion#deployment}
    */
    readonly deployment?: AppEngineFlexibleAppVersionDeployment;
    /**
    * endpoints_api_service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#endpoints_api_service AppEngineFlexibleAppVersion#endpoints_api_service}
    */
    readonly endpointsApiService?: AppEngineFlexibleAppVersionEndpointsApiService;
    /**
    * entrypoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#entrypoint AppEngineFlexibleAppVersion#entrypoint}
    */
    readonly entrypoint?: AppEngineFlexibleAppVersionEntrypoint;
    /**
    * handlers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#handlers AppEngineFlexibleAppVersion#handlers}
    */
    readonly handlers?: AppEngineFlexibleAppVersionHandlers[] | cdktf.IResolvable;
    /**
    * liveness_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#liveness_check AppEngineFlexibleAppVersion#liveness_check}
    */
    readonly livenessCheck: AppEngineFlexibleAppVersionLivenessCheck;
    /**
    * manual_scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#manual_scaling AppEngineFlexibleAppVersion#manual_scaling}
    */
    readonly manualScaling?: AppEngineFlexibleAppVersionManualScaling;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#network AppEngineFlexibleAppVersion#network}
    */
    readonly network?: AppEngineFlexibleAppVersionNetwork;
    /**
    * readiness_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#readiness_check AppEngineFlexibleAppVersion#readiness_check}
    */
    readonly readinessCheck: AppEngineFlexibleAppVersionReadinessCheck;
    /**
    * resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#resources AppEngineFlexibleAppVersion#resources}
    */
    readonly resources?: AppEngineFlexibleAppVersionResources;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#timeouts AppEngineFlexibleAppVersion#timeouts}
    */
    readonly timeouts?: AppEngineFlexibleAppVersionTimeouts;
    /**
    * vpc_access_connector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#vpc_access_connector AppEngineFlexibleAppVersion#vpc_access_connector}
    */
    readonly vpcAccessConnector?: AppEngineFlexibleAppVersionVpcAccessConnector;
}
export interface AppEngineFlexibleAppVersionApiConfig {
    /**
    * Action to take when users access resources that require authentication. Default value: "AUTH_FAIL_ACTION_REDIRECT" Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#auth_fail_action AppEngineFlexibleAppVersion#auth_fail_action}
    */
    readonly authFailAction?: string;
    /**
    * Level of login required to access this resource. Default value: "LOGIN_OPTIONAL" Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#login AppEngineFlexibleAppVersion#login}
    */
    readonly login?: string;
    /**
    * Path to the script from the application root directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#script AppEngineFlexibleAppVersion#script}
    */
    readonly script: string;
    /**
    * Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#security_level AppEngineFlexibleAppVersion#security_level}
    */
    readonly securityLevel?: string;
    /**
    * URL to serve the endpoint at.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#url AppEngineFlexibleAppVersion#url}
    */
    readonly url?: string;
}
export declare function appEngineFlexibleAppVersionApiConfigToTerraform(struct?: AppEngineFlexibleAppVersionApiConfigOutputReference | AppEngineFlexibleAppVersionApiConfig): any;
export declare class AppEngineFlexibleAppVersionApiConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionApiConfig | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionApiConfig | undefined);
    private _authFailAction?;
    get authFailAction(): string;
    set authFailAction(value: string);
    resetAuthFailAction(): void;
    get authFailActionInput(): string | undefined;
    private _login?;
    get login(): string;
    set login(value: string);
    resetLogin(): void;
    get loginInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    get scriptInput(): string | undefined;
    private _securityLevel?;
    get securityLevel(): string;
    set securityLevel(value: string);
    resetSecurityLevel(): void;
    get securityLevelInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization {
    /**
    * Period of time over which CPU utilization is calculated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#aggregation_window_length AppEngineFlexibleAppVersion#aggregation_window_length}
    */
    readonly aggregationWindowLength?: string;
    /**
    * Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_utilization AppEngineFlexibleAppVersion#target_utilization}
    */
    readonly targetUtilization: number;
}
export declare function appEngineFlexibleAppVersionAutomaticScalingCpuUtilizationToTerraform(struct?: AppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationOutputReference | AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization): any;
export declare class AppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization | undefined);
    private _aggregationWindowLength?;
    get aggregationWindowLength(): string;
    set aggregationWindowLength(value: string);
    resetAggregationWindowLength(): void;
    get aggregationWindowLengthInput(): string | undefined;
    private _targetUtilization?;
    get targetUtilization(): number;
    set targetUtilization(value: number);
    get targetUtilizationInput(): number | undefined;
}
export interface AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization {
    /**
    * Target bytes read per second.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_read_bytes_per_second AppEngineFlexibleAppVersion#target_read_bytes_per_second}
    */
    readonly targetReadBytesPerSecond?: number;
    /**
    * Target ops read per seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_read_ops_per_second AppEngineFlexibleAppVersion#target_read_ops_per_second}
    */
    readonly targetReadOpsPerSecond?: number;
    /**
    * Target bytes written per second.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_write_bytes_per_second AppEngineFlexibleAppVersion#target_write_bytes_per_second}
    */
    readonly targetWriteBytesPerSecond?: number;
    /**
    * Target ops written per second.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_write_ops_per_second AppEngineFlexibleAppVersion#target_write_ops_per_second}
    */
    readonly targetWriteOpsPerSecond?: number;
}
export declare function appEngineFlexibleAppVersionAutomaticScalingDiskUtilizationToTerraform(struct?: AppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationOutputReference | AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization): any;
export declare class AppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization | undefined);
    private _targetReadBytesPerSecond?;
    get targetReadBytesPerSecond(): number;
    set targetReadBytesPerSecond(value: number);
    resetTargetReadBytesPerSecond(): void;
    get targetReadBytesPerSecondInput(): number | undefined;
    private _targetReadOpsPerSecond?;
    get targetReadOpsPerSecond(): number;
    set targetReadOpsPerSecond(value: number);
    resetTargetReadOpsPerSecond(): void;
    get targetReadOpsPerSecondInput(): number | undefined;
    private _targetWriteBytesPerSecond?;
    get targetWriteBytesPerSecond(): number;
    set targetWriteBytesPerSecond(value: number);
    resetTargetWriteBytesPerSecond(): void;
    get targetWriteBytesPerSecondInput(): number | undefined;
    private _targetWriteOpsPerSecond?;
    get targetWriteOpsPerSecond(): number;
    set targetWriteOpsPerSecond(value: number);
    resetTargetWriteOpsPerSecond(): void;
    get targetWriteOpsPerSecondInput(): number | undefined;
}
export interface AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization {
    /**
    * Target bytes received per second.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_received_bytes_per_second AppEngineFlexibleAppVersion#target_received_bytes_per_second}
    */
    readonly targetReceivedBytesPerSecond?: number;
    /**
    * Target packets received per second.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_received_packets_per_second AppEngineFlexibleAppVersion#target_received_packets_per_second}
    */
    readonly targetReceivedPacketsPerSecond?: number;
    /**
    * Target bytes sent per second.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_sent_bytes_per_second AppEngineFlexibleAppVersion#target_sent_bytes_per_second}
    */
    readonly targetSentBytesPerSecond?: number;
    /**
    * Target packets sent per second.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_sent_packets_per_second AppEngineFlexibleAppVersion#target_sent_packets_per_second}
    */
    readonly targetSentPacketsPerSecond?: number;
}
export declare function appEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationToTerraform(struct?: AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationOutputReference | AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization): any;
export declare class AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization | undefined);
    private _targetReceivedBytesPerSecond?;
    get targetReceivedBytesPerSecond(): number;
    set targetReceivedBytesPerSecond(value: number);
    resetTargetReceivedBytesPerSecond(): void;
    get targetReceivedBytesPerSecondInput(): number | undefined;
    private _targetReceivedPacketsPerSecond?;
    get targetReceivedPacketsPerSecond(): number;
    set targetReceivedPacketsPerSecond(value: number);
    resetTargetReceivedPacketsPerSecond(): void;
    get targetReceivedPacketsPerSecondInput(): number | undefined;
    private _targetSentBytesPerSecond?;
    get targetSentBytesPerSecond(): number;
    set targetSentBytesPerSecond(value: number);
    resetTargetSentBytesPerSecond(): void;
    get targetSentBytesPerSecondInput(): number | undefined;
    private _targetSentPacketsPerSecond?;
    get targetSentPacketsPerSecond(): number;
    set targetSentPacketsPerSecond(value: number);
    resetTargetSentPacketsPerSecond(): void;
    get targetSentPacketsPerSecondInput(): number | undefined;
}
export interface AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization {
    /**
    * Target number of concurrent requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_concurrent_requests AppEngineFlexibleAppVersion#target_concurrent_requests}
    */
    readonly targetConcurrentRequests?: number;
    /**
    * Target requests per second.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_request_count_per_second AppEngineFlexibleAppVersion#target_request_count_per_second}
    */
    readonly targetRequestCountPerSecond?: string;
}
export declare function appEngineFlexibleAppVersionAutomaticScalingRequestUtilizationToTerraform(struct?: AppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationOutputReference | AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization): any;
export declare class AppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization | undefined);
    private _targetConcurrentRequests?;
    get targetConcurrentRequests(): number;
    set targetConcurrentRequests(value: number);
    resetTargetConcurrentRequests(): void;
    get targetConcurrentRequestsInput(): number | undefined;
    private _targetRequestCountPerSecond?;
    get targetRequestCountPerSecond(): string;
    set targetRequestCountPerSecond(value: string);
    resetTargetRequestCountPerSecond(): void;
    get targetRequestCountPerSecondInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionAutomaticScaling {
    /**
    * The time period that the Autoscaler should wait before it starts collecting information from a new instance.
  This prevents the autoscaler from collecting information when the instance is initializing,
  during which the collected usage would not be reliable. Default: 120s
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#cool_down_period AppEngineFlexibleAppVersion#cool_down_period}
    */
    readonly coolDownPeriod?: string;
    /**
    * Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.
  
  Defaults to a runtime-specific value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#max_concurrent_requests AppEngineFlexibleAppVersion#max_concurrent_requests}
    */
    readonly maxConcurrentRequests?: number;
    /**
    * Maximum number of idle instances that should be maintained for this version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#max_idle_instances AppEngineFlexibleAppVersion#max_idle_instances}
    */
    readonly maxIdleInstances?: number;
    /**
    * Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#max_pending_latency AppEngineFlexibleAppVersion#max_pending_latency}
    */
    readonly maxPendingLatency?: string;
    /**
    * Maximum number of instances that should be started to handle requests for this version. Default: 20
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#max_total_instances AppEngineFlexibleAppVersion#max_total_instances}
    */
    readonly maxTotalInstances?: number;
    /**
    * Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#min_idle_instances AppEngineFlexibleAppVersion#min_idle_instances}
    */
    readonly minIdleInstances?: number;
    /**
    * Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#min_pending_latency AppEngineFlexibleAppVersion#min_pending_latency}
    */
    readonly minPendingLatency?: string;
    /**
    * Minimum number of running instances that should be maintained for this version. Default: 2
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#min_total_instances AppEngineFlexibleAppVersion#min_total_instances}
    */
    readonly minTotalInstances?: number;
    /**
    * cpu_utilization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#cpu_utilization AppEngineFlexibleAppVersion#cpu_utilization}
    */
    readonly cpuUtilization: AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization;
    /**
    * disk_utilization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#disk_utilization AppEngineFlexibleAppVersion#disk_utilization}
    */
    readonly diskUtilization?: AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization;
    /**
    * network_utilization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#network_utilization AppEngineFlexibleAppVersion#network_utilization}
    */
    readonly networkUtilization?: AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization;
    /**
    * request_utilization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#request_utilization AppEngineFlexibleAppVersion#request_utilization}
    */
    readonly requestUtilization?: AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization;
}
export declare function appEngineFlexibleAppVersionAutomaticScalingToTerraform(struct?: AppEngineFlexibleAppVersionAutomaticScalingOutputReference | AppEngineFlexibleAppVersionAutomaticScaling): any;
export declare class AppEngineFlexibleAppVersionAutomaticScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionAutomaticScaling | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionAutomaticScaling | undefined);
    private _coolDownPeriod?;
    get coolDownPeriod(): string;
    set coolDownPeriod(value: string);
    resetCoolDownPeriod(): void;
    get coolDownPeriodInput(): string | undefined;
    private _maxConcurrentRequests?;
    get maxConcurrentRequests(): number;
    set maxConcurrentRequests(value: number);
    resetMaxConcurrentRequests(): void;
    get maxConcurrentRequestsInput(): number | undefined;
    private _maxIdleInstances?;
    get maxIdleInstances(): number;
    set maxIdleInstances(value: number);
    resetMaxIdleInstances(): void;
    get maxIdleInstancesInput(): number | undefined;
    private _maxPendingLatency?;
    get maxPendingLatency(): string;
    set maxPendingLatency(value: string);
    resetMaxPendingLatency(): void;
    get maxPendingLatencyInput(): string | undefined;
    private _maxTotalInstances?;
    get maxTotalInstances(): number;
    set maxTotalInstances(value: number);
    resetMaxTotalInstances(): void;
    get maxTotalInstancesInput(): number | undefined;
    private _minIdleInstances?;
    get minIdleInstances(): number;
    set minIdleInstances(value: number);
    resetMinIdleInstances(): void;
    get minIdleInstancesInput(): number | undefined;
    private _minPendingLatency?;
    get minPendingLatency(): string;
    set minPendingLatency(value: string);
    resetMinPendingLatency(): void;
    get minPendingLatencyInput(): string | undefined;
    private _minTotalInstances?;
    get minTotalInstances(): number;
    set minTotalInstances(value: number);
    resetMinTotalInstances(): void;
    get minTotalInstancesInput(): number | undefined;
    private _cpuUtilization;
    get cpuUtilization(): AppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationOutputReference;
    putCpuUtilization(value: AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization): void;
    get cpuUtilizationInput(): AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization | undefined;
    private _diskUtilization;
    get diskUtilization(): AppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationOutputReference;
    putDiskUtilization(value: AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization): void;
    resetDiskUtilization(): void;
    get diskUtilizationInput(): AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization | undefined;
    private _networkUtilization;
    get networkUtilization(): AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationOutputReference;
    putNetworkUtilization(value: AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization): void;
    resetNetworkUtilization(): void;
    get networkUtilizationInput(): AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization | undefined;
    private _requestUtilization;
    get requestUtilization(): AppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationOutputReference;
    putRequestUtilization(value: AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization): void;
    resetRequestUtilization(): void;
    get requestUtilizationInput(): AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization | undefined;
}
export interface AppEngineFlexibleAppVersionDeploymentCloudBuildOptions {
    /**
    * Path to the yaml file used in deployment, used to determine runtime configuration details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#app_yaml_path AppEngineFlexibleAppVersion#app_yaml_path}
    */
    readonly appYamlPath: string;
    /**
    * The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#cloud_build_timeout AppEngineFlexibleAppVersion#cloud_build_timeout}
    */
    readonly cloudBuildTimeout?: string;
}
export declare function appEngineFlexibleAppVersionDeploymentCloudBuildOptionsToTerraform(struct?: AppEngineFlexibleAppVersionDeploymentCloudBuildOptionsOutputReference | AppEngineFlexibleAppVersionDeploymentCloudBuildOptions): any;
export declare class AppEngineFlexibleAppVersionDeploymentCloudBuildOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionDeploymentCloudBuildOptions | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionDeploymentCloudBuildOptions | undefined);
    private _appYamlPath?;
    get appYamlPath(): string;
    set appYamlPath(value: string);
    get appYamlPathInput(): string | undefined;
    private _cloudBuildTimeout?;
    get cloudBuildTimeout(): string;
    set cloudBuildTimeout(value: string);
    resetCloudBuildTimeout(): void;
    get cloudBuildTimeoutInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionDeploymentContainer {
    /**
    * URI to the hosted container image in Google Container Registry. The URI must be fully qualified and include a tag or digest.
  Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#image AppEngineFlexibleAppVersion#image}
    */
    readonly image: string;
}
export declare function appEngineFlexibleAppVersionDeploymentContainerToTerraform(struct?: AppEngineFlexibleAppVersionDeploymentContainerOutputReference | AppEngineFlexibleAppVersionDeploymentContainer): any;
export declare class AppEngineFlexibleAppVersionDeploymentContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionDeploymentContainer | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionDeploymentContainer | undefined);
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionDeploymentFiles {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#name AppEngineFlexibleAppVersion#name}
    */
    readonly name: string;
    /**
    * SHA1 checksum of the file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#sha1_sum AppEngineFlexibleAppVersion#sha1_sum}
    */
    readonly sha1Sum?: string;
    /**
    * Source URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#source_url AppEngineFlexibleAppVersion#source_url}
    */
    readonly sourceUrl: string;
}
export declare function appEngineFlexibleAppVersionDeploymentFilesToTerraform(struct?: AppEngineFlexibleAppVersionDeploymentFiles | cdktf.IResolvable): any;
export interface AppEngineFlexibleAppVersionDeploymentZip {
    /**
    * files count
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#files_count AppEngineFlexibleAppVersion#files_count}
    */
    readonly filesCount?: number;
    /**
    * Source URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#source_url AppEngineFlexibleAppVersion#source_url}
    */
    readonly sourceUrl: string;
}
export declare function appEngineFlexibleAppVersionDeploymentZipToTerraform(struct?: AppEngineFlexibleAppVersionDeploymentZipOutputReference | AppEngineFlexibleAppVersionDeploymentZip): any;
export declare class AppEngineFlexibleAppVersionDeploymentZipOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionDeploymentZip | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionDeploymentZip | undefined);
    private _filesCount?;
    get filesCount(): number;
    set filesCount(value: number);
    resetFilesCount(): void;
    get filesCountInput(): number | undefined;
    private _sourceUrl?;
    get sourceUrl(): string;
    set sourceUrl(value: string);
    get sourceUrlInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionDeployment {
    /**
    * cloud_build_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#cloud_build_options AppEngineFlexibleAppVersion#cloud_build_options}
    */
    readonly cloudBuildOptions?: AppEngineFlexibleAppVersionDeploymentCloudBuildOptions;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#container AppEngineFlexibleAppVersion#container}
    */
    readonly container?: AppEngineFlexibleAppVersionDeploymentContainer;
    /**
    * files block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#files AppEngineFlexibleAppVersion#files}
    */
    readonly files?: AppEngineFlexibleAppVersionDeploymentFiles[] | cdktf.IResolvable;
    /**
    * zip block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#zip AppEngineFlexibleAppVersion#zip}
    */
    readonly zip?: AppEngineFlexibleAppVersionDeploymentZip;
}
export declare function appEngineFlexibleAppVersionDeploymentToTerraform(struct?: AppEngineFlexibleAppVersionDeploymentOutputReference | AppEngineFlexibleAppVersionDeployment): any;
export declare class AppEngineFlexibleAppVersionDeploymentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionDeployment | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionDeployment | undefined);
    private _cloudBuildOptions;
    get cloudBuildOptions(): AppEngineFlexibleAppVersionDeploymentCloudBuildOptionsOutputReference;
    putCloudBuildOptions(value: AppEngineFlexibleAppVersionDeploymentCloudBuildOptions): void;
    resetCloudBuildOptions(): void;
    get cloudBuildOptionsInput(): AppEngineFlexibleAppVersionDeploymentCloudBuildOptions | undefined;
    private _container;
    get container(): AppEngineFlexibleAppVersionDeploymentContainerOutputReference;
    putContainer(value: AppEngineFlexibleAppVersionDeploymentContainer): void;
    resetContainer(): void;
    get containerInput(): AppEngineFlexibleAppVersionDeploymentContainer | undefined;
    private _files?;
    get files(): AppEngineFlexibleAppVersionDeploymentFiles[] | cdktf.IResolvable;
    set files(value: AppEngineFlexibleAppVersionDeploymentFiles[] | cdktf.IResolvable);
    resetFiles(): void;
    get filesInput(): cdktf.IResolvable | AppEngineFlexibleAppVersionDeploymentFiles[] | undefined;
    private _zip;
    get zip(): AppEngineFlexibleAppVersionDeploymentZipOutputReference;
    putZip(value: AppEngineFlexibleAppVersionDeploymentZip): void;
    resetZip(): void;
    get zipInput(): AppEngineFlexibleAppVersionDeploymentZip | undefined;
}
export interface AppEngineFlexibleAppVersionEndpointsApiService {
    /**
    * Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".
  
  By default, the rollout strategy for Endpoints is "FIXED". This means that Endpoints starts up with a particular configuration ID.
  When a new configuration is rolled out, Endpoints must be given the new configuration ID. The configId field is used to give the configuration ID
  and is required in this case.
  
  Endpoints also has a rollout strategy called "MANAGED". When using this, Endpoints fetches the latest configuration and does not need
  the configuration ID. In this case, configId must be omitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#config_id AppEngineFlexibleAppVersion#config_id}
    */
    readonly configId?: string;
    /**
    * Enable or disable trace sampling. By default, this is set to false for enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#disable_trace_sampling AppEngineFlexibleAppVersion#disable_trace_sampling}
    */
    readonly disableTraceSampling?: boolean | cdktf.IResolvable;
    /**
    * Endpoints service name which is the name of the "service" resource in the Service Management API.
  For example "myapi.endpoints.myproject.cloud.goog"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#name AppEngineFlexibleAppVersion#name}
    */
    readonly name: string;
    /**
    * Endpoints rollout strategy. If FIXED, configId must be specified. If MANAGED, configId must be omitted. Default value: "FIXED" Possible values: ["FIXED", "MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#rollout_strategy AppEngineFlexibleAppVersion#rollout_strategy}
    */
    readonly rolloutStrategy?: string;
}
export declare function appEngineFlexibleAppVersionEndpointsApiServiceToTerraform(struct?: AppEngineFlexibleAppVersionEndpointsApiServiceOutputReference | AppEngineFlexibleAppVersionEndpointsApiService): any;
export declare class AppEngineFlexibleAppVersionEndpointsApiServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionEndpointsApiService | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionEndpointsApiService | undefined);
    private _configId?;
    get configId(): string;
    set configId(value: string);
    resetConfigId(): void;
    get configIdInput(): string | undefined;
    private _disableTraceSampling?;
    get disableTraceSampling(): boolean | cdktf.IResolvable;
    set disableTraceSampling(value: boolean | cdktf.IResolvable);
    resetDisableTraceSampling(): void;
    get disableTraceSamplingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rolloutStrategy?;
    get rolloutStrategy(): string;
    set rolloutStrategy(value: string);
    resetRolloutStrategy(): void;
    get rolloutStrategyInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionEntrypoint {
    /**
    * The format should be a shell command that can be fed to bash -c.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#shell AppEngineFlexibleAppVersion#shell}
    */
    readonly shell: string;
}
export declare function appEngineFlexibleAppVersionEntrypointToTerraform(struct?: AppEngineFlexibleAppVersionEntrypointOutputReference | AppEngineFlexibleAppVersionEntrypoint): any;
export declare class AppEngineFlexibleAppVersionEntrypointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionEntrypoint | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionEntrypoint | undefined);
    private _shell?;
    get shell(): string;
    set shell(value: string);
    get shellInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionHandlersScript {
    /**
    * Path to the script from the application root directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#script_path AppEngineFlexibleAppVersion#script_path}
    */
    readonly scriptPath: string;
}
export declare function appEngineFlexibleAppVersionHandlersScriptToTerraform(struct?: AppEngineFlexibleAppVersionHandlersScriptOutputReference | AppEngineFlexibleAppVersionHandlersScript): any;
export declare class AppEngineFlexibleAppVersionHandlersScriptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionHandlersScript | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionHandlersScript | undefined);
    private _scriptPath?;
    get scriptPath(): string;
    set scriptPath(value: string);
    get scriptPathInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionHandlersStaticFiles {
    /**
    * Whether files should also be uploaded as code data. By default, files declared in static file handlers are
  uploaded as static data and are only served to end users; they cannot be read by the application. If enabled,
  uploads are charged against both your code and static data storage resource quotas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#application_readable AppEngineFlexibleAppVersion#application_readable}
    */
    readonly applicationReadable?: boolean | cdktf.IResolvable;
    /**
    * Time a static file served by this handler should be cached by web proxies and browsers.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
  Default is '0s'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#expiration AppEngineFlexibleAppVersion#expiration}
    */
    readonly expiration?: string;
    /**
    * HTTP headers to use for all responses from these URLs.
  An object containing a list of "key:value" value pairs.".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#http_headers AppEngineFlexibleAppVersion#http_headers}
    */
    readonly httpHeaders?: {
        [key: string]: string;
    };
    /**
    * MIME type used to serve all files served by this handler.
  Defaults to file-specific MIME types, which are derived from each file's filename extension.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#mime_type AppEngineFlexibleAppVersion#mime_type}
    */
    readonly mimeType?: string;
    /**
    * Path to the static files matched by the URL pattern, from the application root directory.
  The path can refer to text matched in groupings in the URL pattern.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#path AppEngineFlexibleAppVersion#path}
    */
    readonly path?: string;
    /**
    * Whether this handler should match the request if the file referenced by the handler does not exist.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#require_matching_file AppEngineFlexibleAppVersion#require_matching_file}
    */
    readonly requireMatchingFile?: boolean | cdktf.IResolvable;
    /**
    * Regular expression that matches the file paths for all files that should be referenced by this handler.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#upload_path_regex AppEngineFlexibleAppVersion#upload_path_regex}
    */
    readonly uploadPathRegex?: string;
}
export declare function appEngineFlexibleAppVersionHandlersStaticFilesToTerraform(struct?: AppEngineFlexibleAppVersionHandlersStaticFilesOutputReference | AppEngineFlexibleAppVersionHandlersStaticFiles): any;
export declare class AppEngineFlexibleAppVersionHandlersStaticFilesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionHandlersStaticFiles | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionHandlersStaticFiles | undefined);
    private _applicationReadable?;
    get applicationReadable(): boolean | cdktf.IResolvable;
    set applicationReadable(value: boolean | cdktf.IResolvable);
    resetApplicationReadable(): void;
    get applicationReadableInput(): boolean | cdktf.IResolvable | undefined;
    private _expiration?;
    get expiration(): string;
    set expiration(value: string);
    resetExpiration(): void;
    get expirationInput(): string | undefined;
    private _httpHeaders?;
    get httpHeaders(): {
        [key: string]: string;
    };
    set httpHeaders(value: {
        [key: string]: string;
    });
    resetHttpHeaders(): void;
    get httpHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _mimeType?;
    get mimeType(): string;
    set mimeType(value: string);
    resetMimeType(): void;
    get mimeTypeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _requireMatchingFile?;
    get requireMatchingFile(): boolean | cdktf.IResolvable;
    set requireMatchingFile(value: boolean | cdktf.IResolvable);
    resetRequireMatchingFile(): void;
    get requireMatchingFileInput(): boolean | cdktf.IResolvable | undefined;
    private _uploadPathRegex?;
    get uploadPathRegex(): string;
    set uploadPathRegex(value: string);
    resetUploadPathRegex(): void;
    get uploadPathRegexInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionHandlers {
    /**
    * Actions to take when the user is not logged in. Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#auth_fail_action AppEngineFlexibleAppVersion#auth_fail_action}
    */
    readonly authFailAction?: string;
    /**
    * Methods to restrict access to a URL based on login status. Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#login AppEngineFlexibleAppVersion#login}
    */
    readonly login?: string;
    /**
    * 30x code to use when performing redirects for the secure field. Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#redirect_http_response_code AppEngineFlexibleAppVersion#redirect_http_response_code}
    */
    readonly redirectHttpResponseCode?: string;
    /**
    * Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#security_level AppEngineFlexibleAppVersion#security_level}
    */
    readonly securityLevel?: string;
    /**
    * URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
  All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#url_regex AppEngineFlexibleAppVersion#url_regex}
    */
    readonly urlRegex?: string;
    /**
    * script block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#script AppEngineFlexibleAppVersion#script}
    */
    readonly script?: AppEngineFlexibleAppVersionHandlersScript;
    /**
    * static_files block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#static_files AppEngineFlexibleAppVersion#static_files}
    */
    readonly staticFiles?: AppEngineFlexibleAppVersionHandlersStaticFiles;
}
export declare function appEngineFlexibleAppVersionHandlersToTerraform(struct?: AppEngineFlexibleAppVersionHandlers | cdktf.IResolvable): any;
export interface AppEngineFlexibleAppVersionLivenessCheck {
    /**
    * Interval between health checks.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#check_interval AppEngineFlexibleAppVersion#check_interval}
    */
    readonly checkInterval?: string;
    /**
    * Number of consecutive failed checks required before considering the VM unhealthy. Default: 4.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#failure_threshold AppEngineFlexibleAppVersion#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#host AppEngineFlexibleAppVersion#host}
    */
    readonly host?: string;
    /**
    * The initial delay before starting to execute the checks. Default: "300s"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#initial_delay AppEngineFlexibleAppVersion#initial_delay}
    */
    readonly initialDelay?: string;
    /**
    * The request path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#path AppEngineFlexibleAppVersion#path}
    */
    readonly path: string;
    /**
    * Number of consecutive successful checks required before considering the VM healthy. Default: 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#success_threshold AppEngineFlexibleAppVersion#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Time before the check is considered failed. Default: "4s"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#timeout AppEngineFlexibleAppVersion#timeout}
    */
    readonly timeout?: string;
}
export declare function appEngineFlexibleAppVersionLivenessCheckToTerraform(struct?: AppEngineFlexibleAppVersionLivenessCheckOutputReference | AppEngineFlexibleAppVersionLivenessCheck): any;
export declare class AppEngineFlexibleAppVersionLivenessCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionLivenessCheck | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionLivenessCheck | undefined);
    private _checkInterval?;
    get checkInterval(): string;
    set checkInterval(value: string);
    resetCheckInterval(): void;
    get checkIntervalInput(): string | undefined;
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _initialDelay?;
    get initialDelay(): string;
    set initialDelay(value: string);
    resetInitialDelay(): void;
    get initialDelayInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionManualScaling {
    /**
    * Number of instances to assign to the service at the start.
  
  **Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
  Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#instances AppEngineFlexibleAppVersion#instances}
    */
    readonly instances: number;
}
export declare function appEngineFlexibleAppVersionManualScalingToTerraform(struct?: AppEngineFlexibleAppVersionManualScalingOutputReference | AppEngineFlexibleAppVersionManualScaling): any;
export declare class AppEngineFlexibleAppVersionManualScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionManualScaling | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionManualScaling | undefined);
    private _instances?;
    get instances(): number;
    set instances(value: number);
    get instancesInput(): number | undefined;
}
export interface AppEngineFlexibleAppVersionNetwork {
    /**
    * List of ports, or port pairs, to forward from the virtual machine to the application container.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#forwarded_ports AppEngineFlexibleAppVersion#forwarded_ports}
    */
    readonly forwardedPorts?: string[];
    /**
    * Tag to apply to the instance during creation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#instance_tag AppEngineFlexibleAppVersion#instance_tag}
    */
    readonly instanceTag?: string;
    /**
    * Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#name AppEngineFlexibleAppVersion#name}
    */
    readonly name: string;
    /**
    * Enable session affinity.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#session_affinity AppEngineFlexibleAppVersion#session_affinity}
    */
    readonly sessionAffinity?: boolean | cdktf.IResolvable;
    /**
    * Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.
  
  If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range.
  If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetworkName) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network.
  If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetworkName must be specified and the IP address is created from the IPCidrRange of the subnetwork.
  If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#subnetwork AppEngineFlexibleAppVersion#subnetwork}
    */
    readonly subnetwork?: string;
}
export declare function appEngineFlexibleAppVersionNetworkToTerraform(struct?: AppEngineFlexibleAppVersionNetworkOutputReference | AppEngineFlexibleAppVersionNetwork): any;
export declare class AppEngineFlexibleAppVersionNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionNetwork | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionNetwork | undefined);
    private _forwardedPorts?;
    get forwardedPorts(): string[];
    set forwardedPorts(value: string[]);
    resetForwardedPorts(): void;
    get forwardedPortsInput(): string[] | undefined;
    private _instanceTag?;
    get instanceTag(): string;
    set instanceTag(value: string);
    resetInstanceTag(): void;
    get instanceTagInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sessionAffinity?;
    get sessionAffinity(): boolean | cdktf.IResolvable;
    set sessionAffinity(value: boolean | cdktf.IResolvable);
    resetSessionAffinity(): void;
    get sessionAffinityInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionReadinessCheck {
    /**
    * A maximum time limit on application initialization, measured from moment the application successfully
  replies to a healthcheck until it is ready to serve traffic. Default: "300s"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#app_start_timeout AppEngineFlexibleAppVersion#app_start_timeout}
    */
    readonly appStartTimeout?: string;
    /**
    * Interval between health checks.  Default: "5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#check_interval AppEngineFlexibleAppVersion#check_interval}
    */
    readonly checkInterval?: string;
    /**
    * Number of consecutive failed checks required before removing traffic. Default: 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#failure_threshold AppEngineFlexibleAppVersion#failure_threshold}
    */
    readonly failureThreshold?: number;
    /**
    * Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#host AppEngineFlexibleAppVersion#host}
    */
    readonly host?: string;
    /**
    * The request path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#path AppEngineFlexibleAppVersion#path}
    */
    readonly path: string;
    /**
    * Number of consecutive successful checks required before receiving traffic. Default: 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#success_threshold AppEngineFlexibleAppVersion#success_threshold}
    */
    readonly successThreshold?: number;
    /**
    * Time before the check is considered failed. Default: "4s"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#timeout AppEngineFlexibleAppVersion#timeout}
    */
    readonly timeout?: string;
}
export declare function appEngineFlexibleAppVersionReadinessCheckToTerraform(struct?: AppEngineFlexibleAppVersionReadinessCheckOutputReference | AppEngineFlexibleAppVersionReadinessCheck): any;
export declare class AppEngineFlexibleAppVersionReadinessCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionReadinessCheck | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionReadinessCheck | undefined);
    private _appStartTimeout?;
    get appStartTimeout(): string;
    set appStartTimeout(value: string);
    resetAppStartTimeout(): void;
    get appStartTimeoutInput(): string | undefined;
    private _checkInterval?;
    get checkInterval(): string;
    set checkInterval(value: string);
    resetCheckInterval(): void;
    get checkIntervalInput(): string | undefined;
    private _failureThreshold?;
    get failureThreshold(): number;
    set failureThreshold(value: number);
    resetFailureThreshold(): void;
    get failureThresholdInput(): number | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _successThreshold?;
    get successThreshold(): number;
    set successThreshold(value: number);
    resetSuccessThreshold(): void;
    get successThresholdInput(): number | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionResourcesVolumes {
    /**
    * Unique name for the volume.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#name AppEngineFlexibleAppVersion#name}
    */
    readonly name: string;
    /**
    * Volume size in gigabytes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#size_gb AppEngineFlexibleAppVersion#size_gb}
    */
    readonly sizeGb: number;
    /**
    * Underlying volume type, e.g. 'tmpfs'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#volume_type AppEngineFlexibleAppVersion#volume_type}
    */
    readonly volumeType: string;
}
export declare function appEngineFlexibleAppVersionResourcesVolumesToTerraform(struct?: AppEngineFlexibleAppVersionResourcesVolumes | cdktf.IResolvable): any;
export interface AppEngineFlexibleAppVersionResources {
    /**
    * Number of CPU cores needed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#cpu AppEngineFlexibleAppVersion#cpu}
    */
    readonly cpu?: number;
    /**
    * Disk size (GB) needed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#disk_gb AppEngineFlexibleAppVersion#disk_gb}
    */
    readonly diskGb?: number;
    /**
    * Memory (GB) needed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#memory_gb AppEngineFlexibleAppVersion#memory_gb}
    */
    readonly memoryGb?: number;
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#volumes AppEngineFlexibleAppVersion#volumes}
    */
    readonly volumes?: AppEngineFlexibleAppVersionResourcesVolumes[] | cdktf.IResolvable;
}
export declare function appEngineFlexibleAppVersionResourcesToTerraform(struct?: AppEngineFlexibleAppVersionResourcesOutputReference | AppEngineFlexibleAppVersionResources): any;
export declare class AppEngineFlexibleAppVersionResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionResources | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionResources | undefined);
    private _cpu?;
    get cpu(): number;
    set cpu(value: number);
    resetCpu(): void;
    get cpuInput(): number | undefined;
    private _diskGb?;
    get diskGb(): number;
    set diskGb(value: number);
    resetDiskGb(): void;
    get diskGbInput(): number | undefined;
    private _memoryGb?;
    get memoryGb(): number;
    set memoryGb(value: number);
    resetMemoryGb(): void;
    get memoryGbInput(): number | undefined;
    private _volumes?;
    get volumes(): AppEngineFlexibleAppVersionResourcesVolumes[] | cdktf.IResolvable;
    set volumes(value: AppEngineFlexibleAppVersionResourcesVolumes[] | cdktf.IResolvable);
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | AppEngineFlexibleAppVersionResourcesVolumes[] | undefined;
}
export interface AppEngineFlexibleAppVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#create AppEngineFlexibleAppVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#delete AppEngineFlexibleAppVersion#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#update AppEngineFlexibleAppVersion#update}
    */
    readonly update?: string;
}
export declare function appEngineFlexibleAppVersionTimeoutsToTerraform(struct?: AppEngineFlexibleAppVersionTimeoutsOutputReference | AppEngineFlexibleAppVersionTimeouts | cdktf.IResolvable): any;
export declare class AppEngineFlexibleAppVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionTimeouts | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface AppEngineFlexibleAppVersionVpcAccessConnector {
    /**
    * Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#name AppEngineFlexibleAppVersion#name}
    */
    readonly name: string;
}
export declare function appEngineFlexibleAppVersionVpcAccessConnectorToTerraform(struct?: AppEngineFlexibleAppVersionVpcAccessConnectorOutputReference | AppEngineFlexibleAppVersionVpcAccessConnector): any;
export declare class AppEngineFlexibleAppVersionVpcAccessConnectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppEngineFlexibleAppVersionVpcAccessConnector | undefined;
    set internalValue(value: AppEngineFlexibleAppVersionVpcAccessConnector | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version google_app_engine_flexible_app_version}
*/
export declare class AppEngineFlexibleAppVersion extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version google_app_engine_flexible_app_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppEngineFlexibleAppVersionConfig
    */
    constructor(scope: Construct, id: string, config: AppEngineFlexibleAppVersionConfig);
    private _betaSettings?;
    get betaSettings(): {
        [key: string]: string;
    };
    set betaSettings(value: {
        [key: string]: string;
    });
    resetBetaSettings(): void;
    get betaSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultExpiration?;
    get defaultExpiration(): string;
    set defaultExpiration(value: string);
    resetDefaultExpiration(): void;
    get defaultExpirationInput(): string | undefined;
    private _deleteServiceOnDestroy?;
    get deleteServiceOnDestroy(): boolean | cdktf.IResolvable;
    set deleteServiceOnDestroy(value: boolean | cdktf.IResolvable);
    resetDeleteServiceOnDestroy(): void;
    get deleteServiceOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _envVariables?;
    get envVariables(): {
        [key: string]: string;
    };
    set envVariables(value: {
        [key: string]: string;
    });
    resetEnvVariables(): void;
    get envVariablesInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _inboundServices?;
    get inboundServices(): string[];
    set inboundServices(value: string[]);
    resetInboundServices(): void;
    get inboundServicesInput(): string[] | undefined;
    private _instanceClass?;
    get instanceClass(): string;
    set instanceClass(value: string);
    resetInstanceClass(): void;
    get instanceClassInput(): string | undefined;
    get name(): string;
    private _nobuildFilesRegex?;
    get nobuildFilesRegex(): string;
    set nobuildFilesRegex(value: string);
    resetNobuildFilesRegex(): void;
    get nobuildFilesRegexInput(): string | undefined;
    private _noopOnDestroy?;
    get noopOnDestroy(): boolean | cdktf.IResolvable;
    set noopOnDestroy(value: boolean | cdktf.IResolvable);
    resetNoopOnDestroy(): void;
    get noopOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _runtime?;
    get runtime(): string;
    set runtime(value: string);
    get runtimeInput(): string | undefined;
    private _runtimeApiVersion?;
    get runtimeApiVersion(): string;
    set runtimeApiVersion(value: string);
    resetRuntimeApiVersion(): void;
    get runtimeApiVersionInput(): string | undefined;
    private _runtimeChannel?;
    get runtimeChannel(): string;
    set runtimeChannel(value: string);
    resetRuntimeChannel(): void;
    get runtimeChannelInput(): string | undefined;
    private _runtimeMainExecutablePath?;
    get runtimeMainExecutablePath(): string;
    set runtimeMainExecutablePath(value: string);
    resetRuntimeMainExecutablePath(): void;
    get runtimeMainExecutablePathInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _servingStatus?;
    get servingStatus(): string;
    set servingStatus(value: string);
    resetServingStatus(): void;
    get servingStatusInput(): string | undefined;
    private _versionId?;
    get versionId(): string;
    set versionId(value: string);
    resetVersionId(): void;
    get versionIdInput(): string | undefined;
    private _apiConfig;
    get apiConfig(): AppEngineFlexibleAppVersionApiConfigOutputReference;
    putApiConfig(value: AppEngineFlexibleAppVersionApiConfig): void;
    resetApiConfig(): void;
    get apiConfigInput(): AppEngineFlexibleAppVersionApiConfig | undefined;
    private _automaticScaling;
    get automaticScaling(): AppEngineFlexibleAppVersionAutomaticScalingOutputReference;
    putAutomaticScaling(value: AppEngineFlexibleAppVersionAutomaticScaling): void;
    resetAutomaticScaling(): void;
    get automaticScalingInput(): AppEngineFlexibleAppVersionAutomaticScaling | undefined;
    private _deployment;
    get deployment(): AppEngineFlexibleAppVersionDeploymentOutputReference;
    putDeployment(value: AppEngineFlexibleAppVersionDeployment): void;
    resetDeployment(): void;
    get deploymentInput(): AppEngineFlexibleAppVersionDeployment | undefined;
    private _endpointsApiService;
    get endpointsApiService(): AppEngineFlexibleAppVersionEndpointsApiServiceOutputReference;
    putEndpointsApiService(value: AppEngineFlexibleAppVersionEndpointsApiService): void;
    resetEndpointsApiService(): void;
    get endpointsApiServiceInput(): AppEngineFlexibleAppVersionEndpointsApiService | undefined;
    private _entrypoint;
    get entrypoint(): AppEngineFlexibleAppVersionEntrypointOutputReference;
    putEntrypoint(value: AppEngineFlexibleAppVersionEntrypoint): void;
    resetEntrypoint(): void;
    get entrypointInput(): AppEngineFlexibleAppVersionEntrypoint | undefined;
    private _handlers?;
    get handlers(): AppEngineFlexibleAppVersionHandlers[] | cdktf.IResolvable;
    set handlers(value: AppEngineFlexibleAppVersionHandlers[] | cdktf.IResolvable);
    resetHandlers(): void;
    get handlersInput(): cdktf.IResolvable | AppEngineFlexibleAppVersionHandlers[] | undefined;
    private _livenessCheck;
    get livenessCheck(): AppEngineFlexibleAppVersionLivenessCheckOutputReference;
    putLivenessCheck(value: AppEngineFlexibleAppVersionLivenessCheck): void;
    get livenessCheckInput(): AppEngineFlexibleAppVersionLivenessCheck | undefined;
    private _manualScaling;
    get manualScaling(): AppEngineFlexibleAppVersionManualScalingOutputReference;
    putManualScaling(value: AppEngineFlexibleAppVersionManualScaling): void;
    resetManualScaling(): void;
    get manualScalingInput(): AppEngineFlexibleAppVersionManualScaling | undefined;
    private _network;
    get network(): AppEngineFlexibleAppVersionNetworkOutputReference;
    putNetwork(value: AppEngineFlexibleAppVersionNetwork): void;
    resetNetwork(): void;
    get networkInput(): AppEngineFlexibleAppVersionNetwork | undefined;
    private _readinessCheck;
    get readinessCheck(): AppEngineFlexibleAppVersionReadinessCheckOutputReference;
    putReadinessCheck(value: AppEngineFlexibleAppVersionReadinessCheck): void;
    get readinessCheckInput(): AppEngineFlexibleAppVersionReadinessCheck | undefined;
    private _resources;
    get resources(): AppEngineFlexibleAppVersionResourcesOutputReference;
    putResources(value: AppEngineFlexibleAppVersionResources): void;
    resetResources(): void;
    get resourcesInput(): AppEngineFlexibleAppVersionResources | undefined;
    private _timeouts;
    get timeouts(): AppEngineFlexibleAppVersionTimeoutsOutputReference;
    putTimeouts(value: AppEngineFlexibleAppVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppEngineFlexibleAppVersionTimeouts | undefined;
    private _vpcAccessConnector;
    get vpcAccessConnector(): AppEngineFlexibleAppVersionVpcAccessConnectorOutputReference;
    putVpcAccessConnector(value: AppEngineFlexibleAppVersionVpcAccessConnector): void;
    resetVpcAccessConnector(): void;
    get vpcAccessConnectorInput(): AppEngineFlexibleAppVersionVpcAccessConnector | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
