import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudiotDeviceConfig extends cdktf.TerraformMetaArguments {
    /**
    * If a device is blocked, connections or requests from this device will fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#blocked CloudiotDevice#blocked}
    */
    readonly blocked?: boolean | cdktf.IResolvable;
    /**
    * The logging verbosity for device activity. Possible values: ["NONE", "ERROR", "INFO", "DEBUG"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#log_level CloudiotDevice#log_level}
    */
    readonly logLevel?: string;
    /**
    * The metadata key-value pairs assigned to the device.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#metadata CloudiotDevice#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * A unique name for the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#name CloudiotDevice#name}
    */
    readonly name: string;
    /**
    * The name of the device registry where this device should be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#registry CloudiotDevice#registry}
    */
    readonly registry: string;
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#credentials CloudiotDevice#credentials}
    */
    readonly credentials?: CloudiotDeviceCredentials[] | cdktf.IResolvable;
    /**
    * gateway_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#gateway_config CloudiotDevice#gateway_config}
    */
    readonly gatewayConfig?: CloudiotDeviceGatewayConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#timeouts CloudiotDevice#timeouts}
    */
    readonly timeouts?: CloudiotDeviceTimeouts;
}
export declare class CloudiotDeviceConfigA extends cdktf.ComplexComputedList {
    get binaryData(): string;
    get cloudUpdateTime(): string;
    get deviceAckTime(): string;
    get version(): string;
}
export declare class CloudiotDeviceLastErrorStatus extends cdktf.ComplexComputedList {
    get details(): {
        [key: string]: string;
    };
    get message(): string;
    get number(): number;
}
export declare class CloudiotDeviceState extends cdktf.ComplexComputedList {
    get binaryData(): string;
    get updateTime(): string;
}
export interface CloudiotDeviceCredentialsPublicKey {
    /**
    * The format of the key. Possible values: ["RSA_PEM", "RSA_X509_PEM", "ES256_PEM", "ES256_X509_PEM"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#format CloudiotDevice#format}
    */
    readonly format: string;
    /**
    * The key data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#key CloudiotDevice#key}
    */
    readonly key: string;
}
export declare function cloudiotDeviceCredentialsPublicKeyToTerraform(struct?: CloudiotDeviceCredentialsPublicKeyOutputReference | CloudiotDeviceCredentialsPublicKey): any;
export declare class CloudiotDeviceCredentialsPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudiotDeviceCredentialsPublicKey | undefined;
    set internalValue(value: CloudiotDeviceCredentialsPublicKey | undefined);
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export interface CloudiotDeviceCredentials {
    /**
    * The time at which this credential becomes invalid.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#expiration_time CloudiotDevice#expiration_time}
    */
    readonly expirationTime?: string;
    /**
    * public_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#public_key CloudiotDevice#public_key}
    */
    readonly publicKey: CloudiotDeviceCredentialsPublicKey;
}
export declare function cloudiotDeviceCredentialsToTerraform(struct?: CloudiotDeviceCredentials | cdktf.IResolvable): any;
export interface CloudiotDeviceGatewayConfig {
    /**
    * Indicates whether the device is a gateway. Possible values: ["ASSOCIATION_ONLY", "DEVICE_AUTH_TOKEN_ONLY", "ASSOCIATION_AND_DEVICE_AUTH_TOKEN"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#gateway_auth_method CloudiotDevice#gateway_auth_method}
    */
    readonly gatewayAuthMethod?: string;
    /**
    * Indicates whether the device is a gateway. Default value: "NON_GATEWAY" Possible values: ["GATEWAY", "NON_GATEWAY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#gateway_type CloudiotDevice#gateway_type}
    */
    readonly gatewayType?: string;
}
export declare function cloudiotDeviceGatewayConfigToTerraform(struct?: CloudiotDeviceGatewayConfigOutputReference | CloudiotDeviceGatewayConfig): any;
export declare class CloudiotDeviceGatewayConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudiotDeviceGatewayConfig | undefined;
    set internalValue(value: CloudiotDeviceGatewayConfig | undefined);
    private _gatewayAuthMethod?;
    get gatewayAuthMethod(): string;
    set gatewayAuthMethod(value: string);
    resetGatewayAuthMethod(): void;
    get gatewayAuthMethodInput(): string | undefined;
    private _gatewayType?;
    get gatewayType(): string;
    set gatewayType(value: string);
    resetGatewayType(): void;
    get gatewayTypeInput(): string | undefined;
    get lastAccessedGatewayId(): string;
    get lastAccessedGatewayTime(): string;
}
export interface CloudiotDeviceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#create CloudiotDevice#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#delete CloudiotDevice#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device#update CloudiotDevice#update}
    */
    readonly update?: string;
}
export declare function cloudiotDeviceTimeoutsToTerraform(struct?: CloudiotDeviceTimeoutsOutputReference | CloudiotDeviceTimeouts | cdktf.IResolvable): any;
export declare class CloudiotDeviceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudiotDeviceTimeouts | undefined;
    set internalValue(value: CloudiotDeviceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device google_cloudiot_device}
*/
export declare class CloudiotDevice extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudiot_device google_cloudiot_device} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudiotDeviceConfig
    */
    constructor(scope: Construct, id: string, config: CloudiotDeviceConfig);
    private _blocked?;
    get blocked(): boolean | cdktf.IResolvable;
    set blocked(value: boolean | cdktf.IResolvable);
    resetBlocked(): void;
    get blockedInput(): boolean | cdktf.IResolvable | undefined;
    config(index: string): CloudiotDeviceConfigA;
    get id(): string;
    get lastConfigAckTime(): string;
    get lastConfigSendTime(): string;
    lastErrorStatus(index: string): CloudiotDeviceLastErrorStatus;
    get lastErrorTime(): string;
    get lastEventTime(): string;
    get lastHeartbeatTime(): string;
    get lastStateTime(): string;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get numId(): string;
    private _registry?;
    get registry(): string;
    set registry(value: string);
    get registryInput(): string | undefined;
    state(index: string): CloudiotDeviceState;
    private _credentials?;
    get credentials(): CloudiotDeviceCredentials[] | cdktf.IResolvable;
    set credentials(value: CloudiotDeviceCredentials[] | cdktf.IResolvable);
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | CloudiotDeviceCredentials[] | undefined;
    private _gatewayConfig;
    get gatewayConfig(): CloudiotDeviceGatewayConfigOutputReference;
    putGatewayConfig(value: CloudiotDeviceGatewayConfig): void;
    resetGatewayConfig(): void;
    get gatewayConfigInput(): CloudiotDeviceGatewayConfig | undefined;
    private _timeouts;
    get timeouts(): CloudiotDeviceTimeoutsOutputReference;
    putTimeouts(value: CloudiotDeviceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudiotDeviceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
