import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRouterPeerConfig extends cdktf.TerraformMetaArguments {
    /**
    * User-specified flag to indicate which mode to use for advertisement.
  Valid values of this enum field are: 'DEFAULT', 'CUSTOM' Default value: "DEFAULT" Possible values: ["DEFAULT", "CUSTOM"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertise_mode ComputeRouterPeer#advertise_mode}
    */
    readonly advertiseMode?: string;
    /**
    * User-specified list of prefix groups to advertise in custom
  mode, which can take one of the following options:
  
  * 'ALL_SUBNETS': Advertises all available subnets, including peer VPC subnets.
  * 'ALL_VPC_SUBNETS': Advertises the router's own VPC subnets.
  * 'ALL_PEER_VPC_SUBNETS': Advertises peer subnets of the router's VPC network.
  
  
  Note that this field can only be populated if advertiseMode is 'CUSTOM'
  and overrides the list defined for the router (in the "bgp" message).
  These groups are advertised in addition to any specified prefixes.
  Leave this field blank to advertise no custom groups.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_groups ComputeRouterPeer#advertised_groups}
    */
    readonly advertisedGroups?: string[];
    /**
    * The priority of routes advertised to this BGP peer.
  Where there is more than one matching route of maximum
  length, the routes with the lowest priority value win.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_route_priority ComputeRouterPeer#advertised_route_priority}
    */
    readonly advertisedRoutePriority?: number;
    /**
    * The status of the BGP peer connection. If set to false, any active session
  with the peer is terminated and all associated routing information is removed.
  If set to true, the peer connection can be established with routing information.
  The default is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#enable ComputeRouterPeer#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
    /**
    * Name of the interface the BGP peer is associated with.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#interface ComputeRouterPeer#interface}
    */
    readonly interface: string;
    /**
    * IP address of the interface inside Google Cloud Platform.
  Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#ip_address ComputeRouterPeer#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Name of this BGP peer. The name must be 1-63 characters long,
  and comply with RFC1035. Specifically, the name must be 1-63 characters
  long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which
  means the first character must be a lowercase letter, and all
  following characters must be a dash, lowercase letter, or digit,
  except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#name ComputeRouterPeer#name}
    */
    readonly name: string;
    /**
    * Peer BGP Autonomous System Number (ASN).
  Each BGP interface may use a different value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#peer_asn ComputeRouterPeer#peer_asn}
    */
    readonly peerAsn: number;
    /**
    * IP address of the BGP interface outside Google Cloud Platform.
  Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#peer_ip_address ComputeRouterPeer#peer_ip_address}
    */
    readonly peerIpAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#project ComputeRouterPeer#project}
    */
    readonly project?: string;
    /**
    * Region where the router and BgpPeer reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#region ComputeRouterPeer#region}
    */
    readonly region?: string;
    /**
    * The name of the Cloud Router in which this BgpPeer will be configured.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#router ComputeRouterPeer#router}
    */
    readonly router: string;
    /**
    * advertised_ip_ranges block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#advertised_ip_ranges ComputeRouterPeer#advertised_ip_ranges}
    */
    readonly advertisedIpRanges?: ComputeRouterPeerAdvertisedIpRanges[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#timeouts ComputeRouterPeer#timeouts}
    */
    readonly timeouts?: ComputeRouterPeerTimeouts;
}
export interface ComputeRouterPeerAdvertisedIpRanges {
    /**
    * User-specified description for the IP range.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#description ComputeRouterPeer#description}
    */
    readonly description?: string;
    /**
    * The IP range to advertise. The value must be a
  CIDR-formatted string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#range ComputeRouterPeer#range}
    */
    readonly range: string;
}
export declare function computeRouterPeerAdvertisedIpRangesToTerraform(struct?: ComputeRouterPeerAdvertisedIpRanges | cdktf.IResolvable): any;
export interface ComputeRouterPeerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#create ComputeRouterPeer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#delete ComputeRouterPeer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer#update ComputeRouterPeer#update}
    */
    readonly update?: string;
}
export declare function computeRouterPeerTimeoutsToTerraform(struct?: ComputeRouterPeerTimeoutsOutputReference | ComputeRouterPeerTimeouts | cdktf.IResolvable): any;
export declare class ComputeRouterPeerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeRouterPeerTimeouts | undefined;
    set internalValue(value: ComputeRouterPeerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer google_compute_router_peer}
*/
export declare class ComputeRouterPeer extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_router_peer google_compute_router_peer} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeRouterPeerConfig
    */
    constructor(scope: Construct, id: string, config: ComputeRouterPeerConfig);
    private _advertiseMode?;
    get advertiseMode(): string;
    set advertiseMode(value: string);
    resetAdvertiseMode(): void;
    get advertiseModeInput(): string | undefined;
    private _advertisedGroups?;
    get advertisedGroups(): string[];
    set advertisedGroups(value: string[]);
    resetAdvertisedGroups(): void;
    get advertisedGroupsInput(): string[] | undefined;
    private _advertisedRoutePriority?;
    get advertisedRoutePriority(): number;
    set advertisedRoutePriority(value: number);
    resetAdvertisedRoutePriority(): void;
    get advertisedRoutePriorityInput(): number | undefined;
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _interface?;
    get interface(): string;
    set interface(value: string);
    get interfaceInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    get managementType(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _peerAsn?;
    get peerAsn(): number;
    set peerAsn(value: number);
    get peerAsnInput(): number | undefined;
    private _peerIpAddress?;
    get peerIpAddress(): string;
    set peerIpAddress(value: string);
    get peerIpAddressInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _router?;
    get router(): string;
    set router(value: string);
    get routerInput(): string | undefined;
    private _advertisedIpRanges?;
    get advertisedIpRanges(): ComputeRouterPeerAdvertisedIpRanges[] | cdktf.IResolvable;
    set advertisedIpRanges(value: ComputeRouterPeerAdvertisedIpRanges[] | cdktf.IResolvable);
    resetAdvertisedIpRanges(): void;
    get advertisedIpRangesInput(): cdktf.IResolvable | ComputeRouterPeerAdvertisedIpRanges[] | undefined;
    private _timeouts;
    get timeouts(): ComputeRouterPeerTimeoutsOutputReference;
    putTimeouts(value: ComputeRouterPeerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRouterPeerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
