import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_gateway#description ComputeVpnGateway#description}
    */
    readonly description?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_gateway#name ComputeVpnGateway#name}
    */
    readonly name: string;
    /**
    * The network this VPN gateway is accepting traffic for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_gateway#network ComputeVpnGateway#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_gateway#project ComputeVpnGateway#project}
    */
    readonly project?: string;
    /**
    * The region this gateway should sit in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_gateway#region ComputeVpnGateway#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_gateway#timeouts ComputeVpnGateway#timeouts}
    */
    readonly timeouts?: ComputeVpnGatewayTimeouts;
}
export interface ComputeVpnGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_gateway#create ComputeVpnGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_gateway#delete ComputeVpnGateway#delete}
    */
    readonly delete?: string;
}
export declare function computeVpnGatewayTimeoutsToTerraform(struct?: ComputeVpnGatewayTimeoutsOutputReference | ComputeVpnGatewayTimeouts | cdktf.IResolvable): any;
export declare class ComputeVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ComputeVpnGatewayTimeouts | undefined;
    set internalValue(value: ComputeVpnGatewayTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_gateway google_compute_vpn_gateway}
*/
export declare class ComputeVpnGateway extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_vpn_gateway google_compute_vpn_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeVpnGatewayConfig
    */
    constructor(scope: Construct, id: string, config: ComputeVpnGatewayConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get gatewayId(): number;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): ComputeVpnGatewayTimeoutsOutputReference;
    putTimeouts(value: ComputeVpnGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeVpnGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
