import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogTagTemplateIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy#policy_data DataCatalogTagTemplateIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy#project DataCatalogTagTemplateIamPolicy#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy#region DataCatalogTagTemplateIamPolicy#region}
    */
    readonly region?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy#tag_template DataCatalogTagTemplateIamPolicy#tag_template}
    */
    readonly tagTemplate: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy google_data_catalog_tag_template_iam_policy}
*/
export declare class DataCatalogTagTemplateIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_tag_template_iam_policy google_data_catalog_tag_template_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCatalogTagTemplateIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataCatalogTagTemplateIamPolicyConfig);
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _tagTemplate?;
    get tagTemplate(): string;
    set tagTemplate(value: string);
    get tagTemplateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
