import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeBackendServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service#name DataGoogleComputeBackendService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service#project DataGoogleComputeBackendService#project}
    */
    readonly project?: string;
}
export declare class DataGoogleComputeBackendServiceBackend extends cdktf.ComplexComputedList {
    get balancingMode(): string;
    get capacityScaler(): number;
    get description(): string;
    get group(): string;
    get maxConnections(): number;
    get maxConnectionsPerEndpoint(): number;
    get maxConnectionsPerInstance(): number;
    get maxRate(): number;
    get maxRatePerEndpoint(): number;
    get maxRatePerInstance(): number;
    get maxUtilization(): number;
}
export declare class DataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicy extends cdktf.ComplexComputedList {
    get includeHost(): cdktf.IResolvable;
    get includeProtocol(): cdktf.IResolvable;
    get includeQueryString(): cdktf.IResolvable;
    get queryStringBlacklist(): string[];
    get queryStringWhitelist(): string[];
}
export declare class DataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicy extends cdktf.ComplexComputedList {
    get code(): number;
    get ttl(): number;
}
export declare class DataGoogleComputeBackendServiceCdnPolicy extends cdktf.ComplexComputedList {
    get cacheKeyPolicy(): cdktf.IResolvable;
    get cacheMode(): string;
    get clientTtl(): number;
    get defaultTtl(): number;
    get maxTtl(): number;
    get negativeCaching(): cdktf.IResolvable;
    get negativeCachingPolicy(): cdktf.IResolvable;
    get serveWhileStale(): number;
    get signedUrlCacheMaxAgeSec(): number;
}
export declare class DataGoogleComputeBackendServiceCircuitBreakers extends cdktf.ComplexComputedList {
    get maxConnections(): number;
    get maxPendingRequests(): number;
    get maxRequests(): number;
    get maxRequestsPerConnection(): number;
    get maxRetries(): number;
}
export declare class DataGoogleComputeBackendServiceConsistentHashHttpCookieTtl extends cdktf.ComplexComputedList {
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleComputeBackendServiceConsistentHashHttpCookie extends cdktf.ComplexComputedList {
    get name(): string;
    get path(): string;
    get ttl(): cdktf.IResolvable;
}
export declare class DataGoogleComputeBackendServiceConsistentHash extends cdktf.ComplexComputedList {
    get httpCookie(): cdktf.IResolvable;
    get httpHeaderName(): string;
    get minimumRingSize(): number;
}
export declare class DataGoogleComputeBackendServiceIap extends cdktf.ComplexComputedList {
    get oauth2ClientId(): string;
    get oauth2ClientSecret(): string;
    get oauth2ClientSecretSha256(): string;
}
export declare class DataGoogleComputeBackendServiceLogConfig extends cdktf.ComplexComputedList {
    get enable(): cdktf.IResolvable;
    get sampleRate(): number;
}
export declare class DataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTime extends cdktf.ComplexComputedList {
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleComputeBackendServiceOutlierDetectionInterval extends cdktf.ComplexComputedList {
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleComputeBackendServiceOutlierDetection extends cdktf.ComplexComputedList {
    get baseEjectionTime(): cdktf.IResolvable;
    get consecutiveErrors(): number;
    get consecutiveGatewayFailure(): number;
    get enforcingConsecutiveErrors(): number;
    get enforcingConsecutiveGatewayFailure(): number;
    get enforcingSuccessRate(): number;
    get interval(): cdktf.IResolvable;
    get maxEjectionPercent(): number;
    get successRateMinimumHosts(): number;
    get successRateRequestVolume(): number;
    get successRateStdevFactor(): number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service google_compute_backend_service}
*/
export declare class DataGoogleComputeBackendService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service google_compute_backend_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeBackendServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeBackendServiceConfig);
    get affinityCookieTtlSec(): number;
    backend(index: string): DataGoogleComputeBackendServiceBackend;
    cdnPolicy(index: string): DataGoogleComputeBackendServiceCdnPolicy;
    circuitBreakers(index: string): DataGoogleComputeBackendServiceCircuitBreakers;
    get connectionDrainingTimeoutSec(): number;
    consistentHash(index: string): DataGoogleComputeBackendServiceConsistentHash;
    get creationTimestamp(): string;
    get customRequestHeaders(): string[];
    get customResponseHeaders(): string[];
    get description(): string;
    get enableCdn(): cdktf.IResolvable;
    get fingerprint(): string;
    get healthChecks(): string[];
    iap(index: string): DataGoogleComputeBackendServiceIap;
    get id(): string;
    get loadBalancingScheme(): string;
    get localityLbPolicy(): string;
    logConfig(index: string): DataGoogleComputeBackendServiceLogConfig;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    outlierDetection(index: string): DataGoogleComputeBackendServiceOutlierDetection;
    get portName(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get protocol(): string;
    get securityPolicy(): string;
    get selfLink(): string;
    get sessionAffinity(): string;
    get timeoutSec(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
