import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGooglePubsubTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic#name DataGooglePubsubTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic#project DataGooglePubsubTopic#project}
    */
    readonly project?: string;
}
export declare class DataGooglePubsubTopicMessageStoragePolicy extends cdktf.ComplexComputedList {
    get allowedPersistenceRegions(): string[];
}
export declare class DataGooglePubsubTopicSchemaSettings extends cdktf.ComplexComputedList {
    get encoding(): string;
    get schema(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic google_pubsub_topic}
*/
export declare class DataGooglePubsubTopic extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic google_pubsub_topic} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGooglePubsubTopicConfig
    */
    constructor(scope: Construct, id: string, config: DataGooglePubsubTopicConfig);
    get id(): string;
    get kmsKeyName(): string;
    labels(key: string): string | cdktf.IResolvable;
    messageStoragePolicy(index: string): DataGooglePubsubTopicMessageStoragePolicy;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    schemaSettings(index: string): DataGooglePubsubTopicSchemaSettings;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
