import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSecretManagerSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret#project DataGoogleSecretManagerSecret#project}
    */
    readonly project?: string;
    /**
    * This must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret#secret_id DataGoogleSecretManagerSecret#secret_id}
    */
    readonly secretId: string;
}
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption extends cdktf.ComplexComputedList {
    get kmsKeyName(): string;
}
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicas extends cdktf.ComplexComputedList {
    get customerManagedEncryption(): cdktf.IResolvable;
    get location(): string;
}
export declare class DataGoogleSecretManagerSecretReplicationUserManaged extends cdktf.ComplexComputedList {
    get replicas(): cdktf.IResolvable;
}
export declare class DataGoogleSecretManagerSecretReplication extends cdktf.ComplexComputedList {
    get automatic(): cdktf.IResolvable;
    get userManaged(): cdktf.IResolvable;
}
export declare class DataGoogleSecretManagerSecretRotation extends cdktf.ComplexComputedList {
    get nextRotationTime(): string;
    get rotationPeriod(): string;
}
export declare class DataGoogleSecretManagerSecretTopics extends cdktf.ComplexComputedList {
    get name(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret google_secret_manager_secret}
*/
export declare class DataGoogleSecretManagerSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret google_secret_manager_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSecretManagerSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSecretManagerSecretConfig);
    get createTime(): string;
    get expireTime(): string;
    get id(): string;
    labels(key: string): string | cdktf.IResolvable;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    replication(index: string): DataGoogleSecretManagerSecretReplication;
    rotation(index: string): DataGoogleSecretManagerSecretRotation;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    topics(index: string): DataGoogleSecretManagerSecretTopics;
    get ttl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
