import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GameServicesGameServerConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * A unique id for the deployment config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#config_id GameServicesGameServerConfig#config_id}
    */
    readonly configId: string;
    /**
    * A unique id for the deployment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#deployment_id GameServicesGameServerConfig#deployment_id}
    */
    readonly deploymentId: string;
    /**
    * The description of the game server config.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#description GameServicesGameServerConfig#description}
    */
    readonly description?: string;
    /**
    * The labels associated with this game server config. Each label is a
  key-value pair.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#labels GameServicesGameServerConfig#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Location of the Deployment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#location GameServicesGameServerConfig#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#project GameServicesGameServerConfig#project}
    */
    readonly project?: string;
    /**
    * fleet_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#fleet_configs GameServicesGameServerConfig#fleet_configs}
    */
    readonly fleetConfigs: GameServicesGameServerConfigFleetConfigs[] | cdktf.IResolvable;
    /**
    * scaling_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#scaling_configs GameServicesGameServerConfig#scaling_configs}
    */
    readonly scalingConfigs?: GameServicesGameServerConfigScalingConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#timeouts GameServicesGameServerConfig#timeouts}
    */
    readonly timeouts?: GameServicesGameServerConfigTimeouts;
}
export interface GameServicesGameServerConfigFleetConfigs {
    /**
    * The fleet spec, which is sent to Agones to configure fleet.
  The spec can be passed as inline json but it is recommended to use a file reference
  instead. File references can contain the json or yaml format of the fleet spec. Eg:
  
  * fleet_spec = jsonencode(yamldecode(file("fleet_configs.yaml")))
  * fleet_spec = file("fleet_configs.json")
  
  The format of the spec can be found :
  'https://agones.dev/site/docs/reference/fleet/'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#fleet_spec GameServicesGameServerConfig#fleet_spec}
    */
    readonly fleetSpec: string;
    /**
    * The name of the FleetConfig.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#name GameServicesGameServerConfig#name}
    */
    readonly name?: string;
}
export declare function gameServicesGameServerConfigFleetConfigsToTerraform(struct?: GameServicesGameServerConfigFleetConfigs | cdktf.IResolvable): any;
export interface GameServicesGameServerConfigScalingConfigsSchedules {
    /**
    * The duration for the cron job event. The duration of the event is effective
  after the cron job's start time.
  
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#cron_job_duration GameServicesGameServerConfig#cron_job_duration}
    */
    readonly cronJobDuration?: string;
    /**
    * The cron definition of the scheduled event. See
  https://en.wikipedia.org/wiki/Cron. Cron spec specifies the local time as
  defined by the realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#cron_spec GameServicesGameServerConfig#cron_spec}
    */
    readonly cronSpec?: string;
    /**
    * The end time of the event.
  
  A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#end_time GameServicesGameServerConfig#end_time}
    */
    readonly endTime?: string;
    /**
    * The start time of the event.
  
  A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#start_time GameServicesGameServerConfig#start_time}
    */
    readonly startTime?: string;
}
export declare function gameServicesGameServerConfigScalingConfigsSchedulesToTerraform(struct?: GameServicesGameServerConfigScalingConfigsSchedules | cdktf.IResolvable): any;
export interface GameServicesGameServerConfigScalingConfigsSelectors {
    /**
    * Set of labels to group by.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#labels GameServicesGameServerConfig#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
}
export declare function gameServicesGameServerConfigScalingConfigsSelectorsToTerraform(struct?: GameServicesGameServerConfigScalingConfigsSelectors | cdktf.IResolvable): any;
export interface GameServicesGameServerConfigScalingConfigs {
    /**
    * Fleet autoscaler spec, which is sent to Agones.
  Example spec can be found :
  https://agones.dev/site/docs/reference/fleetautoscaler/
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#fleet_autoscaler_spec GameServicesGameServerConfig#fleet_autoscaler_spec}
    */
    readonly fleetAutoscalerSpec: string;
    /**
    * The name of the ScalingConfig
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#name GameServicesGameServerConfig#name}
    */
    readonly name: string;
    /**
    * schedules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#schedules GameServicesGameServerConfig#schedules}
    */
    readonly schedules?: GameServicesGameServerConfigScalingConfigsSchedules[] | cdktf.IResolvable;
    /**
    * selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#selectors GameServicesGameServerConfig#selectors}
    */
    readonly selectors?: GameServicesGameServerConfigScalingConfigsSelectors[] | cdktf.IResolvable;
}
export declare function gameServicesGameServerConfigScalingConfigsToTerraform(struct?: GameServicesGameServerConfigScalingConfigs | cdktf.IResolvable): any;
export interface GameServicesGameServerConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#create GameServicesGameServerConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config#delete GameServicesGameServerConfig#delete}
    */
    readonly delete?: string;
}
export declare function gameServicesGameServerConfigTimeoutsToTerraform(struct?: GameServicesGameServerConfigTimeoutsOutputReference | GameServicesGameServerConfigTimeouts | cdktf.IResolvable): any;
export declare class GameServicesGameServerConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): GameServicesGameServerConfigTimeouts | undefined;
    set internalValue(value: GameServicesGameServerConfigTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config google_game_services_game_server_config}
*/
export declare class GameServicesGameServerConfig extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_config google_game_services_game_server_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GameServicesGameServerConfigConfig
    */
    constructor(scope: Construct, id: string, config: GameServicesGameServerConfigConfig);
    private _configId?;
    get configId(): string;
    set configId(value: string);
    get configIdInput(): string | undefined;
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _fleetConfigs?;
    get fleetConfigs(): GameServicesGameServerConfigFleetConfigs[] | cdktf.IResolvable;
    set fleetConfigs(value: GameServicesGameServerConfigFleetConfigs[] | cdktf.IResolvable);
    get fleetConfigsInput(): cdktf.IResolvable | GameServicesGameServerConfigFleetConfigs[] | undefined;
    private _scalingConfigs?;
    get scalingConfigs(): GameServicesGameServerConfigScalingConfigs[] | cdktf.IResolvable;
    set scalingConfigs(value: GameServicesGameServerConfigScalingConfigs[] | cdktf.IResolvable);
    resetScalingConfigs(): void;
    get scalingConfigsInput(): cdktf.IResolvable | GameServicesGameServerConfigScalingConfigs[] | undefined;
    private _timeouts;
    get timeouts(): GameServicesGameServerConfigTimeoutsOutputReference;
    putTimeouts(value: GameServicesGameServerConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): GameServicesGameServerConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
