"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HealthcareFhirStore = exports.HealthcareFhirStoreTimeoutsOutputReference = exports.healthcareFhirStoreTimeoutsToTerraform = exports.healthcareFhirStoreStreamConfigsToTerraform = exports.HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference = exports.healthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform = exports.HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference = exports.healthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform = exports.HealthcareFhirStoreNotificationConfigOutputReference = exports.healthcareFhirStoreNotificationConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function healthcareFhirStoreNotificationConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        pubsub_topic: cdktf.stringToTerraform(struct.pubsubTopic),
    };
}
exports.healthcareFhirStoreNotificationConfigToTerraform = healthcareFhirStoreNotificationConfigToTerraform;
class HealthcareFhirStoreNotificationConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._pubsubTopic !== undefined) {
            hasAnyValues = true;
            internalValueResult.pubsubTopic = this._pubsubTopic;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._pubsubTopic = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._pubsubTopic = value.pubsubTopic;
        }
    }
    get pubsubTopic() {
        return this.getStringAttribute('pubsub_topic');
    }
    set pubsubTopic(value) {
        this._pubsubTopic = value;
    }
    // Temporarily expose input value. Use with caution.
    get pubsubTopicInput() {
        return this._pubsubTopic;
    }
}
exports.HealthcareFhirStoreNotificationConfigOutputReference = HealthcareFhirStoreNotificationConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
HealthcareFhirStoreNotificationConfigOutputReference[_a] = { fqn: "@cdktf/provider-google.HealthcareFhirStoreNotificationConfigOutputReference", version: "0.6.39" };
function healthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        recursive_structure_depth: cdktf.numberToTerraform(struct.recursiveStructureDepth),
        schema_type: cdktf.stringToTerraform(struct.schemaType),
    };
}
exports.healthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform = healthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform;
class HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._recursiveStructureDepth !== undefined) {
            hasAnyValues = true;
            internalValueResult.recursiveStructureDepth = this._recursiveStructureDepth;
        }
        if (this._schemaType !== undefined) {
            hasAnyValues = true;
            internalValueResult.schemaType = this._schemaType;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._recursiveStructureDepth = undefined;
            this._schemaType = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._recursiveStructureDepth = value.recursiveStructureDepth;
            this._schemaType = value.schemaType;
        }
    }
    get recursiveStructureDepth() {
        return this.getNumberAttribute('recursive_structure_depth');
    }
    set recursiveStructureDepth(value) {
        this._recursiveStructureDepth = value;
    }
    // Temporarily expose input value. Use with caution.
    get recursiveStructureDepthInput() {
        return this._recursiveStructureDepth;
    }
    get schemaType() {
        return this.getStringAttribute('schema_type');
    }
    set schemaType(value) {
        this._schemaType = value;
    }
    resetSchemaType() {
        this._schemaType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get schemaTypeInput() {
        return this._schemaType;
    }
}
exports.HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference = HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference;
_b = JSII_RTTI_SYMBOL_1;
HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference[_b] = { fqn: "@cdktf/provider-google.HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference", version: "0.6.39" };
function healthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        dataset_uri: cdktf.stringToTerraform(struct.datasetUri),
        schema_config: healthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform(struct.schemaConfig),
    };
}
exports.healthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform = healthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform;
class HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
        // schema_config - computed: false, optional: false, required: true
        this._schemaConfig = new HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference(this, "schema_config", true);
    }
    get internalValue() {
        var _f, _g;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._datasetUri !== undefined) {
            hasAnyValues = true;
            internalValueResult.datasetUri = this._datasetUri;
        }
        if (((_f = this._schemaConfig) === null || _f === void 0 ? void 0 : _f.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.schemaConfig = (_g = this._schemaConfig) === null || _g === void 0 ? void 0 : _g.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._datasetUri = undefined;
            this._schemaConfig.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._datasetUri = value.datasetUri;
            this._schemaConfig.internalValue = value.schemaConfig;
        }
    }
    get datasetUri() {
        return this.getStringAttribute('dataset_uri');
    }
    set datasetUri(value) {
        this._datasetUri = value;
    }
    // Temporarily expose input value. Use with caution.
    get datasetUriInput() {
        return this._datasetUri;
    }
    get schemaConfig() {
        return this._schemaConfig;
    }
    putSchemaConfig(value) {
        this._schemaConfig.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get schemaConfigInput() {
        return this._schemaConfig.internalValue;
    }
}
exports.HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference = HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference;
_c = JSII_RTTI_SYMBOL_1;
HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference[_c] = { fqn: "@cdktf/provider-google.HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference", version: "0.6.39" };
function healthcareFhirStoreStreamConfigsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        resource_types: cdktf.listMapper(cdktf.stringToTerraform)(struct.resourceTypes),
        bigquery_destination: healthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform(struct.bigqueryDestination),
    };
}
exports.healthcareFhirStoreStreamConfigsToTerraform = healthcareFhirStoreStreamConfigsToTerraform;
function healthcareFhirStoreTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.healthcareFhirStoreTimeoutsToTerraform = healthcareFhirStoreTimeoutsToTerraform;
class HealthcareFhirStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.HealthcareFhirStoreTimeoutsOutputReference = HealthcareFhirStoreTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
HealthcareFhirStoreTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-google.HealthcareFhirStoreTimeoutsOutputReference", version: "0.6.39" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store google_healthcare_fhir_store}
*/
class HealthcareFhirStore extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store google_healthcare_fhir_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthcareFhirStoreConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_healthcare_fhir_store',
            terraformGeneratorMetadata: {
                providerName: 'google'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // notification_config - computed: false, optional: true, required: false
        this._notificationConfig = new HealthcareFhirStoreNotificationConfigOutputReference(this, "notification_config", true);
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new HealthcareFhirStoreTimeoutsOutputReference(this, "timeouts", true);
        this._dataset = config.dataset;
        this._disableReferentialIntegrity = config.disableReferentialIntegrity;
        this._disableResourceVersioning = config.disableResourceVersioning;
        this._enableHistoryImport = config.enableHistoryImport;
        this._enableUpdateCreate = config.enableUpdateCreate;
        this._labels = config.labels;
        this._name = config.name;
        this._version = config.version;
        this._notificationConfig.internalValue = config.notificationConfig;
        this._streamConfigs = config.streamConfigs;
        this._timeouts.internalValue = config.timeouts;
    }
    get dataset() {
        return this.getStringAttribute('dataset');
    }
    set dataset(value) {
        this._dataset = value;
    }
    // Temporarily expose input value. Use with caution.
    get datasetInput() {
        return this._dataset;
    }
    get disableReferentialIntegrity() {
        return this.getBooleanAttribute('disable_referential_integrity');
    }
    set disableReferentialIntegrity(value) {
        this._disableReferentialIntegrity = value;
    }
    resetDisableReferentialIntegrity() {
        this._disableReferentialIntegrity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableReferentialIntegrityInput() {
        return this._disableReferentialIntegrity;
    }
    get disableResourceVersioning() {
        return this.getBooleanAttribute('disable_resource_versioning');
    }
    set disableResourceVersioning(value) {
        this._disableResourceVersioning = value;
    }
    resetDisableResourceVersioning() {
        this._disableResourceVersioning = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableResourceVersioningInput() {
        return this._disableResourceVersioning;
    }
    get enableHistoryImport() {
        return this.getBooleanAttribute('enable_history_import');
    }
    set enableHistoryImport(value) {
        this._enableHistoryImport = value;
    }
    resetEnableHistoryImport() {
        this._enableHistoryImport = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableHistoryImportInput() {
        return this._enableHistoryImport;
    }
    get enableUpdateCreate() {
        return this.getBooleanAttribute('enable_update_create');
    }
    set enableUpdateCreate(value) {
        this._enableUpdateCreate = value;
    }
    resetEnableUpdateCreate() {
        this._enableUpdateCreate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableUpdateCreateInput() {
        return this._enableUpdateCreate;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // self_link - computed: true, optional: false, required: false
    get selfLink() {
        return this.getStringAttribute('self_link');
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
    get notificationConfig() {
        return this._notificationConfig;
    }
    putNotificationConfig(value) {
        this._notificationConfig.internalValue = value;
    }
    resetNotificationConfig() {
        this._notificationConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notificationConfigInput() {
        return this._notificationConfig.internalValue;
    }
    get streamConfigs() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('stream_configs');
    }
    set streamConfigs(value) {
        this._streamConfigs = value;
    }
    resetStreamConfigs() {
        this._streamConfigs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get streamConfigsInput() {
        return this._streamConfigs;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            dataset: cdktf.stringToTerraform(this._dataset),
            disable_referential_integrity: cdktf.booleanToTerraform(this._disableReferentialIntegrity),
            disable_resource_versioning: cdktf.booleanToTerraform(this._disableResourceVersioning),
            enable_history_import: cdktf.booleanToTerraform(this._enableHistoryImport),
            enable_update_create: cdktf.booleanToTerraform(this._enableUpdateCreate),
            labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._labels),
            name: cdktf.stringToTerraform(this._name),
            version: cdktf.stringToTerraform(this._version),
            notification_config: healthcareFhirStoreNotificationConfigToTerraform(this._notificationConfig.internalValue),
            stream_configs: cdktf.listMapper(healthcareFhirStoreStreamConfigsToTerraform)(this._streamConfigs),
            timeouts: healthcareFhirStoreTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.HealthcareFhirStore = HealthcareFhirStore;
_e = JSII_RTTI_SYMBOL_1;
HealthcareFhirStore[_e] = { fqn: "@cdktf/provider-google.HealthcareFhirStore", version: "0.6.39" };
// =================
// STATIC PROPERTIES
// =================
HealthcareFhirStore.tfResourceType = "google_healthcare_fhir_store";
//# sourceMappingURL=data:application/json;base64,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