import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoggingFolderSinkConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of this sink. The maximum length of the description is 8000 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#description LoggingFolderSink#description}
    */
    readonly description?: string;
    /**
    * The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, or a BigQuery dataset. Examples: "storage.googleapis.com/[GCS_BUCKET]" "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]" "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]" The writer associated with the sink must have access to write to the above resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#destination LoggingFolderSink#destination}
    */
    readonly destination: string;
    /**
    * If set to True, then this sink is disabled and it does not export any log entries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#disabled LoggingFolderSink#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The filter to apply when exporting logs. Only log entries that match the filter are exported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#filter LoggingFolderSink#filter}
    */
    readonly filter?: string;
    /**
    * The folder to be exported to the sink. Note that either [FOLDER_ID] or "folders/[FOLDER_ID]" is accepted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#folder LoggingFolderSink#folder}
    */
    readonly folder: string;
    /**
    * Whether or not to include children folders in the sink export. If true, logs associated with child projects are also exported; otherwise only logs relating to the provided folder are included.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#include_children LoggingFolderSink#include_children}
    */
    readonly includeChildren?: boolean | cdktf.IResolvable;
    /**
    * The name of the logging sink.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#name LoggingFolderSink#name}
    */
    readonly name: string;
    /**
    * bigquery_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#bigquery_options LoggingFolderSink#bigquery_options}
    */
    readonly bigqueryOptions?: LoggingFolderSinkBigqueryOptions;
    /**
    * exclusions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#exclusions LoggingFolderSink#exclusions}
    */
    readonly exclusions?: LoggingFolderSinkExclusions[] | cdktf.IResolvable;
}
export interface LoggingFolderSinkBigqueryOptions {
    /**
    * Whether to use BigQuery's partition tables. By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned tables the date suffix is no longer present and special query syntax has to be used instead. In both cases, tables are sharded based on UTC timezone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#use_partitioned_tables LoggingFolderSink#use_partitioned_tables}
    */
    readonly usePartitionedTables: boolean | cdktf.IResolvable;
}
export declare function loggingFolderSinkBigqueryOptionsToTerraform(struct?: LoggingFolderSinkBigqueryOptionsOutputReference | LoggingFolderSinkBigqueryOptions): any;
export declare class LoggingFolderSinkBigqueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): LoggingFolderSinkBigqueryOptions | undefined;
    set internalValue(value: LoggingFolderSinkBigqueryOptions | undefined);
    private _usePartitionedTables?;
    get usePartitionedTables(): boolean | cdktf.IResolvable;
    set usePartitionedTables(value: boolean | cdktf.IResolvable);
    get usePartitionedTablesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface LoggingFolderSinkExclusions {
    /**
    * A description of this exclusion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#description LoggingFolderSink#description}
    */
    readonly description?: string;
    /**
    * If set to True, then this exclusion is disabled and it does not exclude any log entries
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#disabled LoggingFolderSink#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#filter LoggingFolderSink#filter}
    */
    readonly filter: string;
    /**
    * A client-assigned identifier, such as "load-balancer-exclusion". Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink#name LoggingFolderSink#name}
    */
    readonly name: string;
}
export declare function loggingFolderSinkExclusionsToTerraform(struct?: LoggingFolderSinkExclusions | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink google_logging_folder_sink}
*/
export declare class LoggingFolderSink extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_folder_sink google_logging_folder_sink} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoggingFolderSinkConfig
    */
    constructor(scope: Construct, id: string, config: LoggingFolderSinkConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    get folderInput(): string | undefined;
    get id(): string;
    private _includeChildren?;
    get includeChildren(): boolean | cdktf.IResolvable;
    set includeChildren(value: boolean | cdktf.IResolvable);
    resetIncludeChildren(): void;
    get includeChildrenInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get writerIdentity(): string;
    private _bigqueryOptions;
    get bigqueryOptions(): LoggingFolderSinkBigqueryOptionsOutputReference;
    putBigqueryOptions(value: LoggingFolderSinkBigqueryOptions): void;
    resetBigqueryOptions(): void;
    get bigqueryOptionsInput(): LoggingFolderSinkBigqueryOptions | undefined;
    private _exclusions?;
    get exclusions(): LoggingFolderSinkExclusions[] | cdktf.IResolvable;
    set exclusions(value: LoggingFolderSinkExclusions[] | cdktf.IResolvable);
    resetExclusions(): void;
    get exclusionsInput(): cdktf.IResolvable | LoggingFolderSinkExclusions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
