import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringAlertPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * How to combine the results of multiple conditions to
  determine if an incident should be opened. Possible values: ["AND", "OR", "AND_WITH_MATCHING_RESOURCE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#combiner MonitoringAlertPolicy#combiner}
    */
    readonly combiner: string;
    /**
    * A short name or phrase used to identify the policy in
  dashboards, notifications, and incidents. To avoid confusion, don't use
  the same display name for multiple policies in the same project. The
  name is limited to 512 Unicode characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#display_name MonitoringAlertPolicy#display_name}
    */
    readonly displayName: string;
    /**
    * Whether or not the policy is enabled. The default is true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#enabled MonitoringAlertPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Identifies the notification channels to which notifications should be
  sent when incidents are opened or closed or when new violations occur
  on an already opened incident. Each element of this array corresponds
  to the name field in each of the NotificationChannel objects that are
  returned from the notificationChannels.list method. The syntax of the
  entries in this field is
  'projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#notification_channels MonitoringAlertPolicy#notification_channels}
    */
    readonly notificationChannels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#project MonitoringAlertPolicy#project}
    */
    readonly project?: string;
    /**
    * This field is intended to be used for organizing and identifying the AlertPolicy
  objects.The field can contain up to 64 entries. Each key and value is limited
  to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
  can contain only lowercase letters, numerals, underscores, and dashes. Keys
  must begin with a letter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#user_labels MonitoringAlertPolicy#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#conditions MonitoringAlertPolicy#conditions}
    */
    readonly conditions: MonitoringAlertPolicyConditions[] | cdktf.IResolvable;
    /**
    * documentation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#documentation MonitoringAlertPolicy#documentation}
    */
    readonly documentation?: MonitoringAlertPolicyDocumentation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#timeouts MonitoringAlertPolicy#timeouts}
    */
    readonly timeouts?: MonitoringAlertPolicyTimeouts;
}
export declare class MonitoringAlertPolicyCreationRecord extends cdktf.ComplexComputedList {
    get mutateTime(): string;
    get mutatedBy(): string;
}
export interface MonitoringAlertPolicyConditionsConditionAbsentAggregations {
    /**
    * The alignment period for per-time
  series alignment. If present,
  alignmentPeriod must be at least
  60 seconds. After per-time series
  alignment, each time series will
  contain data points only on the
  period boundaries. If
  perSeriesAligner is not specified
  or equals ALIGN_NONE, then this
  field is ignored. If
  perSeriesAligner is specified and
  does not equal ALIGN_NONE, then
  this field must be defined;
  otherwise an error is returned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#alignment_period MonitoringAlertPolicy#alignment_period}
    */
    readonly alignmentPeriod?: string;
    /**
    * The approach to be used to combine
  time series. Not all reducer
  functions may be applied to all
  time series, depending on the
  metric type and the value type of
  the original time series.
  Reduction may change the metric
  type of value type of the time
  series.Time series data must be
  aligned in order to perform cross-
  time series reduction. If
  crossSeriesReducer is specified,
  then perSeriesAligner must be
  specified and not equal ALIGN_NONE
  and alignmentPeriod must be
  specified; otherwise, an error is
  returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#cross_series_reducer MonitoringAlertPolicy#cross_series_reducer}
    */
    readonly crossSeriesReducer?: string;
    /**
    * The set of fields to preserve when
  crossSeriesReducer is specified.
  The groupByFields determine how
  the time series are partitioned
  into subsets prior to applying the
  aggregation function. Each subset
  contains time series that have the
  same value for each of the
  grouping fields. Each individual
  time series is a member of exactly
  one subset. The crossSeriesReducer
  is applied to each subset of time
  series. It is not possible to
  reduce across different resource
  types, so this field implicitly
  contains resource.type. Fields not
  specified in groupByFields are
  aggregated away. If groupByFields
  is not specified and all the time
  series have the same resource
  type, then the time series are
  aggregated into a single output
  time series. If crossSeriesReducer
  is not defined, this field is
  ignored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#group_by_fields MonitoringAlertPolicy#group_by_fields}
    */
    readonly groupByFields?: string[];
    /**
    * The approach to be used to align
  individual time series. Not all
  alignment functions may be applied
  to all time series, depending on
  the metric type and value type of
  the original time series.
  Alignment may change the metric
  type or the value type of the time
  series.Time series data must be
  aligned in order to perform cross-
  time series reduction. If
  crossSeriesReducer is specified,
  then perSeriesAligner must be
  specified and not equal ALIGN_NONE
  and alignmentPeriod must be
  specified; otherwise, an error is
  returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#per_series_aligner MonitoringAlertPolicy#per_series_aligner}
    */
    readonly perSeriesAligner?: string;
}
export declare function monitoringAlertPolicyConditionsConditionAbsentAggregationsToTerraform(struct?: MonitoringAlertPolicyConditionsConditionAbsentAggregations | cdktf.IResolvable): any;
export interface MonitoringAlertPolicyConditionsConditionAbsentTrigger {
    /**
    * The absolute number of time series
  that must fail the predicate for the
  condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#count MonitoringAlertPolicy#count}
    */
    readonly count?: number;
    /**
    * The percentage of time series that
  must fail the predicate for the
  condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#percent MonitoringAlertPolicy#percent}
    */
    readonly percent?: number;
}
export declare function monitoringAlertPolicyConditionsConditionAbsentTriggerToTerraform(struct?: MonitoringAlertPolicyConditionsConditionAbsentTriggerOutputReference | MonitoringAlertPolicyConditionsConditionAbsentTrigger): any;
export declare class MonitoringAlertPolicyConditionsConditionAbsentTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MonitoringAlertPolicyConditionsConditionAbsentTrigger | undefined;
    set internalValue(value: MonitoringAlertPolicyConditionsConditionAbsentTrigger | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface MonitoringAlertPolicyConditionsConditionAbsent {
    /**
    * The amount of time that a time series must
  fail to report new data to be considered
  failing. Currently, only values that are a
  multiple of a minute--e.g. 60s, 120s, or 300s
  --are supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#duration MonitoringAlertPolicy#duration}
    */
    readonly duration: string;
    /**
    * A filter that identifies which time series
  should be compared with the threshold.The
  filter is similar to the one that is
  specified in the
  MetricService.ListTimeSeries request (that
  call is useful to verify the time series
  that will be retrieved / processed) and must
  specify the metric type and optionally may
  contain restrictions on resource type,
  resource labels, and metric labels. This
  field may not exceed 2048 Unicode characters
  in length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#filter MonitoringAlertPolicy#filter}
    */
    readonly filter?: string;
    /**
    * aggregations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#aggregations MonitoringAlertPolicy#aggregations}
    */
    readonly aggregations?: MonitoringAlertPolicyConditionsConditionAbsentAggregations[] | cdktf.IResolvable;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#trigger MonitoringAlertPolicy#trigger}
    */
    readonly trigger?: MonitoringAlertPolicyConditionsConditionAbsentTrigger;
}
export declare function monitoringAlertPolicyConditionsConditionAbsentToTerraform(struct?: MonitoringAlertPolicyConditionsConditionAbsentOutputReference | MonitoringAlertPolicyConditionsConditionAbsent): any;
export declare class MonitoringAlertPolicyConditionsConditionAbsentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MonitoringAlertPolicyConditionsConditionAbsent | undefined;
    set internalValue(value: MonitoringAlertPolicyConditionsConditionAbsent | undefined);
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _aggregations?;
    get aggregations(): MonitoringAlertPolicyConditionsConditionAbsentAggregations[] | cdktf.IResolvable;
    set aggregations(value: MonitoringAlertPolicyConditionsConditionAbsentAggregations[] | cdktf.IResolvable);
    resetAggregations(): void;
    get aggregationsInput(): cdktf.IResolvable | MonitoringAlertPolicyConditionsConditionAbsentAggregations[] | undefined;
    private _trigger;
    get trigger(): MonitoringAlertPolicyConditionsConditionAbsentTriggerOutputReference;
    putTrigger(value: MonitoringAlertPolicyConditionsConditionAbsentTrigger): void;
    resetTrigger(): void;
    get triggerInput(): MonitoringAlertPolicyConditionsConditionAbsentTrigger | undefined;
}
export interface MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger {
    /**
    * The absolute number of time series
  that must fail the predicate for the
  condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#count MonitoringAlertPolicy#count}
    */
    readonly count?: number;
    /**
    * The percentage of time series that
  must fail the predicate for the
  condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#percent MonitoringAlertPolicy#percent}
    */
    readonly percent?: number;
}
export declare function monitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerToTerraform(struct?: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerOutputReference | MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger): any;
export declare class MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger | undefined;
    set internalValue(value: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage {
    /**
    * The amount of time that a time series must
  violate the threshold to be considered
  failing. Currently, only values that are a
  multiple of a minute--e.g., 0, 60, 120, or
  300 seconds--are supported. If an invalid
  value is given, an error will be returned.
  When choosing a duration, it is useful to
  keep in mind the frequency of the underlying
  time series data (which may also be affected
  by any alignments specified in the
  aggregations field); a good duration is long
  enough so that a single outlier does not
  generate spurious alerts, but short enough
  that unhealthy states are detected and
  alerted on quickly.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#duration MonitoringAlertPolicy#duration}
    */
    readonly duration: string;
    /**
    * Monitoring Query Language query that outputs a boolean stream.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#query MonitoringAlertPolicy#query}
    */
    readonly query: string;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#trigger MonitoringAlertPolicy#trigger}
    */
    readonly trigger?: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger;
}
export declare function monitoringAlertPolicyConditionsConditionMonitoringQueryLanguageToTerraform(struct?: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageOutputReference | MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage): any;
export declare class MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage | undefined;
    set internalValue(value: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage | undefined);
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _trigger;
    get trigger(): MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTriggerOutputReference;
    putTrigger(value: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger): void;
    resetTrigger(): void;
    get triggerInput(): MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger | undefined;
}
export interface MonitoringAlertPolicyConditionsConditionThresholdAggregations {
    /**
    * The alignment period for per-time
  series alignment. If present,
  alignmentPeriod must be at least
  60 seconds. After per-time series
  alignment, each time series will
  contain data points only on the
  period boundaries. If
  perSeriesAligner is not specified
  or equals ALIGN_NONE, then this
  field is ignored. If
  perSeriesAligner is specified and
  does not equal ALIGN_NONE, then
  this field must be defined;
  otherwise an error is returned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#alignment_period MonitoringAlertPolicy#alignment_period}
    */
    readonly alignmentPeriod?: string;
    /**
    * The approach to be used to combine
  time series. Not all reducer
  functions may be applied to all
  time series, depending on the
  metric type and the value type of
  the original time series.
  Reduction may change the metric
  type of value type of the time
  series.Time series data must be
  aligned in order to perform cross-
  time series reduction. If
  crossSeriesReducer is specified,
  then perSeriesAligner must be
  specified and not equal ALIGN_NONE
  and alignmentPeriod must be
  specified; otherwise, an error is
  returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#cross_series_reducer MonitoringAlertPolicy#cross_series_reducer}
    */
    readonly crossSeriesReducer?: string;
    /**
    * The set of fields to preserve when
  crossSeriesReducer is specified.
  The groupByFields determine how
  the time series are partitioned
  into subsets prior to applying the
  aggregation function. Each subset
  contains time series that have the
  same value for each of the
  grouping fields. Each individual
  time series is a member of exactly
  one subset. The crossSeriesReducer
  is applied to each subset of time
  series. It is not possible to
  reduce across different resource
  types, so this field implicitly
  contains resource.type. Fields not
  specified in groupByFields are
  aggregated away. If groupByFields
  is not specified and all the time
  series have the same resource
  type, then the time series are
  aggregated into a single output
  time series. If crossSeriesReducer
  is not defined, this field is
  ignored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#group_by_fields MonitoringAlertPolicy#group_by_fields}
    */
    readonly groupByFields?: string[];
    /**
    * The approach to be used to align
  individual time series. Not all
  alignment functions may be applied
  to all time series, depending on
  the metric type and value type of
  the original time series.
  Alignment may change the metric
  type or the value type of the time
  series.Time series data must be
  aligned in order to perform cross-
  time series reduction. If
  crossSeriesReducer is specified,
  then perSeriesAligner must be
  specified and not equal ALIGN_NONE
  and alignmentPeriod must be
  specified; otherwise, an error is
  returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#per_series_aligner MonitoringAlertPolicy#per_series_aligner}
    */
    readonly perSeriesAligner?: string;
}
export declare function monitoringAlertPolicyConditionsConditionThresholdAggregationsToTerraform(struct?: MonitoringAlertPolicyConditionsConditionThresholdAggregations | cdktf.IResolvable): any;
export interface MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations {
    /**
    * The alignment period for per-time
  series alignment. If present,
  alignmentPeriod must be at least
  60 seconds. After per-time series
  alignment, each time series will
  contain data points only on the
  period boundaries. If
  perSeriesAligner is not specified
  or equals ALIGN_NONE, then this
  field is ignored. If
  perSeriesAligner is specified and
  does not equal ALIGN_NONE, then
  this field must be defined;
  otherwise an error is returned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#alignment_period MonitoringAlertPolicy#alignment_period}
    */
    readonly alignmentPeriod?: string;
    /**
    * The approach to be used to combine
  time series. Not all reducer
  functions may be applied to all
  time series, depending on the
  metric type and the value type of
  the original time series.
  Reduction may change the metric
  type of value type of the time
  series.Time series data must be
  aligned in order to perform cross-
  time series reduction. If
  crossSeriesReducer is specified,
  then perSeriesAligner must be
  specified and not equal ALIGN_NONE
  and alignmentPeriod must be
  specified; otherwise, an error is
  returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#cross_series_reducer MonitoringAlertPolicy#cross_series_reducer}
    */
    readonly crossSeriesReducer?: string;
    /**
    * The set of fields to preserve when
  crossSeriesReducer is specified.
  The groupByFields determine how
  the time series are partitioned
  into subsets prior to applying the
  aggregation function. Each subset
  contains time series that have the
  same value for each of the
  grouping fields. Each individual
  time series is a member of exactly
  one subset. The crossSeriesReducer
  is applied to each subset of time
  series. It is not possible to
  reduce across different resource
  types, so this field implicitly
  contains resource.type. Fields not
  specified in groupByFields are
  aggregated away. If groupByFields
  is not specified and all the time
  series have the same resource
  type, then the time series are
  aggregated into a single output
  time series. If crossSeriesReducer
  is not defined, this field is
  ignored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#group_by_fields MonitoringAlertPolicy#group_by_fields}
    */
    readonly groupByFields?: string[];
    /**
    * The approach to be used to align
  individual time series. Not all
  alignment functions may be applied
  to all time series, depending on
  the metric type and value type of
  the original time series.
  Alignment may change the metric
  type or the value type of the time
  series.Time series data must be
  aligned in order to perform cross-
  time series reduction. If
  crossSeriesReducer is specified,
  then perSeriesAligner must be
  specified and not equal ALIGN_NONE
  and alignmentPeriod must be
  specified; otherwise, an error is
  returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#per_series_aligner MonitoringAlertPolicy#per_series_aligner}
    */
    readonly perSeriesAligner?: string;
}
export declare function monitoringAlertPolicyConditionsConditionThresholdDenominatorAggregationsToTerraform(struct?: MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations | cdktf.IResolvable): any;
export interface MonitoringAlertPolicyConditionsConditionThresholdTrigger {
    /**
    * The absolute number of time series
  that must fail the predicate for the
  condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#count MonitoringAlertPolicy#count}
    */
    readonly count?: number;
    /**
    * The percentage of time series that
  must fail the predicate for the
  condition to be triggered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#percent MonitoringAlertPolicy#percent}
    */
    readonly percent?: number;
}
export declare function monitoringAlertPolicyConditionsConditionThresholdTriggerToTerraform(struct?: MonitoringAlertPolicyConditionsConditionThresholdTriggerOutputReference | MonitoringAlertPolicyConditionsConditionThresholdTrigger): any;
export declare class MonitoringAlertPolicyConditionsConditionThresholdTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MonitoringAlertPolicyConditionsConditionThresholdTrigger | undefined;
    set internalValue(value: MonitoringAlertPolicyConditionsConditionThresholdTrigger | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    resetCount(): void;
    get countInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface MonitoringAlertPolicyConditionsConditionThreshold {
    /**
    * The comparison to apply between the time
  series (indicated by filter and aggregation)
  and the threshold (indicated by
  threshold_value). The comparison is applied
  on each time series, with the time series on
  the left-hand side and the threshold on the
  right-hand side. Only COMPARISON_LT and
  COMPARISON_GT are supported currently. Possible values: ["COMPARISON_GT", "COMPARISON_GE", "COMPARISON_LT", "COMPARISON_LE", "COMPARISON_EQ", "COMPARISON_NE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#comparison MonitoringAlertPolicy#comparison}
    */
    readonly comparison: string;
    /**
    * A filter that identifies a time series that
  should be used as the denominator of a ratio
  that will be compared with the threshold. If
  a denominator_filter is specified, the time
  series specified by the filter field will be
  used as the numerator.The filter is similar
  to the one that is specified in the
  MetricService.ListTimeSeries request (that
  call is useful to verify the time series
  that will be retrieved / processed) and must
  specify the metric type and optionally may
  contain restrictions on resource type,
  resource labels, and metric labels. This
  field may not exceed 2048 Unicode characters
  in length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#denominator_filter MonitoringAlertPolicy#denominator_filter}
    */
    readonly denominatorFilter?: string;
    /**
    * The amount of time that a time series must
  violate the threshold to be considered
  failing. Currently, only values that are a
  multiple of a minute--e.g., 0, 60, 120, or
  300 seconds--are supported. If an invalid
  value is given, an error will be returned.
  When choosing a duration, it is useful to
  keep in mind the frequency of the underlying
  time series data (which may also be affected
  by any alignments specified in the
  aggregations field); a good duration is long
  enough so that a single outlier does not
  generate spurious alerts, but short enough
  that unhealthy states are detected and
  alerted on quickly.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#duration MonitoringAlertPolicy#duration}
    */
    readonly duration: string;
    /**
    * A filter that identifies which time series
  should be compared with the threshold.The
  filter is similar to the one that is
  specified in the
  MetricService.ListTimeSeries request (that
  call is useful to verify the time series
  that will be retrieved / processed) and must
  specify the metric type and optionally may
  contain restrictions on resource type,
  resource labels, and metric labels. This
  field may not exceed 2048 Unicode characters
  in length.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#filter MonitoringAlertPolicy#filter}
    */
    readonly filter?: string;
    /**
    * A value against which to compare the time
  series.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#threshold_value MonitoringAlertPolicy#threshold_value}
    */
    readonly thresholdValue?: number;
    /**
    * aggregations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#aggregations MonitoringAlertPolicy#aggregations}
    */
    readonly aggregations?: MonitoringAlertPolicyConditionsConditionThresholdAggregations[] | cdktf.IResolvable;
    /**
    * denominator_aggregations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#denominator_aggregations MonitoringAlertPolicy#denominator_aggregations}
    */
    readonly denominatorAggregations?: MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | cdktf.IResolvable;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#trigger MonitoringAlertPolicy#trigger}
    */
    readonly trigger?: MonitoringAlertPolicyConditionsConditionThresholdTrigger;
}
export declare function monitoringAlertPolicyConditionsConditionThresholdToTerraform(struct?: MonitoringAlertPolicyConditionsConditionThresholdOutputReference | MonitoringAlertPolicyConditionsConditionThreshold): any;
export declare class MonitoringAlertPolicyConditionsConditionThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MonitoringAlertPolicyConditionsConditionThreshold | undefined;
    set internalValue(value: MonitoringAlertPolicyConditionsConditionThreshold | undefined);
    private _comparison?;
    get comparison(): string;
    set comparison(value: string);
    get comparisonInput(): string | undefined;
    private _denominatorFilter?;
    get denominatorFilter(): string;
    set denominatorFilter(value: string);
    resetDenominatorFilter(): void;
    get denominatorFilterInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _thresholdValue?;
    get thresholdValue(): number;
    set thresholdValue(value: number);
    resetThresholdValue(): void;
    get thresholdValueInput(): number | undefined;
    private _aggregations?;
    get aggregations(): MonitoringAlertPolicyConditionsConditionThresholdAggregations[] | cdktf.IResolvable;
    set aggregations(value: MonitoringAlertPolicyConditionsConditionThresholdAggregations[] | cdktf.IResolvable);
    resetAggregations(): void;
    get aggregationsInput(): cdktf.IResolvable | MonitoringAlertPolicyConditionsConditionThresholdAggregations[] | undefined;
    private _denominatorAggregations?;
    get denominatorAggregations(): MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | cdktf.IResolvable;
    set denominatorAggregations(value: MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | cdktf.IResolvable);
    resetDenominatorAggregations(): void;
    get denominatorAggregationsInput(): cdktf.IResolvable | MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[] | undefined;
    private _trigger;
    get trigger(): MonitoringAlertPolicyConditionsConditionThresholdTriggerOutputReference;
    putTrigger(value: MonitoringAlertPolicyConditionsConditionThresholdTrigger): void;
    resetTrigger(): void;
    get triggerInput(): MonitoringAlertPolicyConditionsConditionThresholdTrigger | undefined;
}
export interface MonitoringAlertPolicyConditions {
    /**
    * A short name or phrase used to identify the
  condition in dashboards, notifications, and
  incidents. To avoid confusion, don't use the same
  display name for multiple conditions in the same
  policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#display_name MonitoringAlertPolicy#display_name}
    */
    readonly displayName: string;
    /**
    * condition_absent block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#condition_absent MonitoringAlertPolicy#condition_absent}
    */
    readonly conditionAbsent?: MonitoringAlertPolicyConditionsConditionAbsent;
    /**
    * condition_monitoring_query_language block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#condition_monitoring_query_language MonitoringAlertPolicy#condition_monitoring_query_language}
    */
    readonly conditionMonitoringQueryLanguage?: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage;
    /**
    * condition_threshold block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#condition_threshold MonitoringAlertPolicy#condition_threshold}
    */
    readonly conditionThreshold?: MonitoringAlertPolicyConditionsConditionThreshold;
}
export declare function monitoringAlertPolicyConditionsToTerraform(struct?: MonitoringAlertPolicyConditions | cdktf.IResolvable): any;
export interface MonitoringAlertPolicyDocumentation {
    /**
    * The text of the documentation, interpreted according to mimeType.
  The content may not exceed 8,192 Unicode characters and may not
  exceed more than 10,240 bytes when encoded in UTF-8 format,
  whichever is smaller.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#content MonitoringAlertPolicy#content}
    */
    readonly content?: string;
    /**
    * The format of the content field. Presently, only the value
  "text/markdown" is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#mime_type MonitoringAlertPolicy#mime_type}
    */
    readonly mimeType?: string;
}
export declare function monitoringAlertPolicyDocumentationToTerraform(struct?: MonitoringAlertPolicyDocumentationOutputReference | MonitoringAlertPolicyDocumentation): any;
export declare class MonitoringAlertPolicyDocumentationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MonitoringAlertPolicyDocumentation | undefined;
    set internalValue(value: MonitoringAlertPolicyDocumentation | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    private _mimeType?;
    get mimeType(): string;
    set mimeType(value: string);
    resetMimeType(): void;
    get mimeTypeInput(): string | undefined;
}
export interface MonitoringAlertPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#create MonitoringAlertPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#delete MonitoringAlertPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy#update MonitoringAlertPolicy#update}
    */
    readonly update?: string;
}
export declare function monitoringAlertPolicyTimeoutsToTerraform(struct?: MonitoringAlertPolicyTimeoutsOutputReference | MonitoringAlertPolicyTimeouts | cdktf.IResolvable): any;
export declare class MonitoringAlertPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): MonitoringAlertPolicyTimeouts | undefined;
    set internalValue(value: MonitoringAlertPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy google_monitoring_alert_policy}
*/
export declare class MonitoringAlertPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy google_monitoring_alert_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitoringAlertPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MonitoringAlertPolicyConfig);
    private _combiner?;
    get combiner(): string;
    set combiner(value: string);
    get combinerInput(): string | undefined;
    creationRecord(index: string): MonitoringAlertPolicyCreationRecord;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get name(): string;
    private _notificationChannels?;
    get notificationChannels(): string[];
    set notificationChannels(value: string[]);
    resetNotificationChannels(): void;
    get notificationChannelsInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _conditions?;
    get conditions(): MonitoringAlertPolicyConditions[] | cdktf.IResolvable;
    set conditions(value: MonitoringAlertPolicyConditions[] | cdktf.IResolvable);
    get conditionsInput(): cdktf.IResolvable | MonitoringAlertPolicyConditions[] | undefined;
    private _documentation;
    get documentation(): MonitoringAlertPolicyDocumentationOutputReference;
    putDocumentation(value: MonitoringAlertPolicyDocumentation): void;
    resetDocumentation(): void;
    get documentationInput(): MonitoringAlertPolicyDocumentation | undefined;
    private _timeouts;
    get timeouts(): MonitoringAlertPolicyTimeoutsOutputReference;
    putTimeouts(value: MonitoringAlertPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MonitoringAlertPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
