import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBucketAccessControlConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control#bucket StorageBucketAccessControl#bucket}
    */
    readonly bucket: string;
    /**
    * The entity holding the permission, in one of the following forms:
    user-userId
    user-email
    group-groupId
    group-email
    domain-domain
    project-team-projectId
    allUsers
    allAuthenticatedUsers
  Examples:
    The user liz@example.com would be user-liz@example.com.
    The group example@googlegroups.com would be
    group-example@googlegroups.com.
    To refer to all members of the Google Apps for Business domain
    example.com, the entity would be domain-example.com.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control#entity StorageBucketAccessControl#entity}
    */
    readonly entity: string;
    /**
    * The access permission for the entity. Possible values: ["OWNER", "READER", "WRITER"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control#role StorageBucketAccessControl#role}
    */
    readonly role?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control#timeouts StorageBucketAccessControl#timeouts}
    */
    readonly timeouts?: StorageBucketAccessControlTimeouts;
}
export interface StorageBucketAccessControlTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control#create StorageBucketAccessControl#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control#delete StorageBucketAccessControl#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control#update StorageBucketAccessControl#update}
    */
    readonly update?: string;
}
export declare function storageBucketAccessControlTimeoutsToTerraform(struct?: StorageBucketAccessControlTimeoutsOutputReference | StorageBucketAccessControlTimeouts | cdktf.IResolvable): any;
export declare class StorageBucketAccessControlTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): StorageBucketAccessControlTimeouts | undefined;
    set internalValue(value: StorageBucketAccessControlTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control google_storage_bucket_access_control}
*/
export declare class StorageBucketAccessControl extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control google_storage_bucket_access_control} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageBucketAccessControlConfig
    */
    constructor(scope: Construct, id: string, config: StorageBucketAccessControlConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get domain(): string;
    get email(): string;
    private _entity?;
    get entity(): string;
    set entity(value: string);
    get entityInput(): string | undefined;
    get id(): string;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _timeouts;
    get timeouts(): StorageBucketAccessControlTimeoutsOutputReference;
    putTimeouts(value: StorageBucketAccessControlTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): StorageBucketAccessControlTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
