# SwanCuller

JupyterHub service that checks and cleans user sessions.
It also calls bash scripts to check/renew kerberos tokens for the users, if their sessions still exist, or remove them if not in use.

## Requirements

This module requires and installs Tornado.

## Installation

Install the package:

```bash
pip install swanculler
```

## Usage

Call the binary and specify configuration parameters:
```bash
swanculler --cull_every=600
```

Configuration parameters:
* url: The JupyterHub API URL (default=$JUPYTERHUB_API_URL)
* timeout: The idle timeout (in seconds) (default=600)
* cull_every: The interval (in seconds) for checking for idle servers to cull (default=0)
* max_age: The maximum age (in seconds) of servers that should be culled even if they are active (default=0)
* cull_users: Cull users in addition to servers (default=False)
* concurrency: Limit the number of concurrent requests made to the Hub (default=10)
* hooks_dir: Path to the directory for the krb tickets scripts (check_ticket.sh and delete_ticket.sh) (default="/srv/jupyterhub/culler)
* disable_hooks: wether to  call the krb tickets scripts or not (default=False)