# dip-bundestag
DIP Bundestag API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 0.1.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

```sh
pip install deutschland[dip_bundestag]
```

### poetry install

```sh
poetry add deutschland -E dip_bundestag
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

## Usage

Import the package:
```python
from deutschland import dip_bundestag
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
from deutschland import dip_bundestag
from pprint import pprint
from deutschland.dip_bundestag.api import default_api
# Defining the host is optional and defaults to https://search.dip.bundestag.de/api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = dip_bundestag.Configuration(
    host = "https://search.dip.bundestag.de/api/v1"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration.api_key['ApiKeyAuth'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKeyAuth'] = 'Bearer'


# Enter a context with an instance of the API client
with dip_bundestag.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)

    try:
        # Liste aller Aktivitäten
        api_response = api_instance.aktivitaet_get()
        pprint(api_response)
    except dip_bundestag.ApiException as e:
        print("Exception when calling DefaultApi->aktivitaet_get: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://search.dip.bundestag.de/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**aktivitaet_get**](docs/DefaultApi.md#aktivitaet_get) | **GET** /aktivitaet/ | Liste aller Aktivitäten
*DefaultApi* | [**aktivitaet_id_get**](docs/DefaultApi.md#aktivitaet_id_get) | **GET** /aktivitaet/{id} | Metadaten zu Aktivitäten
*DefaultApi* | [**drucksache_get**](docs/DefaultApi.md#drucksache_get) | **GET** /drucksache/ | Liste aller Drucksachen
*DefaultApi* | [**drucksache_id_get**](docs/DefaultApi.md#drucksache_id_get) | **GET** /drucksache/{id} | Metadaten zu Drucksachen
*DefaultApi* | [**drucksache_text_get**](docs/DefaultApi.md#drucksache_text_get) | **GET** /drucksache-text/ | Liste aller Volltexte der Drucksachen
*DefaultApi* | [**drucksache_text_id_get**](docs/DefaultApi.md#drucksache_text_id_get) | **GET** /drucksache-text/{id} | Soweit vorhanden werden zusätzlich die Volltexte der Drucksachen ausgegeben
*DefaultApi* | [**person_get**](docs/DefaultApi.md#person_get) | **GET** /person/ | Liste aller Personenstammdaten
*DefaultApi* | [**person_id_get**](docs/DefaultApi.md#person_id_get) | **GET** /person/{id} | Personenstammdaten
*DefaultApi* | [**plenarprotokoll_get**](docs/DefaultApi.md#plenarprotokoll_get) | **GET** /plenarprotokoll/ | Liste aller Plenarprotokolle
*DefaultApi* | [**plenarprotokoll_id_get**](docs/DefaultApi.md#plenarprotokoll_id_get) | **GET** /plenarprotokoll/{id} | Metadaten zu Plenarprotokollen
*DefaultApi* | [**plenarprotokoll_text_get**](docs/DefaultApi.md#plenarprotokoll_text_get) | **GET** /plenarprotokoll-text/ | Liste aller Volltexte der Plenarprotokolle
*DefaultApi* | [**plenarprotokoll_text_id_get**](docs/DefaultApi.md#plenarprotokoll_text_id_get) | **GET** /plenarprotokoll-text/{id} | Soweit vorhanden werden zusätzlich die Volltexte der Plenarprotokolle ausgegeben
*DefaultApi* | [**vorgang_get**](docs/DefaultApi.md#vorgang_get) | **GET** /vorgang/ | Liste aller Vorgänge
*DefaultApi* | [**vorgang_id_get**](docs/DefaultApi.md#vorgang_id_get) | **GET** /vorgang/{id} | Metadaten zu Vorgängen
*DefaultApi* | [**vorgangsposition_get**](docs/DefaultApi.md#vorgangsposition_get) | **GET** /vorgangsposition/ | Liste aller Vorgangspositionen
*DefaultApi* | [**vorgangsposition_id_get**](docs/DefaultApi.md#vorgangsposition_id_get) | **GET** /vorgangsposition/{id} | Metadaten zu Vorgangspositionen


## Documentation For Models



## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

kontakt@bund.dev


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in dip_bundestag.apis and dip_bundestag.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from deutschland.dip_bundestag.api.default_api import DefaultApi`
- `from deutschland.dip_bundestag.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
from deutschland import dip_bundestag
from deutschland.dip_bundestag.apis import *
from deutschland.dip_bundestag.models import *
```

