# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['deutschland',
 'deutschland.dip_bundestag',
 'deutschland.dip_bundestag.api',
 'deutschland.dip_bundestag.apis',
 'deutschland.dip_bundestag.model',
 'deutschland.dip_bundestag.models']

package_data = \
{'': ['*']}

install_requires = \
['python-dateutil', 'urllib3>=1.25.3']

setup_kwargs = {
    'name': 'de-dip-bundestag',
    'version': '0.1.0',
    'description': 'Bundestag: Dokumentations- und Informationssystem für Parlamentsmaterialien',
    'long_description': '# dip-bundestag\nDIP Bundestag API\n\nThis Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:\n\n- API version: 1.0.0\n- Package version: 0.1.0\n- Build package: org.openapitools.codegen.languages.PythonClientCodegen\n\n## Requirements.\n\nPython >= 3.6\n\n## Installation & Usage\n### pip install\n\n```sh\npip install deutschland[dip_bundestag]\n```\n\n### poetry install\n\n```sh\npoetry add deutschland -E dip_bundestag\n```\n\n### Setuptools\n\nInstall via [Setuptools](http://pypi.python.org/pypi/setuptools).\n\n```sh\npython setup.py install --user\n```\n(or `sudo python setup.py install` to install the package for all users)\n\n## Usage\n\nImport the package:\n```python\nfrom deutschland import dip_bundestag\n```\n\n## Getting Started\n\nPlease follow the [installation procedure](#installation--usage) and then run the following:\n\n```python\n\nimport time\nfrom deutschland import dip_bundestag\nfrom pprint import pprint\nfrom deutschland.dip_bundestag.api import default_api\n# Defining the host is optional and defaults to https://search.dip.bundestag.de/api/v1\n# See configuration.py for a list of all supported configuration parameters.\nconfiguration = dip_bundestag.Configuration(\n    host = "https://search.dip.bundestag.de/api/v1"\n)\n\n# The client must configure the authentication and authorization parameters\n# in accordance with the API server security policy.\n# Examples for each auth method are provided below, use the example that\n# satisfies your auth use case.\n\n# Configure API key authorization: ApiKeyAuth\nconfiguration.api_key[\'ApiKeyAuth\'] = \'YOUR_API_KEY\'\n\n# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed\n# configuration.api_key_prefix[\'ApiKeyAuth\'] = \'Bearer\'\n\n\n# Enter a context with an instance of the API client\nwith dip_bundestag.ApiClient(configuration) as api_client:\n    # Create an instance of the API class\n    api_instance = default_api.DefaultApi(api_client)\n\n    try:\n        # Liste aller Aktivitäten\n        api_response = api_instance.aktivitaet_get()\n        pprint(api_response)\n    except dip_bundestag.ApiException as e:\n        print("Exception when calling DefaultApi->aktivitaet_get: %s\\n" % e)\n```\n\n## Documentation for API Endpoints\n\nAll URIs are relative to *https://search.dip.bundestag.de/api/v1*\n\nClass | Method | HTTP request | Description\n------------ | ------------- | ------------- | -------------\n*DefaultApi* | [**aktivitaet_get**](docs/DefaultApi.md#aktivitaet_get) | **GET** /aktivitaet/ | Liste aller Aktivitäten\n*DefaultApi* | [**aktivitaet_id_get**](docs/DefaultApi.md#aktivitaet_id_get) | **GET** /aktivitaet/{id} | Metadaten zu Aktivitäten\n*DefaultApi* | [**drucksache_get**](docs/DefaultApi.md#drucksache_get) | **GET** /drucksache/ | Liste aller Drucksachen\n*DefaultApi* | [**drucksache_id_get**](docs/DefaultApi.md#drucksache_id_get) | **GET** /drucksache/{id} | Metadaten zu Drucksachen\n*DefaultApi* | [**drucksache_text_get**](docs/DefaultApi.md#drucksache_text_get) | **GET** /drucksache-text/ | Liste aller Volltexte der Drucksachen\n*DefaultApi* | [**drucksache_text_id_get**](docs/DefaultApi.md#drucksache_text_id_get) | **GET** /drucksache-text/{id} | Soweit vorhanden werden zusätzlich die Volltexte der Drucksachen ausgegeben\n*DefaultApi* | [**person_get**](docs/DefaultApi.md#person_get) | **GET** /person/ | Liste aller Personenstammdaten\n*DefaultApi* | [**person_id_get**](docs/DefaultApi.md#person_id_get) | **GET** /person/{id} | Personenstammdaten\n*DefaultApi* | [**plenarprotokoll_get**](docs/DefaultApi.md#plenarprotokoll_get) | **GET** /plenarprotokoll/ | Liste aller Plenarprotokolle\n*DefaultApi* | [**plenarprotokoll_id_get**](docs/DefaultApi.md#plenarprotokoll_id_get) | **GET** /plenarprotokoll/{id} | Metadaten zu Plenarprotokollen\n*DefaultApi* | [**plenarprotokoll_text_get**](docs/DefaultApi.md#plenarprotokoll_text_get) | **GET** /plenarprotokoll-text/ | Liste aller Volltexte der Plenarprotokolle\n*DefaultApi* | [**plenarprotokoll_text_id_get**](docs/DefaultApi.md#plenarprotokoll_text_id_get) | **GET** /plenarprotokoll-text/{id} | Soweit vorhanden werden zusätzlich die Volltexte der Plenarprotokolle ausgegeben\n*DefaultApi* | [**vorgang_get**](docs/DefaultApi.md#vorgang_get) | **GET** /vorgang/ | Liste aller Vorgänge\n*DefaultApi* | [**vorgang_id_get**](docs/DefaultApi.md#vorgang_id_get) | **GET** /vorgang/{id} | Metadaten zu Vorgängen\n*DefaultApi* | [**vorgangsposition_get**](docs/DefaultApi.md#vorgangsposition_get) | **GET** /vorgangsposition/ | Liste aller Vorgangspositionen\n*DefaultApi* | [**vorgangsposition_id_get**](docs/DefaultApi.md#vorgangsposition_id_get) | **GET** /vorgangsposition/{id} | Metadaten zu Vorgangspositionen\n\n\n## Documentation For Models\n\n\n\n## Documentation For Authorization\n\n\n## ApiKeyAuth\n\n- **Type**: API key\n- **API key parameter name**: Authorization\n- **Location**: HTTP header\n\n\n## Author\n\nkontakt@bund.dev\n\n\n## Notes for Large OpenAPI documents\nIf the OpenAPI document is large, imports in dip_bundestag.apis and dip_bundestag.models may fail with a\nRecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:\n\nSolution 1:\nUse specific imports for apis and models like:\n- `from deutschland.dip_bundestag.api.default_api import DefaultApi`\n- `from deutschland.dip_bundestag.model.pet import Pet`\n\nSolution 2:\nBefore importing the package, adjust the maximum recursion limit as shown below:\n```\nimport sys\nsys.setrecursionlimit(1500)\nfrom deutschland import dip_bundestag\nfrom deutschland.dip_bundestag.apis import *\nfrom deutschland.dip_bundestag.models import *\n```\n\n',
    'author': 'BundesAPI',
    'author_email': 'kontakt@bund.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/bundesAPI/dip-bundestag-api',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
